# These functions allow the administrator to edit a file on a host
#


set sd "/"

#
# editany - Prompt the user to select a new file to edit
# 
proc editany { host } {
    global errno sd textd upgrade_buff
    if { [winfo exists .ea ] != 0 } {
	destroy .ea
    }
    set sd "/"
    toplevel .ea -class Dialog
    wm title .ea "File Editor: $host"
    wm iconname .ea "File Editor"
    entry .ea.h1 
    .ea.h1 insert end $host
    frame .ea.f5
    label .ea.f5.l1 -text "Requested files to include in backup"
    frame .ea.f5.f1 -bd 2 -relief "flat"
    label .ea.f5.f1.l1 -text "Edit Host:" -width 11
    entry .ea.f5.f1.e1 -width 14 -font $textd
    .ea.f5.f1.e1 delete 0 end
    .ea.f5.f1.e1 insert end $host
    .ea.f5.f1.e1 configure -state disabled
    grid .ea.f5.f1.l1 .ea.f5.f1.e1
    
    label .ea.f5.f1.l2 -text "Current Dir:" -width 12
    entry .ea.f5.f1.e2 -width 32 -font $textd
    .ea.f5.f1.e2 delete 0 end
    .ea.f5.f1.e2 insert end $sd
    grid .ea.f5.f1.l2
    grid .ea.f5.f1.e2 -row 1 -column 1 -columnspan 2
    pack .ea.f5.f1 -side top
    
    frame .ea.f5.f2 -bd 2 -relief "flat"
    scrollbar .ea.f5.f2.vscroll -orient vertical -command ".ea.f5.f2.text yview"
    scrollbar .ea.f5.f2.hscroll -orient horizontal -command ".ea.f5.f2.text xview"
    listbox .ea.f5.f2.text -selectforeground white -selectbackground #000080 \
	    -yscrollcommand {.ea.f5.f2.vscroll set } \
	    -xscrollcommand {.ea.f5.f2.hscroll set } -height 8 -width 42 -font $textd
    .ea.f5.f2.text config -cursor hand2
    pack .ea.f5.f2.vscroll -side right -fill y
    pack .ea.f5.f2.hscroll -side bottom -fill x
    pack .ea.f5.f2.text -side left -expand 1 -fill both
    pack .ea.f5.f2 -side top -fill both
    
    
    # -----------------  Bottom Buttons  ---------------------------------------------------
    frame .ea.f7
    button .ea.f7.b1 -text "Edit" -foreground red -activeforeground #a00000 -command {
	if { [.ea.f5.f2.text curselection ] != "" } {
	    set tmp [string trimright "[.ea.f5.f1.e2 get ][.ea.f5.f2.text get [.ea.f5.f2.text curselection ]]" {.} ]
	    set upgrade_buff $tmp
	    global browse
	    set browse 19
	    repack 19
	    destroy .ea
	}
    }
    button .ea.f7.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	destroy .ea
    }
    button .ea.f7.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	help editany
    }
    pack .ea.f7.b1 .ea.f7.b2 .ea.f7.b3 -side left -fill x 
    
    pack .ea.f5 .ea.f7
    # ------------ Bindings --------------------
    bind .ea.f5.f2.text <Button-3> {
	.ea.f7.b1 invoke
    }
    bind .ea.f5.f2.text <Double-1> {
	if { [.ea.f5.f2.text curselection ] != {} } {
	    set t [.ea.f5.f2.text get [.ea.f5.f2.text curselection ] ]
	    if { $t == ".." } {
		# Need to go down a directory
		global sd
		set tmp [string trimright $sd {/} ]
		set ldir [string last {/} $tmp ]
		if { $ldir <= 0 } {
		    set sd "/"
		} else {
		    set tmp [string range $sd 0 $ldir ]
		    set sd $tmp
		}
		getDir [.ea.f5.f1.e1 get] $sd .ea.f5.f2.text
	    } elseif { [string range $t end end ] == {/} } {
		global sd
		set sd "[.ea.f5.f1.e2 get ][.ea.f5.f2.text get [.ea.f5.f2.text curselection ] ]"
		getDir [.ea.f5.f1.e1 get] $sd .ea.f5.f2.text
	    } else {
		.ea.f7.b1 invoke
	    }
	}
	.ea.f5.f1.e2 delete 0 end
	.ea.f5.f1.e2 insert end "$sd"
    }
    getDir [.ea.f5.f1.e1 get] $sd .ea.f5.f2.text
}
	
