# Dnsm.tcl
# Copyright (c) 1997 Mark Black
#

#
# DNS named HUP signaler
#
proc DnsHUP { currenthost } {
    global errno
    set cmd "DNS hup 0"
    set returnval [queryHost $currenthost $cmd 1 ]
    if { $errno != 0 } {
	error 291
	puts stdout "Error, unable to HUP named!"
    }
}


#
# DNS Master Setup Procedure
#
# USE DnsM Currenthost 
#
# This procedure is for the setup of the DNS record headers, and the boot file
# It can Only be used with files it generates.  This was a necessary limitation to 
# simplify coding.
proc DnsM { currenthost args } {
    global errno
    if { [winfo exists .dnsm ] == 0 } {
	toplevel .dnsm -class Dialog
	wm title .dnsm "DNS Master Editor: $currenthost"
	wm iconname .dnsm "DNS Editor"
	entry .dnsm.hidden1
	.dnsm.hidden1 insert end $currenthost
	frame .dnsm.f1 -bd 2 -relief "raised"
	label .dnsm.f1.l1 -text "DNS Domains within DNS Zone"
	pack .dnsm.f1.l1 -fill x 
	
	frame .dnsm.f1.f1 -bd 2 -relief "flat"
	entry .dnsm.f1.f1.e1 -width 20
	button .dnsm.f1.f1.b1 -text "Add" -width 6 -command {
	    if { [.dnsm.f1.f1.e1 get] != "" } {
		.dnsm.f1.f2.text insert end [.dnsm.f1.f1.e1 get]
	    }
	    .dnsm.f1.f1.e1 delete 0 end
	}
	pack .dnsm.f1.f1.e1 .dnsm.f1.f1.b1 -fill x -side left -expand 1
	frame .dnsm.f1.f2 -bd 2 -relief "flat"
	scrollbar .dnsm.f1.f2.vscroll -orient vertical -command ".dnsm.f1.f2.text yview" 
	listbox .dnsm.f1.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.dnsm.f1.f2.vscroll set } -height 3 -width 30
	.dnsm.f1.f2.text config -cursor hand2
	pack .dnsm.f1.f2.vscroll -side left -fill y
	pack .dnsm.f1.f2.text -side left -expand 1 -fill both
	button .dnsm.f1.f2.b1 -text "Delete" -width 6 -foreground red -activeforeground red -command {
	    if { [.dnsm.f1.f2.text curselection ] != "" } {
		.dnsm.f1.f2.text delete [.dnsm.f1.f2.text curselection ]
	    }
	}
	pack .dnsm.f1.f2.b1 -side left
	pack .dnsm.f1.f1 .dnsm.f1.f2 -side top -fill both -expand 1
	button .dnsm.f1.b1 -text "Edit Hosts" -command "DnsEdit [.dnsm.hidden1 get ] 0"
	button .dnsm.f1.b2 -text "Edit Config" -command { 
	    if { [.dnsm.f1.f2.text curselection ] != "" } {
		DnsMConfig [.dnsm.hidden1 get ] [ .dnsm.f1.f2.text get [ .dnsm.f1.f2.text curselection ]] 
	    } else {
		error 280
	    }
	}
	button .dnsm.f1.b3 -text "Parent Zone" -command { }
	pack .dnsm.f1.b1 .dnsm.f1.b2 .dnsm.f1.b3 -side left
	pack .dnsm.f1 -fill x -expand 1

	# ----------------- Key Bindings ---------------------------
	bind .dnsm.f1.f1.e1 <Return> {
	     if { [.dnsm.f1.f1.e1 get] != "" } {
		.dnsm.f1.f2.text insert end [.dnsm.f1.f1.e1 get]
	    }
	    .dnsm.f1.f1.e1 delete 0 end
	}
	.dnsm.f1.f2.text insert end "ee.ryerson.ca"
    }
}


#
# DNS Master configuration header update procedure
#
# USE:  DnsMConfig hostname domain_name
# 
# This procedure is responsible for gathering the data necessary for a DNS record header.
# The actual hosts are added by a seperate configuration procedure.
proc DnsMConfig { currenthost currentdomain } {
    global errno
    if { [winfo exists .dnsh ] == 0 } {
	toplevel .dnsh -class Dialog
	wm title .dnsh "Domain Editor for $currentdomain"
	wm iconname .dnsh "DNS Config"
	entry .dnsh.hidden1
	entry .dnsh.hidden2
	listbox .dnsh.hiddensec 
	.dnsh.hidden1 insert end $currenthost
	.dnsh.hidden2 insert end $currentdomain
	frame .dnsh.f0 -bd 2 -relief "raised"
	label .dnsh.f0.l1 -text "Domain Name:" -width 22
	entry .dnsh.f0.e1
	pack .dnsh.f0.l1 .dnsh.f0.e1 -fill x -side left -expand 1
	frame .dnsh.f1 -bd 2 -relief "raised"
	label .dnsh.f1.l1 -text "Network Address(es) Comprising Domain"
	pack .dnsh.f1.l1 -fill x 
	frame .dnsh.f1.f1 -bd 2 -relief "flat"
	entry .dnsh.f1.f1.e1 -width 3
	label .dnsh.f1.f1.l1 -text "."
	entry .dnsh.f1.f1.e2 -width 3
	label .dnsh.f1.f1.l2 -text "."
	entry .dnsh.f1.f1.e3 -width 3
	label .dnsh.f1.f1.l3 -text "."
	entry .dnsh.f1.f1.e4 -width 3
	button .dnsh.f1.f1.b1 -text "Add" -command {
	    if { [.dnsh.f1.f1.e1 get] != "" } {
		if { [.dnsh.f1.f1.e2 get] != "" } {
		    if { [.dnsh.f1.f1.e3 get] != "" } {
			if { [.dnsh.f1.f1.e4 get] != "" } {
			    if { [ validIP [.dnsh.f1.f1.e1 get] [.dnsh.f1.f1.e2 get] [.dnsh.f1.f1.e3 get] [.dnsh.f1.f1.e4 get] ] == 1 } {
				.dnsh.f1.f2.text insert end "[.dnsh.f1.f1.e1 get].[.dnsh.f1.f1.e2 get].[.dnsh.f1.f1.e3 get].[.dnsh.f1.f1.e4 get]"
				.dnsh.f1.f1.e1 delete 0 end
				.dnsh.f1.f1.e2 delete 0 end
				.dnsh.f1.f1.e3 delete 0 end
				.dnsh.f1.f1.e4 delete 0 end
			    } else {
				error 50
			    }
			} else {
			    focus .dnsh.f1.f1.e4 
			    error 50
			}
		    } else {
			focus .dnsh.f1.f1.e3 
			error 50
		    }
		} else {
		    focus .dnsh.f1.f1.e2 
		    error 50
		}
	    } else {
		focus .dnsh.f1.f1.e1 
		error 50
	    }
	}
	pack .dnsh.f1.f1.e1 .dnsh.f1.f1.l1 .dnsh.f1.f1.e2 .dnsh.f1.f1.l2 .dnsh.f1.f1.e3 .dnsh.f1.f1.l3 .dnsh.f1.f1.e4 .dnsh.f1.f1.b1 -side left
	frame .dnsh.f1.f2 -bd 2 -relief "flat"
	scrollbar .dnsh.f1.f2.vscroll -orient vertical -command ".dnsh.f1.f2.text yview" 
	listbox .dnsh.f1.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.dnsh.f1.f2.vscroll set } -height 3 -width 30
	.dnsh.f1.f2.text config -cursor hand2
	pack .dnsh.f1.f2.vscroll -side left -fill y
	pack .dnsh.f1.f2.text -side left -expand 1 -fill both
	button .dnsh.f1.f2.b1 -text "Delete" -width 6 -foreground red -activeforeground red -command {
	    if { [.dnsh.f1.f2.text curselection ] != "" } {
		.dnsh.f1.f2.text delete [.dnsh.f1.f2.text curselection ]
	    }
	}
	pack .dnsh.f1.f2.b1 -side left
	pack .dnsh.f1.f1 .dnsh.f1.f2 -side top -fill both -expand 1	

	frame .dnsh.f3 -bd 2 -relief "raised"
	label .dnsh.f3.l1 -text "Primary Server Name:" -width 22
	entry .dnsh.f3.e1 
	pack .dnsh.f3.l1 .dnsh.f3.e1 -fill x -side left -expand 1
	frame .dnsh.f4 -bd 2 -relief "raised"
	label .dnsh.f4.l1 -text "Contact Email Address:" -width 22
	entry .dnsh.f4.e1 
	pack .dnsh.f4.l1 .dnsh.f4.e1 -fill x -side left -expand 1

	frame .dnsh.f5 -bd 2 -relief "raised"
	label .dnsh.f5.l1 -text "Secondary Server Parameters"
	pack .dnsh.f5.l1 -fill x -expand 1
	frame .dnsh.f5.f1 -bd 1 -relief "raised"
	label .dnsh.f5.f1.l1 -text "Secondary update rate" -width 22
	entry .dnsh.f5.f1.e1 -width 4
	label .dnsh.f5.f1.l2 -text "minutes." -width 6
	pack .dnsh.f5.f1.l1 .dnsh.f5.f1.e1 .dnsh.f5.f1.l2 -fill x -side left -expand 1
	pack .dnsh.f5.f1 -fill x
	frame .dnsh.f5.f2 -bd 1 -relief "raised"
	label .dnsh.f5.f2.l1 -text "Secondary re-try rate" -width 22
	entry .dnsh.f5.f2.e1 -width 4
	label .dnsh.f5.f2.l2 -text "minutes." -width 6
	pack .dnsh.f5.f2.l1 .dnsh.f5.f2.e1 .dnsh.f5.f2.l2 -fill x -side left -expand 1
	pack .dnsh.f5.f2 -fill x
	frame .dnsh.f5.f3 -bd 1 -relief "raised"
	label .dnsh.f5.f3.l1 -text "Expire data after" -width 22
	entry .dnsh.f5.f3.e1 -width 4
	label .dnsh.f5.f3.l2 -text "hours." -width 6
	pack .dnsh.f5.f3.l1 .dnsh.f5.f3.e1 .dnsh.f5.f3.l2 -fill x -side left -expand 1
	pack .dnsh.f5.f3 -fill x
	
	frame .dnsh.f6 -bd 2 -relief "raised"
	label .dnsh.f6.l1 -text "Time To Live in Cache:" -width 22
	entry .dnsh.f6.e1 -width 4
	label .dnsh.f6.l2 -text "hours" -width 6
	pack .dnsh.f6.l1 .dnsh.f6.e1 .dnsh.f6.l2 -fill x -side left -expand 1

	frame .dnsh.f7 -bd 2 -relief "raised"
	label .dnsh.f7.l0 -text "Primary Server IP:" -width 22
	entry .dnsh.f7.e1 -width 3
	label .dnsh.f7.l1 -text "."
	entry .dnsh.f7.e2 -width 3
	label .dnsh.f7.l2 -text "."
	entry .dnsh.f7.e3 -width 3
	label .dnsh.f7.l3 -text "."
	entry .dnsh.f7.e4 -width 3
	pack .dnsh.f7.l0 .dnsh.f7.e1 .dnsh.f7.l1 .dnsh.f7.e2 .dnsh.f7.l2 .dnsh.f7.e3 .dnsh.f7.l3 .dnsh.f7.e4 -fill x -side left -expand 1

	frame .dnsh.f8 -bd 1 -relief "flat"
	button .dnsh.f8.app -text "Apply" -foreground red -activeforeground #a00000 -command { 
	    if { [DNSentryCheck ] != 1 } {
		set masterIP "[.dnsh.f7.e1 get].[.dnsh.f7.e2 get].[.dnsh.f7.e3 get].[.dnsh.f7.e4 get]"
		# Build the named.boot file first
		set shortnet {}
		for { set position 0 } { $position < [.dnsh.f1.f2.text index end ] } { incr position 1 } {
		    eval "set data \"[.dnsh.f1.f2.text get $position ]\" "
		    puts stdout "Data = $data"
		    lappend shortnet $data         
		}
		
		set cmd "DNS set soa [.dnsh.f0.e1 get]"
		if { [llength [split [.dnsh.f3.e1 get ] "." ] ] < 2 } {
		    .dnsh.f3.e1 insert end ".[.dnsh.f0.e1 get]"
		}
		set data "[.dnsh.f3.e1 get ]:$masterIP:[.dnsh.f4.e1 get ]:[.dnsh.f5.f1.e1 get ]:[.dnsh.f5.f2.e1 get ]:[.dnsh.f5.f3.e1 get ]:[.dnsh.f6.e1 get ]:"
		set flag 0
		set nets {}
		foreach ln [ split $shortnet ] {
		    if { $flag != 0 } {
			append nets ",$ln"
		    } else {
			set flag 1
			set nets $ln
		    }
		}
		puts stdout "Got nets: $nets"
		append data "$nets:"
		set sec {}
		for { set position 0 } { $position < [.dnsh.hiddensec index end ] } { incr position 1 } {
		    eval "set ln \"[.dnsh.hiddensec get $position ]\" "
		    if { $position != 0 } {
			append sec ",$ln"
		    } else {
			set sec $ln
		    }
		}
		append data "$sec"
		append cmd " $data"
		puts stdout "CMD: $cmd"
		set returnval [queryHost [.dnsh.hidden1 get ] $cmd 1 ]
		if { $errno != 0 } {
		    error 283
		    puts stdout "Error, unable to write to the DNS records!"
		} else {
		    # If new domain, update boot file
		    set cmd "DNS set boot [ .dnsh.f0.e1 get ] pri:$masterIP:"
		    for { set pos 0 } { $pos < [.dnsh.f1.f2.text index end ] } { incr pos 1 } {
			set tmp [.dnsh.f1.f2.text get $pos ]
			append cmd "$tmp,"
		    }
		    set newcmd [string trimright $cmd "," ]
		    puts stdout "Sending: $newcmd"
		    puts stdout " "
		    set returnval [queryHost [.dnsh.hidden1 get ] $newcmd 1 ]
		    if { $errno != 0 } {
			error 285
			puts stdout "Error, unable to write named.boot file!"
		    }
		    fillCan 40
		    destroy .dnsh
		}
	    }
	}
	button .dnsh.f8.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help dnssoa
	}
	button .dnsh.f8.can -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .dnsh
	}
	button .dnsh.f8.del -text "Delete Domain" -foreground red -activeforeground #a00000 -command {
	    DnsDelDomain [ .dnsh.f0.e1 get ]
	}
	pack .dnsh.f8.app .dnsh.f8.can .dnsh.f8.help .dnsh.f8.del -anchor w -side left
	
	pack .dnsh.f0 .dnsh.f1 .dnsh.f3 .dnsh.f7 .dnsh.f4 .dnsh.f5 .dnsh.f6 .dnsh.f8 -fill x


	# -------------------- Key Bindings ------------------------
	bind .dnsh.f0.e1 <Return> {
	    focus .dnsh.f1.f1.e1 
	}
	bind .dnsh.f1.f1.e1 <Return> {
	    focus .dnsh.f1.f1.e2 
	}
	bind .dnsh.f1.f1.e1 . {
	    after 150 {
		.dnsh.f1.f1.e1 delete [expr [string length [.dnsh.f1.f1.e1 get]] -1] end
	    }
	    focus .dnsh.f1.f1.e2 
	}
	bind .dnsh.f1.f1.e2 <Return> {
	    focus .dnsh.f1.f1.e3 
	}
	bind .dnsh.f1.f1.e2 . {
	    after 150 {
		.dnsh.f1.f1.e2 delete [expr [string length [.dnsh.f1.f1.e2 get]] -1] end
	    }
	    focus .dnsh.f1.f1.e3 
	}
	bind .dnsh.f1.f1.e3 <Return> {
	    focus .dnsh.f1.f1.e4 
	}
	bind .dnsh.f1.f1.e3 . {
	    after 150 {
		.dnsh.f1.f1.e3 delete [expr [string length [.dnsh.f1.f1.e3 get]] -1] end
	    }
	    focus .dnsh.f1.f1.e4 
	}
	bind .dnsh.f1.f1.e4 <Return> {
	    .dnsh.f1.f1.b1 invoke 
	    focus .dnsh.f3.e1
	}
	bind .dnsh.f3.e1 <Return> {
	    if { [llength [split [.dnsh.f3.e1 get ] "." ] ] < 2 } {
		.dnsh.f3.e1 insert end ".[.dnsh.f0.e1 get]"
	    }
	    focus .dnsh.f7.e1 
	}
	bind .dnsh.f4.e1 <Return> {
	    if { [llength [split [.dnsh.f4.e1 get ] "@" ] ] < 2 } {
		.dnsh.f4.e1 insert end "@[.dnsh.f0.e1 get]"
	    }
	    focus .dnsh.f5.f1.e1 
	}
	bind .dnsh.f5.f1.e1 <Return> {
	    focus .dnsh.f5.f2.e1 
	}
	bind .dnsh.f5.f2.e1 <Return> {
	    focus .dnsh.f5.f3.e1 
	}
	bind .dnsh.f5.f3.e1 <Return> {
	    focus .dnsh.f6.e1 
	}
	bind .dnsh.f6.e1 <Return> {
	    focus .dnsh.f7.e1 
	}
	bind .dnsh.f7.e1 <Return> {
	    focus .dnsh.f7.e2 
	}
	bind .dnsh.f7.e1 . {
	    after 150 {
		.dnsh.f7.e1 delete [expr [string length [.dnsh.f7.e1 get]] -1] end
	    }
	    focus .dnsh.f7.e2 
	}
	bind .dnsh.f7.e2 <Return> {
	    focus .dnsh.f7.e3 
	}
	bind .dnsh.f7.e2 . {
	    after 150 {
		.dnsh.f7.e2 delete [expr [string length [.dnsh.f7.e2 get]] -1] end
	    }
	    focus .dnsh.f7.e3 
	}
	bind .dnsh.f7.e3 <Return> {
	    focus .dnsh.f7.e4 
	}
	bind .dnsh.f7.e3 . {
	    after 150 {
		.dnsh.f7.e3 delete [expr [string length [.dnsh.f7.e3 get]] -1] end
	    }
	    focus .dnsh.f7.e4 
	}
	bind .dnsh.f7.e4 <Return> {
	    focus .dnsh.f4.e1 
	}
    } else {
	# Window exists already
	.dnsh.hidden1 delete 0 end 
	.dnsh.hidden1 insert end $currenthost
	.dnsh.hidden2 delete 0 end 
	.dnsh.hidden2 insert end $currentdomain
	.dnsh.f0.e1 delete 0 end
	.dnsh.f1.f1.e1 delete 0 end
	.dnsh.f1.f1.e2 delete 0 end
	.dnsh.f1.f1.e3 delete 0 end
	.dnsh.f1.f1.e4 delete 0 end
	.dnsh.f1.f2.text delete 0 end
	.dnsh.f3.e1 delete 0 end
	.dnsh.f4.e1 delete 0 end
	.dnsh.f5.f1.e1 delete 0 end
	.dnsh.f5.f2.e1 delete 0 end
	.dnsh.f5.f3.e1 delete 0 end
	.dnsh.f6.e1 delete 0 end
	.dnsh.f7.e1 delete 0 end
	.dnsh.f7.e2 delete 0 end
	.dnsh.f7.e3 delete 0 end
	.dnsh.f7.e4 delete 0 end
	.dnsh.hiddensec delete 0 end
    }
    # Fill windows
    if { $currentdomain != "-" } {
	set cmd "DNS get soa $currentdomain"
	set returnval [queryHost $currenthost $cmd 0 ]
	if { $errno != 0 } {
	    error 282
	    puts stdout "New domain"
	    focus .dnsh.f0.e1
	} else {
	    .dnsh.f0.e1 insert end $currentdomain
	    set data [ split $returnval ":" ]
	    .dnsh.f3.e1 insert end [ lindex $data 0 ]
	    .dnsh.f7.e1 insert end [ lindex [split [lindex $data 1 ] "." ] 0]
	    .dnsh.f7.e2 insert end [ lindex [split [lindex $data 1 ] "." ] 1]
	    .dnsh.f7.e3 insert end [ lindex [split [lindex $data 1 ] "." ] 2]
	    .dnsh.f7.e4 insert end [ lindex [split [lindex $data 1 ] "." ] 3]
	    .dnsh.f4.e1 insert end [ lindex $data 2 ]
	    .dnsh.f5.f1.e1 insert end [ expr [ lindex $data 3 ] / 60 ]
	    .dnsh.f5.f2.e1 insert end [ expr [ lindex $data 4 ] / 60 ]
	    .dnsh.f5.f3.e1 insert end [ expr [ lindex $data 5 ] / 3600 ]
	    .dnsh.f6.e1 insert end [ expr [ lindex $data 6 ] / 3600 ]
	    foreach net [ split [ lindex $data 7 ] "," ] {
		set netno [llength [ split $net "." ] ]
		puts stdout "Length = $netno"
		for { set cnt 0 } { $cnt < [expr 4 - $netno] } { incr cnt 1 } {
		    append net ".0"
		}
		.dnsh.f1.f2.text insert end $net
	    }
	    foreach secserv [ split [ lindex $data 8 ] "," ] {
		.dnsh.hiddensec insert end $secserv
	    }
	}
    }
}

#
# DNSentryCheck
#
# Returns 1 if a field requires an entry
proc DNSentryCheck { } {
    set nogo 0
    if { [validIP [.dnsh.f7.e1 get] [.dnsh.f7.e2 get] [.dnsh.f7.e3 get] [.dnsh.f7.e4 get] ] == 0 } {
	set nogo 1
	error 286
    }
    if { [.dnsh.f0.e1 get] == {} } {
	# No domain
	set nogo 1
	error 287
    }
    if { [.dnsh.f3.e1 get] == {} } {
	# No server name
	set nogo 1
	error 288
    }
    if { [.dnsh.f4.e1 get] == {} } {
	# No contact email
	set nogo 1
	error 289
    }
    if { [.dnsh.f5.f1.e1 get] == {} } {
	# no Update
	set nogo 1
	error 290
    }
    if { [.dnsh.f5.f2.e1 get] == {} } {
	# no Update
	set nogo 1
	error 290
    }
    if { [.dnsh.f5.f3.e1 get] == {} } {
	# no Update
	set nogo 1
	error 290
    }
    if { [.dnsh.f6.e1 get] == {} } {
	# no Update
	set nogo 1
	error 290
    }
    return nogo
}

#
# DnsDelDomain - Delete a DNS domain from the named.boot file
#
# USE:  DnsDelDomain Domain_name
#
proc DnsDelDomain {domain} {
    global errno
    if { [winfo exists .dnsdel ] != 0 } {
	destroy .dnsdel
    }
    toplevel .dnsdel -class Dialog
    wm title .dnsdel "Delete Domain: $domain"
    wm iconname .dnsdel "DNS Deleter"
    set sfont {-Adobe-helvetica-*-R-*-18-*-*}
    message .dnsdel.msg -width 3i -text "Are you sure you want to delete the $domain DNS domain!" -font $sfont -foreground red
    pack .dnsdel.msg -expand 1 -padx 3m -pady 3m
    frame .dnsdel.f1 -bd 2 -relief "flat"
    button .dnsdel.f1.quit -text "Cancel" -command { destroy .dnsdel }
    button .dnsdel.f1.go -text "Delete" -command { 
	set cmd "DNS set boot [ .dnsh.f0.e1 get ] del:0.0.0.0:0.0.0.0"
	set returnval [queryHost [.dnsh.hidden1 get ] $cmd 1 ]
	if { $errno != 0 } {
	    error 285
	    puts stdout "Error, unable to update named.boot file!"
	}
	fillCan 40
	if { [winfo exists .dnsh ] != 0 } {
	    destroy .dnsh
	}
	if { [winfo exists .dnse ] != 0 } {
	    destroy .dnse
	}
	destroy .dnsdel 
    }
    pack .dnsdel.f1.quit .dnsdel.f1.go -side left -padx 3m -pady 3m
    pack .dnsdel.f1 -side bottom -fill x
}



#
# DNS Host editor
#
# USE:  DnsEdit DNS_Master_name Domain_name
#
# This procedure is for adding/modifing hosts to the DNS records
#
# currenthost   - The DNS master
# currentdomain - The domain to edit
# ehost         - Host name to edit.  Set to 9999 for new hosts
# line          - The line produced by DNS get host
#
proc DnsEdit { currenthost currentdomain ehost line args } {
    global errno
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .dnse ] == 0 } {
	toplevel .dnse -class Dialog
	wm title .dnse "DNS Host Editor: $currenthost"
	wm iconname .dnse "DNS Editor"
	entry .dnse.hidden1
	entry .dnse.hidden2
	entry .dnse.hidden3
	.dnse.hidden1 insert end $currenthost
	.dnse.hidden2 insert end $currentdomain
	.dnse.hidden3 insert end $ehost
	frame .dnse.f1 -bd 2 -relief "raised"
	label .dnse.f1.l1 -text "Unqualified Hosts Name:" -width 24
	entry .dnse.f1.e1 -width 8
	pack  .dnse.f1.l1 .dnse.f1.e1 -side left -fill x -expand 1
	frame .dnse.f2 -bd 2 -relief "raised"
	label .dnse.f2.l0 -text "Hosts IP:" -width 16
	entry .dnse.f2.e1 -width 3
	label .dnse.f2.l1 -text "."
	entry .dnse.f2.e2 -width 3
	label .dnse.f2.l2 -text "."
	entry .dnse.f2.e3 -width 3
	label .dnse.f2.l3 -text "."
	entry .dnse.f2.e4 -width 3
	pack .dnse.f2.l0 .dnse.f2.e1 .dnse.f2.l1 .dnse.f2.e2 .dnse.f2.l2 .dnse.f2.e3 .dnse.f2.l3 .dnse.f2.e4 -fill x -side left -expand 1
	
	frame .dnse.f4 -bd 2 -relief "raised"
	label .dnse.f4.l1 -text "Other names for this Host"
	pack .dnse.f4.l1 -fill x 
	frame .dnse.f4.f1 -bd 2 -relief "flat"
	entry .dnse.f4.f1.e1 -width 20
	button .dnse.f4.f1.b1 -text "Add" -width 6 -command {
	    if { [.dnse.f4.f1.e1 get] != "" } {
		.dnse.f4.f2.text insert end [.dnse.f4.f1.e1 get]
	    }
	    .dnse.f4.f1.e1 delete 0 end
	}
	pack .dnse.f4.f1.e1 .dnse.f4.f1.b1 -fill x -side left -expand 1
	frame .dnse.f4.f2 -bd 2 -relief "flat"
	scrollbar .dnse.f4.f2.vscroll -orient vertical -command ".dnse.f4.f2.text yview" 
	listbox .dnse.f4.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.dnse.f4.f2.vscroll set } -height 3 -width 24
	.dnse.f4.f2.text config -cursor hand2
	pack .dnse.f4.f2.vscroll -side left -fill y
	pack .dnse.f4.f2.text -side left -expand 1 -fill both
	button .dnse.f4.f2.b1 -text "Delete" -width 6 -foreground red -activeforeground red -command {
	    if { [.dnse.f4.f2.text curselection ] != "" } {
		.dnse.f4.f2.text delete [.dnse.f4.f2.text curselection ]
	    }
	}
	pack .dnse.f4.f2.b1 -side left
	pack .dnse.f4.f1 .dnse.f4.f2 -side top -fill both -expand 1	

	frame .dnse.f5 -bd 2 -relief "raised"
	label .dnse.f5.l1 -text "Mail Hubs (List Primary First)"
	pack .dnse.f5.l1 -fill x 
	frame .dnse.f5.f1 -bd 2 -relief "flat"
	entry .dnse.f5.f1.e1 -width 20
	button .dnse.f5.f1.b1 -text "Add" -width 6 -command {
	    if { [.dnse.f5.f1.e1 get] != "" } {
		.dnse.f5.f2.text insert end [.dnse.f5.f1.e1 get]
	    }
	    .dnse.f5.f1.e1 delete 0 end
	}
	pack .dnse.f5.f1.e1 .dnse.f5.f1.b1 -fill x -side left -expand 1
	frame .dnse.f5.f2 -bd 2 -relief "flat"
	scrollbar .dnse.f5.f2.vscroll -orient vertical -command ".dnse.f5.f2.text yview" 
	listbox .dnse.f5.f2.text -selectforeground white -selectbackground #000080 -yscrollcommand {.dnse.f5.f2.vscroll set } -height 3 -width 24
	.dnse.f5.f2.text config -cursor hand2
	pack .dnse.f5.f2.vscroll -side left -fill y
	pack .dnse.f5.f2.text -side left -expand 1 -fill both
	button .dnse.f5.f2.b1 -text "Delete" -width 6 -foreground red -activeforeground red -command {
	    if { [.dnse.f5.f2.text curselection ] != "" } {
		.dnse.f5.f2.text delete [.dnse.f5.f2.text curselection ]
	    }
	}
	pack .dnse.f5.f2.b1 -side left
	pack .dnse.f5.f1 .dnse.f5.f2 -side top -fill both -expand 1	
	
	frame .dnse.f6 -bd 2 -relief "raised"
	label .dnse.f6.l1 -text "Comment" -width 8
	entry .dnse.f6.e1 
	pack  .dnse.f6.l1 .dnse.f6.e1 -side top -fill x -expand 1

	frame .dnse.f8 -bd 2 -relief "flat"
	button .dnse.f8.app -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [ validIP [ .dnse.f2.e1 get] [ .dnse.f2.e2 get] [ .dnse.f2.e3 get] [ .dnse.f2.e4 get ] ] == 1 } {
		if { [ .dnse.f1.e1 get] != "" } {
		    set cmd "DNS set host [ .dnse.hidden2 get ] "
		    append cmd "[string tolower [ .dnse.hidden3 get ]]:[ .dnse.f1.e1 get]:[ .dnse.f2.e1 get].[ .dnse.f2.e2 get].[ .dnse.f2.e3 get].[ .dnse.f2.e4 get]:"
		    foreach alis [ .dnse.f4.f2.text get 0 end ] {
			append cmd "[string tolower [string trimright $alis]],"
		    }
		    set tmp [string trimright $cmd "," ] 
		    append tmp ":"
		    foreach mx [ .dnse.f5.f2.text get 0 end ] {
			append tmp "[string tolower [string trimright $mx]],"
		    }
		    set cmd [string trimright $tmp "," ]
		    append cmd ":\"[ .dnse.f6.e1 get ]\""
		    puts "Cmd= $cmd"
		    set returnval [queryHost [ .dnse.hidden1 get ] $cmd 1 ]
		    if { $errno != 0 } {
			error 283
			puts stdout "ERROR:  Unable to update the DNS records for [ .dnse.hidden2 get ]\n       Check the files permissions on DNS master"
		    } else {
			set returndata [queryHost [ .dnse.hidden1 get ] "DNS get host [ .dnse.hidden2 get ]" 0 ]
			filltext $returndata .general.text 41
			destroy .dnsh
		    }
		} else {
		    error 284
		}
	    }
	}
	button .dnse.f8.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help dnsh
	}
	button .dnse.f8.can -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .dnse
	}
	button .dnse.f8.adv -text "Advanced" -foreground #604040 -activeforeground #000000 -command {
	    DnsMConfig [ .dnse.hidden1 get ] [ .dnse.hidden2 get ]
	}
	pack .dnse.f8.app .dnse.f8.can .dnse.f8.adv .dnse.f8.help -anchor w -side left

	
	pack .dnse.f1 .dnse.f2 .dnse.f4 .dnse.f5 .dnse.f6 .dnse.f8 -fill x

	# ---------------------- Key Bindings ---------------------------
	bind .dnse.f1.e1 <Return> {
	    focus .dnse.f2.e1 
	}
	bind .dnse.f2.e1 <Return> {
	    focus .dnse.f2.e2 
	}
	bind .dnse.f2.e1 . {
	    after 150 {
		.dnse.f2.e1 delete [expr [string length [.dnse.f2.e1 get]] -1] end
	    }
	    focus .dnse.f2.e2 
	}
	bind .dnse.f2.e2 <Return> {
	    focus .dnse.f2.e3 
	}
	bind .dnse.f2.e2 . {
	    after 150 {
		.dnse.f2.e2 delete [expr [string length [.dnse.f2.e2 get]] -1] end
	    }
	    focus .dnse.f2.e3 
	}
	bind .dnse.f2.e3 <Return> {
	    focus .dnse.f2.e4 
	}
	bind .dnse.f2.e3 . {
	    after 150 {
		.dnse.f2.e3 delete [expr [string length [.dnse.f2.e3 get]] -1] end
	    }
	    focus .dnse.f2.e4 
	}
	bind .dnse.f2.e4 <Return> {
	    focus .dnse.f4.f1.e1
	}
	bind .dnse.f4.f1.e1 <Return> {
	    if { [.dnse.f4.f1.e1 get] != "" } {
		.dnse.f4.f2.text insert end [.dnse.f4.f1.e1 get]
	    }
	    .dnse.f4.f1.e1 delete 0 end
	}
	bind .dnse.f5.f1.e1 <Return> {
	    if { [.dnse.f5.f1.e1 get] != "" } {
		.dnse.f5.f2.text insert end [.dnse.f5.f1.e1 get]
	    }
	    .dnse.f5.f1.e1 delete 0 end
	}

    } else {
	# Window exists, deal with it
	wm title .dnse "DNS lookup Editor: $currenthost"
	.dnse.hidden1 insert end $currenthost
	.dnse.hidden2 insert end $currentdomain
	.dnse.hidden3 insert end $ehost
    }
    # Fill widgets if possible
    .dnse.f1.e1 delete 0 end
    .dnse.f2.e1 delete 0 end
    .dnse.f2.e2 delete 0 end
    .dnse.f2.e3 delete 0 end
    .dnse.f2.e4 delete 0 end
    .dnse.f4.f1.e1 delete 0 end
    .dnse.f4.f2.text delete 0 end
    .dnse.f5.f1.e1 delete 0 end
    .dnse.f5.f2.text delete 0 end
    .dnse.f6.e1 delete 0 end
    if { [ .dnse.hidden3 get ] != "9999" } {
	puts "Data = $line"
	set tmp [ split $line ":" ]
	.dnse.f1.e1 insert end [ lindex $tmp 0 ]
	set tmp2 [split [ lindex $tmp 1 ] "." ]
	.dnse.f2.e1 insert end [ lindex $tmp2 0 ]
	.dnse.f2.e2 insert end [ lindex $tmp2 1 ]
	.dnse.f2.e3 insert end [ lindex $tmp2 2 ]
	.dnse.f2.e4 insert end [ lindex $tmp2 3 ]
	foreach line [split [ lindex $tmp 2 ] "," ] {
	    .dnse.f4.f2.text insert end $line
	}
	foreach line [split [ lindex $tmp 3 ] "," ] {
	    .dnse.f5.f2.text insert end $line
	}
	.dnse.f6.e1 insert end [string trim [ lindex $tmp 4 ] {\"} ]
    }
}

#
# Valid IP checker
#
# USE:  validIP IP1 IP2 IP3 IP4
# This procedure checkes the IP address to ensure it is valid
#
proc validIP { ip1 ip2 ip3 ip4 } {
    if { $ip1 > 255 || $ip1 < 0 } {
	error 50
	return 0
    } elseif { $ip2 > 255 || $ip2 < 0 } {
	error 50
	return 0
    } elseif { $ip3 > 255 || $ip3 < 0 } {
	error 50
	return 0
    } elseif { $ip4 > 255 || $ip4 < 0 } {
	error 50
	return 0
    } else { 
	return 1
    }
}



#
# DnsSecEdit
#
# Edit DNS secondary servers
proc DnsSecEdit { currentdomain secname } {
    global errno
    global currenthost
    if { [winfo exists .dnsSec ] == 0 } {
	toplevel .dnsSec -class Dialog
	wm title .dnsSec "DNS Secondary Editor for $currentdomain"
	wm iconname .dnsSec "DNS Secondary"
	entry .dnsSec.hidden1
	entry .dnsSec.hidden2
	entry .dnsSec.master
	entry .dnsSec.netIPs
	.dnsSec.hidden1 insert end $currentdomain
	.dnsSec.hidden2 insert end $secname
	frame .dnsSec.f1 -bd 2 -relief "raised"
	label .dnsSec.f1.l1 -text "DNS Secondary Server for $currentdomain"
	entry .dnsSec.f1.e1 -width 24
	pack .dnsSec.f1.l1 .dnsSec.f1.e1 -side top -fill x 

	frame .dnsSec.f8 -bd 1 -relief "flat"
	button .dnsSec.f8.app -text "Apply" -foreground red -activeforeground #a00000 -command {
	    # Query the master server to get the network information
	    # Currenthost will be the master DNS server
	    set cmd "DNS get soa [.dnsSec.hidden1 get]"
	    set returnval [queryHost $currenthost $cmd 1 ]
	    if { $errno != 0 } {
		error 285
		puts stdout "Error, unable to read DNS master information!"
	    }
	    # Information is written back to main server, so save it
	    puts stdout "Master information: $returnval"

	    # Build the named.boot file on the secondary machine
	    set data [ split $returnval ":" ]
	    set cmd "DNS set boot [ .dnsSec.hidden1 get ] sec:[lindex $data 1]"
	    set nets {}
	    foreach net [ split [ lindex $data 7 ] "," ] {
		set netno [llength [ split $net "." ] ]
		puts stdout "Length = $netno"
		for { set cnt 0 } { $cnt < [expr 4 - $netno] } { incr cnt 1 } {
		    append net ".0"
		}
		append nets $net
		append nets ","
	    }
	    set newcmd "$cmd:[string trimright $nets ","]"
	    puts stdout "Sending command to  [.dnsSec.f1.e1 get ]"
	    set returnval [queryHost [.dnsSec.f1.e1 get ] $newcmd 1 ]
	    if { $errno != 0 } {
		if { $errno == 1 } {
		    error 285
		    puts stdout "Error, unable to write named.boot file!"
		} else {
		    error 293
		}
	    } else {
		puts stdout "Update returned: $returnval"
		puts stdout "--> [lindex $returnval [expr [llength $returnval] - 1]]"
		# Rebuild the Master servers SOA records
		set cmd "DNS set soa [.dnsSec.hidden1 get] "
		append cmd "[ lindex $data 0 ]:[ lindex $data 1 ]:[ lindex $data 2 ]:"
		append cmd "[ lindex $data 3 ]:[ lindex $data 4 ]:[ lindex $data 5 ]:"
		append cmd "[ lindex $data 6 ]:$nets:[ lindex $data 8 ],[.dnsSec.f1.e1 get ]"
		puts stdout "Sending --> $cmd"
		set returnval [queryHost $currenthost $cmd 1 ]
		if { $errno != 0 } {
		    error 292
		    puts stdout "Error, unable to write DNS master information!"
		}
	    }


	}
	button .dnsSec.f8.help -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help dnsSec
	}
	button .dnsSec.f8.can -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    destroy .dnsSec
	}
	pack .dnsSec.f8.app .dnsSec.f8.can .dnsSec.f8.help -anchor w -side left

	pack .dnsSec.f1 .dnsSec.f8 -fill x
    } else {
	# Window open already
	.dnsSec.f1.l1 configure -text "DNS Secondary Server for $currentdomain"
	.dnsSec.hidden1 delete 0 end 
	.dnsSec.hidden2 delete 0 end 
	.dnsSec.hidden1 insert end $currentdomain
	.dnsSec.hidden2 insert end $secname
    }
    .dnsSec.f1.e1 delete 0 end
    if { $secname != "9999"} {
	.dnsSec.f1.e1 insert end [ .dnsSec.hidden2 get ]
    }
}





