#  Display.tcl    
#  Copyright (c) 1997 Mark Black
#  Version 0.17
#
#  This library of functions is required for displaying data.
#  It contains the code for filling the list boxes.
#
# Contents:
#   repack       - Redraw the output window
#   filltext     - Fill the output window

#  Level = The command/host level
#          10 = Host select canvas
#          20 = Config file select
#          30 = Stat Selector
#          40 = DNS Master
#          50 = MAT User
#          60 = TAPE Server
#          70 = NIS Server
#          80 = NFS Server
#          90 = MAT Internals
#          100 = System Monitor   ** MOVED to 200 **
#          110 = Syslog Monitor
#          120 = TAPE Backups
#          130 = TAPE Restores
#          140 = TAPE Backup Schedule
#          150 = MATD Tasks
#          160 = TAPE Devices   (Moved to 126)
#          200 = Extended System Monitor
#          250 = Replicateion Master
#          900 = User Defined managed objects
#
# ------  Procedure to Customize the window to suit the variable to edit ---
#
# Negitive values are used to call fillCan with -ve type
proc repack { type args } {
    global currenthost tapeserv level errno
    set rdata {}
    if { $type < 0 } {
	set level [ expr $type * -1 ]
	fillCan $level
    } elseif { $type == 0 } {
	.general.label configure -text "Tasks:  $currenthost"
	
    } elseif { $type == 1 } {
	.general.label configure -text "Hosts:  $currenthost"
	set rdata [queryHost $currenthost "CON get hosts" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 2 } {
	.general.label configure -text "User Groups:  $currenthost"
	set rdata [queryHost $currenthost "CON get group" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 3 } {
	.general.label configure -text "Mounting Filesystems:  $currenthost"
	set rdata [queryHost $currenthost "CON get fstab" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 4 } {
	.general.label configure -text "Inittab  (Delete Only):  $currenthost"
	set rdata [queryHost $currenthost "CON get inittab" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 5 } {
	.general.label configure -text "Users:  $currenthost"
	set rdata [queryHost $currenthost "CON get pass" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 6 } {
	.general.label configure -text "DNS Client Configuration:  $currenthost"
	set rdata [queryHost $currenthost "CON get dnsc" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 7 } {
	.general.label configure -text "Login Message:  $currenthost"
	set rdata [queryHost $currenthost "CON get motd" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 8 } {
	.general.label configure -text "Mailing Lists & Mail Redirection:  $currenthost"
	set rdata [queryHost $currenthost "CON get alias" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 9 } {
	.general.label configure -text "Samba Shares on $currenthost"
	set rdata [queryHost $currenthost "CON get samba" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 10 } {
	.general.label configure -text "Exported Filesystems from $currenthost"
	set rdata [queryHost $currenthost "NFS get exports" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 11 } {
	.general.label configure -text "Sudo Users on $currenthost"
	set rdata [queryHost $currenthost "CON get sudo" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 12 } {
	.general.label configure -text "Crontab on $currenthost"
	set rdata [queryHost $currenthost "CON get crontab" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 13 } {
	.general.label configure -text "Services on $currenthost"
	set rdata [queryHost $currenthost "CON get services" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 19 } {
	global upgrade_buff
	.general.label configure -text "Editing: $upgrade_buff from $currenthost"
	set rdata [queryHost $currenthost "get raw $upgrade_buff" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 41 } {
	# DNS Master record config
	global currentdomain
	.general.label configure -text "DNS records for $currentdomain, on $currenthost"
	set rdata [queryHost $currenthost "DNS get host $currentdomain" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 42 } {
	# DNS Secondary Config
	global currentdomain
	.general.label configure -text "DNS Servers for $currentdomain"
	set returnval [queryHost $currenthost "DNS get soa $currentdomain" 0 ]
	set data [ split $returnval ":" ]
	set rdata {}
	foreach secserv [ split [ lindex $data 8 ] "," ] {
	    lappend rdata $secserv
	}
	filltext $rdata .general.text $type
    } elseif { $type == 61 } {
	.general.label configure -text "Backup files on $currenthost"
	set rdata [queryHost $currenthost "get tapes" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 62 } {
	.general.label configure -text "Restore files on $currenthost"
	set rdata [queryHost $currenthost "get tapes" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 63 } {
	.general.label configure -text "Schedule backups for $currenthost"
	set rdata [queryHost $currenthost "get tapes" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 71 } {
	.general.label configure -text "NIS password entries on $currenthost"
	set rdata [queryHost $currenthost "NIS get pass" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 72 } {
	.general.label configure -text "NIS group entries on $currenthost"
	set rdata [queryHost $currenthost "NIS get group" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 73 } {
	.general.label configure -text "NIS hosts entries on $currenthost"
	set rdata [queryHost $currenthost "NIS get hosts" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 74 } {
	.general.label configure -text "NIS Email aliases on $currenthost"
	set rdata [queryHost $currenthost "NIS get alias" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 75 } {
	.general.label configure -text "NIS Netgroup on $currenthost"
	set rdata [queryHost $currenthost "NIS get netgroup" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 76 } {
	.general.label configure -text "NIS Ethers on $currenthost"
	set rdata [queryHost $currenthost "NIS get ethers" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 77 } {
	.general.label configure -text "NIS Services on $currenthost"
	set rdata [queryHost $currenthost "NIS get services" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 79 } {
	.general.label configure -text "NIS update results on $currenthost"
	set rdata [queryHost $currenthost "NIS make yp" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 81 } {
	.general.label configure -text "Exported Filesystems on $currenthost"
	set rdata [queryHost $currenthost "NFS get exports" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 82 } {
	.general.label configure -text "NFS clients of $currenthost"
	set rdata [queryHost $currenthost "MON get nfsclients" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 83 } {
	.general.label configure -text "NFS stats for $currenthost"
	set rdata [queryHost $currenthost "MON get nfsstat" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 90 } {
	.general.label configure -text "MAT Hosts managed by this Management Console"
	set rdata {}
	set fid [ open "../hosts" r ]
	while { [ gets $fid fout ] > 0 } {
	    lappend rdata $fout
	}
	close $fid
	filltext $rdata .general.text $type
    } elseif { $type == 91 } {
	.general.label configure -text "MAT users on $currenthost"
	set rdata [queryHost $currenthost "CON get matpass" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 92 } {
	.general.label configure -text "MAT Logs for:  $currenthost"
	set rdata [queryHost $currenthost "CON get matlog" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 93 } {
	.general.label configure -text "Upgrading:  $currenthost"
	upgrade $currenthost
    } elseif { $type == 94 } {
	.general.label configure -text "MAT License for:  $currenthost"
	set rdata [queryHost $currenthost "CON get matlic" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 111 } {
	.general.label configure -text "Syslogd Config on $currenthost"
	set rdata [queryHost $currenthost "MON get syslogconf" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 112 } {
	global upgrade_buff
	.general.label configure -text "System log $upgrade_buff on $currenthost"
	set rdata [queryHost $currenthost "get raw $upgrade_buff" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 121 } {
	global tapeserv
	.general.label configure -text "Backup Tapes for $tapeserv"
	set rdata [queryHost $tapeserv "TAPE names $tapeserv" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 123 } {
	global tapeserv
	.general.label configure -text "Backup Host groups on $currenthost"
	set rdata [queryHost $currenthost "TAPE get groups" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 125 } {
	global tapeserv
	.general.label configure -text "Backup jobs on $currenthost"
	set rdata [queryHost $currenthost "TAPE get jobids" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 126 } {
	global tapeserv
	.general.label configure -text "Backup Devices on $currenthost"
	set rdata [queryHost $currenthost "TAPE get drives" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 127 } {
	global tapeserv
	.general.label configure -text "Backup media on $currenthost"
	set rdata {}
	append rdata [queryHost $currenthost "TAPE get vols $args" 0 ]
	puts stdout "Got:  $rdata"
	filltext $rdata .general.text $type
    } elseif { $type == 131 } {
	global tapeserv
	.general.label configure -text "Available Backup Tapes from $tapeserv"
	set rdata [queryHost $currenthost "TAPE get hhist $tapeserv" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 151 } {
	.general.label configure -text "Scheduled Tasks on $currenthost"
	set rdata [queryHost $currenthost "TASK get tasks" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 201 } {
	.general.label configure -text "Last 200 users to login to $currenthost"
	set rdata [queryHost $currenthost "MON get last" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 202 } {
	.general.label configure -text "Processes on $currenthost"
	set rdata [queryHost $currenthost "MON get ps" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 203 } {
	.general.label configure -text "Routing table on $currenthost"
	set rdata [queryHost $currenthost "MON get route" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 204 } {
	# Moved to a new branch
    } elseif { $type == 205 } {
	.general.label configure -text "Local Disk use on $currenthost"
	set rdata [queryHost $currenthost "MON get df" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 206 } {
	.general.label configure -text "Exported (shared) filesystems from $currenthost"
	set rdata [queryHost $currenthost "MON get exports" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 207 } {
	.general.label configure -text "Network Utilization on $currenthost"
	set rdata [queryHost $currenthost "MON get ethload" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 208 } {
	.general.label configure -text "Networt Socket Activity $currenthost"
	set rdata [queryHost $currenthost "MON get sockets" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 209 } {
	.general.label configure -text "Current logins on $currenthost"
	set rdata [queryHost $currenthost "MON get who" 0 ]
	filltext $rdata .general.text $type
    } elseif { $type == 251 } {
	global tapeserv
	.general.label configure -text "Replication Host groups on $currenthost"
	set rdata [queryHost $currenthost "TAPE get groups" 0 ]
	puts stdout $rdata
	filltext $rdata .general.text $type
    } elseif { $type == 252 } {
	global tapeserv
	.general.label configure -text "Replication jobs on $currenthost"
	set rdata [queryHost $currenthost "TAPE get repids" 0 ]
	puts stdout $rdata
	filltext $rdata .general.text $type
    } elseif { $type > 900  & $type < 999 } {
	USERrepack $type
    }

    if { $errno == 2 } {
	puts stdout "Cannot contact host $currenthost"
    } elseif { $errno == 1 } {
	puts stdout "Communications Timeout or Interrupt"
    }
}


#
# getFeature  - Given a features short name return the long name
#
proc getFeature { name } {
    if { $name == "dns" } {
	return "DNS Server"
    } elseif { $name == "gen" } {
	return "Generic Host config'er"
    } elseif { $name == "nis" } {
	return "NIS Server"
    } elseif { $name == "nfs" } {
	return "NFS Server"
    } elseif { $name == "tps" } {
	return "Tape Server"
    } elseif { $name == "rep" } {
	return "Replication Server"
    } elseif { $name == "mon" } {
	return "Monitoring Tools"
    } else {
	return "-"
    }
}

#
# -- Procedure to read data from raw data and fill list window --
#    win = Window to display it in
proc filltext { data win type } {
    global currenthost
    global master
    . config -cursor watch
    $win config -cursor watch
    $win configure -state normal
    $win delete 0.0 end
    # Hosts
    set tabbing(1) {16 24 }
    set toplabel(1) "IP Address      Host Name               Alias(s)"
    # Groups
    set tabbing(2) {12 6 }
    set toplabel(2) "Group name  GID#  Members"
    # Mounts
    set tabbing(3) {28 28 10 18}
    set toplabel(3) "What to mount               Where to mount              Type      Options"
    # Inittab
    set tabbing(4) {3 10 10 }
    set toplabel(4) "ID :  Type     :  Process"
    # Users
    set tabbing(5) {10 6 6 20 24 }
    set toplabel(5) "Login     UID#  GID#  Users Fullname      Home Directory          Shell"
    # DNS Clients
    set tabbing(6) {14 }
    set toplabel(6) "Keyword       Value"
    # Motd
    set toplabel(7) "Edit the text, Then press NEW to update"
    # Mail Aliases
    set tabbing(8) {17 10 }
    set toplabel(8) "Email Name       : Destination "
    # Samba
    set tabbing(9) {11 10 }
    set toplabel(9) "Share Name : Options "
    # Exports
    set tabbing(10) {11 10 }
    set toplabel(10) "Filesystem  Access "
    # Sudo
    set tabbing(11) {11 10 }
    set toplabel(11) "Login/Cmd  Permissions/Programs/Hosts "
    # Crontab
    set tabbing(12) {9 9 11 9 10}
    set toplabel(12) "Minutes  Hours    Month Day  Month    Week Day  Command "
    # Services
    set tabbing(13) {13 24 }
    set toplabel(13) "Service     Port/type        "
    # Edit Any
    set tabbing(19) {}
    set toplabel(19) "Hit New to save the file back to the host.  NOTE:  Text files only!"
    # DNS Master
    set tabbing(41) {12 16 21 }
    set toplabel(41) "Host Name   IP Address      Alias(es)            Comment"
    # DNS Secondaries
    set tabbing(42) 32
    set toplabel(42) "DNS Domain Servers"
    # NIS Entries
    # NIS Password
    set tabbing(71) {10 6 6 20 24 }
    set toplabel(71) "Login     UID#  GID#  Users Fullname      Home Directory          Shell"
    # NIS Groups
    set tabbing(72) {12 6 }
    set toplabel(72) "Group name  GID#  Members"    
    # NIS Hosts
    set tabbing(73) {16 24 }
    set toplabel(73) "IP Address      Host Name               Alias(s)"
    # NIS Mail Aliases
    set tabbing(74) {17 10 }
    set toplabel(74) "Email Name       : Destination "
    # NIS Mail Aliases
    set tabbing(75) {15 10 }
    set toplabel(75) "Netgroup       Members "
    # NIS Mail Aliases
    set tabbing(79) {}
    set toplabel(79) "YP make results"
    # NIS Ethers
    set tabbing(76) {18 10 }
    set toplabel(76) "Ether             Hostname "
    # NIS Services
    set tabbing(77) {13 24 }
    set toplabel(77) "Service     Port/type        "
    # BACKUP/RESTORE tools
    set toplabel(61) "Select a tape device to backup to"
    set toplabel(62) "Select a tape device to restore from"
    set toplabel(63) "Select a tape device to schedule backups on"
    # NFS
    set toplabel(81) "Filesystem              Permissions"
    set tabbing(81) {24}
    set toplabel(82) "Client      Filesystem"
    set toplabel(83) "Sun Only"
    # MAT Hosts
    set tabbing(90) {13 20 }
    set toplabel(90) "Hostname     Services"
    # MAT Passwords
    set tabbing(91) {13 20 }
    set toplabel(91) "Login        Access"
    # MAT Logs
    set tabbing(92) {0 0 }
    set toplabel(92) "Read Only log files"
    set tabbing(94) {10 }
    set toplabel(94) "Type  Quantity     Description"
    # MON Syslog Configuration
    set tabbing(111) {28 }
    set toplabel(111) "Event Type                  Log To"
    # MON Syslog File
    set tabbing(112) {}
    set toplabel(112) "Read Only"
    # TAPE functions 121 to 169

    # MATd functions
    set toplabel(151) "id#       Type    Task Type      When"
    
    # MON Entries
    # MON Lastlog
    set tabbing(201) {12 20 }
    set toplabel(201) "User        From                Time"
    # MON Processes
    set tabbing(202) {9 6 6 6 6}
    set toplabel(202) "User     PID   %CPU  %MEM  Stat  Command"    
    # MON Routing
    set tabbing(203) {16 16 16 7 5 5 7}
    set toplabel(203) "Destination     Gateway         Netmask         Flags  Met  Ref  Use    Interface"
    # MON SYSLOG
    set tabbing(204) {}
    set toplabel(204) "Time                Event"
    # MON Disk Space
    set tabbing(205) {20 10 10 10 6}
    set toplabel(205) "Disk Device         Size(k)   Used(k)   Free(k)  %Use   Mounted on"
    # MON Disk Space
    set tabbing(206) {30 }
    set toplabel(206) "Filesystem                    Permissions"
    # MON net trafic
    set tabbing(207) {20 }
    set toplabel(207) "Ethernet Activity"
    # MON net trafic
    set tabbing(208) {20 }
    set toplabel(208) "Socket Activity"
    # MON logins
    set tabbing(209) {20 }
    set toplabel(209) "Who     Device  Time"

    set bold "-background #c0c000 -relief raised -borderwidth 1"
    set normal "-background {} -relief flat"
    set select "-underline 1"
    set tplabel $win
    append tplabel "label"
    $tplabel configure -state normal
    $tplabel delete 0.0 end
    # catch "$tplabel insert end $toplabel($type)"
    catch "$tplabel insert end \"$toplabel($type)\""
    $tplabel configure -state disabled
  
    if { $type == 1 } {
	# ------------------------------  HOSTS  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lrange $tmp 2 end ]]
		append outline $tmp2
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "Hosts $currenthost $pzn [lindex $data $pzn ]" 
		if { [lindex $tmp 1 ] == "localhost" } {
		    $win tag configure l$pzn -foreground #0000a0
		} else {
		    $win tag configure l$pzn -foreground #000000
		}
	    } else {
		$win insert end "$tmp\n"
	    }
	}
	$win configure -state disabled
    } elseif {$type == 2 } {
	# -----------------  Groups  -------------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [split [lindex $data $pzn ] ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "Groups $currenthost $pzn [lindex $data $pzn ]" 
	    $win tag configure l$pzn -foreground #000000 
	}
	$win configure -state disabled
    } elseif { $type == 3 } {
	# --------------------------------  Fstab  --------------------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 3 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "Fstab $currenthost [lindex $data $pzn ]" 
	    if { [lindex $tmp 2 ]  == "nfs" } {
		$win tag configure l$pzn -foreground #209020
	    } elseif { [lindex $tmp 2 ] == "ext2" | [lindex $tmp 2 ] == "ufs" | [lindex $tmp 2 ] == "4.2" } {
		$win tag configure l$pzn -foreground #0000a0
	    } elseif { [lindex $tmp 2 ] == "msdos" | [lindex $tmp 2 ] == "vfat" } {
		$win tag configure l$pzn -foreground #a00000
	    } else {
		$win tag configure l$pzn -foreground #000000
	    }	   

	}
	$win configure -state disabled
    } elseif {$type == 4 } {
	# --------------------------------------  Inittab  ---------------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "
		append outline [lindex $tmp 2 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": " 
		append outline [lindex $tmp 3 ]
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		#	    $win tag bind l$pzn <Double-1>  "Groups $currenthost $pzn [lindex $data $pzn ]" 
	    } else {
		$win insert end "$tmp2\n"
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 5 } {
	# ------------------  This is the Users Displayer  -------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [split [lindex $data $pzn ] ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 3]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length [lindex $tmp 4]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 5 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length [lindex $tmp 5]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 6 ]
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "User $currenthost $pzn [lindex $data $pzn ]" 
	    if { [string index [lindex $tmp 1 ] 0 ] == "!" } {
		$win tag configure l$pzn -foreground #00a000
	    } elseif { [lindex $tmp 1 ] == "" } {
		$win tag configure l$pzn -foreground #a00000
	    } elseif { [lindex $tmp 1 ] == "*" } {
		$win tag configure l$pzn -foreground #0000a0
	    } else {
		$win tag configure l$pzn -foreground #000000
	    }
	}
	$win configure -state disabled
    }  elseif { $type == 6 } {
	# ---------------------------------  DNS Client  --------------------------------
	set master ""
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [string trimleft $tmp [lindex $tmp 0 ]]]
		append outline $tmp2
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "DnsClient $currenthost 0 0" 
		if { [lindex $tmp 0 ] == "domain" } {
		    $win tag configure l$pzn -foreground #0000a0
		} elseif { [lindex $tmp 0 ] == "search" } {
		    $win tag configure l$pzn -foreground #606020
		} else {
		    $win tag configure l$pzn -foreground #000000
		}
	    }
	}
	$win configure -state disabled
    } elseif {$type == 8 } {
	# ------------------------------  Mail Lists  ---------------------------------
	set master ""
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    lappend master $tmp2
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "

		set trimval [ expr [string length [lindex $tmp 0 ] ] + 1 ]
		set tmp3 [ string trim [ string range $tmp2 $trimval end ] ]

		append outline $tmp3
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "Mail $currenthost [lindex $data $pzn ]"
		set schar [string range $tmp3 0 0 ]
		if { $schar == ":" | $schar == "\""  } {
		    $win tag configure l$pzn -foreground #0000d0
		} elseif { $schar == "/" } {
		    $win tag configure l$pzn -foreground #20a020
		} elseif { $schar == "|" } {
		    $win tag configure l$pzn -foreground #20a090
		} else {
		    $win tag configure l$pzn -foreground #803030
		}
	    } else {
		$win insert end "$tmp2\n" 
	    }
	}
	$win configure -state disabled
    } elseif {$type == 9 } {
	# ------------------------------- Samba Shares  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "
		append outline [lindex $tmp 1 ]
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "Sudo $currenthost $pzn [lindex $data $pzn ]" 
	    } else {
		$win insert end "$tmp2\n"
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif {$type == 206 } {
	# ------------------------------- Exported Filesystems  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    set tmp [split $tmp2 ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lrange $tmp 1 end ]
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    #$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    #$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    #$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    #$win tag bind l$pzn <Double-1>  "Sudo $currenthost $pzn [lindex $data $pzn ]" 
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif {$type == 11 } {
	# ------------------------------- Sudo Users  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "Sudo $currenthost $pzn [lindex $data $pzn ]" 
	    } else {
		$win insert end "$tmp2\n"
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif {$type == 12 } {
	# ------------------------------- Crontab File  ---------------------------------
	set master ""
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    lappend master $tmp
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 2 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 3 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 4 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		for { set loc 5 } { $loc < [llength $tmp] } { incr loc 1 } {
		    set tmp2 [string trim [lindex $tmp $loc ]]
		    append outline "$tmp2 "
		}
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "CronEdit $currenthost $pzn [lindex $data $pzn ]" 
	    } else {
		$win insert end "$tmp\n"
		$win tag delete l$pzn
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif {$type == 13 } {
	# ------------------------------- Services  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline [string trim [lindex $tmp 1 ]]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 1]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline [lrange $tmp 2 end ]
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
#		set nb "$win tag bind l$pzn <Double-1> \"services $currenthost \{[lindex [split [lindex $data $pzn] ] 0]\} \{[lindex $data $pzn ]\}\""
	#	eval $nb
		$win tag bind l$pzn <Double-1>  "services $currenthost [lindex [lindex $data $pzn] 1] [lindex $data $pzn ]"
	    } else {
		$win insert end "$tmp\n"
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 19 } {
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    $win tag delete l$pzn
	    set tmp [lindex $data $pzn ]
	    $win insert end "$tmp\n" l$pzn
	    $win tag configure l$pzn -foreground #000000
	}
    } elseif { $type == 41 } {
	# ------------------------   This is the DNS Hosts Displayer  -----------------------------------
	global currentdomain
	set master ""
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    lappend master $tmp2
	    set tmp [split $tmp2 ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 1 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 1]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "DnsEdit $currenthost $currentdomain [lindex [ split [lindex $data $pzn ] ":" ] 0 ]  [lindex $data $pzn ]" 
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 42 } {
	# ------------------------   This is the DNS Secondary Displayer  -----------------------------
	global currentdomain 
	set master ""
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    lappend master $tmp2
	    set outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "DnsSecEdit $currentdomain [lindex $data $pzn ]" 
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 71 } {
	# ----------------------------  NIS Password  -------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [split [lindex $data $pzn ] ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length [lindex $tmp 3]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 4 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length [lindex $tmp 4]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 5 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length [lindex $tmp 5]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 6 ]
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "NISUser $currenthost [lindex [split [lindex $data $pzn] ":"] 0] [lindex $data $pzn ]" 
	    if { [string index [lindex $tmp 1 ] 0 ] == "!" } {
		$win tag configure l$pzn -foreground #00a000
	    } elseif { [lindex $tmp 1 ] == "" } {
		$win tag configure l$pzn -foreground #a00000
	    } elseif { [lindex $tmp 1 ] == "*" } {
		$win tag configure l$pzn -foreground #0000a0
	    } else {
		$win tag configure l$pzn -foreground #000000
	    }
	}
	$win configure -state disabled
    } elseif {$type == 72 } {
	# -----------------  NIS Groups  -------------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [split [lindex $data $pzn ] ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 2 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 2]]) } { incr cnt 1 } {
		append outline " "
	    }
	    append outline [lindex $tmp 3 ]
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "NISGroups $currenthost [lindex [split [lindex $data $pzn] ":"] 0] [lindex $data $pzn ]" 
#	    $win tag configure l$pzn -foreground #000000 -lmargin2 130
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 73 } {
	# ------------------------------  NIS HOSTS  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lindex $tmp 1 ]]
		append outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lrange $tmp 2 end ]]
		append outline $tmp2
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "NISHosts $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
		if { [lindex $tmp 1 ] == "localhost" } {
		    $win tag configure l$pzn -foreground #0000a0
		} else {
		    $win tag configure l$pzn -foreground #000000
		}
	    }
	}
	$win configure -state disabled
    } elseif {$type == 74 } {
	# -------------------------------  Mail Lists  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set tmp [split $tmp2 ":" ]
		set outline [lindex $tmp 0 ]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline ": "

		set trimval [ expr [string length [lindex $tmp 0 ] ] + 1 ]
		set tmp3 [ string trim [ string range $tmp2 $trimval end ] ]

		append outline $tmp3
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "Mail $currenthost $pzn [lindex $data $pzn ]"
		set schar [string range $tmp3 0 0 ]
		if { $schar == ":" | $schar == "\""  } {
		    $win tag configure l$pzn -foreground #0000d0
		} elseif { $schar == "/" } {
		    $win tag configure l$pzn -foreground #20a020
		} elseif { $schar == "|" } {
		    $win tag configure l$pzn -foreground #20a090
		} else {
		    $win tag configure l$pzn -foreground #803030
		}
	    } else {
		$win insert end "$tmp2\n" 
	    }
	}
	$win configure -state disabled
    } elseif { $type == 75 } {
	# ------------------------------  NIS Netgroup  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [split [lindex $data $pzn ] { 	} ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set lpcnt 0
		for  { set index 1 } { $index < [llength $tmp] } { incr index 1 } {
		    set tmp2 [string trim [lindex $tmp $index ]]
		    append outline $tmp2
		    append outline "  "
		    incr lpcnt 1
		    if { $lpcnt == 2 } {
			set lpcnt 0
			append outline "\n"
			for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0]) } { incr cnt 1 } {
			    append outline " "
			}
		    }
		}
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "NISNetgroup $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
		$win tag configure l$pzn -foreground #0000a0
	    } else {
		$win insert end "$tmp\n" 
	    } 
	}
	$win configure -state disabled
    } elseif { $type == 76 } {
	# ------------------------------  NIS Ethers  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		set tmp2 [string trim [lrange $tmp 1 end ]]
		append outline $tmp2
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "NISEthers $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
		$win tag configure l$pzn -foreground #0000a0
	    } else {
		$win insert end "$tmp\n" 
	    } 
	}
	$win configure -state disabled
    } elseif {$type == 77 } {
	# ------------------------------- NIS Services  ---------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline [string trim [lindex $tmp 1 ]]
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length [lindex $tmp 1]]) } { incr cnt 1 } {
		    append outline " "
		}
		append outline [lrange $tmp 2 end ]
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
#		set nb "$win tag bind l$pzn <Double-1> \"NISserv $currenthost \{[lindex [split [lindex $data $pzn] ] 0]\} \{[lindex $data $pzn ]\}\""
	#	eval $nb
		$win tag bind l$pzn <Double-1>  "services $currenthost [lindex [lindex $data $pzn] 1] [lindex $data $pzn ]"
	    } else {
		$win insert end "$tmp\n"
	    }
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 81 } {
	# ------------------------------  NFS Exports  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 1 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "NFSexport $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 90 } {
	# ------------------------   MAT Hosts Displayer  -----------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp2 [lindex $data $pzn ]
	    set tmp [split $tmp2 ":" ]
	    set outline [lindex $tmp 0 ]
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length [lindex $tmp 0]]) } { incr cnt 1 } {
		append outline " "
	    }
	    foreach line [ split [lindex $tmp 3 ] "," ] {
		if { $line == "DNS" } {
		    append outline "DNS Master  "
		} elseif { $line == "NIS" } {
		    append outline "NIS Master  "
		} elseif { $line == "NFS" } {
		    append outline "NFS Server  "
		} elseif { $line == "SAMBA" } {
		    append outline "Samba  "
		} elseif { $line == "TAPE" } {
		    append outline "Backup Master  "
		} elseif { $line == "USER1" } {
		    append outline "User Defined  "
		} elseif { $line == "REP" } {
		    append outline "Replication Master  "
		} 
	    }
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
	    $win tag bind l$pzn <Double-1>  "MatHost [lindex $data $pzn ]"
	    $win tag configure l$pzn -foreground #000000
	}
	$win configure -state disabled
    } elseif { $type == 91 } {
	# ---------------------------------  MAT USERS  ------------------------------
	global feature_list_file
	global feature_list
	set feature_list {}
	set fid [ open $feature_list_file r ]
	while { [ gets $fid fout ] > 0 } {
	    lappend feature_list $fout
	}
	close $fid
	for  { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [lindex [split $tmp ":" ] 0 ]
	    if { [string range $tmp2 0 0 ] != "#" && [string range $tmp2 0 0 ] != {} } {
		set outline $tmp2
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		# Don't use tmp2  needed for color
		foreach item [ perms2list  [string trim [lindex [split $tmp ":" ] 2 ]] $feature_list ] {
		    append outline "$item, "
		}
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		if { $tmp2 == "root" } {
		    $win tag configure l$pzn -foreground #000000
		    $win tag bind l$pzn <Any-Enter> ""
		    $win tag bind l$pzn <Any-Leave> ""
		    $win tag bind l$pzn <Button-1> ""
		    $win tag bind l$pzn <Double-1>  "" 
		} else {
		    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		    $win tag bind l$pzn <Double-1>  "MatUser $currenthost $pzn [lindex $data $pzn ]" 
		    $win tag configure l$pzn -foreground #0000a0
		}
	    }
	}
	$win configure -state disabled
    } elseif { $type == 94 } {
	# ---------------------------------  MAT License  ------------------------------
	for  { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [lindex [split $tmp ":" ] 1 ]
	    set tmp3 [ getFeature [lindex [split $tmp ":" ] 0 ] ]
	    if { $tmp3 != {-} } {
		set outline "[lindex [split $tmp ":" ] 0 ]   "
		if { $tmp2 == {*} } {
		    append outline "Demo"
		} else {
		    append outline $tmp2
		}
		for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		    append outline " "
		}
		
		append outline $tmp3
		$win tag delete l$pzn
		$win insert end "$outline\n" l$pzn
		if { $tmp2 == "*" } {
		    $win tag configure l$pzn -foreground #0000a0
		} else {
		    $win tag configure l$pzn -foreground #000000
		}
		$win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
		$win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
		$win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
		$win tag bind l$pzn <Double-1>  "MatLic $currenthost [lindex $data $pzn ]" 
	    }
	}
	$win configure -state disabled
    } elseif { $type == 201 } {
	# ------------------------------  MON Lastlog  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 2 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    set login [lindex $tmp 0 ]
	    if { $login == "root" } {
		$win tag configure l$pzn -foreground #0000a0
	    } elseif { $login == "reboot" | $login == "shutdown" } {
		$win tag configure l$pzn -foreground #a04040
	    } else {
		$win tag configure l$pzn -foreground #000000
	    }
	}
	$win configure -state disabled
    } elseif { $type == 202 } {
	# ------------------------------  MON Processes  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 3 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 4 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 5 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
#	    $win tag bind l$pzn <Double-1>  "NISHosts $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
	    if { [lindex $tmp 0 ] == "root" } {
		$win tag configure l$pzn -foreground #000000
	    } else {
		$win tag configure l$pzn -foreground #0000a0
	    }
	}
	$win configure -state disabled
    } elseif { $type == 203 } {
	# ------------------------------  MON Routing  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 3 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 4 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 5 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 5] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 6 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 6] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 7 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"
#	    $win tag bind l$pzn <Double-1>  "NISHosts $currenthost [lindex [split [lindex $data $pzn] ] 0] [lindex $data $pzn ]" 
	    if { [lindex $tmp 0 ] == "127.0.0.0" } {
		$win tag configure l$pzn -foreground #000000
	    } else {
		$win tag configure l$pzn -foreground #0000a0
	    }
	}
	$win configure -state disabled
    } elseif { $type == 205 } {
	# ------------------------------  MON Disk Use  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 1 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 1] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 2 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 2] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 3 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 3] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lindex $tmp 4 ]]
	    append outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 4] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 5 end ]]
	    append outline $tmp2
	    $win tag delete l$pzn
	    $win insert end "$outline\n" l$pzn
	    set capacity [string trim [lindex $tmp 4 ]]
	    if { $capacity >= 95  } {
		$win tag configure l$pzn -foreground #e00000
	    } elseif { $capacity >= 90 & $capacity < 95 } {
		$win tag configure l$pzn -foreground #b02020
	    } else {
		$win tag configure l$pzn -foreground #000000
	    }
	}
	$win configure -state disabled
    } elseif { $type == 111 } {
	# ------------------------------  MON Syslogd Config  --------------------------------
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    set tmp [lindex $data $pzn ]
	    set tmp2 [string trim [lindex $tmp 0 ]]
	    set outline $tmp2
	    for { set cnt 0 } { $cnt < ([lindex $tabbing($type) 0] -[string length $tmp2 ]) } { incr cnt 1 } {
		append outline " "
	    }
	    set tmp2 [string trim [lrange $tmp 1 end ]]
	    append outline $tmp2
	    $win insert end "$outline\n" l$pzn
	    $win tag configure l$pzn -foreground #000000
	    $win tag bind l$pzn <Any-Enter> "$win tag configure l$pzn $bold"
	    $win tag bind l$pzn <Any-Leave> "$win tag configure l$pzn $normal"
	    $win tag bind l$pzn <Button-1> "Selecter $win l$pzn"

	    set nb "$win tag bind l$pzn <Double-1> \"SyslogConf $currenthost \{[lindex [split [lindex $data $pzn] ] 0]\} \{[lindex $data $pzn ]\}\""
	    eval $nb
	}
	$win configure -state disabled
    } elseif { ( $type > 120 ) & ( $type < 132 ) } {
	tapeText $data $win $type
    } elseif { $type == 151 } {
	taskText $data $win $type
    } elseif { $type == 161 } {
	tapeText $data $win $type
    } elseif { ( $type > 250 ) & ( $type < 260 ) } {
	replText $data $win $type
    } else {
	for { set pzn 0 } { $pzn < [llength $data] } { incr pzn 1 } {
	    $win tag delete l$pzn
	    set tmp [lindex $data $pzn ]
	    $win insert end "$tmp\n" l$pzn
	    $win tag configure l$pzn -foreground #000000
	}
    }
    . config -cursor top_left_arrow
    $win config -cursor xterm
}


#
# tclick   Text right-click shortcuts
#
# USE:  tclick calling_window  
#
proc tclick { w } {
    set mpos [winfo pointerxy $w ]
    if {[string match $w [eval winfo contain $mpos ]]} {
	# Cursor on window
	set n .crclick
	if ![winfo exists $n ] {
	    toplevel $n
	    wm override $n 1
	    wm withdraw $n
	    text $n.t -width 10 -height 3 -relief raised 
	    pack $n.t
	}
	update idle
	
	# Create the text box entries and bindings
	set cnt 0
	set bold "-background #c0c000 -relief raised -borderwidth 1"
	set normal "-background {} -relief flat"
	global currenthost
	global browse
	global level
	set labels {New Modify Delete}
	foreach val $labels {
	    $n.t insert end "$val\n" tag$cnt
	    $n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
	    $n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
	    incr cnt 1
	}
	$n.t tag bind tag0 <Button-1> ".commonframe.new invoke ;destroy $n"
	$n.t tag bind tag1 <Button-1> ".commonframe.mod invoke ;destroy $n"
	$n.t tag bind tag2 <Button-1> ".commonframe.del invoke ;destroy $n"
	
	bind $n <Any-Leave> "destroy $n"
	set x [expr [lindex $mpos 0 ] - 10 ]
	set y [expr [lindex $mpos 1 ] - 10 ]
	wm geometry $n +$x+$y
	wm deiconify $n
	raise $n
    }
}

