# defaults.tcl Library
#
# Copyright (c) 1998 Mark Black
#
# This file contains all the routines for reading/writing/modifing
# the MAT defaults file.  The MAT defaults file contains system 
# configuration information.

# The following are the currently recognized defaults:
#     colorScheme  - The color scheme



# The defaults are stored as name value pairs in this array
set defsv {}

#
# readDefaults - Read in the defaults file and store it in 
#                the defsv variable 
proc readDefaults {} {
    global defsv
    set defsv {}
    set df "../defaults"
    catch "open $df r" retval
    if { [string range $retval 0 3 ] == "file" } {
	puts stdout "Reading defaults"
	while { [ gets $retval fout ] > 0 } {
	    lappend defsv $fout
	}
	close $retval
    } else {
	puts stdout "Defaults file not found, ignoring"
    }
}


#
# setDefault - Set a default parameter in the defaults file
#
proc setDefault { parmName parmVal } {
    global defsv

    # Scan the list of defaults and set the appropriate value
    set found 0
    for { set po 0 } { $po < [llength $defsv] } { incr po 1 } {
	set tmp [lindex $defsv $po]
	set name [lindex $tmp 0]
	set val [lindex $tmp 1]
	if { [string compare $name $parmName] == 0 } {
	    # This is it:  Replace it
	    set found 1
	    set defsv [lreplace $defsv $po $po "$parmName $parmVal" ]
	    puts stdout "NEW array = $defsv"
	}
    }
    puts stdout "Array = $defsv"
    if { !$found } {
	lappend defsv "$parmName $parmVal"
    }

    # Write out file
    set df "../defaults"
    catch "open $df w" retval
    if { [string range $retval 0 3 ] == "file" } {
	# Save to write
	foreach l $defsv {
	    puts $retval $l
	}
	close $retval
    } else {
	puts stdout "ERROR:  Cannot save defaults, ignoring"
    }
}


#
# getDefault - Read the value of a default variable
#              Returns {} on not defined
#
proc getDefault { parmName } {
    global defsv

    if { [llength $defsv ] == 0 } {
	readDefaults
    }

    # Scan the list of defaults and set the appropriate value
    set found 0
    for { set p 0 } { $p < [llength $defsv] } { incr p 1 } {
	set tmp [lindex $defsv $p]
	set name [lindex $tmp 0]
	set val [lindex $tmp 1]
	if { [string compare $name $parmName] == 0 } {
	    # This is it:  Return it
	    return $val
	}
    }
    return {}
}


