# Cron.tcl
#
# Copyright (c) 1997 Mark Black
# Alpha release

#
# CronEdit  - Edit a crontab entry
#
# USE: CronEdit CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc CronEdit { ch currentline line args } {
    set host $ch
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .crn ] == 0 } {
	toplevel .crn -class Dialog
	wm title .crn "Crontab Editor: $ch"
	wm iconname .crn "Crontab Editor"
	entry .crn.hidden1 
	entry .crn.hidden2
	entry .crn.hidden3
	# NOT GOOD
	.crn.hidden1 insert end $ch
	.crn.hidden2 insert end $currentline
	.crn.hidden3 insert end $line

	#grab set .crn

	frame .crn.f1 -bd 2 -relief "raised"
	label .crn.f1.l1 -text "Process:" -width 12
	entry .crn.f1.e1 -width 32
	pack .crn.f1.l1 .crn.f1.e1 -fill x -side left -expand 1
	frame .crn.f2 -bd 2 -relief "raised"
	label .crn.f2.l1 -text "Comment:" -width 12
	entry .crn.f2.e1 -width 32
	pack .crn.f2.l1 .crn.f2.e1 -fill x -side left -expand 1

	frame .crn.f3 -bd 2 -relief "raised"
	menubutton .crn.f3.l1 -text "Minutes:" -width 12 -menu .crn.f3.l1.m -relief raised
	menu .crn.f3.l1.m -tearoff 0 
	for { set cnt 0 } { $cnt < 61 } { incr cnt 5 } {
	    .crn.f3.l1.m add command -label $cnt -command ".crn.f3.e1 insert end \"$cnt,\" "
	}
	entry .crn.f3.e1 -width 32
	pack .crn.f3.l1 .crn.f3.e1 -fill x -side left -expand 1 -pady 4

	frame .crn.f4 -bd 2 -relief "raised"
#	menubutton .crn.f4.l1 -text "Hours:" -width 12 -direction below -menu .crn.f4.l1.m -relief raised
	menubutton .crn.f4.l1 -text "Hours:" -width 12 -menu .crn.f4.l1.m -relief raised
	menu .crn.f4.l1.m -tearoff 0 
	set hours {{1} {2} {3} {4} {5} {6} {7} {8} {9} {10} {11} {12} {13} {14} {15} {16} {17} {18} {19} {20} {21} {22} {23} {Any}}
	for { set cnt 0 } { $cnt < 24 } { incr cnt 1 } {
	    .crn.f4.l1.m add command -label [lindex $hours $cnt] -command ".crn.f4.e1 insert end \"[lindex $hours $cnt],\" "
	}
	entry .crn.f4.e1 -width 32
	pack .crn.f4.l1 .crn.f4.e1 -fill x -side left -expand 1 -pady 4

	frame .crn.f5 -bd 2 -relief "raised"
	menubutton .crn.f5.l1 -text "Month Days:" -width 12 -menu .crn.f5.l1.m -relief raised
	menu .crn.f5.l1.m -tearoff 0 
	set monthdays {{1} {2} {3} {4} {5} {6} {7} {8} {9} {10} {11} {12} {13} {14} {15} {16} {17} {18} {19} {20} {21} {22} {23} {24} {25} {26} {27} {28} {29} {30} {31} {Any}}
	for { set cnt 0 } { $cnt < 32 } { incr cnt 1 } {
	    .crn.f5.l1.m add command -label [lindex $monthdays $cnt ] -command ".crn.f5.e1 insert end \"[lindex $monthdays $cnt ],\" "
	}
	entry .crn.f5.e1 -width 32
	pack .crn.f5.l1 .crn.f5.e1 -fill x -side left -expand 1 -pady 4

	frame .crn.f6 -bd 2 -relief "raised"
	menubutton .crn.f6.l1 -text "Month:" -width 12 -menu .crn.f6.l1.m -relief raised
	menu .crn.f6.l1.m -tearoff 0 
	set months {{Jan} {Feb} {Mar} {Apr} {May} {Jun} {Jul} {Sep} {Oct} {Nov} {Dec} {Any}}
	for { set cnt 0 } { $cnt < 12 } { incr cnt 1 } {
	    .crn.f6.l1.m add command -label [lindex $months $cnt ] -command ".crn.f6.e1 insert end \"[lindex $months $cnt ],\" "
	}
	entry .crn.f6.e1 -width 32
	pack .crn.f6.l1 .crn.f6.e1 -fill x -side left -expand 1 -pady 4

	frame .crn.f7 -bd 2 -relief "raised"
	menubutton .crn.f7.l1 -text "Week Day:" -width 12 -menu .crn.f7.l1.m -relief raised
	menu .crn.f7.l1.m -tearoff 0 
	set weekday {{Sun} {Mon} {Tue} {Wed} {Thu} {Fri} {Sat} {Any}}
	for { set cnt 0 } { $cnt < 8 } { incr cnt 1 } {
	    .crn.f7.l1.m add command -label [lindex $weekday $cnt ] -command ".crn.f7.e1 insert end \"[lindex $weekday $cnt ],\" "
	}
	entry .crn.f7.e1 -width 32
	pack .crn.f7.l1 .crn.f7.e1 -fill x -side left -expand 1 -pady 4

	frame .crn.f8 -bd 2 -relief "raised"
	button .crn.f8.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [.crn.f1.e1 get] != "" } {
		# Update the master list
		global master
		# Condition the variables first
		set nmin [string trimright [.crn.f3.e1 get ] "," ]
		foreach v [split $nmin {,} ] {
		    if { $v == "Any" } {
			set nmin "*"
			break
		    }
		}
		set nhour [string trimright [.crn.f4.e1 get ] "," ]
		foreach v [split $nhour {,} ] {
		    if { $v == "Any" } {
			set nhour "*"
			break
		    }
		}
		set nmday [string trimright [.crn.f5.e1 get ] "," ]
		foreach v [split $nmday {,} ] {
		    if { $v == "Any" } {
			set nmday "*"
			break
		    }
		}
		set nmonth [ month2num [.crn.f6.e1 get ]]
		foreach v [split $nmonth {,} ] {
		    if { $v == "Any" } {
			set nmonth "*"
			break
		    }
		}
		set nday [ day2num [.crn.f7.e1 get ]]
		foreach v [split $nday {,} ] {
		    if { $v == "Any" } {
			set nday "*"
			break
		    }
		}
		set currentline [.crn.hidden2 get]
		if { $currentline != 9999 } {
		    set newcron [ lreplace $master [.crn.hidden2 get] [.crn.hidden2 get] "$nmin $nhour $nmday $nmonth $nday [.crn.f1.e1 get ]" ]
		    # Update comment if needed
		    set tmp2 [expr $currentline - 1 ] 
		    set tmp [ lindex $master $tmp2 ]
		    if { [string range $tmp 0 1 ] == "#v" } {
			set master [ lreplace $newcron $tmp2 $tmp2 "#v [.crn.f2.e1 get ]" ]
		    } else {
			set master $newcron
		    }
		} else {
		    lappend master "#v [.crn.f2.e1 get ]"
		    lappend master "$nmin $nhour $nmday $nmonth $nday [.crn.f1.e1 get ]"
		} 
		set upgrade_buff {}
		set upgrade_buff $master
		puts stdout $upgrade_buff
		set cmd "put local crontab"
		set returnval [queryHost [.crn.hidden1 get ] $cmd 1 "ext" "put" "v" "upgrade_buff" ]
		if { [lindex [split [lindex $returnval [expr [llength $returnval] - 1]] " " ] 0 ] == "ERROR:" } {
		    error 361
		    puts stdout "ERROR:  Unable to upload the crontab to $ch"
		} else {
		    # Send the command to update the crontab
		    set cmd "CON set crontab"
		    set returnval [queryHost [.crn.hidden1 get ] $cmd 1 ]
		    if { [lindex [split [lindex $returnval [expr [llength $returnval] - 1]] " " ] 0 ] == "ERROR:" } {
			error 362
			puts stdout "ERROR:  Unable to update crontab on $ch"
		    } else {
			set returndata [queryHost [.crn.hidden1 get ] "CON get crontab" 0 ]
			filltext $returndata .general.text 12
			grab release .crn
			destroy .crn
		    }
		}
	    } else {
		error 360
	    }
	}
	button .crn.f8.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    set returndata [queryHost [.crn.hidden1 get ] "get crontab" 0 ]
	    filltext $returndata .general.text 12
	    destroy .crn
	}
	button .crn.f8.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help cronedit
	}
	pack .crn.f8.b1 .crn.f8.b2 .crn.f8.b3 -side left -fill x 
	

	pack .crn.f1 .crn.f2 .crn.f3 .crn.f4 .crn.f5 .crn.f6 .crn.f7 .crn.f8 -fill both -side top -expand 1
    } else {
	wm title .crn "Crontab Editor: $ch"
	.crn.hidden1 delete 0 end
	.crn.hidden2 delete 0 end
	.crn.hidden3 delete 0 end
	.crn.hidden1 insert end $ch
	.crn.hidden2 insert end $currentline
	.crn.hidden3 insert end $line
	.crn.f1.e1 delete 0 end
	.crn.f2.e1 delete 0 end
	.crn.f3.e1 delete 0 end
	.crn.f4.e1 delete 0 end
	.crn.f5.e1 delete 0 end
	.crn.f6.e1 delete 0 end
	.crn.f7.e1 delete 0 end
    }
    # ----------- Bindings -------------
    bind .crn.f1.e1 <Return> {
	focus .crn.f2.e1
    }
    bind .crn.f2.e1 <Return> {
	focus .crn.f3.e1
    }
    bind .crn.f3.e1 <Return> {
	focus .crn.f4.e1
    }
    bind .crn.f4.e1 <Return> {
	focus .crn.f5.e1
    }
    bind .crn.f5.e1 <Return> {
	focus .crn.f6.e1
    }
    bind .crn.f6.e1 <Return> {
	focus .crn.f7.e1
    }
    bind .crn.f7.e1 <Return> {
	focus .crn.f1.e1
    }

    # -----------------  Fill Entries ----------------
    if { $currentline != 9999 } {
	# Modify
	.crn.f3.e1 insert end "[ string trim [lindex $line 0 ]],"
	set tmp [ string trim [lindex $line 1 ]]
	if { $tmp == {*} } {
	    .crn.f4.e1 insert end "Any,"
	} else {
	    .crn.f4.e1 insert end "$tmp,"
	}
	set tmp [ string trim [lindex $line 2 ]]
	if { $tmp == {*} } {
	    .crn.f5.e1 insert end "Any,"
	} else {
	    .crn.f5.e1 insert end "$tmp,"
	}
	set tmp [ string trim [lindex $line 3 ]]
	month2day .crn.f6.e1 $tmp
	set tmp [ string trim [lindex $line 4 ]]
	num2day .crn.f7.e1 $tmp
	for { set loc 5 } { $loc < [llength $line] } { incr loc 1 } {
	    .crn.f1.e1 insert end "[string trim [lindex $line $loc ] ] "
	}

	if { $currentline > 0 } {
	    global master
	    set tmp [ lindex $master [expr $currentline - 1 ] ]
	    if { [string range $tmp 0 1 ] == "#v" } {
		.crn.f2.e1 insert end [string range $tmp 3 end]
		set comment 1
	    }
	}
    }
}


#
# Convert the day names to cron numbers
#
proc day2num { data } {
    set output {}
    foreach day [ split $data {,} ] {
	if { $day == "Sun" } {
	    append output "0,"
	} elseif { $day == "Mon" } {
	     append output "1,"
	} elseif { $day == "Tue" } {
	    append output "2,"
	} elseif { $day == "Wed" } {
	    append output "3,"
	} elseif { $day == "Thu" } {
	    append output "4,"
	} elseif { $day == "Fri" } {
	    append output "5,"
	} elseif { $day == "Sat" } {
	    append output "6,"
	} elseif { $day == "Any" } {
	    append output "*,"
	} 
    }
    return [string trimright $output "," ]
}

#
# Convert the month names to cron numbers
#
proc month2num { data } {
    set output {}
    foreach day [ split $data {,} ] {
	if { $day == "Jan" } {
	    append output "1,"
	} elseif { $day == "Feb" } {
	    append output "2,"
	} elseif { $day == "Mar" } {
	    append output "3,"
	} elseif { $day == "Apr" } {
	    append output "4,"
	} elseif { $day == "May" } {
	    append output "5,"
	} elseif { $day == "Jun" } {
	    append output "6,"
	} elseif { $day == "Jul" } {
	    append output "7,"
	} elseif { $day == "Aug" } {
	    append output "8,"
	} elseif { $day == "Sep" } {
	    append output "9,"
	} elseif { $day == "Oct" } {
	    append output "10,"
	} elseif { $day == "Nov" } {
	    append output "11,"
	} elseif { $day == "Dec" } {
	    append output "12,"
	} elseif { $day == "Any" } {
	    append output "*,"
	} 
    }
    return [string trimright $output "," ]
}


#
# Fill an entry box with the day names given the munbers
#
proc num2day { window data } {
    foreach day [ split $data {,} ] {
	if { $day == "0" } {
	    $window insert end "Sun,"
	} elseif { $day == "1" } {
	    $window insert end "Mon,"
	} elseif { $day == "2" } {
	    $window insert end "Tue,"
	} elseif { $day == "3" } {
	    $window insert end "Wed,"
	} elseif { $day == "4" } {
	    $window insert end "Thu,"
	} elseif { $day == "5" } {
	    $window insert end "Fri,"
	} elseif { $day == "6" } {
	    $window insert end "Sat,"
	} elseif { $day == {*} } {
	    $window insert end "Any,"
	} 
    }
}


#
# Fill an entry box with the month names given the munbers
#
proc month2day { window data } {
    foreach day [ split $data {,} ] {
	if { $day == "1" } {
	    $window insert end "Jan,"
	} elseif { $day == "2" } {
	    $window insert end "Feb,"
	} elseif { $day == "3" } {
	    $window insert end "Mar,"
	} elseif { $day == "4" } {
	    $window insert end "Apr,"
	} elseif { $day == "5" } {
	    $window insert end "May,"
	} elseif { $day == "6" } {
	    $window insert end "Jun,"
	} elseif { $day == "7" } {
	    $window insert end "Jul,"
	} elseif { $day == "8" } {
	    $window insert end "Aug,"
	} elseif { $day == "9" } {
	    $window insert end "Sep,"
	} elseif { $day == "10" } {
	    $window insert end "Oct,"
	} elseif { $day == "11" } {
	    $window insert end "Nov,"
	} elseif { $day == "12" } {
	    $window insert end "Dec,"
	} elseif { $day == {*} } {
	    $window insert end "Any,"
	} 
    }
    $window delete end end
}


# CronEdit localhost 23 0 4 * * date




