# color.tcl
#
# Copyright (c) 1998 Mark Black
#
# This file contains the code for selecting the color scheme
#

proc setColor {} {
    if { [winfo exists .scol ] != 0 } {
	destroy .scol
    }

    toplevel .scol -class Dialog
    wm title .scol "Color Scheme"
    wm iconname .scol "MAT Color"

    frame .scol.f1 
    scrollbar .scol.f1.scroll -command ".scol.f1.list yview"
    listbox .scol.f1.list -yscroll ".scol.f1.scroll set" \
	    -width 20 -height 16 -setgrid 1
    pack .scol.f1.scroll .scol.f1.list -side left -fill y -expand 1

    set cschm "SlateGray3"

    frame .scol.f2
    button .scol.f2.b1 -text "Default" -command "setDefault colorScheme SlateGray3 ; tk_setPalette SlateGray3 ;destroy .scol"
    button .scol.f2.b2 -text "Save" -command "setDefault colorScheme \$cschm ; destroy .scol"
    pack .scol.f2.b1 .scol.f2.b2 -side left -anchor w
    pack .scol.f1 .scol.f2 -side top 

    bind .scol.f1.list <Double-1> {
	tk_setPalette [selection get]
	set cschm [selection get]
    }

    .scol.f1.list insert 0 gray60 gray70 gray80 gray85 gray90 gray95 \
	    snow4 seashell4 AntiqueWhite4 bisque4 PeachPuff4 NavajoWhite4 \
	    LemonChiffon4 cornsilk4 ivory4 honeydew4 LavenderBlush4 \
	    MistyRose4 azure4 SlateBlue4 RoyalBlue4 blue4 DodgerBlue4 \
	    SteelBlue4 DeepSkyBlue4 SkyBlue4 LightSkyBlue4 SlateGray4 \
	    LightSteelBlue4 LightBlue4 LightCyan4 PaleTurquoise1 \
	    PaleTurquoise2 PaleTurquoise3 PaleTurquoise4 CadetBlue4 \
	    turquoise4 cyan4 DarkSlateGray4 aquamarine4 DarkSeaGreen4 \
	    SeaGreen4 PaleGreen4 SpringGreen4 green4 chartreuse4 \
	    OliveDrab4 DarkOliveGreen4 khaki4 LightGoldenrod4 \
	    LightYellow4 yellow4 gold4 goldenrod4 DarkGoldenrod4 \
	    RosyBrown4 IndianRed4 sienna4 burlywood4 wheat4 tan4 \
	    chocolate4 firebrick4 brown4 LightSalmon4 orange4 \
	    DarkOrange4 coral4 tomato4 OrangeRed4 red4 DeepPink4 \
	    HotPink4 pink4 LightPink4 PaleVioletRed4 maroon4 VioletRed4 \
	    magenta4 orchid4 plum4 MediumOrchid4 DarkOrchid4 \
	    purple4 thistle4
}




