# Canvas.tcl 
# Copyright (c) 1997 Mark Black
#
# This file contains the routines for populating the canvas widget:  
#      fillCan
#      populateCan
#      rclick
#      canMON
#      canDNSM  
#      canARCHIVE
#      canMAT
#      canNFS
#      canNIS



#
# -------------------- Procedure for filling the canvas ----------------
#
#  Level = The command/host level
#          10 = Host select canvas
#          20 = Config file select
#          30 = Stat Selector
#          40 = DNS Master
#          50 = MAT User
#          60 = TAPE Server
#          70 = NIS Server
#          80 = NFS Server
#          90 = MAT Internals
#          100 = System Monitor
#          110 = Syslog monitor
#          120 = TAPE Backups         \
#          127 = Media management      \
#          130 = TAPE Restores          --> Combined
#          140 = TAPE Backup Schedule  /
#          150 = MATD Tasks
#          160 = TAPE Drives
#          200 = Extended Monitor 
#          250 = Replicator
#          900 = USER DEFINED 1
#
proc fillCan { tlevel } {
    if { [winfo exists .tp.host.canvas ] != 0 } {
	destroy .tp.host.canvas
    }

    # Clear the text display each time fillcan is called
    .general.text config -cursor watch
    .general.text configure -state normal
    .general.text delete 0.0 end
    .general.text configure -state disabled
    .general.text config -cursor xterm
    .general.label configure -text "-"
    .general.textlabel configure -state normal
    .general.textlabel delete 0.0 end
    .general.textlabel configure -state disabled

    canvas .tp.host.canvas -height 180 -width 600 -yscrollcommand {.tp.host.vscroll set } -scrollregion { 0 0 500 250 } -confine 0
    pack .tp.host.canvas -side left -fill both -expand 1
    if { $tlevel == 10 } {
	.tp.title configure -text "Host"
	set fig(0) [ image create photo -file "../lib/back.gif" ]
	set hostok [ image create photo -file "../lib/host_ok.gif" ]
	#set hostalrm [ image create photo -file "../lib/host_alrm.gif" ]
	#set hostsel [ image create photo -file "../lib/host_select.gif" ]
	#set hostselalrm [ image create photo -file "../lib/host_select_alrm.gif" ]
	set hostoff [ image create photo -file "../lib/host_off.gif" ]
	set hostlinux [ image create photo -file "../lib/host_linux.gif" ]
	set hostsun [ image create photo -file "../lib/host_sun.gif" ]
	set hostsgi [ image create photo -file "../lib/host_sgi.gif" ]
	set hosthp [ image create photo -file "../lib/host_hp.gif" ]
	set cntn [ image create photo -file "../lib/contain.gif" ]
	global level
	set level 10
	# +++++  Fill canvas with HOST icons  +++++
	global mb_hosts currenthost active_hosts box

	bind .tp.host.canvas <Button-3> "rclick .tp.host.canvas"

	bind .tp.host.canvas <B1-Motion> {
	    moveNode [ .tp.host.canvas find withtag current ] [expr %x-$curX ] [expr %y-$curY ] %x %y
	    set curX %x
	    set curY %y
        }
	bind .tp.host.canvas <Button-1> {
	    set curX %x
	    set curY %y
        }

	set startX 30
	set startY 30
	set icon_size 48
	set incX 70
	set incY 80
	set cntx 0
	set maxY 0
	# Need to put a back pointer in if Container != 0, or != NULL
	if { $box != "0" } {
	    # draw a back arrow and set the binding
	    set bk [ string range $box 0 [expr [ string length $box ] - 2 ] ]
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(0) -tags "Back" ]
	    .tp.host.canvas bind "Back" <Double-1> "set box $bk ;fillCan 10"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "<- Back" -tags "Back" \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	}

	foreach line $active_hosts {
	    # The line of data contains numerous fields
	    # Data format is:    hostname:OS:Container:Services:status:Xposition:Yposition:
	    # Container format is:  Containname:cont:this-level:next-level:0:Xposition:Yposition:
	    set clvl [ lindex [split $line ":" ] 2 ]
	    if { $clvl == {} } { set clvl 0 }
	    if { $clvl == $box } {
		# It's a member of the same box
		set hostname [ lindex [split $line ":" ] 0 ]
		set type [ lindex [split $line ":" ] 1 ]
		set status [ lindex [split $line ":" ] 4 ]
		set nX [ lindex [split $line ":" ] 5 ]
		set nY [ lindex [split $line ":" ] 6 ]
		if { $nX != {} & $nY != {} } {
		    set sX $nX
		    set sY $nY
		    if { $maxY < $nY } {
			set maxY $nY
		    }
		} else {
		    set sX $startX
		    set sY $startY
		    incr startX $incX
		    incr cntx 1
		    if { $cntx == 8 } {
			set cntx 0
			set startX 30
			incr startY $incY 
		    }
		}
		if { $type == "cont" } {
		    # This is a box
		    set node [ .tp.host.canvas create image $sX $sY -image $cntn -tags $hostname ]
		    .tp.host.canvas bind $hostname <Double-1> " \
			    set box [ lindex [split $line ":" ] 3 ] ; \
			    fillCan 10 ; \
			    wm title . \"Box: $hostname\" "

		} else {
		    if { $status == 0 } {
			set node [ .tp.host.canvas create image $sX $sY -image $hostoff -tags $hostname ]
		    } elseif { $type == "linux" } {
			set node [ .tp.host.canvas create image $sX $sY -image $hostlinux -tags $hostname ]
		    } elseif { $type == "sunos" | $type == "solaris" } {
			set node [ .tp.host.canvas create image $sX $sY -image $hostsun -tags $hostname ]
		    } elseif { $type == "irix" } {
			set node [ .tp.host.canvas create image $sX $sY -image $hostsgi -tags $hostname ]
		    } elseif { $type == "hpux" } {
			set node [ .tp.host.canvas create image $sX $sY -image $hosthp -tags $hostname ]
		    } else {
			set node [ .tp.host.canvas create image $sX $sY -image $hostok -tags $hostname ]
		    }
		    .tp.host.canvas bind $hostname <Double-1> " \
			    set currenthost $hostname ; \
			    fillCan 20 ; "
			    #  wm title . \"MAT on: $hostname\" "
		    
		}
		
		set nameLabel [ .tp.host.canvas create text $sX [expr $sY + 0.7 * $icon_size] \
			-justify center -text $hostname \
			-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} -tags $hostname ]
		# Build a list of all the pertenant data
		set iconName($node) $hostname
		set node2nameLabel($node) $nameLabel
		
	    }
	}
	incr startY $incY
	set sregion { 0 0 600 }
	if { $maxY > $startY } {
	    lappend sregion $maxY
	} else {
	    lappend sregion $startY
	}
	.tp.host.canvas configure -scrollregion $sregion
    } elseif { $tlevel == 20 } {
	# +++++  Fill canvas with Configuration icons  +++++
	global currenthost
	global active_hosts
	.tp.title configure -text "Host($currenthost) --> Config"
	set fig(19) [ image create photo -file "../lib/editany.gif" ]
	set fig(80) [ image create photo -file "../lib/export.gif" ]
	set fig(40) [ image create photo -file "../lib/dnsm.gif" ]
	set fig(90) [ image create photo -file "../lib/mat.gif" ]
	set fig(60) [ image create photo -file "../lib/tape.gif" ]
	set fig(70) [ image create photo -file "../lib/yp.gif" ]
	set fig(200) [ image create photo -file "../lib/monitor.gif" ]
	set fig(110) [ image create photo -file "../lib/syslog.gif" ]
	set fig(150) [ image create photo -file "../lib/monitored.gif" ]
	set fig(250) [ image create photo -file "../lib/replicate.gif" ]
	set fig(900) [ image create photo -file "../lib/userdef1.gif" ]

	set startX 40
	set startY 40
	set icon_size 48
	set incX 70
	set incY 80
	#	set config_label { <-Back Users Groups Hosts Motd {DNS Client} Mail Mounts Tasks Inittab Samba Exports Sudoers }
	#	set browse_val { -10 5 2 1 7 6 8 3 0 4 9 10 11 }
        set config_label { <-Back Users Groups Hosts Motd {DNS Client} Mail Mounts Services Cron}
	set browse_val { -10 5 2 1 7 6 8 3 13 12}
	global level
	set level 20
	# Mouse Helper
	bind .tp.host.canvas <Button-3> "rclick .tp.host.canvas"
	global browse

	set retval [populateCan $config_label $browse_val ]

	set startX [lindex $retval 0 ]
	set startY [lindex $retval 1 ]
	set cntx 1

	# -----------  Special Icon for Syslogd  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(110) -tags sysd ]
	.tp.host.canvas bind sysd <Double-1> "fillCan 110"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text "Sys Logs" -tags sysd \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cntx 1
	if { $cntx == 7 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}

	# -----------  Special Icon for Editany  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(19) -tags edany ]
	.tp.host.canvas bind edany <Double-1> "editany $currenthost"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text "Edit File" -tags edany \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cntx 1
	if { $cntx == 7 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}

	# -----------  Special Icon for Matd  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(150) -tags matdd ]
	.tp.host.canvas bind matdd <Double-1> "fillCan 150"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text "MATd" -tags matd \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cntx 1
	if { $cntx == 7 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}

	# -----------  Special Icon for System Monitoring  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(200) -tags mon ]
	.tp.host.canvas bind mon <Double-1> "fillCan 200"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text "Status" -tags mon \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cntx 1
	if { $cntx == 7 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}
	# -----------  Special Icon for MAT  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(90) -tags matu ]
	.tp.host.canvas bind matu <Double-1> "fillCan 50"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text "MAT" -tags matu \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cntx 1
	if { $cntx == 7 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}
	set HasDNS 0
	set HasNIS 0
	set HasNFS 0
	set HasSAMBA 0
	set HasTAPE 0
	set HasUSER1 0
	set HasRep 0
	foreach mathost $active_hosts {
	    if { $currenthost == [ lindex [split $mathost ":" ] 0 ] } {
		set services [ lindex [split $mathost ":" ] 3 ]
		break
	    } else {
		foreach data [split [ lindex [split $mathost ":" ] 3 ] "," ] {
		    if { $data == "TAPE" } {
			set HasTAPE 1
		    } 
		}
	    }
	}

	foreach data [split $services "," ] {
	    if { $data == "DNS" } {
		set HasDNS 1
	    } elseif { $data == "NIS" } {
		set HasNIS 1
	    } elseif { $data == "NFS" } {
		set HasNFS 1
	    } elseif { $data == "SAMBA" } {
		set HasSAMBA 1
	    } elseif { $data == "TAPE" } {
		set HasTAPE 1
	    } elseif { $data == "USER1" } {
		set HasUSER1 1
	    } elseif { $data == "REP" } {
		set HasRep 1
	    }
	}
	if { $HasDNS == 1 } {
	    # -----------  Special Icon for DNS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(40) -tags dnsm ]
	    .tp.host.canvas bind dnsm <Double-1> "fillCan 40"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "DNS Master" -tags dnsm \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
	if { $HasNIS == 1 } {
	    # -----------  Special Icon for NIS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(70) -tags nism ]
	    .tp.host.canvas bind nism <Double-1> "fillCan 70"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "NIS Master" -tags nism \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
	if { $HasNFS == 1 } {
	    # -----------  Special Icon for NFS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(80) -tags nfs ]
	    .tp.host.canvas bind nfs <Double-1> "fillCan 80"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "NFS Server" -tags nfs \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
	if { $HasTAPE == 1 } {
	    # -----------  Special Icon for Backup/Restore  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(60) -tags bak ]
	    .tp.host.canvas bind bak <Double-1> "fillCan 60"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "Archive" -tags bak \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
	if { $HasUSER1 == 1 } {
	    # -----------  Special Icon for User Defined Parameters  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(900) -tags usr1 ]
	    .tp.host.canvas bind usr1 <Double-1> "fillCan 900"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "User Defined" -tags usr1 \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
	if { $HasRep == 1 } {
	    # -----------  Special Icon for File/Dir Replication  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(250) -tags rep ]
	    .tp.host.canvas bind rep <Double-1> "fillCan 250"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		    -justify center -text "Replication" -tags rep \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cntx 1
	    if { $cntx == 7 } {
		set cntx 0
		set startX 40
		incr startY $incY 
	    }
	}
    } elseif { $tlevel == 30 } {
	global currenthost
	.tp.title configure -text "Host($currenthost) --> Config --> Host Stats"
	# Reserved for Stat screens
    } elseif { $tlevel == 40 } { 
	# ---------------  DNS Master Screen  --------------------------
	canDNSM
    } elseif { $tlevel == 60 } {
	# ---------------------  Backup/Restore Window  ---------------------
	canARCHIVE
    } elseif { $tlevel == 50 } {
	# ---------------------  MAT Control Window  ---------------------
	canMAT
    } elseif { $tlevel == 70 } {
	# ---------------------  NIS Server Window  ---------------------
	canNIS
    } elseif { $tlevel == 80 } {
	# ---------------------  NFS Server Window  ---------------------
	canNFS
    } elseif { $tlevel == 200 } {
	# ---------------------  System Monitoring Window  ---------------------
	canMON
    } elseif { $tlevel == 110 } {
	# ---------------------  Syslog Monitoring Window  ---------------------
	global currenthost
	global currentdomain
	global level
	global browse
	global upgrade_buff
	.general.label configure -text "System Logs"
	.tp.title configure -text "Host($currenthost) --> Config --> Syslogs"
	set level 110
	# Enable the accelerators
	# bind .tp.host.canvas <Button-3> "rclick .tp.host.canvas"
	# Put in back button
	set fig(0) [ image create photo -file "../lib/back.gif" ]
 	set fig(1) [ image create photo -file "../lib/new.gif" ]
	set fig(2) [ image create photo -file "../lib/logfile.gif" ]
	set startX 50
	set startY 40
	set icon_size 48
	set incX 120
	set inc2X 120
	set incY 80
	set cnt 0
	set cntx 0
	set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Back" ]
	.tp.host.canvas bind "Back" <Double-1> "repack -20"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
		-justify center -text "<- Back" -tags "Back" \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $inc2X 
	incr cnt 1
	incr cntx 1
	set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Syslogd" ]
	.tp.host.canvas bind "Syslogd" <Double-1> "set browse 111 ; repack 111"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
		-justify center -text "Log Config" -tags "Syslogd" \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $inc2X 
	incr cnt 1
	incr cntx 1
	# Draw icons for each domain
	set cmd "MON get syslogconf"
	set data [queryHost $currenthost $cmd 0 ]
	for { set position 0 } { $position < [llength $data] } { incr position 1 } {
	    set tmp [split [lindex $data $position ] {	} ]
	    set tmp2 [ lindex [lindex $data $position ] end ]
	    if { [string index $tmp2 0 ] == {/} } {
		set node [ .tp.host.canvas create image $startX $startY -image $fig(2) -tags $tmp2 ]
		.tp.host.canvas bind $tmp2 <Double-1> "set upgrade_buff $tmp2; ;set browse 112 ; repack 112"
		set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
			-justify center -text "Log file\n$tmp2" -tags $tmp2 \
			-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
		incr startX $inc2X 
		incr cnt 1
		if { $cnt == 5 } {
		    set cnt 0
		    set startX 50
		    incr startY $incY 
		}
	    }

	}

    } elseif { $tlevel == 120 } {
	# ---------------------  Tape Backup Window  ---------------------
	canBACKUP
    } elseif { $tlevel == 127 } {
	# ---------------------  Tape Media Window  ---------------------
	canMEDIA
    } elseif { $tlevel == 130 } {
	# ---------------------  Tape Restore Window  ---------------------
	canRESTORE
    } elseif { $tlevel == 140 } {
	# ---------------------  Tape Scheduling Window  ---------------------
	canTSCHED
    } elseif { $tlevel == 150 } {
	# ---------------------  MATD Task Window  ---------------------
	canMATD
    } elseif { $tlevel == 160 } {
	# ---------------------  TAPE Drives Window  ---------------------
	canTDRIVE
    } elseif { $tlevel == 250 } {
	# ---------------------  Replication Window  ---------------------
	canREPL
    } elseif { $tlevel == 900 } {
	# ---------------------  USER Defined 1 Window  ---------------------
	canUSER1
    }
}


# 
# Move a host to another location, and record it's position
#
proc moveNode { node xDist yDist cx cy} {
    set t [expr $node % 2 ]
    if { $t == 1 } {
	# This is the icon
	.tp.host.canvas move $node $xDist $yDist
	.tp.host.canvas move [expr $node + 1 ] $xDist $yDist
    } else {
	# This is the text
	.tp.host.canvas move [expr $node - 1 ] $xDist $yDist
	.tp.host.canvas move $node $xDist $yDist
    }
    set sr [ .tp.host.canvas cget -scrollregion ]
    if { [lindex $sr 3 ] < $cy } {
	set srnew { 0 0 600 }
	lappend srnew [ expr  ($cy * 1.5) + 40  ]
	.tp.host.canvas configure -scrollregion $srnew
    }
}

#
# Build the MAT Control Window
#
proc canMAT {} {
    global currenthost
    global level
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> MAT"
    set level 50
    set config_label { <-Back Users Logs Upgrade License}
    set browse_val { -20 91 92 93 94}
    populateCan $config_label $browse_val
}


#
# Build the DNS Master window
#
proc canDNSM {} {
    global currenthost
    global currentdomain
    global level
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> DNS Master"
    set level 40
    # Enable the accelerators
    bind .tp.host.canvas <Button-3> "rclick .tp.host.canvas"
    # Put in back button
    set fig(0) [ image create photo -file "../lib/back.gif" ]
    set fig(1) [ image create photo -file "../lib/new.gif" ]
    set fig(2) [ image create photo -file "../lib/hosts.gif" ]
    set fig(3) [ image create photo -file "../lib/dns_hup.gif" ]
    set fig(4) [ image create photo -file "../lib/dnssec.gif" ]
    set startX 40
    set startY 40
    set icon_size 48
    set incX 100
    set incY 80
    set cnt 0
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "<- Back" -tags "<-Back" \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX 80 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "New" ]
    .tp.host.canvas bind "New" <Double-1> "DnsMConfig $currenthost -"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
	    -justify center -text "New Domain" -tags "New" \
	    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    # Draw icons for each domain
    set cmd "DNS get domain"
    set returndata [queryHost $currenthost $cmd 0 ]
    set tmp [ split $returndata ":" ]
    # puts stdout $returndata
    if { $returndata != {} } {
	foreach line $tmp {
	    set tmp2 [ split $line "," ] 
	    set type [ lindex $tmp2 0 ]
	    set masterip [ lindex $tmp2 1 ]
	    set domain [ lindex $tmp2 2 ]
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(2) -tags $domain ]
	    .tp.host.canvas bind $domain <Double-1> "set currentdomain $domain ;set browse 41 ;repack 41"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
		    -justify center -text "Domain\n$domain" -tags $domain \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    if { $cnt == 6 } {
		set cnt 0
		set startX 40
		incr startY $incY 
	    }
	    # ---------------  Add the DNS HUP Icon -----------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(3) -tags s$domain ]
	    .tp.host.canvas bind s$domain <Double-1> "DnsHUP $currenthost"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] \
		    -justify center -text "Restart\n$domain" -tags s$domain \
		    -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    if { $cnt == 6 } {
		set cnt 0
		set startX 40
		incr startY $incY 
	    }
	    # ---------------  Add the Secondaries Icon -----------------
#	    set node [ .tp.host.canvas create image $startX $startY -image $fig(4) -tags s$domain ]
#	    .tp.host.canvas bind s$domain <Double-1> "set currentdomain $domain ;set browse 42 ;repack 42"
#	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.8 * $icon_size] -justify center -text "Secondaries\n$domain" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
#	    incr startX $incX 
#	    incr cnt 1
#	    if { $cnt == 6 } {
#		set cnt 0
#		set startX 30
#		incr startY $incY 
#	    }
	}	
    }
}


#
# Build the MONitoring screen
#
proc canMON {} {
    # ---------------------  MONitoring System Window  ---------------------
    global currenthost
    global level
    set level 200
    global browse
    set config_label {<-Back Lastlog Logins Process Route Disk_Space Exported Traffic Sockets}
    set browse_val { -20 201 209 202 203 205 206 207 208}

    set retval [populateCan $config_label $browse_val ]

    set startX [lindex $retval 0 ]
    set startY [lindex $retval 1 ]
    set cntx 1
    set icon_size 48
    set incX 70
    set incY 80
}


#
# rclick   Canvas right-click shortcuts
#
# USE:  rclick calling_window  
#
proc rclick { w } {
    set mpos [winfo pointerxy $w ]
    if {[string match $w [eval winfo contain $mpos ]]} {
	# Cursor on window
	set n .crclick
	if ![winfo exists $n ] {
	    toplevel $n
	    wm override $n 1
	    wm withdraw $n
	    text $n.t -width 10 -height 2 -relief raised
	    pack $n.t
	}
	update idle

	# Create the text box entries and bindings
	set cnt 0
	set bold "-background #c0c000 -relief raised -borderwidth 1"
	set normal "-background {} -relief flat"
	global currenthost
	global currentdomain
	global browse
	global level
	if { $level == 10 } {
	    set labels {About New}
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		incr cnt 1 
	    }
	    $n.t tag bind tag1 <Button-1> "MatHost ;destroy $n"
	    $n.t tag bind tag0 <Button-1> "hostinfo $currenthost"
	} elseif { $level == 20 } {
	    set labels {Users Groups Hosts Motd {DNS Client} Aliases Mounts Cron Services}
	    set bval {5 2 1 7 6 8 3 12 13}
	    $n.t insert end "-- NEW --\n"
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		if {[lindex $bval $cnt ] != "-" } {
		    $n.t tag bind tag$cnt <Button-1> "set browse [lindex $bval $cnt ] ; .commonframe.new invoke ;destroy $n"
		}
		incr cnt 1 
	    }
	    $n.t insert end "---------\n" tag99
	    # puts stdout "Hello World"
	    set subs {Archive Mat MATd Status Syslog}
	    set clevel {60 50 150 100 110}
	    set ncnt 0
	    foreach val $subs {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		$n.t tag bind tag$cnt <Button-1> "fillCan set [lindex $clevel $ncnt ] ;destroy $n"
		incr cnt 1
		incr ncnt 1
	    }
	    $n.t tag bind tag8 <Button-1> "fillCan 100 ;destroy $n"
	    $n.t tag bind tag9 <Button-1> "fillCan 50 ;destroy $n"

	} elseif { $level == 40 } {
	    set labels {New Refresh Properties Delete}
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		incr cnt 1 
	    }
	    $n.t tag bind tag0 <Button-1> "DnsMConfig $currenthost -"
	    $n.t tag bind tag1 <Button-1> "DnsHUP $currenthost"
	    $n.t tag bind tag2 <Button-1> "DnsMConfig $currenthost $currentdomain"
	    $n.t tag bind tag3 <Button-1> "DnsDelDomain $currentdomain"
	    
	} elseif { $level == 70 } {
	    $n.t insert end "-- NEW --\n"
	    set labels {Passwords Groups Hosts Aliases Netgroups Ethers {Push Maps}}
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		incr cnt 1 
	    }
	    $n.t tag bind tag0 <Button-1> "NISUser $currenthost 9999 0"
	    $n.t tag bind tag1 <Button-1> "NISGroups $currenthost 9999 0"
	    $n.t tag bind tag2 <Button-1> "NISHosts $currenthost 9999 0"
	    $n.t tag bind tag3 <Button-1> "NISMail $currenthost 9999 0"
	    $n.t tag bind tag4 <Button-1> "NISNetgroup $currenthost 9999 0"
	    $n.t tag bind tag5 <Button-1> "NISEthers $currenthost 9999 0"
	} elseif { $level == 120 } {
	    set labels {{Backup To} {Backup Who} {Backup What}}
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		incr cnt 1 
	    }
	    $n.t tag bind tag0 <Button-1> "tapeDevs $currenthost 9999"
	    $n.t tag bind tag0 <Button-1> "tapeGroup $currenthost 9999 9999"
	    $n.t tag bind tag1 <Button-1> "tapeJobs $currenthost 9999 9999"
	} elseif { $level == 250 } {
	    set labels {Group Replicate}
	    foreach val $labels {
		$n.t insert end "$val\n" tag$cnt
		$n.t tag bind tag$cnt <Any-Enter> "$n.t tag configure tag$cnt $bold"
		$n.t tag bind tag$cnt <Any-Leave> "$n.t tag configure tag$cnt $normal"
		incr cnt 1 
	    }
	    $n.t tag bind tag0 <Button-1> "tapeGroup $currenthost 9999 9999"
	    $n.t tag bind tag1 <Button-1> "replJobs $currenthost -9999 -9999:::::::::"
	} 
	$n.t configure -height [llength $labels]
	bind $n <Any-Leave> "destroy $n"
	set x [expr [lindex $mpos 0 ] - 10 ]
	set y [expr [lindex $mpos 1 ] - 10 ]
	wm geometry $n +$x+$y
	wm deiconify $n
	raise $n
    }
}


#
# populateCan 
# This function fills the canvas widget with the standard icons
# and sets the appropriate bindings.  It returns the last X,Y 
# coordinates used. 
# USE:  populateCan { config_label browse_val }
# config_label - a List containing the names of the icons
# browse_val - A list of the browse value corresponding to the function
proc populateCan { config_label browse_val } {
    # Generic Icons
    set fig(-10) [ image create photo -file "../lib/back.gif" ]
    set fig(-20) [ image create photo -file "../lib/back.gif" ]
    set fig(-100) [ image create photo -file "../lib/back.gif" ]

    # Local Config Icons
    set fig(0) [ image create photo -file "../lib/crontab.gif" ]
    set fig(1) [ image create photo -file "../lib/hosts.gif" ]
    set fig(2) [ image create photo -file "../lib/groups.gif" ]
    set fig(3) [ image create photo -file "../lib/fstab.gif" ]
    set fig(5) [ image create photo -file "../lib/users.gif" ]
    set fig(6) [ image create photo -file "../lib/dnsc.gif" ]
    set fig(7) [ image create photo -file "../lib/motd.gif" ]
    set fig(8) [ image create photo -file "../lib/alias.gif" ]
    set fig(12) [ image create photo -file "../lib/crontab.gif" ]
    set fig(13) [ image create photo -file "../lib/services.gif" ]
    # fig(19) is reserved for editany
    # Archive Icons
    set fig(61) [ image create photo -file "../lib/backup.gif" ]
    set fig(62) [ image create photo -file "../lib/restore.gif" ]
    set fig(63) [ image create photo -file "../lib/sched.gif" ]
    # NIS Icons
    set fig(71) [ image create photo -file "../lib/users.gif" ]
    set fig(72) [ image create photo -file "../lib/groups.gif" ]
    set fig(73) [ image create photo -file "../lib/hosts.gif" ]
    set fig(74) [ image create photo -file "../lib/alias.gif" ]
    set fig(75) [ image create photo -file "../lib/netgrp.gif" ]
    set fig(76) [ image create photo -file "../lib/ethers.gif" ]
    set fig(77) [ image create photo -file "../lib/services.gif" ]
    set fig(79) [ image create photo -file "../lib/rocket.gif" ]
    # NFS Icons
    set fig(81) [ image create photo -file "../lib/export.gif" ]
    set fig(82) [ image create photo -file "../lib/nfsclient.gif" ]
    set fig(83) [ image create photo -file "../lib/nfsstat.gif" ]
    # MAT control Icons
    set fig(91) [ image create photo -file "../lib/mat_user.gif" ]
    set fig(92) [ image create photo -file "../lib/mat_logs.gif" ]
    set fig(93) [ image create photo -file "../lib/mat_upgrd.gif" ]
    set fig(94) [ image create photo -file "../lib/mat_lic.gif" ]
    # Monitoring Icons
    set fig(201) [ image create photo -file "../lib/lastlog.gif" ]
    set fig(202) [ image create photo -file "../lib/process.gif" ]
    set fig(203) [ image create photo -file "../lib/route.gif" ]
    set fig(204) [ image create photo -file "../lib/syslog.gif" ]
    set fig(205) [ image create photo -file "../lib/disk.gif" ]
    set fig(206) [ image create photo -file "../lib/export.gif" ]
    set fig(207) [ image create photo -file "../lib/moneth.gif" ]
    set fig(208) [ image create photo -file "../lib/moneth.gif" ]
    set fig(209) [ image create photo -file "../lib/userlogs.gif" ]
    # MATd Icons
    set fig(151) [ image create photo -file "../lib/crontab.gif" ]

    set startX 40
    set startY 40
    set icon_size 48
    set incX 70
    set incY 80
    set cnt 0
    set cntx 0

    foreach type $config_label {
	set btype [ lindex $browse_val $cnt ]
	set node [ .tp.host.canvas create image $startX $startY -image $fig($btype) -tags $type ]
	.tp.host.canvas bind $type <Double-1> "set browse $btype ;repack $btype"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] \
		-justify center -text [ lindex $config_label $cnt ] -tags $type \
		-font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cnt 1
	incr cntx 1
	if { $cntx == 8 } {
	    set cntx 0
	    set startX 40
	    incr startY $incY 
	}
    }
    set retval $startX
    lappend retval $startY
    return $retval
}
