#!/bin/sh

# DNSNamedHUP - Send the HUP signal to the named deamon.
# If the deamon is not running then start it.

# NOTE:  If you modify this code, you MUST change the version to
#        something over 100 to prevent it being replaced by future
#        versions of this script. 
VER=1
export VER

# If we have input args look for -v
case "$1" in

'-v')
    echo $VER
    exit 0
    ;;

'-1')
    echo "1"
    exit 0
    ;;
esac

killproc() {            # kill the named process(es)                            
        pid=`/usr/bin/ps -e |                                                   
             /usr/bin/grep $1 |                                                 
             /usr/bin/sed -e 's/^  *//' -e 's/ .*//'`                           
        [ "$pid" != "" ] && kill $pid                                           
} 

OS=`uname -s`
PATH=/usr/sbin:/bin:/usr/bin:/usr/etc:/usr/ucb:$PATH

case "$OS" in 
    "Linux")
        # Linux OS
        PID=`ps -ax |grep named |grep -v grep |awk -F' ' '{print $1}'` 2> /dev/null
	if [ `echo $PID |wc -w` -eq 0 ]                                                                 
	then
	    echo "Warning:  The DNS server appears to be not running."
	    named 
	    if [ $? -ne 0 ]                                                                 
	    then
		echo "ERROR:  Unable to start DNS server."
		exit 1
	    else
	        echo "DNS server started."
	    fi
        else
	    echo "Sending HUP to DNS deamon"
	    kill -HUP ${PID}
	fi
    ;;

    "SunOS")
        # SunOS 4.1.x, and Solaris
        PID=`ps -ax |grep in.named |grep -v grep |awk -F' ' '{print $1}'` 2> /dev/null
	if [ `echo $PID |wc -w` -eq 0 ] 
	then
	    echo "Warning:  The DNS server appears to be not running."
	    in.named 
	    if [ $? -ne 0 ]                                                                 
	    then
		echo "ERROR:  Unable to start DNS server."
		exit 1
	    else
	        echo "DNS server started."
	    fi
	else
	    kill -HUP ${PID}
	fi
    ;;
esac










