#!/bin/sh

#  This is to be run from $MATHOME/tmp.  The upgrade files should be in 
#  the same location.

# NOTE:  Do NOT modify this script it will be overwritten when the
#        next upgrade is applied

NEW=1
export NEW

PATH=/bin:/usr/bin:/usr/etc:/usr/ucb:/usr/sbin
export PATH

# If we have input args look for -v
case "$1" in

'-v')
    echo $NEW
    exit 0
    ;;

'-1')
    echo "1"
    exit 0
    ;;
esac


MATHOME="$PWD"
MATBIN="$MATHOME/bin"
MATTMP="$MATHOME/tmp"
MATSRC="$MATHOME/scripts"

# Get the version of the MATd
MVER=`$MATBIN/matd -v |awk -F' ' '{ print $1 }'`

echo "MAT version $MVER found"

if [ `expr $MVER = 0.19 \| $MVER = 0.20 \| $MVER = 0.21 \| $MVER = 0.22` ]; then
    # As of 0.19 all scripts provide version numbers.  Only the lower
    # version scripts will be replaced.
    for i in `cat $MATTMP/catalog` ;
    do
	# Check versions
	CVER=`$MATTMP/$i -v`
        if [ -f $MATSRC/$i ]; then
	    VER=`$MATSRC/$i -v |awk -F' ' '{ print $1 }'`
	    if [ $CVER -gt $VER ]; then
		echo "Upgrading MAT script $i.  Old version $VER.  New version $CVER"
		mv $MATTMP/$i $MATSRC/$i
		chmod 755 $MATSRC/$i
	    else
		echo "No upgrade of $i.  Old version $VER.  New version $CVER"
		rm $MATTMP/$i
	    fi
	else
	    echo "MAT script $i not found.  Adding."
	    mv $MATTMP/$i $MATSRC/$i
	    chmod 755 $MATSRC/$i
	fi
    done
else
    echo "Pre 0.19 MAT install.  Replacing all scripts"
    for i in `cat $MATTMP/catalog` ;
    do
	# The older versions of the scripts did not support "-v", so
	# we have to replace them blindly
	echo "Upgrading MAT script $i"
	mv $MATTMP/$i $MATSRC/$i
        chmod 755 $MATSRC/$i
   done

fi

rm $MATTMP/catalog

# Upgrade tape Library
mv $MATTMP/libtape.so $MATBIN/libtape.so
chmod 755 $MATBIN/libtape.so

# Upgrade the MATd binary
if [ -f $MATBIN/matd ]; then
    echo "Upgrading MATd"
    mv $MATTMP/matd $MATBIN/matd
else
    echo "MATd not found.  Adding."
    mv $MATTMP/matd $MATBIN/matd
fi
chmod 755 $MATBIN/matd

echo "The matd needs to be restarted."
echo "Different Linux ps's make this difficult to script."

# Add the directories and files necessary for the tape code
if [ -d $MATHOME/var/tape/jobids ]; then
    echo "Already configured for tapes"
else
    echo "Making backup job request directory"
    mkdir -p $MATHOME/var/tape/jobids
    touch $MATHOME/var/tape/jobids/index
    touch $MATHOME/var/tape/jobids/group
fi
touch $MATHOME/var/tape/bhistory
# Add the password entry if needed
if [ -f $MATHOME/etc/MATpass ]; then
    HAV=`grep archive_user $MATHOME/etc/MATpass`
    if [ -z "$HAV" ]; then
	echo "archive_user:MCM5uW|sTxxA_1qAZlithP90xd:c" >> $MATHOME/etc/MATpass
    fi
else
    echo "** WARNING **  MATpass not found.  Creating!"
    echo "root:MCGbE|h0_b6Bu1qAjgZFlOZF8M:0" > $MATHOME/etc/MATpass
    echo "archive_user:MCM5uW|sTxxA_1qAZlithP90xd:c" >> $MATHOME/etc/MATpass
fi

# Clean up
if [ -f $MATTMP/mat.tar ]; then
    rm $MATTMP/mat.tar
fi
if [ -f $MATTMP/Umat.000 ]; then
    rm $MATTMP/Umat.000
fi

# Add Licenses
echo "dns:*:0:11166:5_75Z47YVW7UZ:" > $MATHOME/etc/MATlic.dat
echo "nis:*:0:11166:7755YY5YUU5UY:" >> $MATHOME/etc/MATlic.dat
echo "nfs:*:0:11166:UWTURSTQVWTUR:" >> $MATHOME/etc/MATlic.dat
echo "rep:*:0:11166:VWUTSRUPWVUTS:" >> $MATHOME/etc/MATlic.dat
echo "mon:*:0:11166:BCA6CBA6CBA6C:" >> $MATHOME/etc/MATlic.dat
echo "tps:*:0:11166:CEDE6ADADEDE6:" >> $MATHOME/etc/MATlic.dat
echo "gen:*:0:11166:LMMLIHMHEDMDI:" >> $MATHOME/etc/MATlic.dat

# Upgrade the MAT cmd binary
if [ -f $MATBIN/cmd ]; then
    echo "Upgrading MAT cmd"
    mv $MATTMP/cmd $MATBIN/cmd
else
    echo "MAT cmd not found.  Adding."
    mv $MATTMP/cmd $MATBIN/cmd
fi
chmod 755 $MATBIN/cmd

# Terminate communications with the MAT console, before 
# trying to replace the matagent binary
echo "TRANSFER OK"

# Upgrade the MAT agent binary
if [ -f $MATBIN/matagent ]; then
    echo "Upgrading MAT agent"
    mv $MATTMP/matagent $MATBIN/matagent
else
    echo "MAT agent not found.  Adding."
    mv $MATTMP/matagent $MATBIN/matagent
fi
chmod 755 $MATBIN/matagent




