#include "string.h"
#include "stdlib.h"
#include <ctype.h>

/* Split.c
   This function returna a pointer to an array of pointers.
   The individual pointers point to the elements withint str1
   which are delimited by the character delim

   USE:   char *outputs[16], stop, delimiter ;
          split(&outputs,"String to split", delimiter , stop) ;
   The string will be broken into stop parts.  The delimiter is a 
   single character.  The input string WILL be destroyed!  After the 
   function data has been used it MUST be free'ed

   Function returns the number of strings found.

   NOTE:  There is a limit of 16 split strings
   by Mark Black
*/
int split( char *output[], char *str1, char delim, char stop) ;


/* WSSPLIT:
   Split a string into its individual words, setting the whitespace characters to '\0'.
   Stop after finding last words.
   NOTE: This destroys the input string
   Returns the number of words found.
   */
int wssplit(char *output[], char *indata, char last) ;


/* INSPLIT:
   Split a string into its individual strings, based on the occurance
   of spliton char.   Stop after finding stop words.
   NOTE: This destroys the input string
   Returns the number of words found.
   */
int insplit(char *output[], char *indata, char spliton, int last) ;






