#!/bin/sh

# cronGet.sh - Send a copy of the root crontable
#

# NOTE:  If you modify this code, you MUST change the version to
#        something over 100 to prevent it being replaced by future
#        versions of this script. 
VER=1
export VER

# If we have input args look for -v
case "$1" in

'-v')
    echo $VER
    exit 0
    ;;

'-i')
    echo "1"
    exit 0
    ;;
esac

OS=`uname -s`
PATH=/usr/sbin:/bin:/usr/bin:/usr/etc:/usr/ucb:$PATH

case "$OS" in 
    "Linux")
        # Linux OS
        crontab -l > tmp/cron.out
	if [ $? -ne 0 ]                                                                 
	then
	    echo "ERROR:  Unable to get root's cron table."
	    exit 1
	fi
    ;;

    "SunOS")
        # SunOS 4.1.x, and Solaris
        crontab -l > tmp/cron.out
	if [ $? -ne 0 ]                                                                 
	then
	    echo "ERROR:  Unable to get root's cron table."
	    exit 1
	fi
    ;;

    "HP-UX")
        # HPUX
        crontab -l > tmp/cron.out
	if [ $? -ne 0 ]                                                                 
	then
	    echo "ERROR:  Unable to get root's cron table."
	    exit 1
	fi
    ;;

    "IRIX" | "IRIX64")
        # IRIX
        crontab -l > tmp/cron.out
	if [ $? -ne 0 ]                                                                 
	then
	    echo "ERROR:  Unable to get root's cron table."
	    exit 1
	fi
    ;;
esac










