/*
	Extension to POP server for virtual mail server management.
	Written by Jacques Gelinas jacques@solucorp.qc.ca

	Use as needed :-)
	This does not supersede the original POP server license. It only
	apply to this file.
*/
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>


void strlwr (char *dst, const char *src)
{
	while (*src != '\0'){
		*dst++ = tolower(*src);
		src++;
	}
	*dst = '\0';
}
/*
	Extract which virtual host is expected by the POP client.
	Return -1 if any error.
*/
int vmail_getourname(char *name)
{
	int ret = -1;
	struct sockaddr_in adr;
	int len = sizeof(adr);
	if (getsockname (0,(struct sockaddr*)&adr,&len) != -1){
		/* syslog (LOG_DEBUG,"connexion de %d %x",adr.sin_port,adr.sin_addr); */ 
		struct hostent *ent = gethostbyaddr ((const char*)&adr.sin_addr
			,sizeof(adr.sin_addr.s_addr),AF_INET);
		/* syslog (LOG_DEBUG,"connexion de %p",ent); */
		if (ent != NULL){
			strlwr (name,ent->h_name);
			/* syslog (LOG_DEBUG,"connexion de %s",name); */
			ret = 0;
		}
	}
	return ret;
}
 
static int vmail_splitline (const char *line, char words[9][100])
{
	int nbword = 0;
	char *dst = words[0];
	int i;
	for (i=0; i<9; i++) words[i][0] = '\0';
	while (*line != '\0' && *line != '\n'){
		if (*line == ':'){
			line++;
			*dst = '\0';
			nbword++;
			dst = words[nbword];
		}else{
			*dst++ = *line++;
		}
	}
	*dst = '\0';
	return nbword;
}



/*
	Lookup a user in a file with the same layout as /etc/passwd
*/
struct passwd *vmail_getpwnam (const char *pwdfile, const char *user)
{
	struct passwd *ret = NULL;
	FILE *fin = fopen (pwdfile,"r");
	if (fin != NULL){
		char buf[400];
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			static char words[9][100];
			static struct passwd p = {
				words[0],
				words[1],
				0,
				0,
				words[4],
				words[5],
				words[6]
			};
			int nb = vmail_splitline (buf,words);
			if (strcmp(user,words[0])==0){
				ret = &p;
				p.pw_uid = atoi(words[2]);
				p.pw_gid = atoi(words[3]);
				break;
			}
		}
		fclose (fin);
	}
	return ret;
}

