#include <stdio.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <pwd.h>
#include <grp.h>
#include <errno.h>
#include <string.h>
#include "pop3.h"

static void vdeliver_checkdir(const char *dirpath)
{
	struct stat st;
	if (stat(dirpath,&st)==-1){
		fprintf (stderr,"Directory %s does not exist\n",dirpath);
		exit (-1);
	}else if (!S_ISDIR(st.st_mode)){
		fprintf (stderr,"%s is not a directory\n",dirpath);
		exit (-1);
	}
}

static void vdeliver_copy (FILE *fout)
{
	char buf[1000];
	while (fgets(buf,sizeof(buf)-1,stdin)!=NULL){
		fputs (buf,fout);
	}
}

static FILE *vdeliver_openex (const char *fname, struct passwd *pwd)
{
	FILE *ret = NULL;
	int i;
	for (i=0; i<20; i++){
		ret = fopen (fname,"a");
		if (ret == NULL){
			break;
		}else{
			int fd = fileno(ret);
			if (flock(fd, LOCK_EX) != -1) {
				struct group *grp = getgrnam ("mail");
				int mailgid = 0;
				if (grp != NULL) mailgid = grp->gr_gid;
				fchown (fd,pwd->pw_uid,mailgid);
				fchmod (fd,0600);
				break;
			}else{
				fclose(ret);
				ret = NULL;
				sleep(1);
			}
		}
	}
	if (i==20 && ret == NULL) fprintf (stderr,"Can't lock %s\n",fname);
	return ret;
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 3){
		fprintf (stderr,"vdeliver: Invalid arguments\n");
		fprintf (stderr,"          expect user domain\n");
	}else{
		const char *user = argv[1];
		char domain[PATH_MAX];
		char pwdfile[PATH_MAX];
		struct passwd *pwd;
		strlwr (domain,argv[2]);
		sprintf (pwdfile,"/etc/vmail/passwd.%s",domain);
		pwd = vmail_getpwnam (pwdfile,user);
		if (pwd == NULL){
			fprintf (stderr,"Unknown user: %s\n",user);
		}else{
			FILE *fout;
			char dirpath[PATH_MAX],filepath[PATH_MAX];
			struct stat st;
			sprintf (dirpath,"/var/spool/vmail/%s",domain);
			vdeliver_checkdir (dirpath);
			sprintf (filepath,"%s/%s",dirpath,user);
			fout = vdeliver_openex (filepath,pwd);
			if (fout != NULL){
				vdeliver_copy (fout);
				ret = fclose (fout);
			}else{
				fprintf (stderr,"Can't open file %s (%s)\n"
					,filepath,strerror(errno));

			}
		}
	}
	return ret;
}
		

