#pragma implementation
#include "uucp.h"
#include <misc.h>
#include "uucp.m"
#include "internal.h"

extern UUCP_HELP_FILE help_uucp;

/*
	Main menu of uucp management
*/
void uucp_edit ()
{
	int choice=0;
	while (1){
		static const char *systems = MSG_U(M_SYSTEMS,"Systems");
		static const char *devices = MSG_U(M_HOSTS,"Devices and modems");
		static const char *menuopt[]={
			MSG_U(M_CONFIG,"Configure"),		systems,
			" ",		devices,
			NULL
		};
		MENU_STATUS code = xconf_menu (
			MSG_U(T_UUCP,"UUCP configurator")
			,MSG_U(I_UUCP,"This package allows you to configure from\n"
			 "scratch a UUCP network using modem\n"
			 "and serial devices")
			,help_uucp
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == systems){
				system_edit();
			}else if (key == devices){
				devices_edit();
			}
		}
	}
}

static void uucp_usage ()
{
	xconf_error ("%s\n"
		"uucpconf --connect site\n"
		"\n"
		"%s\n"
		,MSG_U(E_NETCONF,"uucpconf: Invalid arguments\n")
		,MSG_U(E_NETCONFDEF,"uucpconf without argument start the interactive mode\n")
		);
}
int uucp_main (int argc, char *argv[])
{
	int ret = -1;
	if (argc == 1){
		uucp_edit();
		ret = 0;
	}else if (argc == 3){
		char *arg1 = argv[1];
		if (strcmp(arg1,"--connect")==0){
			/* #Specification: uucpconf / option / --connect
				uucpconf --connect "system" establish a connexion (forced)
				to a uucp site.
			*/
			xconf_notice (MSG_U(E_NOTDONE,"Not done yet, sorry!"));
		}else{
			uucp_usage();
		}
	}else{
		uucp_usage();
	}
	return ret;
}

