#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <misc.h>
#include "internal.h"

/*
	Print an error message in a popup
	Stubs to avoid linking the world
*/
void xconf_error (const char *msg, ...)
{
	va_list list;
	va_start (list,msg);
	vfprintf (stderr,msg,list);
	va_end (list);
}



static void usage()
{
	fprintf (stderr,
		"msgclean 1.0\n"
		"msgscan dictionary_path\n"
		"\n"
		"Remove obsolete messages from a dictionary.\n"
		"Obsolete messages can't be found in any sources anymore.\n"
		"After a msgclean operation, one will generally recompile the\n"
		"complete project.\n"
		);
}

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc != 2){
		usage();
	}else{
		TR_STRINGS tr;
		const char *pathdict = argv[1];
		tr.read (pathdict);
		for (int i=0; i<tr.getnb(); i++){
			TR_STRING *t = tr.getitem(i);
			if (t->getnblang()==0){
				printf ("removing %s\n",t->getid());
				tr.remove_del(t);
			}
		}
		if (tr.was_modified()){
			int ver = tr.getversion();
			ver++;
			printf ("Updating version number of %s to %d\n",pathdict,ver);
			tr.setversion(ver);
			tr.write(pathdict);
		}else{
			printf ("%s was clean\n",pathdict);
		}
		ret = 0;
	}
	return ret;
}


