GPP=g++
GCC=gcc
LINUXCONF_REV=1.8
LINUXCONF_SUBREV=0
ifeq ($(LINUXCONF_SUBREV),0)
PACKAGE_REV=$(LINUXCONF_REV)
else
PACKAGE_REV=$(LINUXCONF_REV)r$(LINUXCONF_SUBREV)
endif
SBIN=/sbin
ETC=/etc
HELP=/usr/lib/linuxconf
# Some path to stuff the LADR distribution
SBIN_LADR=/n/pc_jac/diska/umsdos/base/admin/sbin
BIN_LADR=/n/pc_jac/diska/umsdos/base/admin/bin
ETC_LADR=/n/pc_jac/diska/umsdos/base/admin/etc
HELP_LADR=/n/pc_jac/diska/umsdos/base/admin/usr/lib/linuxconf

all:
	@for i in $(DIRS); do make GCC=$(GCC) GPP=$(GPP) -C $$i $@ ; done


checker:
	@$(MAKE) GPP=checkerg++ GCC=checkergcc all

ifndef LINUXCONF_PATH
LINUXCONF_PATH=..
LINUXCONF_HELP=../messages/sources
LINUXCONF_MSG=linuxconf-msg
MSGDICS=askrunlevel dialog dnsconf fstab misc main netconf mailconf \
		uucp userconf xconf
endif

ifdef DIRS
install: $(LOCAL_INSTALL) install_subdirs $(LOCAL_POSTINSTALL)

install_subdirs:
	@echo doing subdirs
	@for i in $(DIRS); do make -C $$i install ; done
	@echo end subdirs

else
install: $(LOCAL_INSTALL) $(LOCAL_POSTINSTALL)
endif


install_ladr: $(LOCAL_INSTALLLADR)
	@for i in $(DIRS); do make -C $$i $@ ; done

clean: $(LOCAL_CLEAN)
	rm -f x *.o *.obt *.bak *~ *.a *.old *.log *.nap *.nar
	@for i in $(DIRS); do make -C $$i clean ; done


LIBS = ../askrunlevel/askrunlevel.a \
	../netconf/netconf.a \
	../fstab/fstab.a \
	../dnsconf/dnsconf.a \
	../mailconf/mailconf.a \
	../xconf/xconf.a ../userconf/userconf.a\
	../uucp/uucp.a \
	../translate/translate.a ../misc/misc.a ../dialog/dialog.a \
	-lncurses $(LIBDYNAMIC)

.SUFFIXES: .o .obt .help .html .sgml .txt .doc .tex

CPP_DEFINES=-DPUBLIC= -DPROTECTED= -DPRIVATE= -DVIRTUAL=
DEF_NCURSES=-DHAVE_NCURSES -I/usr/include/ncurses
ifdef OLDGCC
FLAGS=-funsigned-char -g -O2 -Wall -DLINUXCONF_AOUT
BINFORM=aout
else
# For gcc 2.7.x
FLAGS=-fno-for-scope -funsigned-char -g -O2 -Wall
BINFORM=elf
LIBDYNAMIC=-ldl
OPTDYNAMIC=-rdynamic
endif
INCLUDES=-I../misc -I../dialog -I../userconf -I../translate -I../netconf \
	-I../xconf -I../dnsconf -I../mailconf -I../fstab

.c.o:
	@echo "    " $<
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			$(MODULE_CFLAGS) \
		$(INCLUDES) $(CPP_DEFINES) $(DEF_NCURSES) $(FLAGS) -c $< -o $@

# Trick to compile test program at the end of a source
.c.obt:
	@echo $< '->' $@
	@$(GPP) -DLINUXCONF_REVISION=\"$(LINUXCONF_REV)\" \
			-DLINUXCONF_SUBREVISION=$(LINUXCONF_SUBREV) \
			$(MODULE_CFLAGS) \
			-DTEST $(CPP_DEFINES) \
		$(INCLUDES) $(DEF_NCURSES) $(FLAGS) -c $< -o $@

# Path of the linuxdoc-sgml package (used to format HOWTOs)
#LINUXDOC=/usr/lib/linuxdoc-sgml/bin
#FORMAT=$(LINUXDOC)/format
#QTEX=$(LINUXDOC)/qtex
#QROFF=$(LINUXDOC)/qroff

.sgml.txt:
	@echo Formatting $< '->' $@
	sgml2txt -l $<
	sgml2html -l $<

.sgml.html:
	@echo Formatting $< '->' $@
	sgml2html -l $<

.sgml.tex:
	@echo Formatting $< '->' $@
	sgml2latex -l $<


.txt.help:
	@mv $< $@

.txt.doc:
	@$(LINUXCONF_PATH)/translate/sgml2flat $< $@
	@rm -f $<
	
# Produce the binary dictionnary (Message translation)
# English message (originals)
msg.eng:
	$(LINUXCONF_PATH)/translate/msgcomp -p$(LINUXCONF_HELP)/ \
		/tmp/$(LINUXCONF_MSG)-$(LINUXCONF_REV).eng eE \
		$(MSGDICS)

# French canadian
msg.cfr:
	$(LINUXCONF_PATH)/translate/msgcomp -p$(LINUXCONF_HELP)/ -p../messages/cfr/ \
		/tmp/$(LINUXCONF_MSG)-$(LINUXCONF_REV).cfr feE \
		$(MSGDICS)

upd.cfr:
	$(LINUXCONF_PATH)/translate/msgupd -s$(LINUXCONF_HELP)/ -d../messages/cfr/ \
		$(MSGDICS)

_dict.o: _dict.c $(CURDIR).m

lib: $(CURDIR).a

$(CURDIR).a: $(OBJS)
	ar cr $(CURDIR).a $(OBJS)
	ranlib $(CURDIR).a

msg:
	$(LINUXCONF_PATH)/translate/msgscan $(CURDIR) \
		$(LINUXCONF_HELP)/$(CURDIR).dic $(CURDIR).m EF *.c

msg.clean:
	$(LINUXCONF_PATH)/translate/msgclean $(LINUXCONF_HELP)/$(CURDIR).dic
	$(LINUXCONF_PATH)/translate/msgscan $(CURDIR) \
		$(LINUXCONF_HELP)/$(CURDIR).dic $(CURDIR).m EF *.c

