#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "netconf.h"
#include "../paths.h"
#include "netconf.m"

extern NETCONF_HELP_FILE help_routes;
/*
	Edit a route configuration for a host or network (destination).

	Return 0 if edit is ok
	return 1 if the user wish to delete this route
	return -1 if the user escape from edit.
*/
PUBLIC int ROUTE::edit(int edit_host_route)
{
	int ret = -1;
	DIALOG dia;
	dia.newf_str (MSG_U(F_GATEWAY,"Gateway"),ip_gateway);
	dia.newf_str (MSG_U(F_DEST,"Destination"),ip_dst);
	if (!edit_host_route) dia.newf_str (MSG_R(F_NETMASK),netmask);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit(MSG_U(T_ROUTESPEC,"route specification")
			,MSG_U(I_ROUTESPEC,"Enter either IP numbers or names\n")
			,help_routes
			,nof,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			ret = 1;
			break;
		}else if (code == MENU_ACCEPT){
			if (ip_gateway.is_empty() || ip_dst.is_empty()){
				xconf_error (MSG_U(E_IVLROUTE,"Invalid route specification"));
			}else{
				ret = 0;
				break;
			}
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

