#pragma implementation
#include <stdio.h>
#include <string.h>
#include <misc.h>
#include <confdb.h>
#include "netconf.h"
#include "pppdial.h"

static char ATZOK[]="ATZ OK ATDT";

const char PPP_CHANNEL[]="channel";
static const char PHONE[]="phone";
static const char LOGIN[]="login";
static const char PASSWD[]="passwd";
static const char LOGINKEY[]="loginkey";
static const char PASSWDKEY[]="passwdkey";
static const char LOGINOK[]="loginok";
static const char LOGINFAIL[]="loginfail";
static const char LOGINCHAT[]="loginchat";
static const char DEVICE[]="device";
static const char MODEMINIT[]="modeminit";
static const char TYPE[]="type";
static const char LOCK[]="lock";
static const char MODEM[]="modem";
static const char DEFAULTROUTE[]="defaultroute";
static const char PROXYARP[]="proxyarp";
static const char PPPAUTH[]="pppauth";
static const char MRU[]="mru";
static const char MTU[]="mtu";
static const char BAUD[]="baud";
static const char IDLETIME[]="idletime";
static const char DBGPPP[]="dbgppp";
static const char DBGCHAT[]="dbgchat";
static const char OPTIONS[]="options";
static const char ASYNCMAP[]="asyncmap";
static const char OURIP[]="ourip";
static const char REMOTEIP[]="remoteip";
static const char LCPECHO[]="lcpecho";
static const char SSH_HOST[]="ssh_host";
static const char SSH_USER[]="ssh_user";
static const char SSH_ENCRYPT[]="ssh_encrypt";
static const char SSH_COMPRESS[]="ssh_compress";
static const char SSH_PPPDPATH[]="ssh_pppdpath";
static const char SSH_VIASHELL[]="ssh_viashell";
static const char IPROUTES[]="iproutes";
/*
	Initialise 3 tables to simplify loading/clearing and saving
*/
PRIVATE void PPPONE::setuptbdb()
{
	memset (strs,0,sizeof(strs));
	memset (chars,0,sizeof(chars));
	memset (nums,0,sizeof(nums));

	strs[0].key = PHONE;
	strs[0].str = &phone;

	strs[1].key = LOGIN;	
	strs[1].str = &login;	

	strs[2].key = PASSWD;
	strs[2].str = &passwd;

	strs[3].key = DEVICE;
	strs[3].str = &device;

	strs[4].key = MODEMINIT;
	strs[4].str = &modeminit;
	strs[4].defval = ATZOK;

	strs[5].key = OPTIONS;
	strs[5].str = &options;

	strs[6].key = ASYNCMAP;
	strs[6].str = &asyncmap;
	strs[6].defval = "0";

	strs[7].key = OURIP;
	strs[7].str = &ourip;

	strs[8].key = REMOTEIP;
	strs[8].str = &remoteip;

	strs[9].key = LOGINOK;
	strs[9].str = &loginok;

	strs[10].key = LOGINCHAT;
	strs[10].str = &loginchat;

	strs[11].key = LOGINFAIL;
	strs[11].str = &loginfail;

	strs[12].key = LOGINKEY;
	strs[12].str = &loginkey;
	strs[12].defval = "ogin:--ogin:";

	strs[13].key = PASSWDKEY;
	strs[13].str = &passwdkey;
	strs[13].defval = "assword:";

	strs[14].key = LCPECHO;
	strs[14].str = &lcpecho;
	strs[14].defval = "";

	strs[15].key = SSH_HOST;
	strs[15].str = &ssh.host;
	strs[15].defval = "";

	strs[16].key = SSH_USER;
	strs[16].str = &ssh.user;
	strs[16].defval = "";

	strs[17].key = SSH_ENCRYPT;
	strs[17].str = &ssh.encrypt;
	strs[17].defval = "";

	strs[18].key = SSH_PPPDPATH;
	strs[18].str = &ssh.pppd_path;
	strs[18].defval = "/usr/sbin/pppd";

	strs[19].key = NULL;

	chars[0].key = TYPE;
	chars[0].num = &type;
	chars[0].defval = 0;

	chars[1].key = MODEM;
	chars[1].num = &modem;
	chars[1].defval = 1;

	chars[2].key = DEFAULTROUTE;
	chars[2].num = &defaultroute;
	chars[2].defval = 1;

	chars[3].key = LOCK;
	chars[3].num = &lock;
	chars[3].defval = 1;

	chars[4].key = DBGPPP;
	chars[4].num = &dbgppp;
	chars[4].defval = 0;

	chars[5].key = DBGCHAT;
	chars[5].num = &dbgchat;
	chars[5].defval = 0;

	chars[6].key = PROXYARP;
	chars[6].num = &proxyarp;
	chars[6].defval = 0;

	chars[7].key = PPPAUTH;
	chars[7].num = &pppauth;
	chars[7].defval = 0;

	chars[8].key = SSH_COMPRESS;
	chars[8].num = &ssh.compress;
	chars[8].defval = 0;

	chars[9].key = SSH_VIASHELL;
	chars[9].num = &ssh.via_shell;
	chars[9].defval = 0;

	chars[10].key = NULL;


	nums[0].key = BAUD;
	nums[0].num = &baud;
	nums[0].defval = 38400;

	nums[1].key = MRU;
	nums[1].num = &mru;
	nums[1].defval = 1500;

	nums[2].key = IDLETIME;
	nums[2].num = &idletime;
	nums[2].defval = 0;

	nums[3].key = MTU;
	nums[3].num = &mtu;
	nums[3].defval = 0;

	nums[4].key = NULL;
}

PUBLIC PPPONE::PPPONE(CONFDB &cfg, const char *_name)
{
	setuptbdb();
	if (_name != NULL){
		name.setfrom (_name);
		for (LK_STR *ps = strs; ps->key != NULL; ps++){
			ps->str->setfrom (cfg.getval(_name,ps->key
				,ps->defval));
		}
		for (LK_INT *pn = nums; pn->key != NULL; pn++){
			*pn->num = cfg.getvalnum(_name,pn->key
				,pn->defval);
		}
		for (LK_CHAR *pc = chars; pc->key != NULL; pc++){
			*pc->num = cfg.getvalnum(_name,pc->key
				,pc->defval);
		}
		SSTRINGS tbr;
		cfg.getall (_name,IPROUTES,tbr,1);
		for (int i=0; i<tbr.getnb(); i++){
			const char *s = tbr.getitem(i)->get();
			iproutes.add (new PPPIPROUTE (s));
		}
	}else{
		for (LK_STR *ps = strs; ps->key != NULL; ps++){
			ps->str->setfrom (ps->defval);
		}
		for (LK_INT *pn = nums; pn->key != NULL; pn++){
			*pn->num = pn->defval;
		}
		for (LK_CHAR *pc = chars; pc->key != NULL; pc++){
			*pc->num = pc->defval;
		}
	}
	if (type == TYPE_PPP_PAP){
		type = TYPE_PPP_SERIAL;
		pppauth = PPP_AUTH_PAP;
	}else if (type == TYPE_PPP_CHAP){
		type = TYPE_PPP_SERIAL;
		pppauth = PPP_AUTH_CHAP;
	}
}

/*
	Update the CONFDB object and save it on disk
*/
PUBLIC int PPPONE::save(CONFDB &cfg)
{
	const char *_name = name.get();
	SSTRINGS lst;
	cfg.getall ("",PPP_CHANNEL,lst,1);
	if (lst.lookup(name.get())==-1){
		lst.add (new SSTRING(name));
		cfg.replace ("",PPP_CHANNEL,lst);
	}
	for (LK_STR *ps = strs; ps->key != NULL; ps++){
		cfg.replace (_name,ps->key,*ps->str);
	}
	for (LK_INT *pn = nums; pn->key != NULL; pn++){
		cfg.replace (_name,pn->key,*pn->num);
	}
	for (LK_CHAR *pc = chars; pc->key != NULL; pc++){
		cfg.replace (_name,pc->key,*pc->num);
	}
	cfg.removeall (_name,IPROUTES);
	for (int r=0; r<iproutes.getnb(); r++){
		PPPIPROUTE *ir = iproutes.getitem(r);
		if (!ir->dest.is_empty()){
			char buf[200];
			sprintf (buf,"%s %s",ir->dest.get(),ir->mask.get());
			cfg.add (_name,IPROUTES,buf);
		}
	}
	return cfg.save();
}

/*
	Remove this configuration from the configuration file
*/
PROTECTED void PPPONE::del(CONFDB &cfg, const char *_name)
{
	if (_name[0] != '\0'){
		SSTRINGS lst;
		cfg.getall ("",PPP_CHANNEL,lst,1);
		int pos = lst.lookup(_name);
		if (pos != -1){
			lst.remove_del (lst.getitem(pos));
			cfg.replace ("",PPP_CHANNEL,lst);
		}
		for (LK_STR *ps = strs; ps->key != NULL; ps++){
			cfg.removeall (_name,ps->key);
		}
		for (LK_INT *pn = nums; pn->key != NULL; pn++){
			cfg.removeall (_name,pn->key);
		}
		for (LK_CHAR *pc = chars; pc->key != NULL; pc++){
			cfg.removeall (_name,pc->key);
		}
		cfg.removeall (_name,IPROUTES);
	}
}

