#pragma interface
#ifndef NETCONF_H
#define NETCONF_H

#include "../paths.h"

#include <stdio.h>

#ifndef MISC_H
	#include <misc.h>
#endif

#define NETLOG_REQ		1		// Required output to netconf.log
#define NETLOG_ERR		2		// Error messages from the commands
#define NETLOG_OUT		4		// Stdout from the commands
#define NETLOG_VERB		8		// Informative stuff produced by linuxconf
#define NETLOG_CMD		16		// Command line
#define NETLOG_TITLE	32		// Group title
#define NETLOG_SECTION	64		// Section title
#define NETLOG_DONTDO	128		// Things which won't be done
#define NETLOG_WHY		256		// Why linuxconf is doing something

#define NETINTRO_PREBOOTING	0
#define NETINTRO_BOOTING	1
#define NETINTRO_FIXPERM	2
#define NETINTRO_UPDATE		3
#define NETINTRO_RUNLEVEL	4
#define NETINTRO_PPPPOST	5


class NETCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ NETCONF_HELP_FILE */
public:
	NETCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ NETCONF_HELP_FILE */
};

/*
	A HOST simply contain a single line of /etc/hosts.
	It will remember comments. Line containing only a comment will
	be store with name1 and others == NULL.
*/
class HOST: public ARRAY_OBJ{
protected:
	SSTRING name1;
	SSTRING others;		// Other name (alias)
	SSTRING ip_num;		// Even the IP number is stored as a string
						// It allows "editing" completly broken
						// /etc/hosts file.
	SSTRING comment;
	char is_valid;		// Tells if the record is valid
						// If not, it is managed as a comment
	/*~PROTOBEG~ HOST */
public:
	HOST (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	HOST (const char *buf);
	HOST (void);
	virtual int edit (HELP_FILE&helpfile);
private:
	void freeall (void);
public:
	const char *getcomment (void)const;
	const char *getipnum (void)const;
	const char *getname1 (void)const;
	const char *getothers (void)const;
	virtual int is_special (void)const;
	int iscomment (void)const;
	virtual void print (FILE *fout)const;
	void set (const char *buf);
	void setcomment (const char *_comment);
	void setipnum (const char *_ipnum);
	void setname1 (const char *_name1);
	void setothers (const char *_others);
	virtual ~HOST (void);
	/*~PROTOEND~ HOST */
};
class NETWORK: public HOST{
	/*~PROTOBEG~ NETWORK */
public:
	NETWORK (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	NETWORK (const char *buf);
	NETWORK (void);
	int is_special (void)const;
	void print (FILE *fout)const;
	/*~PROTOEND~ NETWORK */
};

class HOSTS: public ARRAY{
protected:
	CONFIG_FILE *cfgf;
	/*~PROTOBEG~ HOSTS */
public:
	HOSTS (void);
	void add (HOST *pt);
	virtual void add (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual void add (const char *buf);
	int edit (const char *title, HELP_FILE&helpfile);
	HOST *getitem (const char *name)const;
	HOST *getitem (int no)const;
	virtual HOST *newhost (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual HOST *newhost (const char *buf);
	int read (void);
	int write (void)const;
	/*~PROTOEND~ HOSTS */
};
class NETWORKS: public HOSTS{
	/*~PROTOBEG~ NETWORKS */
public:
	NETWORKS (void);
	virtual HOST *newhost (const char *_ip_num,
		 const char *_name1,
		 const char *_others,
		 const char *_comment);
	virtual HOST *newhost (const char *buf);
	/*~PROTOEND~ NETWORKS */
};

class THISHOST{
	char *name1;		// Principal name of this host
	char ip_num[16];
	char is_config;		// Is it currently configured
	/*~PROTOBEG~ THISHOST */
public:
	THISHOST (void);
	int configok (void);
	const char *getipnum (int);
	const char *getname1 (void);
	void setname1 (const char *newname1);
	~THISHOST (void);
	/*~PROTOEND~ THISHOST */
};

// Information on a process ID
class PROC{
	PROC *next;
	int pid;
	int ppid;		// Parent process ID
	char *path;		// Path of the program
	char *name;		// Pointer into path
	/*~PROTOBEG~ PROC */
public:
	PROC (int _pid, PROC *_next);
	const char *getname (void);
	PROC *getnext (void);
	const char *getpath (void);
	int getpid (void);
	int getppid (void);
	long getstarttime (void);
	int isok (void);
	int kill (int signo);
	~PROC (void);
	/*~PROTOEND~ PROC */
};

/*
	Control the startup of daemons
*/
class DAEMON{
protected:
	DAEMON *next;
	char *name;
	char *path;
	char *args;
	char managed;
	char override;	// Path or argument has been changed by the admin
					// and must be saved in /etc/conf.linuxconf
	char path_ok;	// Is the path for this daemon ok ?
						
	char path_checked;// (We don't wan't to hammer the user all the time
						//  if a daemon is missing)
	char timeout;	// Maximum normal execution time of the command
					// or daemon activation
	CONFIG_FILE *pidfile;
	/*~PROTOBEG~ DAEMON */
public:
	DAEMON (void);
	int checkpath (void);
	int edit (void);
	PROC *findprocess (void);
	const char *getargs (void);
	const char *getname (void);
	DAEMON *getnext (void);
	const char *getpath (void);
	int gettimeout (void);
	void init (int _managed,
		 const char *_name,
		 const char *buf,
		 DAEMON *_next);
	int is_managed (void);
	int is_overriden (void);
	int isok (void);
	int kill (int signal_num);
	virtual int restart (void);
	void set_managed (int _managed);
	void set_override (int _over);
	void setpidfile (CONFIG_FILE *_pidfile);
	void setspec (const char *_path, const char *_args);
	void settimeout (int nbsec);
	int signal (int signal_num,
		 const char *msg,
		 const char *sem_file);
	int signal (int signal_num, const char *msg);
	virtual int start (void);
	virtual int startif (void);
	int startif_date (long date);
	int startif_file (const CONFIG_FILE&cfile);
	int startif_file (const char *fname);
	virtual int stop (void);
	int system (const char *cmd);
	void write (FILE *fout);
	virtual ~DAEMON (void);
	/*~PROTOEND~ DAEMON */
};

class ROUTE: public ARRAY_OBJ{
	SSTRING ip_dst;
	SSTRING ip_gateway;
	SSTRING netmask;
	SSTRING flags;
	int tag;		// Application placeholder
	SSTRING invalid_line;	// Contain an unparsable line from ETC_CONF_ROUTE
	SSTRING iface;
	/*~PROTOBEG~ ROUTE */
public:
	ROUTE (const char *buf, int noline);
	ROUTE (const char *dst,
		 const char *gate,
		 const char *mask,
		 const char *_flags,
		 const char *_iface);
	ROUTE (void);
	int compare (const SSTRING&dst,
		 const SSTRING&gateway,
		 const SSTRING&o_netmask,
		 const SSTRING&o_flags);
	int dst_is_host (void);
	int edit (int edit_host_route);
	const char *getdst (void);
	const char *getgateway (void);
	const char *getiface (void);
	int gettag (void);
	int is_default (void);
	int is_loopback (void);
	int isdevice (void);
	int kill (void);
	int match (const SSTRING&dst);
	void settag (int _tag);
	void write (FILE *fout);
	~ROUTE (void);
	/*~PROTOEND~ ROUTE */
};

class ROUTES: public ARRAY{
	/*~PROTOBEG~ ROUTES */
public:
	ROUTE *find (const SSTRING&ip_dst);
	ROUTE *getitem (int no)const;
	int readactive (void);
	void readbyme (void);
	void write (FILE *fout);
	void writebyme (void);
	/*~PROTOEND~ ROUTES */
};

class NIS_CONF{
	SSTRING domain;
	SSTRING server;
	/*~PROTOBEG~ NIS_CONF */
public:
	NIS_CONF (void);
	int configok (void);
	int edit (void);
	const char *getdomain (void);
	const char *getserver (void);
	int valid_server (void);
	void write (void);
	/*~PROTOEND~ NIS_CONF */
};

struct IFCONFIG_INFO {
	int flags;
	char ip_addr[16];
	char dst_addr[16];
	char netmask[16];
	char bcast[16];
};

class PPPIPROUTE: public ARRAY_OBJ{
public:
	SSTRING dest;
	SSTRING mask;
	/*~PROTOBEG~ PPPIPROUTE */
public:
	PPPIPROUTE (const char *s);
	PPPIPROUTE (void);
	/*~PROTOEND~ PPPIPROUTE */
};

class PPPIPROUTES: public ARRAY{
	/*~PROTOBEG~ PPPIPROUTES */
public:
	int empty (void);
	PPPIPROUTE *getitem (int no);
	/*~PROTOEND~ PPPIPROUTES */
};


#include "dialog.h"
#include <stdio.h>

struct hostent;
struct HOSTINFO;

#include "netconf.p"

#endif

