#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <netdb.h>
#include <fstab.h>
#include <dnsconf.h>
#include <mailconf.h>
#include <userconf.h>
#include <translat.h>
#include "../askrunlevel/askrunlevel.h"
#include "../uucp/uucp.h"
#include "netconf.h"
#include "netconf.m"

static NETCONF_HELP_FILE help_others ("others");
static NETCONF_HELP_FILE help_netconf ("netconf");
static NETCONF_HELP_FILE help_netlevel ("netlevel");

/*
	Bring the system in sync with its configuration.
*/
void netconf_update(int msg)
{
	if (perm_rootaccess(MSG_U(P_PERMUPDATE
		,"update the status of the system"))){
		if (!simul_ison()) net_introlog (msg);
		netconf_runlevel (-1);
	}
}

/*
	Bring the system in sync with its configuration.
*/
void netconf_update()
{
	int msg = NETINTRO_UPDATE;
	if (getpid()<=150) msg = NETINTRO_BOOTING;
	netconf_update (msg);
}

/*
	Check what have to be done to bring the system in sync
	with its configuration.
*/
void netconf_status()
{
	simul_init (stdout);
	printf (MSG_U(X_LIST
		,"List of things requiered to activate current configuration\n"));
	netconf_update(NETINTRO_UPDATE);
}

void netconf_edit()
{
	/* #Specification: netconf / principal
		netconf use a large flat menu to direct the user to
		the proper configuration dialogs. The menu is splitted
		in several sections.

		#
		Basic informations.
		Client related configurations
		Server related configurations.
		Firewalling.
		#
	*/
	int choice=0;
	while (1){
		static const char *your_system = MSG_U(M_INFOR,"information about your system");
		static const char *other_hosts = MSG_U(M_HOSTS,"information about other hosts");
		static const char *other_networks = MSG_U(M_NETWORKS,"information about other networks");
		static const char *routing_tables = MSG_U(M_ROUTING,"routing and gateways");
		static const char *resolv= MSG_U(M_RESOLV,"Name server specification (DNS)");
		static const char *nis= MSG_U(M_NIS,"Network Information System (NIS)");
		static const char *order= MSG_U(M_ORDER,"Search path for host name");
		static const char *ipx= MSG_U(M_IPXCONF,"IPX interface setup");
		static const char *exports= MSG_U(M_EXPORTS,"exported file-systems (NFS)");
		static const char *dns= MSG_U(M_DNS,"Domain Name Server (DNS)");
		static const char *sendmail = MSG_U(M_MAIL,"Mail delivery system (sendmail)");
		static const char *uucp     = MSG_U(M_UUCP,"UUCP (Unix to unix copy)");
		static const char *alias    = MSG_U(M_ALIAS,"IP aliases for virtual hosts");
		static const char *firewallc = MSG_U(M_FWDEF,"firewalling defaults (packet filtering)");
		static const char *firewallf = MSG_U(M_FORWARD,"forward firewalling");
		static const char *firewallb = MSG_U(M_BLOCK,"blocking firewalling");
		static const char *firewallo = MSG_U(M_OUTPUT,"outputing firewalling");
		static const char *firewalla = MSG_U(M_ACCT,"packets accounting");
		static const char *ppp = MSG_U(M_PPP,"ppp or slip dialout");
		static const char *rarp = MSG_U(M_RARP,"RARP server");
		static const char *htmlaccess = MSG_U(M_HTMLACCES,"linuxconf network access");
		static const char *isolated = MSG_U(M_ISOL,"Isolated/simple network from scratch");
		static const char *menuopt[]={
			MSG_U(M_EDIT,"Edit"),		your_system,
			" ",		other_hosts,
			" ",		other_networks,

			"-",		MSG_U(T_CLIENTTASKS,"Client tasks"),
			MSG_R(M_CONFIG),	resolv,
			" ",		routing_tables,
			" ",		order,
			" ",		nis,
			" ",		ipx,
			" ",		ppp,

			"-",		MSG_U(T_SERVER,"Server tasks"),
			MSG_R(M_CONFIG),	exports,
			" ",		dns,
			" ",		sendmail,
			" ",		uucp,
			" ",		alias,
			"-",		MSG_U(T_BOOT,"Boot services"),
			" ",		rarp,

			"-",		MSG_U(T_FIREWALL,"Firewalling & packets Accounting"),
			MSG_R(M_CONFIG),	firewallc,
			" ",		firewallb,
			" ",		firewallf,
			" ",		firewallo,
			" ",		firewalla,

			"-",		"",
			MSG_R(M_CONFIG),	htmlaccess,
			MSG_U(M_INSTALL,"Install"),	isolated,
			"-",		MSG_U(M_MODULES,"Modules"),
			NULL
		};
		DIALOG dia;
		dia.new_menuitems (menuopt);
		MENU_STATUS code = dia.editmenu (MENU_NETWORK
			,MSG_U(T_NETWORK,"Network configurator")
			,MSG_U(I_NETWORK,"This package allows you to configure from\n"
			 "scratch a TCP/IP network using ethernet\n"
			 "and serial cable (modem)")
			,help_netconf
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == isolated){
				simple_install();
			}else if (key == your_system){
				netconf_edithost();
			}else if (key == other_hosts){
				netconf_edithosts();
			}else if (key == other_networks){
				netconf_editnet();
			}else if (key == routing_tables){
				netconf_editroutes();
			}else if (key == nis){
				netconf_editnis();
			}else if (key == resolv){
				dnsconf_editresolv();
			}else if (key == order){
				dnsconf_editorder();
			}else if (key == ipx){
				ipx_edit();
			}else if (key == exports){
				exports_edit();
			}else if (key == dns){
				dnsconf_edit();
			}else if (key == sendmail){
				mailconf_edit();
			}else if (key == uucp){
				uucp_edit();
			}else if (key == alias){
				alias_edit();
			}else if (key == firewallc){
				firewall_editc();
			}else if (key == firewallf){
				firewall_editf();
			}else if (key == firewallb){
				firewall_editb();
			}else if (key == firewalla){
				firewall_edita();
			}else if (key == firewallo){
				firewall_edito();
			}else if (key == ppp){
				ppp_edit();
			}else if (key == rarp){
				rarp_edit();
			}else if (key == htmlaccess){
				html_access_edit();
			}
		}
	}
}

/*
	Return 0 if nothing had to be done, 1 if it was done, -1 if something
	had to be done but was not done.
*/
int netconf_checkupdate()
{
	/* #Specification: configuration / probing for update
		linuxconf can compare the current (running)
		configuration of the machine with the intended
		(what is setup in configuration files) one.

		It will compute what has to be done to bring
		the machine in sync with the intended configuraiton.

		It will present a summary to the user and let him
		decide if he wants to activate this now or wait later.

		One (maybe) unrelated mecanism has been added here.
		The fixperm facility is included in the probing.
		It is expected that with both set of tests, the linux
		machine will be always up and running without
		puzzling bugs for the administrator.
	*/
	int ret = -1;
	if (perm_rootaccess(MSG_R(P_PERMUPDATE))){
		simul_init();
		netconf_update(NETINTRO_UPDATE);
		ret = simul_prompt();
		if (ret==1){
			net_setshowmode (0);
			netconf_update (NETINTRO_UPDATE);
			net_setshowmode (1);
		}
	}
	return ret;
}

static void usage()
{
	xconf_error ("%s\n"
		"netconf --connect site [--fore]\n"
		"netconf --disconnect site\n"
		"netconf --postconnect linuxconf_dialout site ppp-device\n"
		"netconf --postconnect linuxconf_dialin site ppp-device\n"
		"netconf --predisconnect linuxconf_dialout site ppp-device\n"
		"netconf --predisconnect linuxconf_dialin site ppp-device\n"
		"netconf --resetfw\n"
		"netconf --runlevel 0|1|2\n"
		"netconf --runlevel local|client|server\n"
		"netconf --update\n"
		"netconf --status\n"
		"\n"
		"%s\n"
		,MSG_U(E_NETCONF,"Netconf: Invalid arguments\n")
		,MSG_U(E_NETCONFDEF,"netconf without argument start the interactive mode\n")
		);
}

static void netconf_gorun(const char *arg)
{
	/* #Specification: netconf / runlevel option
		if netconf is run with the argument --runlevel, it will
		activate/desactivate all the daemons associated with this
		runlevel. It will also check if running daemons are informed
		of any changes in there configuration files.
	*/
	const char *pt = arg;
	int netmode=-1;
	if (strcmp(arg,"local")==0){
		netmode = 0;
	}else if (strcmp(arg,"client")==0){
		netmode = 1;
	}else if (strcmp(arg,"server")==0){
		netmode = 2;
	}else{
		int runlevel = atoi(arg);
		while (*pt != '\0'){
			if (!isdigit(*pt)){
				runlevel = -1;
				break;
			}
			pt++;
		}
		if (runlevel > 0 && runlevel < 7){
			static char tb[7]={0
				,1	// Maintenance mode
				,0	// Text mode only
				,2	// Text mode and network (server mode)
				,1	// X terminal
				,0	// Graphic only
				,2	// Graphic and network
			};
			netmode = tb[runlevel];
		}
	}
	if (netmode != -1){
		#if 0
			char buf[100];
			static char *tb[]={"local","client","server"};
			sprintf (buf,"netconf --runlevel %s",tb[netmode]);
		#endif
		net_introlog (NETINTRO_RUNLEVEL);
		netconf_runlevel (netmode);
	}else{
		xconf_error (MSG_U(E_IVLRUNLEVEL
			,"Invalid runlevel %s for network daemons\n"
			 "Values 1,2,3,4,5,6 or local,client,server\n"
			 "are valid.\n")
			,arg);
		dialog_end();
	}
}

void netconf_editrunlevel()
{
	char level = (char)netconf_getnetlevel();
	DIALOG dia;
	dia.newf_radio ("",level,0,MSG_U(F_LOCALMODE,"No network"));
	dia.newf_radio ("",level,1,MSG_U(F_CLIENTMODE,"Client mode"));
	dia.newf_radio ("",level,2,MSG_U(F_SERVERMODE,"Server"));
	if (dia.edit (
		MSG_U(T_NETRUNLEVEL,"Network operation mode") 
		,MSG_U(I_NETRUNLEVEL,"")
		,help_netlevel)==MENU_ACCEPT){
		if (perm_rootaccess(MSG_U(E_NETRUNLEVEL
			,"Change network operation mode"))){
			netconf_setnetlevel (level);
			netconf_checkupdate();
		}
	}
}
static PRIVILEGE p_mainaccess ("mainaccess"
	,P_MSG_U(T_MAINACCESS,"0-May use linuxconf")
	,P_MSG_U(T_PSYSCONTROL,"0-General system control"));
/*
	check if the user has the minimum privilege to enter the main menus
	of linuxconf.

	Return 0 if not.
*/
int netconf_mainaccess()
{	
	extern PRIVILEGE p_mainaccess;
	return perm_access (&p_mainaccess,MSG_U(P_MAINACCESS,"access linuxconf"));
}

int netconf_main (int argc, char *argv[])
{
	if (netconf_mainaccess()){
		if (argc == 1){
			netconf_edit();
			netconf_checkupdate();
		}else if (argc == 2){
			char *arg1 = argv[1];
			if (strcmp(arg1,"--update")==0){
				/* #Specification: netconf / option / --update
					netconf --update is equivalent to run netconf --runlevel
					with the current runlevel value.
				*/
				netconf_update();
			}else if (strcmp(arg1,"--status")==0){
				/* #Specification: netconf / option / --status
					netconf --status perform a simulation of netconf --update.
					It simply shows what netconf --update will do to activate
					the current configuration. Most of time, it prints
					only a header, since the system is "current".
				*/
				netconf_status();
			}else if (strcmp(arg1,"--resetfw")==0){
				/* #Specification: netconf / option / --resetfw
					netconf --resetfw turn off completly the
					firewalling configuration. This means that
					the machine is now wide open (as far as
					packet filtering goes).

					This only reset the "running" configuration,
					not the configuration itself.
					netconf --update will bring the firewall back
					to its previous state.
				*/
				firewall_reset();
			}else{
				usage();
			}
		}else if (argc >= 3){
			char *arg1 = argv[1];
			if (strcmp(arg1,"--connect")==0){
				/* #Specification: netconf / option / --connect
					netconf --connect establish a PPP or SLIP
					connection to a preconfigured site.
				*/
				ppp_connect (argc-2,argv+2);
			}else if (strcmp(arg1,"--disconnect")==0){
				/* #Specification: netconf / option / --disconnect
					netconf --disconnect terminate a PPP or SLIP
					connection.
				*/
				ppp_disconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--postconnect")==0 && argc == 5){
				ppp_postconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--predisconnect")==0 && argc == 5){
				ppp_predisconnect (argc-2,argv+2);
			}else if (strcmp(arg1,"--runlevel")==0){
				netconf_gorun(argv[2]);
			}else{
				usage();
			}
		}else{
			usage();
		}
	}
	return 0;
}

