#include <stdio.h>
#include "netconf.h"
#include <misc.h>
#include "netconf.m"

static NETCONF_HELP_FILE help_netlevel ("netlevel");
static CONFIG_FILE f_netlevel (VAR_RUN_NETLEVEL,help_netlevel,CONFIGF_MANAGED);
/*
	Store the net level into /var/run/netconf.level
*/
void netconf_setnetlevel(int level)
{
	FILE *fout = f_netlevel.fopen ("w");
	if (fout != NULL){
		fprintf (fout,"%d\n",level);
		fclose (fout);
	}
}

/*
	Retrieve the net level from /var/run/netconf.level
*/
int netconf_getnetlevel()
{
	int level;
	FILE *fin = f_netlevel.fopen ("r");
	if (fin != NULL){
		fscanf (fin,"%d\n",&level);
		fclose (fin);
	}
	if (level < 0 || level > 2){
		xconf_error (MSG_U(E_IVLDNETLEVEL
			,"File %s\n"
			 "contains an invalid netconf level: %d\n"
			 "It must be 0, 1 or 2.\n"
			 "Just run \"netconf --runlevel\" with an\n"
			 "explicit value (local, client, or server)\n"
			 "to fix this.\n"
			 "\n"
			 "Assuming \"local\" configuration for now.\n")
			,VAR_RUN_NETLEVEL,level);
	}
	return level;
}

