/* #Specification: routes / gateways identified manually
	The user is allowed to program some routes to other network
	using gateways. A default gateways may be identified (default_router)
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "netconf.h"
#include <misc.h>
#include "netconf.m"

NETCONF_HELP_FILE help_routes ("routes");
static NETCONF_HELP_FILE help_defroute ("default_route");

CONFIG_FILE f_conf_routes (ETC_CONF_ROUTES
	,help_routes,CONFIGF_MANAGED|CONFIGF_OPTIONNAL);

struct GROUTES_INFO {
	char defroute[MAX_LEN+1];
	ROUTES routes;
};

/*
	Sort routes by destination
*/
static int cmp_route_by_dest (const void *p1, const void *p2)
{
	ROUTE *h1 = *(ROUTE**)p1;
	ROUTE *h2 = *(ROUTE**)p2;
	return strcmp(h1->getdst(),h2->getdst());
}
/*
	Write /etc/conf.routes
*/
static void groutes_save(GROUTES_INFO &info)
{
	FILE *fout = f_conf_routes.fopen ("w");
	if (fout != NULL){
		if (info.defroute[0] != '\0'){
			fprintf (fout,"-net default gw %s\n",info.defroute);
		}
		info.routes.write(fout);
		fclose (fout);
	}
}


static void groutes_editothers(GROUTES_INFO &info, int edit_host_route)
{
	int choice=0;
	while (1){
		ROUTE *tb[500];
		int nbrt=0;
		{
			// Collect the entries which are host route or network route
			// depending on edit_host_route
			int nb_total = info.routes.getnb();
			for (int i=0; i<nb_total; i++){
				ROUTE *pt = info.routes.getitem(i);
				int is_host = (pt->dst_is_host() != 0)
					+ (edit_host_route != 0);
				if (is_host == 0 || is_host == 2){
					tb[nbrt++] = pt;
				}
			}
		}
		qsort (tb,nbrt,sizeof(ROUTE *),cmp_route_by_dest);
		char *menuopt[1000];
		{
			int j=0;
			for (int i=0; i<nbrt; i++){
				menuopt[j++] = " ";
				menuopt[j++] = strdup(tb[i]->getdst());
			}
			menuopt[j] = NULL;
		}
		MENU_STATUS code = xconf_menu (
			edit_host_route
				? MSG_U(T_ROUTEHOSTS,"Route to other hosts")
				: MSG_U(T_ROUTENET,"Route to other networks")
			,MSG_U(I_ROUTEHOSTS
			 ,"If your network has access to other networks\n"
			  "you must tell how to reach those networks\n")
			,help_routes
			,NULL
			,NULL
			,NULL
			,MSG_U(I_TOADDROUTE,"to add a new route")
			,(const char**)menuopt,choice);
		for (int k=0; k<nbrt; k++) free (menuopt[k*2+1]);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			ROUTE *route = new ROUTE ("","",""
				,edit_host_route ? "UGH" : "UG","");
			if (route->edit(edit_host_route)==0){
				info.routes.add (route);
				groutes_save (info);
			}else{
				delete route;
			}
		}else if (nbrt > 0){
			if (code == MENU_OK){
				ROUTE *route = tb[choice];
				int ok = route->edit(edit_host_route);
				if (ok != -1){
					if (ok == 1){
						info.routes.remove_del (route);
					}
					groutes_save(info);
				}
			}
		}
	}
}

/*
	Check if there is at least one route other than the default
	Return != 0 if yes.
*/
static int groutes_isothers(ROUTES &routes, int host_route)
{
	int ret = 0;
	host_route = host_route != 0;
	int nb = routes.getnb();
	for (int i=0; i<nb; i++){
		ROUTE *pt = routes.getitem(i);
		if (!pt->is_default()){
			int is_host_route = pt->dst_is_host() != 0;
			if (host_route == is_host_route){
				ret = 1;
				break;
			}
		}
	}
	return ret;
}

static int groutes_edit(
	GROUTES_INFO &info)
{
	int ret = 0;
	int choice=0;
	while (1){
		static const char *default_route = MSG_U(M_DEFROUTE,"the default route");
		static const char *other_route_net = MSG_U(M_ROUTENET,"other routes to networks");
		static const char *other_route_host = MSG_U(M_ROUTEHOSTS,"other routes to hosts");
		static const char *routed = MSG_U(M_ROUTED,"the routed daemon");
		char default_route_str[80];
		char other_route_str_net[80];
		char other_route_str_host[80];
		static const char *menuopt[]={
			MSG_U(M_SET,"Set"),		NULL,
			" ",					NULL,
			" ",					NULL,
			MSG_U(M_CONFIG,"Configure"),routed,
			NULL
		};
		menuopt[1] = menu_setupopt(default_route_str,default_route
			,info.defroute);
		menuopt[3] = menu_setupopt(other_route_str_net,other_route_net
			,groutes_isothers(info.routes,0)
			? MSG_U(M_CONFIGURED,"configured") : MSG_U(M_NONE,"none"));
		menuopt[5] = menu_setupopt(other_route_str_host,other_route_host
			,groutes_isothers(info.routes,1)
			? MSG_R(M_CONFIGURED) : MSG_R(M_NONE));
		MENU_STATUS code = xconf_menu (
			MSG_U(T_ROUTES,"Routes to other network")
			,MSG_U(I_ROUTES
			 ,"If your network has access to other networks\n"
			  "you must tell how to reach those networks\n"
			  "For many setup, simply setting the default route\n"
			  "is good enough\n"
			  "\n"
			  "If you only talk to machine on the local network\n"
			  "then all this is not necessary.\n")
			,help_routes
			,NULL
			,NULL
			,NULL
			,NULL
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			ret = -1;
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == default_route_str){
				DIALOG dia;
				dia.newf_str("",info.defroute
					,sizeof(info.defroute)-1);
				if (dia.edit (MSG_U(T_DEFGTW,"Default gateway")
					,MSG_U(I_DEFGTW
					 ,"Enter the IP number of the main gateway\n")
					,help_defroute) == MENU_ACCEPT){
					groutes_save(info);
				}
			}else if (key == other_route_str_net){
				groutes_editothers (info,0);
			}else if (key == other_route_str_host){
				groutes_editothers (info,1);
			}else if (key == routed){
				routed_edit();
			}
		}
	}
	return ret;
}


/*
	Edite /etc/conf.routes
*/
void netconf_editroutes()
{
	GROUTES_INFO info;
	info.defroute[0] = '\0';
	FILE *fin = f_conf_routes.fopen ("r");
	if (fin != NULL){
		char buf[300];
		int noline;
		while (fgets_strip (buf,sizeof(buf)-1,fin,&noline)!=NULL){
			ROUTE *pt = new ROUTE (buf,noline);
			if (pt->is_default()){
				strcpy (info.defroute,pt->getgateway());
				delete pt;
			}else{
				info.routes.add (pt);
			}
		}
		fclose (fin);
	}
	groutes_edit(info);
}

