#include <string.h>
#include <misc.h>
#include "netconf.h"
#include "../paths.h"

static NETCONF_HELP_FILE help_dev ("devlist");

static CONFIG_FILE f_dev (PROC_NET_DEV
	,help_dev
	,CONFIGF_PROBED);


/*
	Get the list of all network device (except aliases).
	Return -1 if any errors.
*/	
int devlist_read (SSTRINGS &list)
{
	int ret = -1;
	FILE *fin = f_dev.fopen ("r");
	if (fin != NULL){
		char buf[600];
		if (fgets(buf,sizeof(buf)-1,fin)!=NULL
			&& fgets(buf,sizeof(buf)-1,fin)!=NULL){
			ret = 0;
			while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
				char word[600];
				str_copyword (word,buf);
				char *pt = strchr(word,':');
				if (pt != NULL){
					if (strchr(pt+1,':')==NULL){
						/* #Specification: netconf / proc/net/dev
							netconf assume that /proc/net/dev has the following
							format. 2 lines of heading followed by device info.
							Each line begin by the device name. A device name
							is ended by :, while an alias has a : in the middle
							and at the end.
						*/
						*pt = '\0';
						list.add (new SSTRING(word));
					}
				}
			}
		}
		fclose (fin);
	}
	return ret;
}


/*
	Return != 0 if a network device is available in the kernel

	This function is implemented by reading /proc/net/dev instead of
	asking the kernel directly. Asking the kernel directly has the side
	effect of triggering kerneld if the device is not loaded. This is
	not always what we want.
*/
int devlist_devexist (const char *devname)
{
	int ret = 0;
	SSTRINGS list;
	if (devlist_read(list)!=-1){
		int n = list.getnb();
		for (int i=0; i<n; i++){
			SSTRING *s = list.getitem(i);
			if (s->cmp(devname)==0){
				ret = 1;
				break;
			}
		}
	}
	return ret;
}

