#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>

/*
	Probe the running kernel for its version and release
*/
int kernel_version (int v[3])
{
	struct utsname u;
	int ret = uname (&u);
	v[0] = v[1] = v[2] = 0;
	if (ret != -1){
		v[0] = atoi(u.release);
		char *pt = strchr(u.release,'.');
		if (pt != NULL){
			pt++;
			v[1] = atoi(pt);
			pt = strchr(pt,'.');
			if (pt != NULL){
				v[2] = atoi(pt+1);
			}
		}
	}
	return ret;
}

/*
	Return != 0 if the running kernel is newer than v0.v1.v2
*/
int kernel_newer (int v0, int v1, int v2)
{
	int ret = 0;
	int v[3];
	if (kernel_version(v)!=-1){
		ret = v0*1000000+v1*1000+v2 < v[0]*1000000 + v[1]*1000 + v[2];
	}
	return ret;
}


#ifdef TEST

#include <stdio.h>

int main (int, char *[])
{
	int v[3];
	if (kernel_version (v)!=-1){
		printf ("kernel_version %d %d %d\n",v[0],v[1],v[2]);
		printf ("kernel is newer than 1.3.66 -> %d\n",kernel_newer(1,3,66));
	}else{
		printf ("kernel_version fail\n");
	}
	return 0;
}


#endif

