#pragma implementation
#include <string.h>
#include <stdlib.h>
#include "misc.h"

PUBLIC SSTRING::SSTRING()
{
	str = NULL;
	maxsiz = 200;
}

PUBLIC SSTRING::SSTRING (const char *_str)
{
	str = strdup(_str);
	maxsiz = 200;		// Arbitrary maximum
}

PUBLIC SSTRING::SSTRING (const char *_str, int _maxsiz)
{
	str = strdup(_str);
	maxsiz = _maxsiz;
}

PUBLIC SSTRING::SSTRING(const SSTRING &_str)
{
	str = strdup(_str.get());
	maxsiz = _str.maxsiz;
}
PUBLIC SSTRING &SSTRING::operator = (const SSTRING &_str)
{
	setfrom (_str.get());
	maxsiz = _str.maxsiz;
	return *this;
}
PUBLIC SSTRING::~SSTRING()
{
	free (str);
}

PUBLIC void SSTRING::copy (char *dst) const
{
	*dst = '\0';
	if (str != NULL) strcpy (dst,str);
}
PUBLIC void SSTRING::copy (SSTRING &dst) const
{
	dst.setfrom (get());
}

/*
	Initialise the SSTRING from a value.
	This value may be a substring of the current value of this SSTRING
*/
PUBLIC VIRTUAL void SSTRING::setfrom (const char *src)
{
	char *newstr = NULL;
	if (src != NULL) newstr = strdup(src);
	free (str);
	str = newstr;
}
PUBLIC void SSTRING::setfrom (const SSTRING &src)
{
	setfrom (src.get());
}

/*
	Initialise a SSTRING from a integer (convert to ASCII decimal)
*/
PUBLIC void SSTRING::setfrom (int val)
{
	char bufval[20];
	sprintf (bufval,"%d",val);
	setfrom(bufval);
}
/*
	Append a string to the current content.
*/
PUBLIC void SSTRING::append (const char *app)
{
	const char *pt1 = get();
	int len1 = strlen(pt1);
	int len2 = strlen(app);
	char *newstr = (char*)malloc(len1+len2+1);
	if (newstr != NULL){
		strcpy (newstr,pt1);
		strcpy (newstr+len1,app);
		free (str);
		str = newstr;
	}
}

/*
	Return the numerical (integer) value of the SSTRING
*/
PUBLIC int SSTRING::getval() const
{
	return atoi(get());
}
/*
	Return the numerical (double) value of the SSTRING
*/
PUBLIC double SSTRING::getvalf() const
{
	return atof(get());
}
/*
	Return the length of the string.
*/
PUBLIC int SSTRING::getlen() const
{
	return strlen (get());
}
/*
	Get the string value. Will never return NULL (only an empty string).
*/
PUBLIC const char *SSTRING::get() const
{
	char *ret = str;
	if (str == NULL) ret = "";
	return ret;
}

/*
	Perform a strcmp on the string and the other one.
*/
PUBLIC int SSTRING::cmp (const char *other) const
{
	char *one = str;
	if (one == NULL) one = "";
	return strcmp(one,other);
}
/*
	Perform a strncmp on the string and the other one.
*/
PUBLIC int SSTRING::ncmp (const char *other, int len) const
{
	char *one = str;
	if (one == NULL) one = "";
	return strncmp(one,other,len);
}
/*
	Perform a stricmp on the string and the other one.
*/
PUBLIC int SSTRING::icmp (const char *other) const
{
	char *one = str;
	if (one == NULL) one = "";
	return stricmp(one,other);
}

/*
	Perform a stricmp on the string and the other one.
*/
PUBLIC int SSTRING::icmp (const SSTRING &other) const
{
	return icmp(other.get());
}

/*
	Find the occurence of a character in the string.
*/
PUBLIC const char *SSTRING::strchr(char carac)
{
	const char *ret = NULL;
	if (str != NULL) ret = ::strchr(str,carac);
	return ret;
}
/*
	Find the occurence of a string in the string.
*/
PUBLIC const char *SSTRING::strstr(const char *sub)
{
	const char *ret = NULL;
	if (str != NULL) ret = ::strstr(str,sub);
	return ret;
}

PUBLIC int SSTRING::cmp(const SSTRING &other) const
{
	return cmp(other.get());
}

PUBLIC void SSTRING::setmaxsiz(int size)
{
	maxsiz = size;
}

PUBLIC int SSTRING::getmaxsiz() const
{
	return maxsiz;
}

/*
	Return != 0 if the SSTRING is an empty string.
*/
PUBLIC int SSTRING::is_empty() const
{
	int ret = 1;
	if (str != NULL) ret = str[0] == '\0';
	return ret;
}

/*
	Cut the white space at the end of the string
*/
PUBLIC void SSTRING::strip_end()
{
	if (str != NULL) ::strip_end (str);
}

/*
	Extract a word (non white space) from a string.
	Return a pointer to the end of the word in the line.
*/
PUBLIC char *SSTRING::copyword (const char *line)
{
	char word[1000];
	line = str_copyword(word,line);
	setfrom (word);
	return (char*)line;
}

/*
	Record the comment part of the CSSTRING
*/
PUBLIC void CSSTRING::setcomment(const SSTRING &com)
{
	comment.setfrom (com);
}

#ifdef TEST

static void test (const char *name, SSTRING &t, SSTRING c)
{
	printf ("%s = :%s:[%p] == :%s:[%p]\n",name,t.get(),t.get(),c.get(),c.get());
}

#define P(x)	test (#x,x,x)

int main (int, char *[])
{
	SSTRING t1;
	t1.setfrom ("allo");
	P(t1);
	SSTRING t2 (t1);
	P(t2);
	SSTRING t3;
	t3 = t2;
	P(t3);
	return 0;
}

#endif

