#pragma interface
#ifndef POPEN_H
#define POPEN_H

#ifndef MISC_H
	#include <misc.h>
#endif

class POPEN{
	int pid;
	int status;
	struct {
		int out;
		int err;
		int ctl;
	}fds;
	SSTRING outbuf;
	SSTRING errbuf;
	int cur_dead;	// Current level of child_counter
	/*~PROTOBEG~ POPEN */
public:
	POPEN (const char *command);
private:
	void checksignal (void);
public:
	void forget (void);
	int getstatus (void);
	int isok (void);
	void kill (void);
	int readerr (char *line, int size);
private:
	void readif (struct fd_set *in, int fd, SSTRING&buf);
	int readline (char *line, int size, SSTRING&buf);
public:
	int readout (char *line, int size);
	int wait (int timeout);
	int wait (int timeout, int otherfd);
private:
	void waitend (void);
	void waitone (void);
public:
	~POPEN (void);
	/*~PROTOEND~ POPEN */
};


#endif

