#pragma interface
#ifndef CONFDB_H
#define CONFDB_H

#ifndef MISC_H
	#include "misc.h"
#endif

class PRIVILEGE;

class CONFOBJ: public ARRAY_OBJ{
public:
	SSTRING key;
	SSTRING val;
	/*~PROTOBEG~ CONFOBJ */
public:
	CONFOBJ (const char *_key, const char *_val);
	/*~PROTOEND~ CONFOBJ */
};

class CONFDB: public ARRAY{
	CONFIG_FILE *fcfg;
	/*~PROTOBEG~ CONFDB */
public:
	CONFDB (CONFIG_FILE&_fcfg);
	CONFDB (void);
	void add (const char *prefix,
		 const char *key,
		 const SSTRING&val);
	void add (const char *prefix,
		 const char *key,
		 const char *val);
	void add (const char *prefix,
		 const char *key,
		 int val);
	void addline (const char *buf);
	int getall (const char *prefix,
		 const char *key,
		 SSTRINGS&lst,
		 int copy);
	CONFOBJ *getitem (int no);
	const char *getval (const char *prefix,
		 const char *key);
	const char *getval (const char *prefix,
		 const char *key,
		 const char *defval);
	double getvalf (const char *prefix,
		 const char *key,
		 double defval);
	int getvalnum (const char *prefix,
		 const char *key,
		 int defval);
	void removeall (const char *prefix, const char *key);
	void replace (const char *prefix,
		 const char *key,
		 const SSTRING&val);
	void replace (const char *prefix,
		 const char *key,
		 const SSTRINGS&vals);
	void replace (const char *prefix,
		 const char *key,
		 const char *val);
	void replace (const char *prefix,
		 const char *key,
		 double val);
	void replace (const char *prefix,
		 const char *key,
		 int val);
	int save (PRIVILEGE *priv);
	int save (void);
	/*~PROTOEND~ CONFDB */
};


#endif

