#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <syslog.h>
#include <xconf.h>
#include <dnsconf.h>
#include <netconf.h>
#include "../askrunlevel/askrunlevel.h"
#include <userconf.h>
#include <fstab.h>
#include <mailconf.h>
#include "../uucp/uucp.h"
#include "main.h"
#include "main.m"
#include <translat.h>

char *revision = LINUXCONF_REVISION;

/* #Specification: configuration programs / strategy
	The configuration program askrunlevel, netconf, xconf and lpdconf
	share a lot of code. They are seldom used (at startup only)
	generally.

	so they have been melted in one program. By using proper symlinks
	this program can behave differently

	ln -s /bin/linuxconf /bin/netconf
	ln -s /bin/linuxconf /bin/lpdconf
	ln -s /bin/linuxconf /bin/userconf
	ln -s /bin/linuxconf /bin/fsconf
	ln -s /bin/linuxconf /bin/xconf
	ln -s /bin/linuxconf /sbin/askrunlevel
	ln -s /bin/linuxconf /sbin/fixperm
	ln -s /bin/linuxconf /sbin/dnsconf
	ln -s /bin/linuxconf /sbin/mailconf
	ln -s /bin/linuxconf /sbin/uucpconf


	This is done mostly to save disk space and also make sure
	all those utility are updated in sync (a single program :-) )
*/

static HELP_FILE introweb ("main","introweb");

/*
	Load the proper messages dictionnary
*/
static void main_loaddict ()
{
	/* #Specification: messages dictionnary / location
		The messages dictionnary is normally located in
		/usr/lib/linuxconf/linuxconf-msg-x.y.lang.
		This can't be overriden by the user.

		There is a way to override this during development, allowing
		to linuxconf to coexist. The environnement variable "LINUXCONF_DICT"
		contain the path of the directory containing the directories.

		This variable is not checked and when the program is run setuid
	*/
	/* #Specification: messages & help / langage selection
		The environnement variable LINUXCONF_LANG select the extension
		use to load the messages dictionnay and the help files.

		help file will be located in /usr/lib/linuxconf/help.LANG

		This mecanism is specific to Linuxconf. This will remain as an
		ultimate override. In the future, linuxconf should be able to
		probe the system to find out which langage to support.
	*/
	char bdict[30];
	sprintf (bdict,"linuxconf-msg-%s",LINUXCONF_REVISION);
	translat_load (USR_LIB_LINUXCONF,"LINUXCONF_DICT",bdict,"LINUXCONF_LANG");
	help_setlang ("eng","LINUXCONF_LANG");
}

int main (int argc, char *argv[])
{
	int ret = -1;
	char argv0[PATH_MAX];
	char *pta = argv0;
	char *pt = argv[0];
	main_loaddict();
	// Extract the name of the program from its path
	while (*pt != '\0'){
		if (*pt == '/'){
			pt++;
			pta = argv0;
		}else{
			*pta++ = *pt++;
		}
	}
	*pta = '\0';
	/* #Specification: linuxconf / aliases
		linuxconf manipulate of lot of stuff for configuring properly
		a Linux station. Because of this, it include code to perform
		many task normally done by utilities seldom used. It was
		decide that in order to save some disk space, linuxconf could
		act as clone for those different programs. Here is the list
		of the different aliases.

		#
		/bin/fsconf
		/bin/linuxconf
		/bin/netconf
		/bin/userconf
		/bin/xconf
		/bin/hostname
		/bin/passwd
		/bin/domainname
		/bin/dnsdomainname
		/sbin/askrunlevel
		/sbin/dnsconf
		/sbin/fixperm
		/sbin/mailconf
		#
	*/
	if(argc > 1 && strcmp(argv[1],"--demo")==0){
		simul_setdemoflag (1);
		if (chroot("/demo_linuxconf")==-1
			|| chdir ("/") == -1){
			syslog (LOG_ERR,MSG_U(E_DEMOINIT,"can't chroot(\"/demo_linuxconf\" (%m)"));
			exit (-1);
		}
	}
	module_load();
	if (strcmp(argv0,"askrunlevel")==0){
		if (getuid()!=0){
			xconf_error (MSG_U(ERR_BOOT,"Askrunlevel is only used\n"
				"at boot time\n"));
		}else{
			ret = askrunlevel_main (argc, argv);
		}
	}else if (strcmp(argv0,"domainname")==0){
		ret = netconf_domainname (argc,argv);
	}else if (strcmp(argv0,"dnsdomainname")==0){
		ret = netconf_dnsdomainname (argc,argv);
	}else if (strcmp(argv0,"hostname")==0){
		ret = netconf_hostname (argc,argv);
	}else if (strcmp(argv0,"fixperm")==0){
		ret = fstab_fixperm (argc,argv);
	}else if (strcmp(argv0,"dnsconf")==0){
		ret = dnsconf_main (argc,argv);
	}else if (strcmp(argv0,"mailconf")==0){
		ret = mailconf_main (argc,argv);
	}else if (strcmp(argv0,"uucpconf")==0){
		ret = uucp_main (argc,argv);
	}else if (strcmp(argv0,"linuxconf")==0){
		if (argc == 2 && strcmp(argv[1],"--helpfile")==0){
			helpf_checkall();
		}else if (argc == 2 && strcmp(argv[1],"--update")==0){
			netconf_update();
		}else if (argc == 2 && strcmp(argv[1],"--status")==0){
			netconf_status();
		}else if (argc >= 2
			&& (strcmp(argv[1],"--http")==0 || strcmp(argv[1],"--demo")==0)){
			/* #Specification: linuxconf / command line / --http
				The --http option of linuxconf tells it
				to behave like an httpd server. It will
				all of a sudden start talking ... html.

				This option is normally used when starting
				linuxconf from /etc/inetd.conf

				Suboptions are available (--http --options ...)

				#
				--port port_number: Use this portnumber to format URLs.
					Default to LINUXCONF_HTTP_PORT
				--name name: Use this name to format URLs. Default to the
					fully qualified hostname.
				--debug 0|1: Assume standalone startup (Not from inetd)
					and use a different port (LINUXCONF_HTTP_PORT_DEBUG).
					This way, gdb can be used on linuxconf without problem.
				#

				The --debug option is maybe useless. If linuxconf detect
				that the handle 0 is a tty, it assumes it is starting
				from a command line (not inetd) so assume the same context
				as debug mode and use the same port.
			*/
			/* #Specification: Linuxconf / startting from inetd
				Here is the proper configuration line which
				must be added to /etc/inetd.conf
				linuxconf  stream  tcp     wait  root    /bin/linuxconf --http
			*/
			openlog ("linuxconf",LOG_PID,LOG_DAEMON);
			/* #Specification: linuxconf / command line / --demo
				The --demo option of linuxconf is like the --http
				except linuxconf will do a chroot("/demo_linuxconf")
				and will not do anything except probing the system.
				The mode "simul" on all the time
			*/
			if (getuid()!=0){
				xconf_error(MSG_U(E_HTTP
					,"--http and --demo may only be used by root"));
				exit (-1);
			}
			dialog_setmode (DIALOG_HTML);
			int port = -1;
			THISHOST host;
			const char *name = host.getname1();
			int debug = 0;
			for (int i=2; i<argc; i += 2){
				const char *arg = argv[i+1];
				if (strcmp(argv[i],"--port")==0){
					port = atoi(arg);
				}else if (strcmp(argv[i],"--name")==0){
					name = arg;
				}else if (strcmp(argv[i],"--debug")==0){
					debug = atoi(arg);
					if (port == -1) port = LINUXCONF_HTTP_PORT_DEBUG;
				}
			}
			if (isatty(0)){
				debug = 1;
				if (port == -1) port = LINUXCONF_HTTP_PORT_DEBUG;
			}				
			if (port == -1) port = LINUXCONF_HTTP_PORT;
			html_sethost (name,port);
			perm_sethtml (1);
			int timeout = linuxconf_gethtmltimeout();
			char module_key[100];
			while (html_get(debug,introweb,timeout,module_key) != -1){
				if (module_key[0] != '\0'){
					module_dohtml(module_key);
				}else{
					linuxconf_main (1);
				}
			}
			printf ("Ending html\n");
		}else{
			linuxconf_main (0);
		}
		ret = 0;
	}else if (strcmp(argv0,"netconf")==0){
		ret = netconf_main (argc, argv);
	}else if (strcmp(argv0,"passwd")==0){
		ret = userconf_passwd (argc,argv);
	}else if (strcmp(argv0,"userconf")==0){
		ret = userconf_main (argc,argv);
	}else if (strcmp(argv0,"fsconf")==0){
		ret = fstab_main (argc,argv);
	}else if (strcmp(argv0,"xconf")==0){
		ret = xconf_main (argc, argv);
	}else{
		ret = module_execmain (argc,argv);
		if (ret == -1000){
			fprintf (stderr
				,MSG_U(ERR_NAME,"This program can't be rename to any name\n"
				"It is normally named linuxconf.\n"));
			ret = -1;
		}
	}
	return ret;
}

