#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

class MAILCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ MAILCONF_HELP_FILE */
public:
	MAILCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ MAILCONF_HELP_FILE */
};


// Special case where we dictate to sendmail which forwarding host to use
class SPC_ROUTE: public ARRAY_OBJ{
public:
	SSTRING to;		// Destination of the mail
	SSTRING mailer;		// mailer used to reach the forwarder
	SSTRING forwarder;
	char subdomain;		// Deliver to subdomain also
	/*~PROTOBEG~ SPC_ROUTE */
public:
	SPC_ROUTE (void);
	int edit (void);
	void write (FILE *fout);
	/*~PROTOEND~ SPC_ROUTE */
};

class SPC_ROUTES: public ARRAY{
	/*~PROTOBEG~ SPC_ROUTES */
public:
	SPC_ROUTES (void);
	int build (const char *dbformat);
	int edit (void);
	SPC_ROUTE *getitem (int no);
	int save (void);
	void sort (void);
	/*~PROTOEND~ SPC_ROUTES */
};

class COMPLEX_ROUTE: public ARRAY_OBJ{
public:
	char active;
	SSTRING from;
	SSTRING to;
	SSTRING router;
	SSTRING mailer;
	SSTRING new_from;
	SSTRING new_to;
	SSTRING comment;
	/*~PROTOBEG~ COMPLEX_ROUTE */
public:
	COMPLEX_ROUTE (const char *buf);
	COMPLEX_ROUTE (void);
	int edit (void);
	int rule0 (FILE *fout,
		 char *status,
		 SSTRINGS *aliases);
	/*~PROTOEND~ COMPLEX_ROUTE */
};

class COMPLEX_ROUTES: public ARRAY{
	/*~PROTOBEG~ COMPLEX_ROUTES */
public:
	COMPLEX_ROUTES (void);
	int edit (void);
	COMPLEX_ROUTE *getitem (int no);
	int rule0 (FILE *fout, SSTRINGS&aliases);
	int write (void);
	/*~PROTOEND~ COMPLEX_ROUTES */
};

class VDOMAINS;
class VDOMAIN: public ARRAY_OBJ{
public:
	SSTRING domain;		// Fully qualified name of the domain
	SSTRING aliases;	// Path of the alias file
	/*~PROTOBEG~ VDOMAIN */
public:
	VDOMAIN (const char *line);
	VDOMAIN (void);
	int edit (VDOMAINS&vs);
	/*~PROTOEND~ VDOMAIN */
};

class VDOMAINS: public ARRAY{
	/*~PROTOBEG~ VDOMAINS */
public:
	VDOMAINS (void);
	int checkperm (bool);
	int edit (void);
	VDOMAIN *getitem (const char *domain);
	VDOMAIN *getitem (int no);
	MENU_STATUS select (const char *title,
		 const char *intro,
		 int mayadd,
		 int &nof);
	void sort (void);
	int write (void);
	/*~PROTOEND~ VDOMAINS */
};


#define MAXDNSFOR 5

class MAILCONF{
	SSTRINGS alias;
	SSTRING mailas;		// System name we are using
				// when mailing out
	SSTRING mailhost;	// We send all mail to this machine
				// including local one.
	SSTRING smarthost;	// We send what we can't resolve
	SSTRING smartmailer;	// Mailer used to send to smarthost
	struct {
		SSTRING dontmasque;	// Users which will never be
					// masquerade using mailas
		SSTRING deliverlocal;	// Users who received their
					// mail on this machine even
					// if we have a mailhost
	} users;
	struct {
		char dnsneeded;		// Sendmail perform only if it can
							// find the DNS
		char nodns;			// Never use the DNS to canonify hostname
		char uucpnobatch;	// No -r option for uux
		char mailertable;	// Use /var/lib/mailertable or not
		SSTRING dbformat;	// format for mailertable
		int uucpmax;		// Taille maximum du mail uucp
	} features;
	SSTRINGS dnsfor;		// Use the DNS only for those domains
							// See the large comment about
							// DNS scope in basic.c
	SPC_ROUTES spcs;		// Special routes using mailertable
	COMPLEX_ROUTES cplxs;
	SSTRING deliver;		// Utility to deliver local mail
	/*~PROTOBEG~ MAILCONF */
public:
	MAILCONF (void);
	int basicedit (void);
	int generate (bool);
	void spcs_edit (void);
	int write (void);
	/*~PROTOEND~ MAILCONF */
};


#endif

