#include <limits.h>
#include "dnsconf.h"
#include "internal.h"
#include "dnsconf.m"

extern DNSCONF_HELP_FILE help_dnsedit;
/*
	Present all record in the primary and let edit one
*/
PUBLIC void PRIMARY::edithosts(DNS &dns)
{
	int nof = 0;
	while (1){
		/* #Specification: Primary / editing by list / strategy
			We extract all the names available in the domaine (be it a CNAME
			or a NS  or A record and then we sort them and eliminate the
			identical one. We do this because linuxconf provide a global
			view of all the characteristic of a name.
		*/
		SSTRINGS tb;
		tb.neverdelete();
		for (int i=0; i<origins.getnb(); i++){
			ORIGIN *ori = origins.getitem(i);
			RECORDS *tbrec = &ori->tbrec;
			int nrec = tbrec->getnb();
			for (int r=0; r<nrec; r++){
				RECORD *rec = tbrec->getitem(r);
				RECORD_TYPE id = rec->id;
				SSTRING *s = NULL;
				if (id == RTYPE_A){
					RECORD_IN_A *reca = (RECORD_IN_A*)rec;
					s = &reca->name;
				}else if (id == RTYPE_CNAME){
					RECORD_IN_CNAME *reca = (RECORD_IN_CNAME*)rec;
					s = &reca->nickname;
				}else if (id == RTYPE_NS){
					RECORD_IN_NS *reca = (RECORD_IN_NS*)rec;
					s = &reca->name;
				}else if (id == RTYPE_MX){
					RECORD_IN_MX *reca = (RECORD_IN_MX*)rec;
					s = &reca->mailname;
				}
				if (s != NULL && !s->is_empty() && s->cmp("@")!=0){
					tb.add(s);
				}
			}
		}
		tb.sort();
		int n = tb.getnb();
		const char *last = "";
		// Remove dups
		int s;
		for (s=0; s < n; s++){
			SSTRING *ss = tb.getitem(s);
			const char *pt = ss->get();
			if (strcmp(pt,last)==0){
				tb.remove_del (ss);
				i--;
				n--;
			}else{
				last = pt;
			}
		}
		DIALOG dia;
		for (s=0; s < n; s++){
			SSTRING *ss = tb.getitem(s);
			dia.new_menuitem ("",ss->get());
		}
		dia.addwhat (MSG_U(I_ANEWHOST,"A new host/sub-domain"));
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_SELHOST,"Hosts to edit")
			,""
			,help_dnsedit
			,nof,MENUBUT_ADD);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			char buf[PATH_MAX];
			sprintf (buf,".%s",domain.get());
			dns.editrecs (buf);
		}else if (nof >= 0 && nof < n){
			const char *name = tb.getitem(nof)->get();
			char fullname[PATH_MAX];
			sprintf (fullname,"%s.%s",name,domain.get());
			dns.editone(fullname);
		}
	}
}

static int cmp_by_name (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	PRIMARY *s1 = (PRIMARY*)o1;
	PRIMARY *s2 = (PRIMARY*)o2;
	return s1->domainv.cmp(s2->domainv);
}



/*
	Format the menu to select one domain
*/
PRIVATE void PRIMARYS::setselect (DIALOG &dia)
{
	int nb = getnb();
	/* #Specification: domains / edition / sorting
		Domain are always sorted before being presented. This changes
		the ordering in /etc/named.boot.
	*/
	sort(cmp_by_name);
	for (int i=0; i<nb; i++){
		PRIMARY *pri = getitem(i);
		dia.new_menuitem (" ",pri->domainv);
	}
}
/*
	Present the list of primarys. Show selectivly the
	standard domain primaris or the reverse mapping primarys.
*/
PUBLIC void PRIMARYS::editbydom(DNS &dns)
{
	if (getnb()==0){
		xconf_error (MSG_U(E_NODOMAINDEF,"No domain defined yet"));
	}else{
		int choice=0;
		while (1){
			DIALOG dia;
			setselect (dia);
			MENU_STATUS code = dia.editmenu(
				MSG_U(T_EDITBYDOM,"Edit hosts by domain")
				,""
				,help_dnsedit
				,choice,0);
			if (code == MENU_QUIT || code == MENU_ESCAPE){
				break;
			}else if (choice >= 0 && choice < getnb()){
				PRIMARY *p = getitem(choice);
				p->edithosts(dns);
			}
		}
	}
}

