#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "dnsconf.h"
#include "internal.h"

PUBLIC CACHEFILE::CACHEFILE(const char *_domain, const char *_path)
{
	domain.setfrom(_domain);
	path.setfrom (_path);
}

PUBLIC CACHEFILE* CACHEFILES::getitem(int no)
{
	return (CACHEFILE*)ARRAY::getitem(no);
}


PUBLIC IP_ADDR::IP_ADDR()
{
	a[0] = a[1] = a[2] = a[3] = -1;
}
PUBLIC IP_ADDR::IP_ADDR(const SSTRING &str)
{
	setfrom (str.get());
}
PUBLIC IP_ADDR::IP_ADDR(const IP_ADDR &adr)
{
	memcpy (a,adr.a,sizeof(a));
	SSTRING::setfrom (adr.get());
}

PUBLIC void IP_ADDR::setfrom (const char *pt)
{
	SSTRING::setfrom (pt);
	int i=0;
	a[0] = a[1] = a[2] = a[3] = -1;
	while (isdigit(*pt) && i < 4){
		a[i] = atoi(pt);
		i++;
		pt = ::strchr(pt,'.');
		if (pt == NULL) break;
		pt++;
	}
}

/*
	Return != 0 if this is a valid IP number
*/
PUBLIC int IP_ADDR::is_valid()
{
	int ret = 1;
	for (int i=0; i<4; i++){
		if (a[i] < 0 || a[i] > 255){
			ret = 0;
			break;
		}
	}
	return ret;
}

/*
	Reformat the string representation from the four numbers
*/
PUBLIC void IP_ADDR::reformat()
{
	char buf[20];
	char *ctl = "%d";
	char *pt = buf;
	for (int i=0; i<4 && a[i] != -1; i++){
		pt += sprintf (pt,ctl,a[i]);
		ctl = ".%d";
	}
	SSTRING::setfrom (buf);
}
#if 0
/*
	Compute the domain for reverse mapping IN-ADDR.ARPA
*/
PUBLIC void IP_ADDR::setrev (
	int nbn,	// Number of IP number used to define to reverse
			// domain
	char *str)
{
	for (int i=nbn-1; i>=0; i--){
		str += sprintf (str,"%u.",a[i]);
	}
	strcpy (str,"IN-ADDR.ARPA");
}
#endif
/*
	Compute the domain for reverse mapping IN-ADDR.ARPA
	Guess the type of network from the amount ot -1's in the
	address.
*/
PUBLIC void IP_ADDR::setrev (
	char *str)
{
	for (int i=3; i>=0; i--){
		if (a[i] != -1){
			str += sprintf (str,"%d.",a[i]);
		}
	}
	strcpy (str,"IN-ADDR.ARPA");
}

/*
	Turn the IP number upside-down
*/
PUBLIC void IP_ADDR::reverse()
{
	int b[4];
	b[0] = a[3];
	b[1] = a[2];
	b[2] = a[1];
	b[3] = a[0];
	memcpy (a,b,sizeof(a));
	reformat();
}

PUBLIC int IP_ADDR::cmp(const IP_ADDR *p)
{
	int ret = 0;
	for (int i=0; i<4; i++){
		ret = a[i] - p->a[i];
		if (ret != 0) break;
	}
	return ret;
}
/*
	Shift the IP numbers to the left over the -1's (0.0.1.2 -> 1.2.0.0)
*/
PUBLIC void IP_ADDR::shift()
{
	for (int i=0; i<4; i++){
		if (a[0] == -1){
			memmove (a,a+1,3*sizeof(a[0]));
			a[3] = -1;
		}else{
			break;
		}
	}
	reformat();
}
/*
	Shift the IP numbers to the right over the -1's (1.2.0.0 -> 0.0.1.2)
*/
PUBLIC void IP_ADDR::shift_right()
{
	for (int i=3; i>0; i--){
		if (a[3] == -1){
			memmove (a+1,a,3*sizeof(a[0]));
			a[0] = -1;
		}else{
			break;
		}
	}
	reformat();
}

/*
	Augment the IP number by one.
	No reformat is done since this function is called often
*/
PUBLIC void IP_ADDR::increm()
{
	for (int i=3; i>=0; i--){
		a[i]++;
		if (a[i] < 256) break;
		a[i] = 0;
	}
}
/*
	Merge one IP number end over another.
*/
PUBLIC void IP_ADDR::merge(IP_ADDR &partial)
{
	for (int i=0; i<4; i++){
		if (partial.a[i] != -1) a[i] = partial.a[i];
	}
	reformat();
}
/*
	Make sure there is a trailing dot at the end of the string
*/
void dns_cnv2abs(SSTRING &s)
{
	const char *str = s.get();
	int len = strlen(str);
	if (len == 0 || str[len-1] != '.') s.append(".");
}


PUBLIC IP_ADDR *IP_ADDRS::getitem(int no) const
{
	return (IP_ADDR*)ARRAY::getitem(no);
}

static int cmp_by_addr (const ARRAY_OBJ *op1, const ARRAY_OBJ *op2)
{
	IP_ADDR *p1 = (IP_ADDR*)op1;
	IP_ADDR *p2 = (IP_ADDR*)op2;
	return p1->cmp(p2);
}

PUBLIC void IP_ADDRS::sort()
{
	ARRAY::sort(cmp_by_addr);
}

