#pragma implementation
#include <misc.h>
#include "dnsconf.h"
#include "internal.h"
#include <netconf.h>
#include "dnsconf.m"

DNSCONF_HELP_FILE help_dnsconf ("intro");

static DNSCONF_HELP_FILE help_forward ("forwarders");
extern CONFIG_FILE f_boot;

/*
	Edit the forwarders IP number.
*/
PUBLIC void DNS::editforwarders()
{
	DIALOG dia;
	int i;
	for (i=0; i<MAX_FORWARDERS; i++){
		dia.newf_str (i==0 ? MSG_U(F_IPADR,"IP address") : "",forwarders[i]);
	}
	if (dia.edit (MSG_U(T_FORWARDERS,"Forwarders")
		,MSG_U(I_FORWARDERS,"Your DNS may delegate to other DNS\n"
		 "the resolution of external domain.\n"
		 "Just enter the IP number of each DNS\n"
		 "in priority order.")
		,help_forward) == MENU_ACCEPT){
		nbforward = 0;
		for (i=0; i<MAX_FORWARDERS; i++){
			if (!forwarders[i].is_empty()){
				nbforward++;
			}
		}
		write();
	}
}


PUBLIC int DNS::edit()
{
	/* #Specification: dnsconf / main menu
	*/
	int choice=0;
	while (1){
		static const char *t_primarys = MSG_U(M_DOMAINS,"domains");
		static const char *t_reverses = MSG_U(M_IPREV,"IP reverse mappings");
		static const char *t_secondarys = MSG_U(M_SECOND,"secondaries");
		static const char *t_forwarders = MSG_U(M_FORWARD,"forwarders");
		static const char *t_ipmap = MSG_U(M_IPRANGE,"IP allocation space");
		static const char *t_editbydom = MSG_U(M_EDITBYDOM,"host information by domain");
		static const char *t_editrecs = MSG_U(M_HOSTINFO,"(quick edit)");
		static const char *menuopt[]={
			MSG_U(M_CONFIG,"Configure"),	t_primarys,
			" ",		t_reverses,
			" ",		t_secondarys,
			" ",		t_forwarders,
			" ",		t_ipmap,
			"-",		"",
			MSG_U(ADDEDIT,"Add/Edit"),	t_editbydom,
			"",			t_editrecs,
			NULL
		};
		MENU_STATUS code = xconf_menu (
			MSG_U(T_DNSCONF,"DNS configurator")
			,MSG_U(I_DNSCONF,"This package allows you to configure\n"
			 "a Domain Name Server (DNS)\n")
			,help_dnsconf
			,NULL
			,NULL
			,NULL
			,NULL
			,menuopt,choice);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
			const char *key = menuopt[choice*2+1];
			if (key == t_primarys){
				primarys.edit(*this);
			}else if (key == t_reverses){
				primarys_rev.edit(*this);
			}else if (key == t_secondarys){
				secondarys.edit(*this);
			}else if (key == t_forwarders){
				editforwarders();
			}else if (key == t_ipmap){
				ipmap_edit();
			}else if (key == t_editbydom){
				primarys.editbydom(*this);
			}else if (key == t_editrecs){
				editrecs("");
			}
		}
	}
	return 0;
}

/*
	Find out if any part of the DNS was modified during the session
*/
PUBLIC int DNS::was_modified()
{
	int ret = 0;
	if (ARRAY_OBJ::was_modified()
		|| primarys.was_modified()
		|| secondarys.was_modified()){
		ret = 1;
	}
	return ret;
}
		
static DNS *cur_dns = NULL;

void dnsconf_edit()
{
	DNS dns;
	if (!dns.empty()
		|| xconf_yesno(MSG_U(Q_NODNS,"No DNS configured")
			,MSG_U(I_NODNS,"Do you want to create one ?")
			,help_dnsconf)==MENU_YES){
		dns.basiccheck();
		
		cur_dns = &dns;		// Hack for dnsconf_condset()
					// which is called by netconf_updatedns()
		dns.edit();
		cur_dns = NULL;
	}
}

/*
	Update the DNS with a host definition.
	If there is no DNS currently configured, it just do nothing.

	Return != 0 if the DNS was updated.
*/
int dnsconf_condset(
	const char *hostname,
	const char *tbip[],
	int nbip)
{
	int ret = 0;
	if (cur_dns != NULL){
		if (cur_dns->set (hostname,tbip,nbip) != -1){
			ret = 1;
		}
	}else if (f_boot.exist()){
		DNS dns;
		if (dns.set (hostname,tbip,nbip) != -1){
			dns.write();
			ret = 1;
		}
	}
	return ret;
}

static void usage ()
{
	xconf_error (MSG_U(N_DNSUSAGE
		,"Dnsconf: Invalid arguments\n"
		 "dnsconf --set host ip_number\n"
		 "dnsconf --unset host\n"
		 "\n"
		"dnsconf without argument start the interactive mode\n")
		);
}

int dnsconf_main (int argc, char *argv[])
{
	int ret = 0;
	if (netconf_mainaccess()){
		if (argc == 1){
			dnsconf_edit();
			netconf_checkupdate();
		}else if (!f_boot.exist()){
			xconf_error (MSG_U(E_NODNS,"No DNS currently configured"));
		}else{
			DNS dns;
			if (dns.empty()){
				xconf_error (MSG_R(E_NODNS));
			}else if (argc >= 4
				&& strcmp(argv[1],"--set")==0){
				/* #Specification: dnsconf / --set option
					The dnsconf options "--set" allows you to
					set or update the specification of a host.
					You must specify the name (fully qualified or
					not) followed by the IP number.

					dnsconf --set newhost.mydomain 192.68.210.2
				*/
				ret = dns.set (argv[2],(const char**)&argv[3],argc - 3);
				if (ret != -1){
					dns.write();
				}else{
					fprintf (stderr,MSG_U(E_NODOMAINS
						,"Not applicable to any domain in the DNS\n"));
				}
			}else if (argc == 3
				&& strcmp(argv[1],"--unset")==0){
				/* #Specification: dnsconf / --unset option
					The dnsconf options "--unset" allows you to
					remove a host specification from your DNS.

					dnsconf --unset newhost.mydomain
				*/
				dns.unset (argv[2]);
				dns.write();
			}else{
				usage();
			}
		}
	}
	return ret;
}

