#pragma interface
#ifndef DIALOG_H
#define DIALOG_H

/* Optionnal buttons for menubox */
#define MENUBUT_SAVE	1
#define MENUBUT_ADD		2
#define MENUBUT_DEL		4
#define MENUBUT_INS		8
// Other button setup internally
#define MENUBUT_OK		16
#define MENUBUT_ACCEPT		32
#define MENUBUT_CANCEL		64
#define MENUBUT_QUIT		128
#define MENUBUT_YES		256
#define MENUBUT_NO		512
#define MENUBUT_EDIT		1024
#define MENUBUT_RESET		2048
#define MENUBUT_MORE		4096
#define MENUBUT_USR1		8192
#define MENUBUT_USR2		16384
#define MENUBUT_USR3		32768


enum DIALOG_MODE{
	DIALOG_CURSES,	// Use Ncurse
	DIALOG_HTML,	// Web mode
	DIALOG_GUI,		// One day maybe
};
	
extern DIALOG_MODE dialog_mode;

// Return code of many function
enum MENU_STATUS {
	MENU_NULL,
	MENU_ESCAPE,
	MENU_CANCEL,
	MENU_QUIT,
	MENU_SAVE,
	MENU_OK,
	MENU_ACCEPT,
	MENU_DEL,
	MENU_INS,
	MENU_ADD,
	MENU_YES,
	MENU_NO,
	MENU_EDIT,
	MENU_RESET,
	MENU_INTERNAL_TIMEOUT,		// Used to signal a one second delay
								// to the dialog editor
	MENU_HELP,				// Help button, used internally
	MENU_MORE,
	MENU_USR1,
	MENU_USR2,
	MENU_USR3,
};


#define MAX_LEN		2048

#include <curses.h>

#ifndef MISC_H
	#include <misc.h>
#endif
	
class BUTTONS_INFO;
class SSTRINGS;
class HELP_FILE;

class FIELD_MSG{
public:
	char is_loaded;		// Is there a message to process
	void *key;			// Generally a pointer to a common
						// data used by field to talk to each other
	int  int_val;		// Value of the message
						// It is expected to see other type
						// to communicate more complex messages
						// between fields.
	/*~PROTOBEG~ FIELD_MSG */
public:
	FIELD_MSG (void);
	/*~PROTOEND~ FIELD_MSG */
};

class FIELD: public ARRAY_OBJ{
protected:
	char readonly;		// This field can't be modified
	char maybeempty;
	char may_select;	// For Menu field
	friend class DIALOG;
protected:
	char *prompt;
public:
	struct {
		int x;	// Horizontal position of the input boxes
		int width;
		int y;	// Vertical coordinate of the input boxes
	} box;
public:		     	
	virtual void drawtxt(WINDOW *)=0;
	virtual void dokey(WINDOW *, int key, FIELD_MSG &msg)=0;
	virtual void save()=0;
	virtual void restore()=0;
	virtual void html_draw(int nofield)=0;
	virtual int html_validate(int nofield)=0;
	/*~PROTOBEG~ FIELD */
public:
	FIELD (const char *_prompt);
	void draw (WINDOW *dialog);
	virtual void format_htmlkey (char *key, int nof);
	virtual const char *getmenustr (void);
protected:
	virtual int getwidths (int []);
public:
	int is_readonly (void);
	virtual int is_selectable (void);
	virtual int post_validate (void);
protected:
	virtual void processmsg (WINDOW *, FIELD_MSG&, int);
public:
	virtual void set_noempty (void);
	void set_readonly (void);
	virtual void set_selectable (int _may_select);
	virtual void setcursor (WINDOW *dialog);
protected:
	virtual void setwidths (int , int []);
public:
	virtual void unselect (WINDOW *);
	virtual ~FIELD (void);
	/*~PROTOEND~ FIELD */
};

class FIELD_STRING_BASE: public FIELD{
protected:
	struct {
		int input;	// Current position in window */
		int scroll;	// Amount of horizontal scrolling so far */
	}x;
	int size;
	char *buf;		// For editing
protected:
	int password_mode;	// Echo on or not
	/*~PROTOBEG~ FIELD_STRING_BASE */
protected:
	FIELD_STRING_BASE (const char *_prompt,
		 const char *_str,
		 int maxsiz);
	FIELD_STRING_BASE (const char *_prompt,
		 int maxsiz);
public:
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	void html_draw (int nof);
	int html_validate (int nof);
private:
	void init (int maxsiz);
public:
	int is_empty (void);
	int post_validate (void);
	void setcursor (WINDOW *dialog);
	~FIELD_STRING_BASE (void);
	/*~PROTOEND~ FIELD_STRING_BASE */
};

class FIELD_STRING: public FIELD_STRING_BASE{
protected:
	char *str;		// String to edit
	char *backup;
	/*~PROTOBEG~ FIELD_STRING */
public:
	FIELD_STRING (const char *_prompt,
		 char *_str,
		 int maxsiz);
	void restore (void);
	void save (void);
	~FIELD_STRING (void);
	/*~PROTOEND~ FIELD_STRING */
};

class SSTRING;
class FIELD_SSTRING: public FIELD_STRING_BASE{
protected:
	SSTRING &str;
	SSTRING backup;
	/*~PROTOBEG~ FIELD_SSTRING */
public:
	FIELD_SSTRING (const char *_prompt,
		 SSTRING&_str);
	void html_draw (int nof);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_SSTRING */
};

class FIELD_PASSWORD: public FIELD_SSTRING{
	/*~PROTOBEG~ FIELD_PASSWORD */
public:
	FIELD_PASSWORD (const char *_prompt,
		 SSTRING&_str);
	/*~PROTOEND~ FIELD_PASSWORD */
};


// FIELD_STRING with a helper hot key
// generally used to setup combo-box
class FIELD_STRING_HELP: public FIELD_SSTRING{
protected:
	virtual void assist(WINDOW *dialog)=0;
	/*~PROTOBEG~ FIELD_STRING_HELP */
public:
	FIELD_STRING_HELP (const char *_prompt,
		 SSTRING&_str);
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&msg);
	void drawtxt (WINDOW *dialog);
	/*~PROTOEND~ FIELD_STRING_HELP */
};

class LIST_STR;
class FIELD_COMBO: public FIELD_STRING_HELP{
protected:
	LIST_STR *opts;
	int listvalueonly;
	/*~PROTOBEG~ FIELD_COMBO */
public:
	FIELD_COMBO (const char *_prompt, SSTRING&_str);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
protected:
	void assist (WINDOW *dialog);
public:
	void html_draw (int nof);
	int html_validate (int nof);
	~FIELD_COMBO (void);
	/*~PROTOEND~ FIELD_COMBO */
};
class FIELD_LIST: public FIELD_COMBO{
	/*~PROTOBEG~ FIELD_LIST */
public:
	FIELD_LIST (const char *_prompt, SSTRING&_str);
	void dokey (WINDOW *dialog, int , FIELD_MSG&);
	virtual int post_validate (void);
	/*~PROTOEND~ FIELD_LIST */
};
class FIELD_ENUM: public FIELD_LIST{
	int &sel;
	int backup_sel;
	/*~PROTOBEG~ FIELD_ENUM */
public:
	FIELD_ENUM (const char *_prompt, int &_sel);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_ENUM */
};

class FIELD_COMBO_MANY: public FIELD_COMBO{
	/*~PROTOBEG~ FIELD_COMBO_MANY */
public:
	FIELD_COMBO_MANY (const char *_prompt,
		 SSTRING&_str);
	void addopt (const char *str, char &selected);
protected:
	void assist (WINDOW *dialog);
public:
	/*~PROTOEND~ FIELD_COMBO_MANY */
};

class FIELD_CHECK_RADIO: public FIELD{
protected:
	char *title;
	char *var;
	char val;
	char backup;
	/*~PROTOBEG~ FIELD_CHECK_RADIO */
public:
	FIELD_CHECK_RADIO (const char *_prompt,
		 char &_var,
		 const char *_title);
	void drawtxt_check (WINDOW *dialog,
		 char openchar,
		 char closechar,
		 char selchar);
	void format_htmlkey (char *key, int nof);
	void restore (void);
	void save (void);
	void setcursor (WINDOW *dialog);
	~FIELD_CHECK_RADIO (void);
	/*~PROTOEND~ FIELD_CHECK_RADIO */
};


class FIELD_CHECK: public FIELD_CHECK_RADIO{
	/*~PROTOBEG~ FIELD_CHECK */
public:
	FIELD_CHECK (const char *_prompt,
		 char &_var,
		 const char *_title);
	void dokey (WINDOW *dialog, int key, FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	void html_draw (int nof);
	int html_validate (int nof);
	/*~PROTOEND~ FIELD_CHECK */
};
class FIELD_RADIO: public FIELD_CHECK_RADIO{
	char instance_val;
	FIELD_RADIO *next;		// All field radio are in a linked list
							// see radio.c
	/*~PROTOBEG~ FIELD_RADIO */
public:
	FIELD_RADIO (const char *_prompt,
		 char &_var,
		 char _instance_val,
		 const char *_title);
	void dokey (WINDOW *, int key, FIELD_MSG&msg);
	void drawtxt (WINDOW *dialog);
	void html_draw (int);
	int html_validate (int);
private:
	FIELD_RADIO *locate_key (char *key);
protected:
	void processmsg (WINDOW *dialog,
		 FIELD_MSG&msg,
		 int drawok);
public:
	~FIELD_RADIO (void);
	/*~PROTOEND~ FIELD_RADIO */
};

class FIELD_CHECK_MULTI: public FIELD{
protected:
	SSTRINGS options;
	char *var;
	char val;
	char backup;
	/*~PROTOBEG~ FIELD_CHECK_MULTI */
public:
	FIELD_CHECK_MULTI (const char *_prompt,
		 char &_var,
		 const char *_options[]);
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	void html_draw (int nof);
	int html_validate (int nof);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_CHECK_MULTI */
};




class BUTTONS_INFO;

#define DIALOG_MAXCOL	20
class DIALOG: public ARRAY{
protected:
	BUTTONS_INFO *buttons;
	int button;	// Button currently selected or -1
	int width;
	int height;
	SSTRING title;
	SSTRING intro;
	SSTRING icon;
	int offset;	// Number of the first visible field
	int nbvisible;	// How many field are visible (window height)
	struct {
		SSTRING save;
		SSTRING ins;
		SSTRING add;
		SSTRING del;
	}what;	// Small explanation about the behavior of some special
		// buttons.
	int tbcol[DIALOG_MAXCOL];	// Maxwidth of each columns in menu items.
	int nbcol;
	struct {
		SSTRING intro;
		SSTRING body;
		SSTRING end;
	}html_bypass;
	SSTRING internal_title;
	/*~PROTOBEG~ DIALOG */
public:
	DIALOG (void);
	void addwhat (const char *help);
	void delwhat (const char *help);
private:
	void draw (WINDOW *dialog);
	void drawarrow_if (WINDOW *win,
		 bool condition,
		 bool&flag,
		 bool top,
		 chtype carac);
protected:
	void drawf (WINDOW *dialog);
public:
	MENU_STATUS edit (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof,
		 int but_options);
	MENU_STATUS edit (const char *_title,
		 const char *intro,
		 HELP_FILE&helpfile);
	MENU_STATUS edit (const char *_title,
		 const char *intro,
		 HELP_FILE&helpfile,
		 int &nof);
private:
	MENU_STATUS edithtml (int &nof);
public:
	MENU_STATUS editmenu (MENU_CONTEXT context,
		 const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
private:
	MENU_STATUS editterm (int &nof, int but_options);
	void fixwidth1 (void);
public:
	FIELD *getitem (int no);
	const char *getmenustr (int choice);
	void html_body (const char *ctl, ...);
private:
	void html_draw (DIALOG *spc, int nof);
	void html_draw (int nof);
	void html_draw_end (void);
	void html_draw_fields (int nof);
	void html_draw_form (int nof);
	void html_draw_intro (void);
	void html_draw_top (void);
public:
	void html_end (const char *ctl, ...);
	void html_intro (const char *ctl, ...);
private:
	int html_validate (void);
public:
	void inswhat (const char *help);
protected:
	virtual int keymove (WINDOW *dialog,
		 int key,
		 int &nof);
public:
	void last_noempty (void);
	void new_menuinfo (const char *prompt1,
		 const char *prompt2);
	void new_menuitem (const SSTRING&prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *prompt1,
		 const char *prompt2);
	void new_menuitems (const char *opt[]);
	void new_menuline (const char *prompt1,
		 const char *prompt2,
		 int may_select);
	FIELD_CHECK *newf_chk (const char *prompt,
		 char &var,
		 const char *title);
	FIELD_CHECK_MULTI *newf_chkm (const char *prompt,
		 char &var,
		 const char *title[]);
	FIELD_COMBO *newf_combo (const char *prompt,
		 SSTRING&str);
	FIELD_COMBO_MANY *newf_combo_many (const char *prompt,
		 SSTRING&str);
	FIELD *newf_dbl (const char *prompt,
		 double &val,
		 int nbdecimals);
	FIELD_ENUM *newf_enum (const char *prompt, int &sel);
	FIELD *newf_hexnum (const char *prompt, int &val);
	FIELD_LIST *newf_list (const char *prompt,
		 SSTRING&str);
	FIELD *newf_num (const char *prompt, int &val);
	FIELD_PASSWORD *newf_pass (const char *prompt,
		 SSTRING&str);
	FIELD_RADIO *newf_radio (const char *prompt,
		 char &var,
		 char instance_val,
		 const char *title);
	FIELD_SSTRING *newf_str (const char *prompt,
		 SSTRING&str);
	FIELD_STRING *newf_str (const char *prompt,
		 char *str,
		 int maxsiz);
	void newf_text (const char *prompt, const char *buftab);
	void newf_title (const char *prompt, const char *msg);
private:
	void processmsg (WINDOW *dialog, FIELD_MSG&msg);
public:
	void restore (void);
	void save (void);
	void savewhat (const char *help);
	void set_alt_title (const char *_title);
	void set_lastreadonly (void);
	void set_readonly (void);
	void setbutinfo (int id,
		 const char *title,
		 const char *icon);
	void seticon (const char *_icon);
private:
	void setoffset (int newoff);
	void setup (void);
	void showtimeout (WINDOW *win);
public:
	int was_modified (void);
	~DIALOG (void);
	/*~PROTOEND~ DIALOG */
};


class HTML_VARVAL;

#include "dialog.p"

#endif
