#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif
#ifndef MODULE_H
	#include <module.h>
#endif

#ifndef NETCONF_H
	#include <netconf.h>
#endif

class MODULE_APACHE: public LINUXCONF_MODULE{
	/*~PROTOBEG~ MODULE_APACHE */
public:
	MODULE_APACHE (void);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int probe (int state, int target);
	void setmenu (DIALOG&dia, MENU_CONTEXT context);
	/*~PROTOEND~ MODULE_APACHE */
};


class HTTPD_DOMAIN: public ARRAY_OBJ{
	friend class HTTPD_CONFIG;
	CSSTRING host;
	CSSTRING serveradmin;
	CSSTRING servername;
	CSSTRING documentroot;
	CSSTRING errlog;
	CSSTRING transferlog;
	/*~PROTOBEG~ HTTPD_DOMAIN */
public:
	void write (FILE *fout);
	/*~PROTOEND~ HTTPD_DOMAIN */
};

class HTTPD_DOMAINS: public ARRAY{
	/*~PROTOBEG~ HTTPD_DOMAINS */
public:
	HTTPD_DOMAIN *getitem (int no);
	/*~PROTOEND~ HTTPD_DOMAINS */
};
class HTTPD_CONFIG{
	int in_use;			// Httpd is operationnal on this system
	SSTRING comment_port;
	int port;
	SSTRING comment_startservers;
	int startservers;
	SSTRING comment_maxclients;
	int maxclients;
	SSTRING comment_maxrequestsperchild;
	int maxrequestsperchild;
	SSTRING comment_minspareservers;
	int minspareservers;
	SSTRING comment_maxspareservers;
	int maxspareservers;
	SSTRING comment_servertype;
	char servertype;	// 0: Standalone
						// 1: inetd
	CSSTRING pidfile;
	CSSTRING uid;
	CSSTRING gid;
	CSSTRING user;
	CSSTRING group;
	HTTPD_DOMAINS domains;
	HTTPD_DOMAIN defdom;		// Option par dfaut
	SSTRING comment_timeout;
	int timeout;
	CSSTRING scoreboardfile;
	/*~PROTOBEG~ HTTPD_CONFIG */
public:
	HTTPD_CONFIG (void);
	int write (void);
	/*~PROTOEND~ HTTPD_CONFIG */
};

class DAEMON_HTTPD: public DAEMON{
	/*~PROTOBEG~ DAEMON_HTTPD */
public:
	int startif (void);
	/*~PROTOEND~ DAEMON_HTTPD */
};

#endif

