#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"


static HELP_FILE help_httpd ("apache","httpd");
CONFIG_FILE httpd_conf (VAR_LIB_WWW_HTTPD_CONF,help_httpd
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED);

/* #Specification: httpd config / principle
	Linuxconf supports the apache httpd server. While the apache server
	share most of its configuration file format with ncsa httpd, I have not
	made any attempt at "virtualizing" linuxconf. Linuxconf hope to really
	support apache closer and closer.

	It is expect that linuxconf will grow into something more modular one
	day and modules will be available to manage other things than apache
	if this is needed.
*/

static const char HTTPD[]="HTTPD";
static const char IN_USE[]="INUSE";
static const char PORT[]="Port";
static const char USER[]="User";
static const char GROUP[]="Group";
static const char SERVERTYPE[]="ServerType";
static const char PIDFILE[]="PidFile";
static const char STARTSERVERS[]="StartServers";
static const char MAXCLIENTS[]="MaxClients";
static const char MAXREQUESTSPERCHILD[]="MaxRequestsPerChild";
static const char VIRTUALHOST[]="VirtualHost";
static const char TIMEOUT[]="Timeout";
static const char MINSPARESERVERS[]="MinSpareServers";
static const char MAXSPARESERVERS[]="MaxSpareServers";
static const char SCOREBOARDFILE[]="ScoreBoardFile";

static const char SERVERADMIN[]="ServerAdmin";
static const char SERVERNAME[]="ServerName";
static const char DOCUMENTROOT[]="DocumentRoot";
static const char ERRLOG[]="ErrLog";
static const char TRANSFERLOG[]="TransferLog";


PUBLIC HTTPD_DOMAIN *HTTPD_DOMAINS::getitem(int no)
{
	return (HTTPD_DOMAIN*)ARRAY::getitem(no);
}

static void writeif (FILE *fout,const char *title, CSSTRING &s)
{
	if (!s.is_empty()){
		fprintf (fout,"%s\n",s.comment.get());
		fprintf (fout,"%s %s\n",title,s.get());
	}
}

PUBLIC void HTTPD_DOMAIN::write(FILE *fout)
{
	fputc ('\n',fout);
	writeif (fout,SERVERADMIN,serveradmin);
	writeif (fout,SERVERNAME,servername);
	writeif (fout,DOCUMENTROOT,documentroot);
	writeif (fout,ERRLOG,errlog);
	writeif (fout,TRANSFERLOG,transferlog);
}

PUBLIC HTTPD_CONFIG::HTTPD_CONFIG()
{
	FILE *fin = httpd_conf.fopen ("r");
	in_use = linuxconf_getvalnum (HTTPD,IN_USE,0);
	port = 80;
	startservers = 5;
	maxclients = 150;
	maxrequestsperchild = 30;
	minspareservers = 5;
	maxspareservers = 10;
	servertype = 0;
	pidfile.setfrom ("logs/httpd.pid");
	uid.setfrom ("nobody");
	gid.setfrom ("-1");
	timeout = 400;
	scoreboardfile.setfrom ("logs/apache_runtime_status");
	if (fin != NULL){
		char buf[3000];
		SSTRING comments;
		HTTPD_DOMAIN *dom = &defdom;
		while (fgets_comments(buf,sizeof(buf)-1,fin,comments)!=NULL){
			char *pt = str_skip (buf);
			if (*pt == '<'){
			}else{
				char word[200];
				const char *arg = str_copyword (word,pt);
				arg = str_skip(arg);
				if (strcmp(word,SERVERADMIN)==0){
					dom->serveradmin.setcomment(comments);
					dom->serveradmin.setfrom(arg);
				}else if (strcmp(word,SERVERNAME)==0){
					dom->servername.setcomment(comments);
					dom->servername.setfrom(arg);
				}else if (strcmp(word,DOCUMENTROOT)==0){
					dom->documentroot.setcomment(comments);
					dom->documentroot.setfrom(arg);
				}else if (strcmp(word,ERRLOG)==0){
					dom->errlog.setcomment(comments);
					dom->errlog.setfrom(arg);
				}else if (strcmp(word,TRANSFERLOG)==0){
					dom->transferlog.setcomment(comments);
					dom->transferlog.setfrom(arg);
				}else if (strcmp(word,PORT)==0){
					comment_port.setfrom (comments);
					port = atoi(arg);
				}else if (strcmp(word,USER)==0){
					user.setcomment(comments);
					user.setfrom (arg);
				}else if (strcmp(word,GROUP)==0){
					group.setcomment(comments);
					group.setfrom (arg);
				}else if (strcmp(word,SERVERTYPE)==0){
					comment_servertype.setfrom (comments);
					servertype = stricmp(arg,"standalone") == 0 ? 0 : 1;
				}else if (strcmp(word,PIDFILE)==0){
					pidfile.setcomment(comments);
					pidfile.setfrom (arg);
				}else if (strcmp(word,STARTSERVERS)==0){
					comment_startservers.setfrom (comments);
					startservers = atoi(arg);
				}else if (strcmp(word,MAXCLIENTS)==0){
					comment_maxclients.setfrom (comments);
					maxclients = atoi(arg);
				}else if (strcmp(word,MAXREQUESTSPERCHILD)==0){
					comment_maxrequestsperchild.setfrom (comments);
					maxrequestsperchild = atoi(arg);
				}else if (strcmp(word,TIMEOUT)==0){
					comment_timeout.setfrom (comments);
					timeout = atoi(arg);
				}else if (strcmp(word,MINSPARESERVERS)==0){
					comment_minspareservers.setfrom (comments);
					minspareservers = atoi(arg);
				}else if (strcmp(word,MAXSPARESERVERS)==0){
					comment_maxspareservers.setfrom (comments);
					maxspareservers = atoi(arg);
				}else if (strcmp(word,SCOREBOARDFILE)==0){
					scoreboardfile.setcomment (comments);
					scoreboardfile.setfrom (arg);
				}else{
					xconf_error ("Invalid line %s\n",buf);
				}
			}
		}
		fclose (fin);

	}
}

PUBLIC int HTTPD_CONFIG::write ()
{
	int ret = -1;
	FILE *fout = httpd_conf.fopen ("w");
	if (fout != NULL){
		fprintf (fout,"%s\n",comment_servertype.get());
		fprintf (fout,"%s %s\n",SERVERTYPE,servertype ? "standalone" : "inetd");
		fprintf (fout,"%s\n",comment_port.get());
		fprintf (fout,"%s %d\n",PORT,port);
		fprintf (fout,"%s\n",comment_startservers.get());
		fprintf (fout,"%s %d\n",STARTSERVERS,startservers);
		fprintf (fout,"%s\n",comment_minspareservers.get());
		fprintf (fout,"%s %d\n",MINSPARESERVERS,minspareservers);
		fprintf (fout,"%s\n",comment_maxspareservers.get());
		fprintf (fout,"%s %d\n",MAXSPARESERVERS,maxspareservers);
		fprintf (fout,"%s\n",comment_maxclients.get());
		fprintf (fout,"%s %d\n",MAXCLIENTS,maxclients);
		fprintf (fout,"%s\n",comment_maxrequestsperchild.get());
		fprintf (fout,"%s %d\n",MAXREQUESTSPERCHILD,maxrequestsperchild);
		fprintf (fout,"%s\n",pidfile.comment.get());
		fprintf (fout,"%s %s\n",PIDFILE,pidfile.get());
		fprintf (fout,"%s\n",comment_timeout.get());
		fprintf (fout,"%s %d\n",TIMEOUT,timeout);
		fprintf (fout,"%s\n",uid.comment.get());
		fprintf (fout,"%s %s\n",USER,uid.get());
		fprintf (fout,"%s\n",group.comment.get());
		fprintf (fout,"%s %s\n",GROUP,gid.get());
		fprintf (fout,"%s\n",scoreboardfile.comment.get());
		fprintf (fout,"%s %s\n",SCOREBOARDFILE,scoreboardfile.get());

		defdom.write (fout);
		fprintf (fout,"\n");
		for (int i=0; i<domains.getnb(); i++){
			HTTPD_DOMAIN *d = domains.getitem(i);
			fprintf (fout,"<%s %s>\n",VIRTUALHOST,d->host.get());
			domains.getitem(i)->write(fout);
			fprintf (fout,"</%s>\n\n",VIRTUALHOST);
		}
		ret = fclose (fout);
	}
	linuxconf_replace (HTTPD,IN_USE,in_use);
	linuxconf_save();
	return ret;
}




