#!/bin/sh
# Installation script for linuxconf
BIN=/bin
USRBIN=/usr/bin
SBIN=/sbin
rcm=/etc/rc.d/rc.M
# DVER identify which version you have
DVER=
INITTAB=
UPDCONF=
checkalready(){
	if [ `grep askrunlevel $rcs | wc -l` = 1 ] ; then
		echo
		echo Linuxconf has already been installed on this
		echo machine once, no need to update RC scripts
		echo
		exit 0
	fi
}
if [ -f /etc/init.d/boot ] ; then
	echo
	echo Debian based system detected
	echo This installation script has been tested on
	echo "     " Debian 1.1
	echo "     " Debian support in linuxconf is preliminary
	echo
	rcs=/etc/init.d/boot
	rcm=/etc/init.d/rc.M
	DVER=debian
	INITTAB=inittab.debian
	UPDCONF=conf.linuxconf-debian
	checkalready
elif [ -f /etc/rc.d/rc.sysinit ] ; then
	if [ -f /sbin/mingetty ] ; then
		echo
		echo RedHat 4.0 based system detected
		echo This installation script has been tested on
		echo "     " RedHat 4.0
		echo
		rcs=/etc/rc.d/rc.sysinit
		DVER=redhat4.0
		INITTAB=inittab.redhat-4.0
		UPDCONF=conf.linuxconf-redhat-4.0
	else
		echo
		echo RedHat 2.x/3.0.3 based system detected
		echo This installation script has been tested on
		echo "     " RedHat 3.0.3
		#echo "     " Caldera 1.0
		echo
		rcs=/etc/rc.d/rc.sysinit
		DVER=redhat
		INITTAB=inittab.redhat
	fi
	checkalready
elif [ -f /etc/rc.d/rc.S -a -f /etc/rc.d/rc.inet1 -a -f /etc/rc.d/rc.inet2 ]; then
	echo
	echo Slackware based system detected
	echo
	rcs=/etc/rc.d/rc.S
	DVER=slack
	checkalready
else
	echo
	echo '           ********************'
	echo '           ********************'
	echo '           **** attention *****'
	echo '           ********************'
	echo '           ********************'
	echo
	echo This linux system does not look like a Slackware system
	echo nor a RedHat based system
	echo
	echo Please inspect the /install/doinst.sh script
	echo before going further
	echo linuxconf should be compatible with most Linux
	echo system out there, but a very simple incompatibilty
	echo may render your system unbootable.
	echo
	echo -n Do you want to continue anyway '? '
	read yes
	if [ "$yes" != "y" ]; then
		exit
	fi
fi

replace_if(){
	echo -n Do you want to replace $BIN/$1 \($2\) '? '
	read yes
	if [ "$yes" = "y" ] ; then
		if [ -f $BIN/$1 ] ; then
			if [ ! -f $BIN/$1.old ] ; then
				echo Making a backup copy $BIN/$1 '->' $BIN/$1.old
				mv $BIN/$1 $BIN/$1.old
			fi
			ln -sf $BIN/linuxconf $BIN/$1
		elif [ -f $USRBIN/$1 ] ; then
			if [ ! -f $USRBIN/$1.old ] ; then
				echo Making a backup copy $USTBIN/$1 '->' $USRBIN/$1.old
				mv $USRBIN/$1 $USRBIN/$1.old
			fi
			ln -sf $BIN/linuxconf $USRBIN/$1
		else
			echo No $BIN/$1 nor $USRBIN/$1 on this system
		fi
	fi
}


rm -f /sbin/linuxconf
ln -sf $BIN/linuxconf $BIN/netconf
ln -sf $BIN/linuxconf $BIN/xconf
ln -sf $BIN/linuxconf $BIN/lpdconf
ln -sf $BIN/linuxconf $BIN/fsconf
ln -sf $BIN/linuxconf $SBIN/askrunlevel
ln -sf $BIN/linuxconf $SBIN/dnsconf
ln -sf $BIN/linuxconf $SBIN/fixperm
ln -sf $BIN/linuxconf $SBIN/mailconf
ln -sf $BIN/linuxconf $BIN/userconf

sleep 2
echo
echo '================================================='
echo

if [ "$INITTAB" != "" ] ; then
	echo The /etc/inittab file provided on your system is
	echo incompatible with linuxconf. One replacement inittab
	echo is provided here. I can install it here after doing
	echo a backup \(/etc/inittab.old\).
	echo Not installing it will prevent Linuxconf from operating
	echo normally. Operation without the modified inittab is
	echo possible, but not support by this script. Email
	echo me \(jacques@solucorp.qc.ca\) so we can talk about it.
	echo
	echo -n Do you want to install the special /etc/inittab '? '
	read yes
	if [ "$yes" = "y" ] ; then
		if [ ! -f /etc/inittab.old ] ; then
			echo Making a backup copy /etc/inittab.old
			mv /etc/inittab /etc/inittab.old
		fi
		cp /install/$INITTAB /etc/inittab
	else
		echo aborting linuxconf installation
		echo You can still use linuxconf to manage some
		echo key parts of your system, but it won\'t control
		echo its operation.
		exit 1
	fi
fi
sleep 2
echo
echo '================================================='
echo

echo One of the great feature of linuxconf is the askrunlevel
echo utility. This utility start pretty early during the boot
echo process and present you with a nice set of options
echo From there you can decide the operation mode and you
echo can even configure right away your system.
echo askrunlevel avoid those false start boot with an invalid
echo configuration.
echo
echo To activate this feature you need to place a call /sbin/askrunlevel
echo at the end of the $rcs script. I can install this for you.
echo
echo -n Do you want to modify $rcs '? '
read yes
if [ "$yes" = "y" ] ; then
	if [ `grep askrunlevel $rcs | wc -l` = 0 ] ; then
		echo /sbin/askrunlevel >>$rcs
		echo
		echo $rcs has been modified
	else
		echo $rcs already looks ok
	fi
	echo
	echo You may want to remove the clock command from
	echo the file $rcs. askrunlevel take care of
	echo setting the system time from the CMOS. Linuxconf
	echo provide a nice form to set the system time.
	echo Check the help about it.
	echo
	echo -n 'hit <enter> to continue '
	read yes
fi

sleep 2
echo
echo '================================================='
echo
 
echo linuxconf is both a configurator and an activator
echo It means that it replace most of the startup scripts
echo with a single simple rc.M script
echo
echo -n Do you want to install the simpler rc.M script '? '
read yes
if [ "$yes" = "y" ] ; then
	if [ ! -f $rcm.old ] ; then
		if [ -f $rcm ] ; then
			echo Making a backup copy $rcm.old
			mv $rcm $rcm.old
		fi
	fi
	mv /install/rc.M $rcm
fi
sleep 2
echo
echo '================================================='
echo
echo linuxconf may be run with the setuid root flag.
echo It allows anyone to use and configure the system without
echo being root \"first\". At the proper time, the user will
echo be prompt for the root password. If the user does not know
echo it, it will be denied the operation he is attempting.
echo This feature is extremly convenient.
echo
echo -n Do you want to activate the setuid mode of linuxconf '? '
read yes
if [ "$yes" = "y" ] ; then
	chown root.root $BIN/linuxconf
	chmod 4755 $BIN/linuxconf

	sleep 2
	echo
	echo '================================================='
	echo
	echo linuxconf is a replacement for few utilities
	echo This script will make a backup copy of the utilities
	echo and will setup a symbolic link to $BIN/linuxconf
	echo
	echo You will be prompt separatly for each utilty.
	echo Answer y for yes or anything else for no
	echo
	replace_if passwd "recommended"
	#replace_if hostname "Save disk space a bit"
	#replace_if domainname "Save disk space a bit"
else
	chown root.root $BIN/linuxconf
	chmod 755 $BIN/linuxconf
fi

if [ `grep linuxconf /etc/inetd.conf | wc -l` = 0 ] ; then
	sleep 2
	echo
	echo '================================================='
	echo
	echo One very special feature of Linuxconf is that it may
	echo be operated using a Web browser. This is especially
	echo convenient to do remote administration. You don\'t need
	echo to have a web server on this machine to get this feature:
	echo Linuxconf is in itself a simple web server started on
	echo demand by the inetd superserver.
	echo
	echo -n Do you want to install this capability \?
	read yes
	if [ "$yes" = "y" ] ; then
		# Make sure a new line is created
		echo >>/etc/services
		echo linuxconf 98/tcp >>/etc/services
		echo >>/etc/inetd.conf
		echo linuxconf stream tcp wait root /bin/linuxconf linuxconf --http >>/etc/inetd.conf
		killall -HUP inetd
		echo
		echo Linuxconf\'s web mode is now installed and operationnal
		echo To use it, just point your favorite web browser to
		echo http:/this_machine:98/
	fi
fi
if [ "$UPDCONF" != "" -a ! -f /etc/conf.linuxconf ] ; then
	echo Installing a special /etc/conf.linuxconf
	cp /install/$UPDCONF /etc/conf.linuxconf
fi

sleep 2
echo
echo '=============== The end ========================='
echo
echo Linuxconf is now installed
echo just type linuxconf to get a full menu of configuration option.
echo While there, check the first help screen to learn more.
echo
echo After that, you should look at the following screens and menus
echo to assure proper operation
echo
echo "    " Basic host configuration
echo "    " Networking/routing and gateways
echo "    " boot mode/default boot mode
echo "    " date \& time
echo
echo These feature uses special configuration files which are unique
echo to Linuxconf. The other feature managed by linuxconf are managed
echo using the standard configuration file \(When they exist\).
echo
echo You can uninstall linuxconf with the command
echo "    " /install/uninstall_linuxconf.sh

