// -*- c++ -*-
//==========================================================
// prefs.h
// Part of Kwatch
// (c) 1997 by Ralph C. Weichert

#ifndef PREFS_H
#define PREFS_H

#include <qtabdlg.h>
#include <qlistbox.h>
#include <qchkbox.h>
//#include <qdir.h>

class KLogPrefs : public QTabDialog {
    Q_OBJECT

public:
    KLogPrefs( KConfigBase * cfg, QWidget * parent = 0, const char * name = 0,
               bool modal = FALSE );
    ~KLogPrefs();

private:
    QListBox * files;
    QStrList * filelist, * addlist, * dellist;
    QLabel * preview;
    QCheckBox * stick;
    bool fileschanged, fontchanged, fgchanged, bgchanged;
/*     QDir * dir; */
    void setPreviewForeground( const QColor &c );

private slots:
    void addFile();
    void delFile();
    void chooseFont();
    void chooseForeground();
    void chooseBackground();

protected:
    virtual void closeEvent( QCloseEvent *e );

protected slots:
    void applyChanges();

signals:
    void dlgClosed();
    void apply( KConfigBase * cfg );
};

#endif

// EOF
