// -*- c++ -*-
//==========================================================
// main.h
// Part of Kwatch
// (c) 1997 by Ralph C. Weichert

#ifndef MAIN_H
#define MAIN_H

#include <kmenubar.h>
#include <kpopmenu.h>

#include "klogwidget.h"
#include "prefs.h"

class TopLevel : public QWidget {
    Q_OBJECT        
public:
    TopLevel( KConfig * cfg, QWidget * parent = 0, const char * name = 0 );
    ~TopLevel();

private slots:
    void exit();
    void menuBarMoved( KMenuBar::menuPosition );
    void toggleShowDate();          //leon
    void toggleMenuBar();
    void preferences();
    void saveOptions();
    void saveState();

    // void about();
    void help();

    void prefsClosed();
    void reConfig( KConfigBase * cfg );

protected:
    virtual void resizeEvent( QResizeEvent* );

private:
    KLogPrefs * prefs;
    KLogWidget *log;
    KMenuBar *menubar;          // KDE look&feel for menubar
    QPopupMenu *options;
    KPopupMenu *context;
    bool menubar_visible;
    bool show_date;                         //leon
    int id_menubar, id_menubar2;
    int id_showdate, id_showdate2;           //leon
 
    void initMenus( KMenuBar::menuPosition mp );
    void saveOptionsTo( KConfigBase * cfg );
};

#endif

// EOF
