/*******************************/
#ifndef QPLUS_H
#define QPLUS_H

#include <qwidget.h>
#include <qlabel.h>
#include <qcombo.h>
#include <qlined.h>
#include <qevent.h>
#include <qobjcoll.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qkeycode.h>
#include <qslider.h>
#include <qchkbox.h>

#include <qcursor.h>
#include <qmsgbox.h>

#include <iostream.h>


class QCheckBoxX:public QCheckBox
{
   Q_OBJECT
   public:
      QCheckBoxX(QWidget *parent=0,const char *name =0);
      QCheckBoxX(const char *text,QWidget *parent=0,const char *name =0);
   signals:
      void checkedTrue(bool);
      void checkedFalse(bool);
      void invCheckedTrue(bool);
      void invCheckedFalse(bool);
   private slots:
      void emitAdditional(bool b);
   public slots:
      void setCheckedSl(bool check);
};

class QMessageBoxX:public QMessageBox
{
   Q_OBJECT
   public:
      QMessageBoxX(QWidget *parent=0, const char *name=0);
      void setMouseCatching(bool mode);
   protected:
      void paintEvent(QPaintEvent *e);
      QPushButton *orig;
   private:
      bool firstTime,catchMouse;
};  

class QDialogX:public QDialog
{
   Q_OBJECT
   public:
      QDialogX(QWidget *parent=NULL, const char *name=0,bool modal=FALSE,WFlags f=0);
      void setMouseCatching(bool mode);
      void catchMouse();
   protected:
      void paintEvent(QPaintEvent *e);
   private:
      bool firstTime,wetherCatchMouse;
};

class QPushButtonX:public QPushButton
{
   Q_OBJECT
   public:
      QPushButtonX(QWidget *parent=NULL,const char *name=NULL);   
      QPushButtonX(const char *text,QWidget *parent=NULL,const char *name=NULL);
      int value();
   public slots:
      void setValue(int i);
   protected:
      int val;
      virtual void mousePressEvent(QMouseEvent *e);
   private slots:
      void emitValueClicked();
   signals:
      void valueClicked(int i);
      void valueRightClicked(int i);
      void rightClicked();
};

/*******************************
nach exec:
   0= nein
   1= ja
   2= abgebrochen
*******************************/
class QSaveDialog:public QDialogX
{
   Q_OBJECT
   public:
      QSaveDialog(QWidget *parent=NULL,const char *name=NULL,bool modal=FALSE); 
   protected:
      QPushButton yes,no;
      QPushButtonX esc;
      QLabel text;
};

class QNumLineEdit:public QLineEdit
   {
   Q_OBJECT
   public:
      QNumLineEdit(int Min, int Max, int Val, QWidget *parent=NULL,const char *name=NULL);
      int value(void);
   public slots:
      void setValue(int i);
   protected:
      void keyPressEvent(QKeyEvent *e);
      void focusOutEvent(QFocusEvent* e);

   	void checkRange();
   protected slots:
      virtual void valueCorrect(int i);

   private:
      int val,min,max;
   private slots:
      void setValue(const char * valstr);

   signals:
      void valueChanged(int i);
      void valueCorrected(int i);
   };
   
class QComboBoxX:public QComboBox
	{
	Q_OBJECT
	public:
		QComboBoxX(bool b,QWidget *parent=0,const char *name =0);
      void setMaxLength(int length);
   public slots:
      void setText(const char * text);
	protected:
      QLineEdit *orig;
	};

class QColorSelect:public QWidget
{
   Q_OBJECT
   public:
      QColorSelect(QWidget *parent=0,const char *name=0,QColor icol=QColor(0,0,0));
      void setRgb(int lr, int lg, int lb);
      void setHsv(int lh, int ls, int lv);
      void hsv(int &lh, int &ls, int &lv);
      void rgb(int &lr, int &lg, int &lb);
   private:
      QColor col;
      int h,s,v,r,g,b;
      bool inWork;
      QSlider hsl,ssl,vsl,rsl,gsl,bsl;
      QLineEdit hle,sle,vle,rle,gle,ble;
      QLabel hla,sla,vla,rla,gla,bla;
      QWidget showColor;
   protected slots:
      void hsvChanged(int);
      void rgbChanged(int);
};

#endif //QPLUS_H
