/****************************
	klassen
	und qcomboboxx
   und qnumlineedit
   und qsavedialog
   und qpushbuttonx
   und qdialogx
   und qmessageboxx
   and qcheckboxx
*****************************/

#include "qplus.h"
/****************************
QCheckBoxX
****************************/

QCheckBoxX::QCheckBoxX(QWidget *parent,const char *name):QCheckBox(parent,name)
{
   connect(this,SIGNAL(toggled(bool)),this,SLOT(emitAdditional(bool)));
};

QCheckBoxX::QCheckBoxX(const char *text,QWidget *parent,const char *name):QCheckBox(text,parent,name)
{
   connect(this,SIGNAL(toggled(bool)),this,SLOT(emitAdditional(bool)));
};

void QCheckBoxX::setCheckedSl(bool check)
{
   setChecked(check);
};

void QCheckBoxX::emitAdditional(bool b)
{
   if (b)
   {
      emit checkedTrue(TRUE);
      emit invCheckedTrue(FALSE);
   }
   else
   {
      emit checkedFalse(FALSE);
      emit invCheckedFalse(TRUE);
   };
};

/**************************
QColorSelect
**************************/
QColorSelect::QColorSelect(QWidget *parent,const char *name,QColor icol)
   :QWidget(parent,name)
   ,col(icol)
   ,h(0)
   ,s(0)
   ,v(0)
   ,r(col.red())
   ,g(col.green())
   ,b(col.blue())
   ,inWork(FALSE)
   ,hsl(-1,360,10,0,QSlider::Vertical,this)
   ,ssl(0,255,10,0,QSlider::Vertical,this)
   ,vsl(0,255,10,0,QSlider::Vertical,this)
   ,rsl(0,255,10,0,QSlider::Vertical,this)
   ,gsl(0,255,10,0,QSlider::Vertical,this)
   ,bsl(0,255,10,0,QSlider::Vertical,this)
   ,hle(this)
   ,sle(this)
   ,vle(this)
   ,rle(this)
   ,gle(this)
   ,ble(this)
   ,hla("Hue",this)
   ,sla("Sat.",this)
   ,vla("Value",this)
   ,rla("Red",this)
   ,gla("Green",this)
   ,bla("Blue",this)
   ,showColor(this,"color")
{
   rsl.setValue(r);
   gsl.setValue(g);
   bsl.setValue(b);
   setCaption("Select a color");
   resize(400,180);
   hle.setGeometry(10,140,35,30);
   sle.setGeometry(60,140,35,30);
   vle.setGeometry(110,140,35,30);
   rle.setGeometry(160,140,35,30);
   gle.setGeometry(210,140,35,30);
   ble.setGeometry(260,140,35,30);
   showColor.setGeometry(310,30,80,100);

   hla.setGeometry(15,0,35,30);
   sla.setGeometry(65,0,35,30);
   vla.setGeometry(115,0,35,30);
   rla.setGeometry(165,0,35,30);
   gla.setGeometry(215,0,35,30);
   bla.setGeometry(265,0,35,30);

   hsl.setGeometry(15,30,20,100);
   ssl.setGeometry(65,30,20,100);
   vsl.setGeometry(115,30,20,100);
   rsl.setGeometry(165,30,20,100);
   gsl.setGeometry(215,30,20,100);
   bsl.setGeometry(265,30,20,100);
	hsl.setFocusPolicy(QWidget::TabFocus);
	ssl.setFocusPolicy(QWidget::TabFocus);
	vsl.setFocusPolicy(QWidget::TabFocus);
	rsl.setFocusPolicy(QWidget::TabFocus);
	gsl.setFocusPolicy(QWidget::TabFocus);
	bsl.setFocusPolicy(QWidget::TabFocus);

	hsl.setTickmarks(QSlider::Left);
	ssl.setTickmarks(QSlider::Left);
	vsl.setTickmarks(QSlider::Left);
	rsl.setTickmarks(QSlider::Left);
	gsl.setTickmarks(QSlider::Left);
	bsl.setTickmarks(QSlider::Left);

	hsl.setTickInterval(50);
	ssl.setTickInterval(50);
	vsl.setTickInterval(50);
	rsl.setTickInterval(50);
	gsl.setTickInterval(50);
	bsl.setTickInterval(50);

   connect(&hsl,SIGNAL(sliderMoved(int)),this,SLOT(hsvChanged(int)));
   connect(&ssl,SIGNAL(sliderMoved(int)),this,SLOT(hsvChanged(int)));
   connect(&vsl,SIGNAL(sliderMoved(int)),this,SLOT(hsvChanged(int)));
   connect(&rsl,SIGNAL(sliderMoved(int)),this,SLOT(rgbChanged(int)));
   connect(&gsl,SIGNAL(sliderMoved(int)),this,SLOT(rgbChanged(int)));
   connect(&bsl,SIGNAL(sliderMoved(int)),this,SLOT(rgbChanged(int)));

   connect(&hsl,SIGNAL(valueChanged(int)),this,SLOT(hsvChanged(int)));
   connect(&ssl,SIGNAL(valueChanged(int)),this,SLOT(hsvChanged(int)));
   connect(&vsl,SIGNAL(valueChanged(int)),this,SLOT(hsvChanged(int)));
   connect(&rsl,SIGNAL(valueChanged(int)),this,SLOT(rgbChanged(int)));
   connect(&gsl,SIGNAL(valueChanged(int)),this,SLOT(rgbChanged(int)));
   connect(&bsl,SIGNAL(valueChanged(int)),this,SLOT(rgbChanged(int)));
   rgbChanged(0);
};
void QColorSelect::setRgb(int lr, int lg, int lb)
{
   rsl.setValue(lr);
   gsl.setValue(lg);
   bsl.setValue(lb);
   rgbChanged(0);
};

void QColorSelect::setHsv(int lh, int ls, int lv)
{
   hsl.setValue(lh);
   ssl.setValue(ls);
   vsl.setValue(lv);
   hsvChanged(0);
};

void QColorSelect::hsv(int &lh, int &ls, int &lv)
{
   lh=h;
   ls=s;
   lv=v;
};

void QColorSelect::rgb(int &lr, int &lg, int &lb)
{
   lr=r;
   lg=g;
   lb=b;
};

void QColorSelect::hsvChanged(int)
{
	if (inWork==FALSE)
	{
      inWork=TRUE;
		h=hsl.value();
		char str[4];
		sprintf(str,"%i",h);
		hle.setText(str);

		s=ssl.value();
		sprintf(str,"%i",s);
		sle.setText(str);

		v=vsl.value();
		sprintf(str,"%i",v);
		vle.setText(str);

		col.setHsv(h,s,v);
		col.rgb(&r,&g,&b);

		sprintf(str,"%i",r);
		rle.setText(str);
		sprintf(str,"%i",g);
		gle.setText(str);
		sprintf(str,"%i",b);
		ble.setText(str);

		rsl.setValue(r);
		gsl.setValue(g);
		bsl.setValue(b);

		showColor.setBackgroundColor(col);
      inWork=FALSE;
	};
};

void QColorSelect::rgbChanged(int)
{
	if (inWork==FALSE)
	{
		inWork=TRUE;
		r=rsl.value();
		char str[4];
		sprintf(str,"%i",r);
		rle.setText(str);

		g=gsl.value();
		sprintf(str,"%i",g);
		gle.setText(str);

		b=bsl.value();
		sprintf(str,"%i",b);
		ble.setText(str);

		col.setRgb(r,g,b);
		col.hsv(&h,&s,&v);

		sprintf(str,"%i",h);
		hle.setText(str);
		sprintf(str,"%i",s);
		sle.setText(str);
		sprintf(str,"%i",v);
		vle.setText(str);

		hsl.setValue(h);
		ssl.setValue(s);
		vsl.setValue(v);

		showColor.setBackgroundColor(col);
		inWork=FALSE;
	};
};

/*void QColorSelect::hChanged(int i)
{
	h=i;
	char str[4];
	sprintf(str,"%i",i);
	hle.setText(str);
   col.setHsv(h,s,v);
   col.rgb(&r,&g,&b);
   showColor.setBackgroundColor(col);
// updateColor();
};

void QColorSelect::sChanged(int i)
{
	s=i;
	char str[4];
	sprintf(str,"%i",i);
	sle.setText(str);
   col.setHsv(h,s,v);
   col.rgb(&r,&g,&b);
   showColor.setBackgroundColor(col);

// updateColor();
};

void QColorSelect::vChanged(int i)
{
	v=i;
	char str[4];
	sprintf(str,"%i",i);
	vle.setText(str);
   col.setHsv(h,s,v);
   col.rgb(&r,&g,&b);
   showColor.setBackgroundColor(col);
// updateColor();
};*/

/*void QColorSelect::rChanged(int i)
{
	r=i;
	char str[4];
	sprintf(str,"%i",i);
	rle.setText(str);
   col.setRgb(r,g,b);
   col.hsv(&r,&g,&b);
   showColor.setBackgroundColor(col);

// updateColor();
};

void QColorSelect::gChanged(int i)
{
	g=i;
	char str[4];
	sprintf(str,"%i",i);
	gle.setText(str);
   col.setRgb(r,g,b);
   col.hsv(&r,&g,&b);
   showColor.setBackgroundColor(col);

// updateColor();
};

void QColorSelect::bChanged(int i)
{
	b=i;
	char str[4];
	sprintf(str,"%i",i);
	ble.setText(str);
   col.setRgb(r,g,b);
   col.hsv(&r,&g,&b);
   showColor.setBackgroundColor(col);
// updateColor();
};*/

/*void QColorSelect::updateColor()
{
   showColor.setBackgroundColor(col);
};*/

/**************************
QDialogX
**************************/

QDialogX::QDialogX(QWidget *parent,const char *name,bool modal, WFlags f):QDialog(parent,name,modal,f)
   ,firstTime(TRUE)
   ,wetherCatchMouse(FALSE)   
{
};

void QDialogX::catchMouse()
{
	QCursor cursor;
	cursor.setPos(x()+(width()/2),y()+(height()/2));
	firstTime=FALSE;
};

void QDialogX::paintEvent(QPaintEvent *e)
{
   QDialog::paintEvent(e);
   if ((firstTime)&&(wetherCatchMouse)) catchMouse();
};

void QDialogX::setMouseCatching(bool mode)
{
   wetherCatchMouse=mode;
};

/*******************************
QMessageBoxX
*******************************/
QMessageBoxX::QMessageBoxX(QWidget *parent,const char *name):QMessageBox(parent,name)
   ,firstTime(TRUE)
   ,catchMouse(TRUE)   
{
	QObjectList *list = queryList("QPushButton");
	orig=(QPushButton *)list->first();
	orig->setDefault(TRUE);
   orig->setFocus();
};

void QMessageBoxX::paintEvent(QPaintEvent *e)
{
   QDialog::paintEvent(e);
   if ((firstTime)&&(catchMouse))
   {
      QCursor cursor;
      cursor.setPos(x()+(width()/2),y()+(height()/2));
      firstTime=FALSE;
   };
};

void QMessageBoxX::setMouseCatching(bool mode)
{
   catchMouse=mode;
};



/*************************
	QPushButtonX
*************************/
QPushButtonX::QPushButtonX(QWidget *parent,const char *name):QPushButton(parent,name)
      	,val(0)
{
	connect(this,SIGNAL(clicked()),this,SLOT(emitValueClicked()));
};

QPushButtonX::QPushButtonX(const char *text,QWidget *parent,const char *name):QPushButton(text,parent,name)
      	,val(0)
{
	connect(this,SIGNAL(clicked()),this,SLOT(emitValueClicked()));
};

void QPushButtonX::setValue(int i)
{
   val=i;
};

int QPushButtonX::value()
{
   return val;
};

void QPushButtonX::emitValueClicked()
{
   emit valueClicked(val);
};

void QPushButtonX::mousePressEvent(QMouseEvent *e)
{
   if (e->button()==RightButton)
   {
      emit rightClicked();
      emit valueRightClicked(val);
   } else QPushButton::mousePressEvent(e);
};


/*************************
QSaveDialog
*************************/
QSaveDialog::QSaveDialog(QWidget *parent, const char *name, bool modal):QDialogX(parent,name,modal)
         	,yes("&Yes",this)
            ,no("&No",this)
            ,esc("C&ancel",this)
            ,text(this,"text")
{
   resize(340,100);
   text.setText("Save Changes ?");
   text.move(20,10);
   yes.move(10,60);
   yes.setFocus();
   no.move(120,60);
   esc.move(230,60);
   esc.setValue(2);
   
   connect(&yes,SIGNAL(clicked()),this,SLOT(accept()));
   connect(&no,SIGNAL(clicked()),this,SLOT(reject()));
   connect(&esc,SIGNAL(valueClicked(int)),this,SLOT(done(int)));
};

/*************************
	QNumLineEdit
*************************/
QNumLineEdit::QNumLineEdit(int Min, int Max, int Val,QWidget *parent,const char *name)
      	:QLineEdit(parent,name)
         ,min(Min)
         ,max(Max)
//       ,vChanged(TRUE)
//       ,vCorrected(FALSE)
//       ,intern(FALSE)
{
	connect(this,SIGNAL(textChanged(const char *)),this,SLOT(setValue(const char *)));
	connect(this,SIGNAL(valueCorrected(int)),this,SLOT(valueCorrect(int)));
   setValue(Val);
};

int QNumLineEdit::value(void)
{
   checkRange();
	return val;
};

void QNumLineEdit::focusOutEvent(QFocusEvent* e)
{
   checkRange();
   QLineEdit::focusOutEvent(e);
};

void QNumLineEdit::setValue(int i)
{
   if (val==i) return;
   val=i;
   char tmp[30];
   sprintf(tmp,"%d",val);
   setText(tmp);
   emit valueChanged(val);
};

void QNumLineEdit::setValue(const char * valstr)
{
   char **error=NULL;
   setValue(strtol(valstr,error,10));
};

void QNumLineEdit::keyPressEvent(QKeyEvent *e)
{
   if ((e->state()==ControlButton) ||
   ((e->state()==ShiftButton) && (e->key()>=Key_Delete) &&(e->key()<=Key_Next)) ||
   ((e->state()==0) && ((e->key()==Key_Plus)|| (e->key()==Key_Minus)) && (strchr(text(),'-')==NULL) && (strchr(text(),'+')==NULL) )||
   ((e->state()==0) && ((e->key()>=Key_Escape) || ((e->key()>=Key_0) && (e->key()<=Key_9)))))
      QLineEdit::keyPressEvent(e);
};

void QNumLineEdit::checkRange()
{
   if ((val<min) ||(val>max))
   {
      if (val<min) setValue(min); else setValue(max);
      emit valueCorrected(val);
   };
};

void QNumLineEdit::valueCorrect(int i)
{
/*   QMessageBox mb(this);
   char tmp[40];
   sprintf(tmp,"Value out of range !\n( %d ... %d )",min,max);
   mb.setText(tmp);
   mb.exec();*/
};
/*void QNumLineEdit::setValue(int i)
{
   vCorrected=FALSE;
   vChanged=FALSE;
   if (i<min)
   {
      vCorrected=TRUE;
      if (val!=min) 
      {
         vChanged=TRUE;
         val=min;
      };
   }
   else 
   if (i>max)
   {
      vCorrected=TRUE;
      if (val!=max) 
      {
         vChanged=TRUE;
         val=max;
      };
   }
   else 
   if (i!=val)
   {
      vCorrected=FALSE;
      vChanged=TRUE;
      val=i;
   };
   if (vChanged) emit valueChanged(val);
   if (vCorrected==TRUE) 
   {
   emit valueCorrected(val);
   };
   emit valueSet(val);
   intern=TRUE;
   if ((vCorrected) || (vChanged))
   {
      char tmp[30];
      sprintf(tmp,"%d",val);
      setText(tmp);
   };
};*/

/************************
	qcomboboxx
************************/

QComboBoxX::QComboBoxX(bool b,QWidget *parent=0,const char *name =0):QComboBox(b,parent,name)
   ,orig(NULL)
{
	if (b)
	{
      QObjectList *list = queryList("QLineEdit");
      orig=(QLineEdit *)list->first();
	};
};

void QComboBoxX::setText(const char * name)
{
	if (orig != NULL) orig->setText(name);
};

void QComboBoxX::setMaxLength(int length)
{
	if (orig != NULL) orig->setMaxLength(length);
};


