#ifndef SAMBACLASS_H
#define SAMBACLASS_H

#include <stdio.h>
#include <DLList.h>
#include <String.h>
//#include <procbuf.h>
//#include <sys/types.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "../initfile/initfile.h"

struct sharesInf
{
   enum
   {
      smbfs=0,
      nfs=1
   };
   String name,comment;
   int fs,mounted;
};

class NPC
{
   public:
      int informed,mounted,hasNFS,running;
      NPC():informed(0),mounted(0),hasNFS(0),running(0){};
      String pc_name,wg,comment,ip,os,domain;
      DLList<sharesInf>shares;
};

class SambaClass
{
   public:
      SambaClass(const char * config,const char* selfName);
      virtual ~SambaClass(){;};
      void getNetStatus();
      void getSambaNetList(DLList<NPC>& newList);
      void getNSList(DLList<NPC>& newList);
      void mergeList(DLList<NPC>& newList);
      void insertHost(NPC tmp);
      void deleteHost(Pix tmpPix);

      virtual void getPCStatus(const char *target, const char *uname=0,const char *pword=0);

      void getNFSExports(const char *target);
      void getSambaShares(const char *target, const char *uname=0,const char *pword=0);

      void getIP(const char *target);
      virtual void startUp();
      String getIPDirect(const char *target);
      String browseListServer;
      DLList<NPC> hostList;

   protected:
   	Pix getTargetPix(const char *target);
   	Pix getSharePix(const Pix& p,const char *share);
      void doErrorMess(const char *text);

      virtual void readConfig();
      virtual void readConfigCore();

      Pix smbpix,sharepix;
      String myName;
      
//configuration
   	String configDir,configFile;
   	String command,sh_path,tmpFile,smbMountPath,shell,stdUser,talkCommand,nsLookup;
      int refreshTime,rows,unmountOnExit,fontSize,ipForSamba,sambaForList;
      String shellOpts[15];
      String fManager[20];
};

#endif
