#include "sambaclass.h"

/**********************************/

int fNotEmpty(const char *name)
{
   FILE *f=fopen(name,"r");
   if (f==NULL) return 0;
   int i=fgetc(f);
   fclose(f);
   if (i==EOF) return 0;
   return 1;
};

SambaClass::SambaClass(const char * config, const char *selfName)
   :browseListServer("")
   ,hostList()
   ,myName(selfName)
   ,configDir("")
   ,configFile(config)
   ,tmpFile("/tmp/qnetmonstd.tmp")
   ,talkCommand("standard")
   ,nsLookup("")
   ,refreshTime(0)
   ,rows(40)
   ,unmountOnExit(1)
   ,fontSize(10)
   ,ipForSamba(0)
   ,sambaForList(1)
{
	if (configFile!="std")
   splitFilename(String((const char*)configFile),configDir,configFile);
   else
   {
      configFile="qnetmonrc";
      configDir="/etc";
   };
// readConfig();
};

void SambaClass::startUp()
{
   readConfig();
};

#include <iostream.h>
void SambaClass::readConfig()
{
   readConfigCore();
};

void SambaClass::readConfigCore()
{
//   cout<<"reading configuration from "<<configDir<<configFile<<endl;


   TInitFile initf((const char*)configFile,(const char* ) configDir);
//   TInitFile initf("qnetmonrc","/etc");

   String tmpRefresh(initf.getSingleEntry("refresh"));
	char *error="";
	int tmp=strtol(tmpRefresh,&error,10);
   if ((tmpRefresh!="manual") &&((tmp<5)||(tmp>3600)))
   {
      cout<<"Invalid entry for refresh: -"<<tmpRefresh<<"-\npossible values: manual,5 to 3600\nrefresh time set to 60 s"<<endl;
      refreshTime=180;
   }
   else if (tmpRefresh=="manual") refreshTime=-1;
   else refreshTime=tmp;

	tmp=strtol((const char*)initf.getSingleEntry("max_rows"),&error,10);
   if (tmp>0) rows=tmp;

   if (initf.getSingleEntry("xtalk")!="standard") talkCommand=initf.getSingleEntry("xtalk");
   if (initf.getSingleEntry("unmount_on_exit")=="no") unmountOnExit=0;   
   if (initf.getSingleEntry("use_ip_for_samba")=="yes") ipForSamba=1;   
   sambaForList=(initf.getSingleEntry("use_smbclient_for_getting_userlist")=="yes");

   nsLookup=initf.getSingleEntry("use_nslookup");   
//   cout<<"nslookup: "<<nsLookup<<endl;
   if (nsLookup=="no") nsLookup="";

	tmp=strtol((const char*)initf.getSingleEntry("font_size"),&error,10);
   if (tmp>3) fontSize=tmp;

   browseListServer=initf.getSingleEntry("browselist_server");
//	cout<<"browselist_server: -"<<browseListServer<<"-"<<endl;
   smbMountPath=initf.getSingleEntry("mount_point");
//   if (smbMountPath[0]!='/') smbMountPath="/"+smbMountPath;

//   cout<<smbMountPath<<endl;
   shell=initf.getSingleEntry("xterm");
   if (initf.getSingleEntry("tmpfile")!="") tmpFile=initf.getSingleEntry("tmpfile");

   stdUser=initf.getSingleEntry("std_user");

//read shell options
   String tmpString=initf.getSingleEntry("xterm_options");
   if (tmpString=="") shellOpts[0]="";
   else
   {
		int optCount(0);
		do
		{
			shellOpts[optCount]=(String)tmpString.before(RXwhite);
         if ((tmpString!="") && (tmpString.before(RXwhite)=="")) shellOpts[optCount]=tmpString;
//         cout<<"shelloption "<<optCount<<": *"<<shellOpts[optCount]<<"*"<<endl;
			tmpString=tmpString.after(RXwhite);
			optCount++;
      } while (tmpString!="");
   };

//read filemanager
   tmpString=initf.getSingleEntry("filemanager");
   if (tmpString=="") fManager[0]="";
   else
   {
		int optCount(0);
		do
		{
			fManager[optCount]=(String)tmpString.before(RXwhite);
         if ((tmpString!="") && (tmpString.before(RXwhite)=="")) fManager[optCount]=tmpString;
//         cout<<"fm: "<<optCount<<": *"<<fManager[optCount]<<"*"<<endl;
			tmpString=tmpString.after(RXwhite);
			optCount++;
      } while (tmpString!="");
   };
   
   if (ipForSamba==1)
   {
      command="smbclient -L "+browseListServer+" -I "+getIPDirect(browseListServer);//+" >"+tmpFile;
   } else
   command="smbclient -L "+browseListServer;//+" >"+tmpFile;
//   cout<<"tmpfile: -"<<command<<"-"<<endl;
//   cout<<"sambaForList: "<<sambaForList<<endl;
};

/*!
intern: searches the list hostList to find
the host named target and returns the pix 
*/
Pix SambaClass::getTargetPix(const char *target)
{
   Pix tmpPix=hostList.first();
   if (tmpPix==0) return 0;
   String s(hostList(tmpPix).pc_name);

   while ( (tmpPix!=0) && ( s!=String(target)) )
   {
      hostList.next(tmpPix);   
      if (tmpPix!=0) s=hostList(tmpPix).pc_name;
//		cout<<"pc-name: "<<s<<endl;
   };
   return tmpPix;
};

Pix SambaClass::getSharePix(const Pix& p,const char *share)
{
   Pix tmpPix=hostList(p).shares.first();
   String s(hostList(p).shares(tmpPix).name);

   while ( (tmpPix!=0) && ( s!=String(share)) )
   {
      hostList(p).shares.next(tmpPix);   
      if (tmpPix!=0) s=hostList(p).shares(tmpPix).name;
//		cout<<"share-name: "<<s<<endl;
   };
   return tmpPix;
};

void SambaClass::doErrorMess(const char *text)
{
   String infoS(myName+": execution of ");
   infoS+=text;
   infoS+=" failed\n"+myName+": check your valid "+myName+"rc or your path\n";
   cerr<<infoS<<endl;
};


void SambaClass::getIP(const char * target)
{
   Pix tmpPix;
   tmpPix=getTargetPix(target);
   if (tmpPix==0) cout<<"error !!"<<endl;
   hostList(tmpPix).ip=getIPDirect(target);
//   cout<<"IP of "<<target<<": "<<hostList(tmpPix).ip<<endl;
};

/*!
does a smbclient to host pc and scans the output to get
information about shares and so on
*/
void SambaClass::getPCStatus(const char* target,const char *uname,const char *pword)
{
   getIP(target);
   hostList(getTargetPix(target)).shares.clear();
   getSambaShares(target,uname,pword);
   getNFSExports(target);

/*   Pix tmpPix=getTargetPix(target);
   sharepix=hostList(tmpPix).shares.first();
   while  (sharepix!=0)
   {
      cout<<"//"<<hostList(tmpPix).pc_name<<"/"<<hostList(tmpPix).shares(sharepix).name<<"   # "<<hostList(tmpPix).shares(sharepix).comment<<endl;
      hostList(tmpPix).shares.next(sharepix);   
   };*/
};

void SambaClass::mergeList(DLList<NPC>& tmpList)
{
   Pix tmpPixOld,tmpPixNew;
   tmpPixOld=hostList.first();
	while(tmpPixOld!=0)
	{
		hostList(tmpPixOld).running=-1;
   	hostList.next(tmpPixOld);
   };
//   cout<<"hostlist set to -1"<<endl;
   String hostName("");
   tmpPixNew=tmpList.first();
   if (tmpPixNew==0) cout<<"Pix==NULL"<<endl;
	while(tmpPixNew!=0)
	{
      hostName=tmpList(tmpPixNew).pc_name;
      tmpPixOld=getTargetPix(hostName);
      if (tmpPixOld!=0)
      {
//         cout<<"name: "<<tmpList(tmpPixNew).pc_name<<"  "<<tmpList(tmpPixNew).running<<endl;
         if (tmpList(tmpPixNew).running==0)
         {
//         cout<<"deleting "<<tmpList(tmpPixNew).pc_name<<endl;
         deleteHost(tmpPixOld);
         }
         else if (tmpList(tmpPixNew).running==1)
         {
//            cout<<"activating "<<tmpList(tmpPixNew).pc_name<<endl;
            hostList(tmpPixOld).running=1;
         };
      }
      else if (tmpList(tmpPixNew).running==1)
      {
//         cout<<"name: "<<tmpList(tmpPixNew).pc_name<<"  "<<tmpList(tmpPixNew).running<<endl;
         NPC npc_var;
         npc_var.running=1;
         npc_var.pc_name=hostName;
         npc_var.comment=tmpList(tmpPixNew).comment;
         insertHost(npc_var);
      }
      tmpList.next(tmpPixNew);
//   	hostList.next(tmpPixOld);
   };
};

void SambaClass::deleteHost(Pix tmpPix)
{
   if (tmpPix==hostList.first())
   {
      tmpPix=0;
      hostList.del_after(tmpPix);
   }
   else
   {
      hostList.prev(tmpPix);
      hostList.del_after(tmpPix);
   };   
};

void SambaClass::insertHost(NPC tmp)
{
   Pix tmpPix=hostList.first();
	while ((tmpPix!=0) && (hostList(tmpPix).pc_name<tmp.pc_name)) hostList.next(tmpPix);
   if (tmpPix==0) hostList.append(tmp);
   else hostList.ins_after(tmpPix,tmp);
};

void SambaClass::getNetStatus()
{
//   cout<<"sambaForList: "<<sambaForList<<endl;
   DLList<NPC> tmpList;
   if (sambaForList) getSambaNetList(tmpList);
   else getNSList(tmpList);
   mergeList(tmpList);
};

/*String SambaClass::getIPDirect(const char * target)
{
   if (nsLookup=="") return"";
   String nslook("nslookup ");
   char buf[200];
   nslook+=target;
   nslook+=" ";
   nslook+=nsLookup;
   FILE *f=popen(nslook,"r");
   if (f==0)
   {
      doErrorMess("nslookup");
      return String("nslookup failed");
   };
      //   cout<<"nslookup: "<<nslook<<endl;
   String s;
   do
   {
      fgets(buf,200,f);
      s=buf;
   }
   while ( (!feof(f)) && (s.contains("Address:")==0));//alle zeilen bis incl. "Address:" auslesen

   if (!feof(f))
   do
   {
      fgets(buf,200,f);
      s=buf;
   }
   while ( (!feof(f)) && (s.contains("Address:")==0));//alle zeilen bis incl. "Address:" auslesen

   if (s.contains("Address:")) return String(s.after(RXwhite));
   return String("IP not found");
   pclose(f);
};

void SambaClass::getSambaShares(const char *target, const char *uname=0,const char *pword=0)
{
   Pix tmpPix;
   tmpPix=getTargetPix(target);

   String s("smbclient -L ");
   s+=target;
   if (ipForSamba==1)
   {
      s+=" -I ";
      s+=hostList(tmpPix).ip;
   };
   if (pword==0) s+=" -N ";
   else 
   {
      s+=" -U ";
      s+=uname;
   };
   FILE *f=popen(s,"r");
   if (f==0)
   {
      doErrorMess("smbclient");
      return;
   };
//   cout<<" done."<<endl;

   sharesInf si;
   s="";
   char buf[200];
//   cout<<"suche pc; "<<target<<endl;
//   smbpix=getTargetPix(target);

   String pruef("");
   do
   {
      fgets(buf,200,f);
      s=buf;
      if (s.contains("OS="))
      {
         pruef=s.after("OS=");
         pruef=pruef.before(RXwhite);
         pruef=pruef.at(1,pruef.length()-2);
//         cout<<"OS: "<<pruef<<endl;
         hostList(tmpPix).os=pruef;
      };
*      if (s.contains("Domain="))
      {
         pruef=s.after("Domain=");
         pruef=pruef.before(RXwhite);
         cout<<"Domain: "<<pruef<<endl;
         hostList(smbpix).os=pruef;
      };*
   }
   while ((!feof(f)) &&(s.contains("Sharename")==0));//alle zeilen bis incl. "sharename" auslesen
   
   if (s.contains("Sharename")==1)
   {
      int typePos(s.index("Type"));
      do
      {
         fgets(buf,200,f);
         s=buf;
      }										
      while (s.contains("--")==0);	//alle zeilen bis incl. unterstrich auslesen
      s="";
      do
      {
         if ((s!="") && (s!="IPC$")) 	//sharename rausgefiltert
         {
            si.name=pruef;
            s=buf;
            s=s.after(RXwhite);
            s=s.after(RXwhite);
            s=s.before(RXwhite);
            si.comment=s;
            si.fs=sharesInf::smbfs;
         	hostList(tmpPix).shares.append(si);	//und an liste anhaengen
//            cout<<"pc: "<<hostList(tmpPix).pc_name<<"/"<<s<<endl;
         };
         buf[0]=char(27);
         fgets(buf,200,f);
         s=buf;
         pruef=s.at(0,typePos);
         pruef=pruef.after(RXwhite);
         pruef.reverse();
         pruef=pruef.after(RXwhite);
         pruef.reverse();
         
         s=s.after(RXwhite);
         s=s.before(RXwhite);
      }
      while ((!feof(f)) && (buf[0]!=char(27)) && (s!=""));
   };
   hostList(tmpPix).informed=1;
   pclose(f);
};

void SambaClass::getNFSExports(const char *target)
{
   Pix tmpPix;
   tmpPix=getTargetPix(target);

   FILE *f=popen(String("showmount -e ")+target,"r");
   if (f==0)
   {
      doErrorMess("showmount");
      return;
   };
   sharesInf si;
   String s("");
   char buf[200];
   String pruef("");
   do
   {
      fgets(buf,200,f);
      s=buf;
   }
   while ((!feof(f)) &&(s.contains("Export list")==0));//alle zeilen bis incl. "sharename" auslesen
   
   if (s.contains("Export list")==1)
   {
      s="";
      do
      {
         if (s!="")  	//sharename rausgefiltert
         {
            si.name=s;
            si.comment="";
            si.fs=sharesInf::nfs;
         	hostList(tmpPix).shares.append(si);	//und an liste anhaengen
         };
         buf[0]=char(27);
         fgets(buf,200,f);
         s=buf;
         s=s.before(RXwhite);
      }
      while ((!feof(f)) && (buf[0]!=char(27)));
   };
   hostList(tmpPix).informed=1;
   pclose(f);
};

void SambaClass::getNSList(DLList<NPC>& newList)
{
   int status(0);
   //get the domainname
   FILE *f=popen("domainname -d","r");
   if (f==0)
   {
      doErrorMess("domainname");
      return;
   };
   //get the name list
   char buf[200];
   String domain;
   fgets(buf,200,f);
   domain=buf;
   pclose(f);
   f=0;
   
   domain="echo \"ls "+domain+" \" | nslookup - "+nsLookup;
   f=popen(domain,"r");
   if (f==0)
   {
      doErrorMess("domainname");
      return;
   };

   Pix tmpPix;
   newList.clear();
   
   String s,s2;
   NPC npc_var;
   s="";
   do
	{
      if ((s!="") && (s!="ls") && (s!="localhost") &&  (s[s.length()-1]!='.'))
      {
         npc_var.running=0;
         npc_var.pc_name=upcase(s);
         npc_var.comment="";
         newList.append(npc_var);
      }
      buf[0]=char(27);
      fgets(buf,200,f);
		s=buf;
      s2=s;
		s=s.after(RXwhite);
		s=s.before(RXwhite);
	}
	while ((!feof(f)) && (buf[0]!=char(27)));
   pclose(f);
   
   //now ping'em all
   pid_t pid=fork();
	if (pid==0)
	{
		tmpPix=newList.first();
      int count(0);
		while(tmpPix!=0)
		{
         count++;
         String nextHost=newList(tmpPix).pc_name;
         newList.next(tmpPix);
         //ping
         pid_t pid2=fork();
         if (pid2==0)
         {
            String pingCommand("ping "+nextHost+" -c1 -q > "+String("/tmp/pinging."+nextHost));
//            cout<<pingCommand<<"   "<<count<<endl;
            system(pingCommand);
            exit(0);
         };
      };
      int allPinged(0);
      //wait until all pings finished
      do
		{
			allPinged=0;
			tmpPix=newList.first();
			while(tmpPix!=0)
			{
				if (fNotEmpty(tmpFile+"."+newList(tmpPix).pc_name)==0) allPinged=-1;
				newList.next(tmpPix);
			};
		} while (allPinged==-1);

      exit(0);
	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
	waitpid(pid,&status,0); //datei schreiben lassen

   tmpPix=newList.first();
   while(tmpPix!=0)
	{
      String fname("/tmp/pinging."+newList(tmpPix).pc_name);
		ifstream inf((const char *)fname);
		String s,s2;
		char c;
		do
		{
			inf.get(buf,200,'\n');
			inf.get(c);
         s2=s;
			s=buf;
		}
		while ( !inf.eof());
      if (s2.contains("transmitted")) newList(tmpPix).running=0;
         else
         {
//            cout<<"running: "<<newList(tmpPix).pc_name<<endl;
            newList(tmpPix).running=1;
            
         }
		newList.next(tmpPix);
      inf.close();
      remove(fname);
	};
};

//does a smblist to host own_ip to scan for active hosts
void SambaClass::getSambaNetList(DLList<NPC>& newList)
{
   cout<<"getting netstatus . . . "<<flush;
   newList.clear();
   String s(""),s2("");
   char buf[200];
   FILE *f=popen(command,"r");
   if (f==0)
   {
      doErrorMess("smbclient");
      return;
   };
   cout<<"smbclient running..."<<endl;
   do
   {
      fgets(buf,200,f);
      s=buf;
   }
   while ((!feof(f)) &&(s.contains("browse list")==0));
//   while (s.contains("browse list")==0);

   NPC npc_var;
   if (s.contains("browse list")==1)
   {
      do
      {
         fgets(buf,200,f);
         s=buf;
      }
      while (s.contains("--")==0);

      // read the sharenames
      do
      {
         s="";
         buf[0]=char(27);
         fgets(buf,200,f);
         if (buf[0]!=char(27))
         {
            s=buf;
            s=s.after(RXwhite);
            s2=s;
            s2=s2.after(RXwhite);
            s=s.before(RXwhite);
            cout<<"comment: "<<s2<<"  -"<<s<<"-"<<endl;
            npc_var.running=1;
            npc_var.pc_name=s;
            npc_var.comment=s2;
            newList.append(npc_var);
         };
      }
      while (buf[0]!=char(27) && (s!=""));
   };
   pclose(f);
};*/

void SambaClass::getSambaNetList(DLList<NPC>& newList)
{
   int status(0);

//   cout<<"getting netstatus . . . "<<flush;
   String s(""),s2("");
   char c;
   char buf[200];
   pid_t pid=fork();
   if (pid==0)
   {
      execlp("sh","sh","-c",(const char *)command,0);

		doErrorMess("smbclient");
		exit(1);
   };
   waitpid(pid,&status,0);
//   cout<<"done."<<endl;

//   cout<<"tmpFile: -"<<tmpFile<<"-"<<endl;
   ifstream inf((const char *)tmpFile);   
   newList.clear();
   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
   }
   while ((!inf.eof()) &&(s.contains("browse list")==0));
   NPC npc_var;
   if (s.contains("browse list")==1)
   {
      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
      }
      while (s.contains("--")==0);
      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
         s=s.after(RXwhite);
         s2=s;
         s2=s2.after(RXwhite);
         s=s.before(RXwhite);
//         cout<<"comment: "<<s2<<"  -"<<s<<"-"<<endl;
         npc_var.running=1;
         npc_var.pc_name=s;
         npc_var.comment=s2;
         newList.append(npc_var);                  
      }
      while ((!inf.eof()) && (s!=""));
   };
};

String SambaClass::getIPDirect(const char * target)
{
   if (nsLookup=="") return"";
   String nslook("nslookup ");
   char buf[200];
   nslook+=target;
   nslook+=" ";
   nslook+=nsLookup+" > "+tmpFile;
//   cout<<"nslookup: "<<nslook<<endl;
   system(nslook);

   String s;
   char c;
   ifstream inf((const char *)tmpFile);   
   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
   }
   while ( (!inf.eof()) && (s.contains("Address:")==0));//alle zeilen bis incl. "Address:" auslesen

   if ( (!inf.eof()))
   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
   }
   while ( (!inf.eof()) && (s.contains("Address:")==0));//alle zeilen bis incl. "Address:" auslesen

   if (s.contains("Address:")) return String(s.after(RXwhite));
   return String("IP not found");
};

void SambaClass::getNFSExports(const char *target)
{
   int status(0);
//   cout<<"hier kommt showmount"<<endl;

   Pix tmpPix;
   tmpPix=getTargetPix(target);

//   cout<<"showmount to "<<target<<" . . . "<<flush;
   pid_t pid=fork();
   if (pid==0) 
   {
      String s("showmount -e ");
      s+=target;
//      cout<<"getnfsexports: "<<s<<endl;
      s=s+">"+tmpFile;
      execlp("sh","sh","-c",(const char *)s ,0);

		doErrorMess("showmount");
		exit(1);

   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
   waitpid(pid,&status,0); //datei schreiben lassen
//   cout<<" done."<<endl;

   sharesInf si;
   String s("");
   char buf[200];
   char c;

   ifstream inf((const char *)tmpFile);   
   String pruef("");
   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
   }
   while ((!inf.eof()) &&(s.contains("Export list")==0));//alle zeilen bis incl. "sharename" auslesen
   
   if (s.contains("Export list")==1)
   {

//   	hostList(tmpPix).shares.clear();
      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
         s=s.before(RXwhite);

         if (s!="") 	//sharename rausgefiltert
         {
            si.name=s;
            si.comment="";
            si.fs=sharesInf::nfs;
         	hostList(tmpPix).shares.append(si);	//und an liste anhaengen
//            cout<<"pc: "<<hostList(tmpPix).pc_name<<"/"<<s<<endl;
         };
      }
      while ((!inf.eof()) && (s!=""));
   };
   hostList(tmpPix).informed=1;
};

void SambaClass::getSambaShares(const char *target, const char *uname=0,const char *pword=0)
{
   Pix tmpPix;
   int status=0;
   tmpPix=getTargetPix(target);

//   cout<<"smbclient to "<<target<<" . . . "<<flush;
   pid_t pid=fork();
   if (pid==0) 
   {
      String s("smbclient -L ");
      s+=target;
      if (ipForSamba==1)
      {
         s+=" -I ";
         s+=hostList(tmpPix).ip;
      };
      if (pword==0) s+=" -N ";
      else 
      {
         s+=" -U ";
         s+=uname;
      };
//      cout<<"getpcstatus: "<<s<<endl;
      s=s+">"+tmpFile;
      execlp("sh","sh","-c",(const char *)s ,0);

		doErrorMess("smbclient");
		exit(1);

   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
   waitpid(pid,&status,0); //datei schreiben lassen
//   cout<<" done."<<endl;

   sharesInf si;
   String s("");
   char buf[200];
   char c;
//   cout<<"suche pc; "<<target<<endl;
//   smbpix=getTargetPix(target);

   ifstream inf((const char *)tmpFile);   
   String pruef("");
   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
      if (s.contains("OS="))
      {
         pruef=s.after("OS=");
         pruef=pruef.before(RXwhite);
         pruef=pruef.at(1,pruef.length()-2);
//         cout<<"OS: "<<pruef<<endl;
         hostList(tmpPix).os=pruef;
      };
//      if (s.contains("Domain="))
//      {
//         pruef=s.after("Domain=");
//         pruef=pruef.before(RXwhite);
//         cout<<"Domain: "<<pruef<<endl;
//         hostList(smbpix).os=pruef;
//      };*
   }
   while ((!inf.eof()) &&(s.contains("Sharename")==0));//alle zeilen bis incl. "sharename" auslesen
   
   if (s.contains("Sharename")==1)
   {
      int typePos(s.index("Type"));
      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
      }										
      while (s.contains("--")==0);	//alle zeilen bis incl. unterstrich auslesen

      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
         pruef=s.at(0,typePos);
         pruef=pruef.after(RXwhite);
         pruef.reverse();
         pruef=pruef.after(RXwhite);
         pruef.reverse();
         
         s=s.after(RXwhite);
         s=s.before(RXwhite);
         if ((s!="") && (s!="IPC$")) 	//sharename rausgefiltert
         {
            si.name=pruef;
            s=buf;
            s=s.after(RXwhite);
            s=s.after(RXwhite);
            s=s.before(RXwhite);
            si.comment=s;
            si.fs=sharesInf::smbfs;
         	hostList(tmpPix).shares.append(si);	//und an liste anhaengen
//            cout<<"pc: "<<hostList(tmpPix).pc_name<<"/"<<s<<endl;
         };
      }
      while ((!inf.eof()) && (s!=""));
   };
   hostList(tmpPix).informed=1;
};

void SambaClass::getNSList(DLList<NPC>& newList)
{
   String domain("domainname -d > ");
   int status;
   char buf[200];
   domain+=tmpFile;
//   cout<<"domain: "<<domain<<endl;
   system(domain);
   
   ifstream infDomain((const char *)tmpFile);   
   infDomain.get(buf,200,'\n');
   domain=buf;
   
   domain="echo \"ls "+domain+" > "+tmpFile+" \" | nslookup - "+nsLookup;
   system(domain);
   
	Pix tmpPix;
   newList.clear();
   
   ifstream inf((const char *)tmpFile);   
   String s,s2;
   char c;
   NPC npc_var;
   do
	{
		inf.get(buf,200,'\n');
		inf.get(c);
		s2=buf;
      s=s2;
		s=s.after(RXwhite);
		s=s.before(RXwhite);
      if ((s!="") && (s!="ls") && (s!="localhost") &&  (s[s.length()-1]!='.'))
      {
         npc_var.running=0;
         npc_var.pc_name=upcase(s);
         npc_var.comment="";
         newList.append(npc_var);
      }
	}
	while ((!inf.eof()) && (s2!=""));

   pid_t pid=fork();
	if (pid==0)
	{
		tmpPix=newList.first();
      int count(0);
		while(tmpPix!=0)
		{
         count++;
         String nextHost=newList(tmpPix).pc_name;
			newList.next(tmpPix);
         
         pid_t pid2=fork();
         if (pid2==0)
         {
            String pingCommand("ping "+nextHost+" -c1 -q > "+String(tmpFile+"."+nextHost));
//            cout<<pingCommand<<"   "<<count<<endl;
            system(pingCommand);
            exit(0);
         };
		};
      int allPinged(0);
      do
		{
			allPinged=0;
			tmpPix=newList.first();
			while(tmpPix!=0)
			{
				if (fNotEmpty(tmpFile+"."+newList(tmpPix).pc_name)==0) allPinged=-1;
				newList.next(tmpPix);
			};
		} while (allPinged==-1);

      exit(0);
	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
	waitpid(pid,&status,0); //datei schreiben lassen

   tmpPix=newList.first();
   while(tmpPix!=0)
	{
      String fname(tmpFile+"."+newList(tmpPix).pc_name);
		ifstream inf((const char *)fname);
		String s,s2;
		char c;
		do
		{
			inf.get(buf,200,'\n');
			inf.get(c);
         s2=s;
			s=buf;
		}
		while ( !inf.eof());
      if (s2.contains("transmitted")) newList(tmpPix).running=0;
         else
         {
//            cout<<"running: "<<newList(tmpPix).pc_name<<endl;
            newList(tmpPix).running=1;
            
         }
		newList.next(tmpPix);
      inf.close();
      remove(fname);
	};
};

