#include "qsambaclass.h"

void getListFromCBox(QStrList& list,const QComboBox * box)
{
   list.clear();
   if (box==0) return;
   if (box->currentText()!="")
   {
      if (box->count()==0) list.append(box->currentText());
      else if (String(box->text(0))!=box->currentText()) list.append(box->currentText());
   };
   for (int i=0;i<box->count();i++) list.append(box->text(i));
   return;
};

QNamePass::QNamePass(const QStrList *users,QWidget *parent)
   :QFrame(parent)
   ,cb1("&Use name and password for mounting",this)
   ,nameCb(TRUE,this)
   ,passLe(this)
{
   setFrameStyle(QFrame::Sunken|QFrame::Box);
   resize(315,125);
   
   cb1.setGeometry(5,5,295,25);

   nameCb.setMaxCount(20);
   nameCb.insertStrList(users);
   nameCb.setGeometry(130,35,175,30);
   nameCb.setEnabled(FALSE);

   passLe.setGeometry(130,80,175,30);
   passLe.setEnabled(FALSE);
   passLe.setEchoMode(QLineEdit::Password);

   String sx("Enter &name:");
   QLabel *text=new QLabel(&nameCb,sx,this);
   text->move(20,35);

   sx="Enter pass&word:";
   text=new QLabel(&passLe,sx,this);
   text->move(20,80);

   connect(&cb1,SIGNAL(toggled(bool)),&nameCb,SLOT(setEnabled(bool)));
   connect(&cb1,SIGNAL(toggled(bool)),&passLe,SLOT(setEnabled(bool)));
};

QSambaStatsDlg::QSambaStatsDlg(QSambaClass *sambaParent,QWidget *parent,const char *name,bool modal)
   :QDialogX(parent,name,modal)
   ,smbParent(sambaParent)
   ,liste(this)
   ,closeButton("&Close",this)
   ,updateButton("&Update",this)
{
   setCaption(smbParent->myName+": Samba status");
   resize(470,260);
   setFixedSize(size());
   String s("");
   QLabel *text;

   s="Status of Samba connections:";
   text=new QLabel(s,this);
	text->setFont( QFont( "Helvetica", 12, QFont::Bold ) );
   text->setGeometry(10,10,450,20);

   s="Share:        User:    Group:     Machine:   Since:";
   text=new QLabel(s,this);
	text->setFont( QFont( "Courier", 12, QFont::Normal ) );
   text->setGeometry(10,40,450,20);

   updateButton.move(10,220);
   closeButton.move(360,220);
	liste.setFont( QFont( "Courier", 12, QFont::Normal ) );
   liste.setGeometry(10,60,450,150);

   connect(&updateButton,SIGNAL(clicked()),this,SLOT(updateStatus()));
   connect(&closeButton,SIGNAL(clicked()),this,SLOT(hide()));
};

void QSambaStatsDlg::updateStatus()
{
   liste.clear();
   int status=0;
   cout<<"Getting samba state . . .   "<<flush;
   pid_t pid=fork();
   if (pid==0) 
   {
      cout<<"parent->tmpFile: -"<<smbParent->tmpFile<<"-"<<endl;
      String s("smbstatus >");
      s+=smbParent->tmpFile;
      execlp("sh","sh","-c",(const char *)s ,0);
		smbParent->doErrorMess("smbstatus");
		exit(1);
   };   

   if (pid<0) cout<<"fork or sh not found, \ncheck "<<smbParent->myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
   waitpid(pid,&status,0);
   cout<<"done."<<endl;

//   wait(&status);		//datei schreiben lassen

   String s(""),sBeg(""),sEnd("");
   char buf[200];
   char c;
   ifstream inf((const char *)smbParent->tmpFile);   

   do
   {
      inf.get(buf,200,'\n');
      inf.get(c);
      s=buf;
   }
   while ((!inf.eof()) &&(s.contains("---")==0));	//alle zeilen bis incl. "---" auslesen

   if (s.contains("---")==1)
   {
      do
      {
      	inf.get(buf,200,'\n');
         inf.get(c);
         s=buf;
         sBeg=s.before(RXwhite);		//share
         s=s.after(RXidentifier);
         sBeg+=s.before(RXidentifier);
         s=s.after(RXwhite);

         sBeg+=s.before(RXwhite);	//user
         s=s.after(RXidentifier);
         sBeg+=s.before(RXidentifier);
         s=s.after(RXwhite);

         sBeg+=s.before(RXwhite);	//group
         s=s.after(RXidentifier);
         sBeg+=s.before(RXint);		//before pid
         s=s.after(RXwhite);

         s=s.after(RXwhite);			//after pid

         sBeg+=s.before(RXwhite);
         s=s.after(RXidentifier);
         sBeg+=s.before("(");
         s=s.after(")");
         s=s.after(RXint);
         s=s.after(RXwhite);
         s=s.before(RXwhite);
         if (s!="") 
         {
            s=sBeg+"  "+s;
            liste.insertItem((const char *)s);
         };
      }
      while ((!inf.eof()) && (s!=""));
   };
   update();
};

void QSambaStatsDlg::show()
{
   cout<<"updating..."<<endl;
   updateStatus();
   QDialogX::show();
};

QSambaSharesList::QSambaSharesList(QSambaClass *sambaParent,QWidget *parent,const char *target,const char *name,bool smbfs, bool nfs)
      	:QWidget(parent,name)
         ,showSMBFS(smbfs)
         ,showNFS(nfs)
         ,tgt(target)
         ,smbParent(sambaParent)
         ,liste(this)
         ,cb("Show &hidden shares",this)

{
   cb.resize(200,20);
   
   liste.move(5,5);

   resize(150,60);
   setMinimumSize(size());

   connect(&cb,SIGNAL(toggled(bool)),this,SLOT(showShares(bool)));
   showShares(FALSE);
};

void QSambaSharesList::showShares(bool showHidden)
{
   Pix targetpix=smbParent->getTargetPix(tgt);
   if (targetpix==0)
   {
      QMessageBox::warning(this,"Host not found","Host not found, action failed\nStay cool, think it must have been a bug");
      return;
   };

   smbParent->getPCStatus(tgt);
   Pix sharepix=smbParent->hostList(targetpix).shares.first();
   String checkHidden("");
   liste.clear();


   while (sharepix!=0)			//s2 = mountpoint; s = sharename
   {
      checkHidden=smbParent->hostList(targetpix).shares(sharepix).name;

//      if ((checkHidden[checkHidden.length()-1]=='$')&& (showHidden==FALSE)); else
      if ((checkHidden[checkHidden.length()-1]!='$')|| (showHidden==TRUE))

      {      
         if ( ( (smbParent->hostList(targetpix).shares(sharepix).fs==sharesInf::nfs) && (showNFS==TRUE)) ||
         ((smbParent->hostList(targetpix).shares(sharepix).fs==sharesInf::smbfs) && (showSMBFS==TRUE)))
         {
            checkHidden+="   #"+smbParent->hostList(targetpix).shares(sharepix).comment+"   (type: ";
            if (smbParent->hostList(targetpix).shares(sharepix).fs==sharesInf::smbfs) checkHidden+="smbfs)";
            else checkHidden+="nfs)";
            liste.insertItem(checkHidden);
         };
//      if ((checkHidden[0]=='$') && (showHidden==FALSE)); else liste.insertItem(checkHidden);
   	};
      smbParent->hostList(targetpix).shares.next(sharepix);   
   };
/*   while (sharepix!=0)
   {
      checkHidden=smbParent->hostList(targetpix).sha(sharepix).name+"   #"+smbParent->hostList(targetpix).sha(sharepix).comment;
      if ((checkHidden[checkHidden.length()-1]=='$') && (showHidden==FALSE)); else liste.insertItem(checkHidden);

      smbParent->hostList(targetpix).sha.next(sharepix);   
   };*/
};

void QSambaSharesList::resizeEvent(QResizeEvent *)
{
   cb.move(5,height()-20);
   liste.resize(width()-10,height()-30);
};

void QSambaSharesList::setTarget(const char *target)
{
   tgt=target;
};

