//xterm -e sh -c '(smbclient -L alex2_pc;sh)'

#ifndef QSAMBACLASS_H
#define QSAMBACLASS_H

#include "sambaclass.h"

#include <qwidget.h>
#include <qpushbt.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include <qlined.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qmsgbox.h>
#include <qradiobt.h>
#include <qbttngrp.h>
#include <qchkbox.h>
#include <qapp.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qstrlist.h>

#include <dirent.h>
#include <sys/types.h>
#include <signal.h>

#include "../qplus/qplus.h"
#include "../utils/mytypes.h"

class QSambaClass;

class QSambaSharesList:public QWidget
{
   Q_OBJECT
   public:
      QSambaSharesList(QSambaClass *sambaParent,QWidget *parent=0,const char *target=0,const char *name=0,bool smbfs=TRUE, bool nfs=TRUE);
      void setTarget(const char *target);
      const char* text(int index)	{return liste.text(index);};
      uint count() 						{return liste.count();};
      bool isSelected(int index)		{return liste.isSelected(index);};
      void setMultiSelection(bool mode)	{liste.setMultiSelection(mode);};
      bool isMultiSelection()			{return liste.isMultiSelection();};
      int currentItem()					{return liste.currentItem();};
      bool showSMBFS,showNFS;
   protected:
      String tgt;
      QSambaClass *smbParent;
      QListBox liste;
      QCheckBox cb;
      virtual void resizeEvent(QResizeEvent *);
   public slots:
      void setNFS(bool show)			{showNFS=show;};
      void setSMBFS(bool show)		{showSMBFS=show;};
   protected slots:
      void showShares(bool showHidden);
};

void getListFromCBox(QStrList& list,const QComboBox * box);

class QNamePass:public QFrame
{
   Q_OBJECT
public:
   QNamePass(const QStrList *users,QWidget *parent=0);
protected:
   QCheckBox cb1;
   QComboBox nameCb;
   QLineEdit passLe;
public:
   const char * userName() {return nameCb.currentText();};
   const char * password() {return passLe.text();};
   const QComboBox * getBox() {return &nameCb;};
   bool usePW() {return cb1.isChecked();};
};

class QSambaStatsDlg:public QDialogX
{
   Q_OBJECT
   public:
      QSambaStatsDlg(QSambaClass *sambaParent,QWidget *parent=0,const char *name=0,bool modal=FALSE);
   protected:
      QSambaClass *smbParent;
      QListBox liste;
      QPushButton closeButton, updateButton;
   public slots:
      void updateStatus();
      virtual void show();
};

class QSambaClass:public QWidget,public SambaClass
{
   Q_OBJECT
   friend QSambaStatsDlg;
   friend QSambaSharesList;
   public:
      QSambaClass(const char * config,const char *selfName);
      virtual ~QSambaClass();
      DLList<QPushButtonX*> button_liste;
      QTimer timer;

      QPushButton statusButton;//,serverPing,refrButton;
      QPushButtonX aboutButton;
      QPushButton exitButton;

      QPopupMenu menu,sysMenu;
      int currentUser;
      void doUnmountAll(int i=-1);
      void procSigUsr1(int);
      void startUp();
      virtual bool adjustSettings();
   public slots:
      void refresh();
      void showMenu(int count);
      void procMenu(int id);
      void procSysMenu(int id);
//      void readConfigS();
   protected:
		QSambaStatsDlg *statsDlg;
      QStrList hostHist,userHist;
      String currentTarget;
      const char * getCurrentUserName();
      String getName(const char* text,const char *target);
      int getNamePass(String &name, String &pass,const char* text,const char * btextp, const char *btexto, const char *target);
      int getHost(String& target,const char * mess);
      int getUserHost(String& target,String& user,const char * mess);

      void execRLogin(const char *target, const char *user);
      void execTelnet(const char *target, const char *user);
      void execTalk(const char *target, const char *user);
      void readConfig();

//      String getShareToConnect(const char *target);
   protected slots:
   	void doSystemMenu();
      void doExploreHost(const char * target);
      bool doSMBMount(const char * target);
      void manualSMBMount();
      void manualSMBClient();
      void manualSMBList();
      void doUnmount(const char * target);
      void doSMBClient(const char * target);
      void doSMBList(const char * target);
      void doRLogin(const char * target);
      void doTelnet(const char * target);
      void doTalk(const char * target);
      void doFinger(const char * target);
      void doShowInfo(const char *target);
      void doPing(const char * target);


      void doPing();
      void doPingServer();
      virtual void doAboutDialog();
      void doQuickExploreHost(int i);

   signals:
      void quit();
      void configRead();
};

#endif
