#include "qsambaclass.h"

/*!
constructor
*/
#include <iostream.h>
QSambaClass::QSambaClass(const char *config,const char *selfName)
   :QWidget(0,"main")
   ,SambaClass(config,selfName)
   ,button_liste()
   ,timer(this)
   ,statusButton("&Status",this)
   ,aboutButton("&More",this)
   ,exitButton("E&xit",this)
   ,menu(0,"menu")
   ,sysMenu(0)
   ,currentUser(0)
	,statsDlg(0)
   ,hostHist(TRUE)
   ,userHist(TRUE)
   ,currentTarget()
{
   signal(SIGHUP,&QApplication::exit);
   signal(SIGINT,&QApplication::exit);
	signal(SIGQUIT,&QApplication::exit);
	signal(SIGILL,&QApplication::exit);
	signal(SIGABRT,&QApplication::exit);
	signal(SIGSEGV,&QApplication::exit);
	signal(SIGPIPE,&QApplication::exit);
	signal(SIGTERM,&QApplication::exit);

   statsDlg=new QSambaStatsDlg(this,0);

   menu.insertItem("Explore host");
   menu.insertItem("Mount");
   menu.insertItem("UnMount");
   menu.insertItem("SMBClient");
   menu.insertItem("SMBList");
   menu.insertItem("RLogin");
   menu.insertItem("Talk");
   menu.insertItem("Telnet");
   menu.insertItem("Finger");
   menu.insertItem("Ping");
   menu.insertItem("Info");
	menu.setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );

   sysMenu.insertItem("Mount share");
   sysMenu.insertItem("SMBClient");
   sysMenu.insertItem("SMBList");
   sysMenu.insertItem("RLogin");
   sysMenu.insertItem("Talk");
   sysMenu.insertItem("Telnet");
   sysMenu.insertItem("Finger");
   sysMenu.insertItem("Ping");
   sysMenu.insertItem("Get IP address");
   sysMenu.insertSeparator();
   sysMenu.insertItem("Configure");
   sysMenu.insertItem("Refresh");
   sysMenu.insertItem("Ping Nameserver");
   sysMenu.insertItem("About");
	sysMenu.setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );
   connect(&sysMenu,SIGNAL(activated(int)),this,SLOT(procSysMenu(int)));

   connect(&menu,SIGNAL(activated(int)),this,SLOT(procMenu(int)));
   connect(&exitButton,SIGNAL(clicked()),this,SIGNAL(quit()));
   connect(&statusButton,SIGNAL(clicked()),statsDlg,SLOT(show()));

   connect(&aboutButton,SIGNAL(clicked()),this,SLOT(doSystemMenu()));
   connect(&aboutButton,SIGNAL(rightClicked()),this,SLOT(doSystemMenu()));

   connect(this,SIGNAL(configRead()),this,SLOT(refresh()));
   connect(this,SIGNAL(configRead()),statsDlg,SLOT(updateStatus()));
};

QSambaClass::~QSambaClass()
{
   if (unmountOnExit) doUnmountAll();
};

bool QSambaClass::adjustSettings()
{
   return TRUE;
};

void QSambaClass::startUp()
{
   readConfig();
   if (refreshTime>0)
   {
      cout<<"starting timer: "<<refreshTime<<endl;
      timer.start(refreshTime*1000);
      connect(&timer,SIGNAL(timeout()),this,SLOT(refresh()));
      connect(&timer,SIGNAL(timeout()),statsDlg,SLOT(updateStatus()));
   }; 
   userHist.append(stdUser);
};

void QSambaClass::readConfig()
{
   readConfigCore();

   exitButton.setGeometry(0,height()-(fontSize*2),fontSize*10,fontSize*2);
   aboutButton.setGeometry(0,height()-(fontSize*4),fontSize*10,fontSize*2);
   statusButton.setGeometry(0,height()-(fontSize*6),fontSize*10,fontSize*2);
   setFixedSize(fontSize*10,fontSize*6);
	exitButton.setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );
	aboutButton.setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );
	statusButton.setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );
   resize(size());
   emit configRead();
};

void QSambaClass::showMenu(int i)
{
   currentUser=i;
   menu.popup(QCursor::pos());
};

int QSambaClass::getNamePass(String &name, String &pass,const char* text,const char* btextp, const char *btexto,const char *target)
{
   QDialogX diag(0,"dialog",TRUE);
   diag.resize(310,180);
   QLabel label(text,&diag);
   label.move(20,20);
   QLabel label2("Enter password",&diag);
   label2.move(20,60);

   QComboBox uName(TRUE,&diag);
   uName.setMaxCount(20);
   uName.insertStrList(&userHist);
   uName.setGeometry(130,20,120,30);
   uName.setFocus();

   QLineEdit pWord(&diag);
   pWord.setGeometry(130,60,120,30);
   pWord.setEchoMode(QLineEdit::NoEcho);
   
   QPushButtonX okP(btextp,&diag);
   okP.setGeometry(10,100,140,30);
   okP.setValue(0);
   QPushButtonX ok(btexto,&diag);
   ok.setGeometry(160,100,140,30);
   ok.setValue(1);
   QPushButton pingB("&Ping",&diag);
   pingB.setGeometry(10,140,140,30);
   QPushButtonX esc("&Cancel",&diag);
   esc.setGeometry(160,140,140,30);
   esc.setValue(2);

   currentTarget=target;
   connect(&ok,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));
   connect(&okP,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));
   connect(&esc,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));
   connect(&pingB,SIGNAL(clicked()),this,SLOT(doPing()));

   int erg=diag.exec();
   if (erg==0)
   {
      name=uName.currentText();
      pass=pWord.text();
   };

   getListFromCBox(userHist,&uName);

   return erg;
};

/*!
   executes a dialogbox which asks for usually for your user name and
   returns it
*/
String QSambaClass::getName(const char* text,const char *target)
{
   QDialogX diag(0,"dialog",TRUE);
   diag.resize(310,120);
   QLabel label(text,&diag);
   label.move(20,20);

   QComboBox uName(TRUE,&diag);
   uName.setMaxCount(20);
   uName.insertStrList(&userHist);
   uName.move(120,20);
   uName.setFocus();

   QPushButton pingB("&Ping",&diag);
   pingB.setGeometry(10,70,90,30);
   QPushButton ok("&Ok",&diag);
   ok.setGeometry(110,70,90,30);
   QPushButton esc("&Cancel",&diag);
   esc.setGeometry(210,70,90,30);
   currentTarget=target;

   connect(&ok,SIGNAL(clicked()),&diag,SLOT(accept()));
   connect(&esc,SIGNAL(clicked()),&diag,SLOT(reject()));
   connect(&pingB,SIGNAL(clicked()),this,SLOT(doPing()));
   
   int erg=diag.exec();

   getListFromCBox(userHist,&uName);

   if (erg==1) return uName.currentText();	//ok
   else return "";
};

int QSambaClass::getUserHost(String& target,String& user,const char * mess)
{
   QDialogX diag(0,"dialog",TRUE);
   diag.resize(310,140);
   QLabel label(mess,&diag);
   label.move(20,20);
   QLabel label2("On host:",&diag);
   label2.move(20,60);

   QComboBox uName(TRUE,&diag);
   uName.setMaxCount(20);
   uName.insertStrList(&userHist);
   uName.setGeometry(130,20,120,30);
   uName.setFocus();

   QComboBox host(TRUE,&diag);
   host.setMaxCount(20);
   host.insertStrList(&hostHist);
   host.setGeometry(130,60,120,30);
   
   QPushButtonX ok("&Ok",&diag);
   ok.setGeometry(10,100,140,30);
   ok.setValue(0);
   QPushButtonX esc("&Cancel",&diag);
   esc.setGeometry(160,100,140,30);
   esc.setValue(2);

//   currentTarget=target;
   connect(&ok,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));
   connect(&esc,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));

   int erg=diag.exec();

   getListFromCBox(userHist,&uName);
   getListFromCBox(hostHist,&host);

   if (erg==0)
   {
      target=host.currentText();
      user=uName.currentText();
   };

   return erg;
};

int QSambaClass::getHost(String& target,const char* mess)
{
   QDialogX diag(0,"dialog",TRUE);
   diag.resize(310,100);
   QLabel label(mess,&diag);
   label.setGeometry(20,20,130,30);

   QComboBox host(TRUE,&diag);
   host.setMaxCount(20);
   host.insertStrList(&hostHist);
   host.setGeometry(160,20,120,30);
   host.setFocus();
   
   QPushButtonX ok("&Ok",&diag);
   ok.setGeometry(10,60,140,30);
   ok.setValue(0);
   QPushButtonX esc("&Cancel",&diag);
   esc.setGeometry(160,60,140,30);
   esc.setValue(2);

   connect(&ok,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));
   connect(&esc,SIGNAL(valueClicked(int)),&diag,SLOT(done(int)));

   int erg=diag.exec();
   if (erg==0) target=host.currentText();

   getListFromCBox(hostHist,&host);

   return erg;
};

void QSambaClass::doRLogin(const char * target)
{
   String uname=getName("Enter login name:",target);
   cout<<"rlogin as: "<<uname<<endl;
   if (uname!="")
   execRLogin(target,(const char*) uname);
};

void QSambaClass::execTelnet(const char *target, const char *user)
{
	int pid=fork();
	if (pid==0)
	{
		String s("telnet -l ");
		String titel(myName+": telnet: ");
		String tname(user);
		s+=tname;
		s+=" ";
		s+=target;
		titel+=tname;
		titel+=" on ";
		titel+=target;

		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char*)((const char*)titel);
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);
		doErrorMess("telnet");
		exit(1);

	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
	cout<<"telnet"<<endl;
};

void QSambaClass::execRLogin(const char *target, const char *user)
{
	int pid=fork();
	if (pid==0)
	{
		String s("rlogin -l ");
      String uname(user);
		s=s+uname+" "+target;
		uname=String(myName+": Logged in as ")+uname+" on "+target;

		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char*)((const char*)uname);
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);

		doErrorMess("rlogin");
		exit(1);
	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};

void QSambaClass::execTalk(const char *target, const char *user)
{
	int pid=fork();
	if (pid==0)
	{
		String tname(user);
      tname+="@";
		tname+=target;
		if (talkCommand=="standard")
		{
			String s("talk ");
			s=s+tname;
			String titel(myName+": Talking to ");
			titel=titel+tname;


			char *argtest[20];
			argtest[0]=(char*)((const char*)shell);
			argtest[1]="-title";
			argtest[2]=(char*)((const char*)titel);
			int extraOpts(0);
			while (shellOpts[extraOpts]!="")
			{
				argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
				extraOpts++;
			};
			argtest[extraOpts+3]="-e";
			argtest[extraOpts+4]="sh";
			argtest[extraOpts+5]="-c";
			argtest[extraOpts+6]=(char*)((const char*)s);
			argtest[extraOpts+7]=0;
			execvp((const char*)shell,argtest);
		}
		else
		{
			cout<<"talkCommand: "<<talkCommand<<endl;
			execlp((const char*)talkCommand,(const char *)talkCommand,(const char *)tname,0);
		};
		doErrorMess("talk");
		exit(1);

	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};


void QSambaClass::doTalk(const char * target)
{
	String tname=getName("Talk to:",target);
	if (tname!="")
   execTalk(target,tname);
};

void QSambaClass::doQuickExploreHost(int i)
{
   currentUser=i;
   doExploreHost(getCurrentUserName());
};

void QSambaClass::doExploreHost(const char * target)
{
   Pix smbpix=getTargetPix(target);
   bool mountingSucceded(TRUE);
   if (hostList(smbpix).mounted==0) mountingSucceded=doSMBMount(target);
   if (mountingSucceded==FALSE) return;

	int pid=fork();
	if (pid==0)
	{
      String tmpString("");

   	char *argtest[20];
      argtest[0]= (char*)((const char*)fManager[0]);

      int fManOpts(1);
      while (fManager[fManOpts]!="")
      {
         if (fManager[fManOpts]=="%dir")
         {
            tmpString=smbMountPath+"/"+target;
            argtest[fManOpts]=(char*) ((const char*)tmpString);
         }
         else argtest[fManOpts]=(char*) ((const char*)fManager[fManOpts]);
         fManOpts++;
      };

      argtest[fManOpts]=0;

   	execvp((const char*)fManager[0],argtest);

      doErrorMess("%filemanager");
      exit(1);

	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};


/*!
pings the host currentTarget, which is set by some functions
like doSMBmount
*/
void QSambaClass::doPing()
{
   doPing((const char*)currentTarget);
};

/*!
displays an about-messagebox
*/
void QSambaClass::doAboutDialog()
{
   QMessageBoxX mb(0,"mess");
	mb.setFont( QFont( "Helvetica", 12, QFont::Bold ) );
   mb.setIcon(QMessageBox::Information);
   mb.setMouseCatching(TRUE);
   mb.setText("QNetMon 0.90beta by Alexander Neundorf\nBug reports, comments,... to alexander.neundorf@rz.tu-ilmenau.de\nNewest versions under http://www.rz.tu-ilmenau.de/~lekus/software.htm\n\nThis program is free available under the terms of the GNU General Public License\n\nCreated using Qt 1.4 by Troll Tech http://www.troll.no");
   mb.exec();
};

/*!
pings the nameserver
*/
void QSambaClass::doPingServer()
{
   doPing(nsLookup);
};

/*!
opens a xterm and does an eternal ping to host target
*/
void QSambaClass::doPing(const char * target)
{
	int pid=fork();
	if (pid==0)
	{
		String titel(myName+": Pinging ");
		titel=titel+target;
		titel=titel+" . . .";

   	char *argtest[20];
      argtest[0]=(char*)((const char*)shell);
      argtest[1]="-title";
      argtest[2]=(char*)((const char*)titel);
      int extraOpts(0);
      while (shellOpts[extraOpts]!="")
      {
      	argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
         extraOpts++;
      };
      argtest[extraOpts+3]="-e";
      argtest[extraOpts+4]="ping";
      argtest[extraOpts+5]=(char*)target;
      argtest[extraOpts+6]=0;
   	execvp((const char*)shell,argtest);

      doErrorMess("ping");
      exit(1);

	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};

/*!
opens a xterm and does an eternal ping to host target
*/
void QSambaClass::doFinger(const char * target)
{
	int pid=fork();
	if (pid==0)
	{
		String titel(myName+": Finger at ");
		titel=titel+target;
		titel=titel+" . . .";

   	char *argtest[20];
      argtest[0]=(char*)((const char*)shell);
      argtest[1]="-title";
      argtest[2]=(char*)((const char*)titel);
      int extraOpts(0);
      while (shellOpts[extraOpts]!="")
      {
      	argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
         extraOpts++;
      };
      argtest[extraOpts+3]="-e";
      argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";

      String s("finger");
      s+= " @";
      s+=target;
      s+="|less";
      argtest[extraOpts+6]=(char *)(const char *)s;
      argtest[extraOpts+7]=0;
   	execvp((const char*)shell,argtest);

      doErrorMess("finger");
      exit(1);

	};
	if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};

/*!
starts a xterm to execute telnet to host target
*/
void QSambaClass::doTelnet(const char * target)
{
	String tname=getName("Enter login name:",target);
	if (tname!="")
   execTelnet(target,(const char *)tname);
};

void QSambaClass::manualSMBMount()
{
   QDialogX dlg(0,"dialog",TRUE);
   dlg.resize(340,335);

   QLabel *text;

   String sx("Mount share:");
   text=new QLabel(sx,&dlg);
   text->setGeometry(20,20,100,30);

   QLineEdit sharele(&dlg);
   sharele.setGeometry(160,20,165,30);
//   sharele.setText((const char*)stdUser);
   sharele.setFocus();

   sx="Mount share from host:";
   text=new QLabel(sx,&dlg);
   text->setGeometry(20,65,135,30);

   QComboBox hostle(TRUE,&dlg);
   hostle.setMaxCount(20);
   hostle.insertStrList(&hostHist);
   hostle.setGeometry(160,65,165,30);

   QButtonGroup bgroup(&dlg);
   bgroup.setGeometry(10,115,315,30);
   sx="Select filesystem:";
   text=new QLabel(sx,&bgroup);
   text->setGeometry(20,5,100,20);

   QRadioButton smbfsRb("Smb (Windows)",&bgroup),nfsRb("NFS",&bgroup);
   smbfsRb.setGeometry(130,8,120,15);
   smbfsRb.setChecked(TRUE);
   nfsRb.setGeometry(250,8,50,15);

   QNamePass qnp(&userHist,&dlg);
   qnp.move(10,160);

   QPushButton mountButton("&Mount",&dlg);
   mountButton.move(10,295);

   QPushButton cancelButton("&Cancel",&dlg);
   cancelButton.move(230,295);

   connect(&mountButton,SIGNAL(clicked()),&dlg,SLOT(accept()));
   connect(&cancelButton,SIGNAL(clicked()),&dlg,SLOT(reject()));

   int dlgerg=dlg.exec();
   if (dlgerg==QDialog::Rejected) return;

   getListFromCBox(userHist,qnp.getBox());
   getListFromCBox(hostHist,&hostle);

   String hostStr(hostle.currentText());
   hostStr.upcase();
   String shareStr(sharele.text());

   if (nfsRb.isChecked())
	{
		String sn(hostStr);
		sn+=":/";
		sn+=shareStr;

		String s2n(smbMountPath);
		makeDir((const char *)s2n);
		s2n+=String("/")+hostStr;
		makeDir((const char*)s2n);
		s2n+=String("/")+shareStr;
		makeDir((const char *)s2n);

		cout<<smbMountPath<<endl;
		cout<<s2n<<endl;
		cout<<sn<<endl;

		int pid2n=fork();
		if (pid2n==0)
		{
			if (qnp.usePW()) execlp("smbmount","smbmount",(const char *)sn,(const char*)s2n,"-U",qnp.userName(),"-P",qnp.password(),0);
			else execlp("mount","mount",(const char *)sn,(const char*)s2n,"-t","nfs",0);

			doErrorMess("smbmount");
			exit(1);
		};
		return;
	};

   Pix smbpix=getTargetPix((const char *)hostStr);
   if (smbpix==0)
   {
      cout<<"adding to list: "<<hostStr<<endl;
      NPC npc_var;
      npc_var.pc_name=hostStr;
      npc_var.comment="";
      npc_var.mounted=1;
      hostList.append(npc_var);                  
   } 
   else hostList(smbpix).mounted=1;

   String s("//");
   s+=hostStr;
   s+="/";
   s+=shareStr;

   String s2(smbMountPath);
 	makeDir((const char *)s2);
   s2+=String("/")+hostStr;
   makeDir((const char*)s2);
   s2+=String("/")+shareStr;
   makeDir((const char *)s2);

   cout<<smbMountPath<<endl;
   cout<<s2<<endl;
   cout<<s<<endl;

	int pid2=fork();
	if (pid2==0)
	{
		if (qnp.usePW()) execlp("smbmount","smbmount",(const char *)s,(const char*)s2,"-U",qnp.userName(),"-P",qnp.password(),0);
		else execlp("smbmount","smbmount",(const char *)s,(const char*)s2,"-n",0);

      doErrorMess("smbmount");
      exit(1);
	};

   return;
};

void QSambaClass::manualSMBClient()
{
   QDialogX dlg(0,"dialog",TRUE);
   dlg.resize(340,310);

   QLabel *text;

   String sx("Name of share:");
   text=new QLabel(sx,&dlg);
   text->setGeometry(20,20,120,30);

   QLineEdit sharele(&dlg);
   sharele.setGeometry(150,20,175,30);
   sharele.setFocus();

   sx="Connect to host:";
   text=new QLabel(sx,&dlg);
   text->setGeometry(20,65,120,30);

   QComboBox hostle(TRUE,&dlg);
   hostle.setMaxCount(20);
   hostle.insertStrList(&hostHist);
   hostle.setGeometry(150,65,175,30);

   QNamePass qnp(&userHist,&dlg);
   qnp.move(10,135);

   QPushButton mountButton("C&onnect",&dlg);
   mountButton.move(10,270);

   QPushButton cancelButton("&Cancel",&dlg);
   cancelButton.move(230,270);

   connect(&mountButton,SIGNAL(clicked()),&dlg,SLOT(accept()));
   connect(&cancelButton,SIGNAL(clicked()),&dlg,SLOT(reject()));

   int dlgerg=dlg.exec();
   if (dlgerg==QDialog::Rejected) return;

   getListFromCBox(userHist,qnp.getBox());
   getListFromCBox(hostHist,&hostle);

   String sharename(sharele.text());
   if (sharename=="") return;
   int pid=fork();
   if (pid==0) 
   {
      String titel(myName+": Connected to //");
      titel+=hostle.currentText();
      titel+="/"+sharename;
      String s("smbclient \"");
		s+='\\';
		s+='\\';
		s+='\\';
		s+='\\';
      s+=hostle.currentText();
		s+='\\';
		s+='\\';
		s+=sharename;
      s+="\"";
      if (qnp.usePW())
      {
      	s+=" -U ";
         s+=qnp.userName();
      }
      else s+=" -N ";

		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char*)((const char*) titel);
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);

		doErrorMess("smbclient");
		exit(1);
   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
   return;
};

void QSambaClass::manualSMBList()
{
   QDialogX dlg(0,"dialog",TRUE);
   dlg.resize(340,300);

   QLabel *text;

   String sx("Get list from host:");
   text=new QLabel(sx,&dlg);
   text->setGeometry(20,20,100,30);

   QComboBox hostle(TRUE,&dlg);
   hostle.setMaxCount(20);
   hostle.insertStrList(&hostHist);
   hostle.setGeometry(150,20,175,30);
   hostle.setFocus();

   QNamePass qnp(&userHist,&dlg);
   qnp.move(10,95);

   QPushButton mountButton("C&onnect",&dlg);
   mountButton.move(10,260);

   QPushButton cancelButton("&Cancel",&dlg);
   cancelButton.move(230,260);

   connect(&mountButton,SIGNAL(clicked()),&dlg,SLOT(accept()));
   connect(&cancelButton,SIGNAL(clicked()),&dlg,SLOT(reject()));

   int dlgerg=dlg.exec();
   if (dlgerg==QDialog::Rejected) return;

   getListFromCBox(userHist,qnp.getBox());
   getListFromCBox(hostHist,&hostle);
   
   int pid=fork();
   if (pid==0) 
   {
      String s("smbclient");
      if (qnp.usePW())
      //      if (cb1.isChecked())
      {
      	s+=" -U ";
         s+=qnp.userName();
//         s+=namele.currentText();
      }
      else s+=" -N ";
      s+=" -L ";
      s+=hostle.currentText();
      s+=";sh";

      cout<<"smblist: "<<s<<endl;
		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char *)hostle.currentText();
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);

   	doErrorMess("smbclient");
		exit(1);
   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
   return;
};

void QSambaClass::doUnmountAll(int)
{
   cout<<"unmounting on exit"<<endl;
   Pix tmpPix=hostList.first();
   while (tmpPix!=0)
   {
      if(hostList(tmpPix).mounted==1)
      doUnmount(hostList(tmpPix).pc_name);
      hostList.next(tmpPix);   
   };
};

/*!
tries to mount shares of host target
*/
bool QSambaClass::doSMBMount(const char * target)
{
   QDialogX dlg(0,"dialog",TRUE);
   dlg.resize(340,460);

   QFrame frame1(&dlg);
   frame1.setGeometry(10,40,315,195);
   frame1.setFrameStyle(QFrame::Sunken|QFrame::Box);

   QSambaSharesList liste(this,&frame1,target);
   liste.setMultiSelection(TRUE);
   liste.setGeometry(5,5,305,185);
   
   QLabel *text;
   String sx("Mount shares from host ");
   sx+=target;

   text=new QLabel(sx,&dlg);
   text->setGeometry(15,5,305,30);
	text->setFont( QFont( "Helvetica", 12, QFont::Bold ) );
   
   QButtonGroup bgroup(&dlg);
   bgroup.setGeometry(10,245,315,30);

   QRadioButton rb1("Mount &all shares",&bgroup);
   rb1.setGeometry(5,5,140,20);
   rb1.setChecked(TRUE);

   QRadioButton  rb2("Mount &selected shares",&bgroup);
   rb2.setGeometry(150,5,155,20);


   QNamePass qnp(&userHist,&dlg);
   qnp.move(10,285);

   QPushButton mountButton("&Mount",&dlg);
   mountButton.move(10,420);

   QPushButton pingButton("&Ping",&dlg);
   pingButton.move(120,420);

   QPushButton cancelButton("&Cancel",&dlg);
   cancelButton.move(230,420);

   currentTarget=target;

   connect(&mountButton,SIGNAL(clicked()),&dlg,SLOT(accept()));
   connect(&cancelButton,SIGNAL(clicked()),&dlg,SLOT(reject()));
   connect(&pingButton,SIGNAL(clicked()),this,SLOT(doPing()));

   int dlgerg=dlg.exec();
   if (dlgerg==QDialog::Rejected) return FALSE;

   getListFromCBox(userHist,qnp.getBox());
   
   smbpix=getTargetPix(target);
   if (smbpix==0)
   {
      QMessageBox::warning(this,"Host not found","Host not found, action failed\nStay cool, think it must have been a bug");
      return FALSE;
   };
   if (hostList(smbpix).informed==0)
   {
      if (qnp.usePW()) getPCStatus(target,qnp.userName(),qnp.password());
      else getPCStatus(target);
   };
   String s("");
   String s2(smbMountPath);
   s2+=String("/")+target;
 	makeDir(smbMountPath);
   makeDir((const char*)s2);
   s2=s2+"/";
   cout<<smbMountPath<<endl;
   cout<<s2<<endl;

   hostList(smbpix).mounted=1;
   String sharename("");
   for (unsigned int countShares=0;countShares<liste.count();countShares++)
   {
      s=liste.text(countShares);
      if ( (rb1.isChecked() || (rb2.isChecked()&&liste.isSelected(countShares)))&&(s.after("#")!="Printer"))
      {
         if (s.contains("(type: smbfs)"))
         {
            String memShare(s.before('#'));
            memShare.reverse();
            memShare=memShare.after(RXwhite);
            memShare.reverse();
				s=memShare;

				sharename=String("\"//")+target;
				sharename+=String("/")+s;
            sharename+="\"";
				s=s2+s;
				makeDir((const char*)s);
            s+="\"";
            s="\""+s;

            cout<<"making dir :"<<s<<endl;
				int pid2=fork();
				if (pid2==0)
				{
					int sysErg(0);
					cout<<"mount: "<<s<<" share: "<<sharename<<endl;
					if (qnp.usePW())
						sysErg=system((const char *)String(String("smbmount ")+sharename+String(" ")+s+String(" -U ")+String(qnp.userName())+String(" -P ")+qnp.password()));
					else
					{
						sysErg=system((const char *)String(String("smbmount ")+sharename+String(" ")+s+String(" -n")));
						cout<<(const char *)String(String("smbmount ")+sharename+String(" ")+s+String(" -n"))<<endl;
					}

					if (sysErg==0)
						hostList(smbpix).shares( getSharePix( smbpix,memShare ) ).mounted=1;
					cout<<"result system: "<<sysErg<<endl;
					//            doErrorMess("smbmount");
					exit(0);

				};
			} else
// nfs - export
         {
            String memShare=s.before(RXwhite);
				s=memShare;
            cout<<"nfs-export: "<<s<<endl;
            cout<<"nfs-export: "<<s<<endl;
				sharename=target+String(":");
				sharename+=s;

            for (unsigned int i=0;i<s.length();i++)
               if (s[i]=='/') s[i]='_';
            s=s2+s;
            cout<<"nfs-export: "<<s<<endl;
				makeDir((const char*)s);
				int pid2=fork();
				if (pid2==0)
				{
					int sysErg(0);
					cout<<"mount: "<<s<<" share: "<<sharename<<endl;
					sysErg=system((const char *)String(String("mount ")+sharename+String(" ")+s+String(" -tnfs")));

					if (sysErg==0)
						hostList(smbpix).shares( getSharePix( smbpix,memShare ) ).mounted=1;
					cout<<"result system: "<<sysErg<<endl;
					//            doErrorMess("smbmount");
					exit(0);
				};
         };
      };
   };
   Pix tmpPix=getTargetPix(target);
   sharepix=hostList(tmpPix).shares.first();
   cout<<hostList(tmpPix).pc_name<<" comment: "<<hostList(tmpPix).comment<<endl;
   while  (sharepix!=0)
   {
      cout<<"//"<<hostList(tmpPix).pc_name<<"/"<<hostList(tmpPix).shares(sharepix).name<<"   # "<<hostList(tmpPix).shares(sharepix).comment<<" mounted: "<<hostList(tmpPix).shares(sharepix).mounted<<endl;
      hostList(tmpPix).shares.next(sharepix);   
   };
   return TRUE;
};

/*!
unmounts the shares mounted from host target
and removes the according directories
**/
void QSambaClass::doUnmount(const char * target)
{
   String rootPath(smbMountPath);
   rootPath+="/";
   rootPath+=target;
   rootPath+="/";

   DIR *directory=0;
   struct dirent *dirEntry=0;
   directory=opendir((const char*) rootPath);
   if (directory!=0)
   {
      String mountedShare("");
      String umountCommand("");
      while ((dirEntry = readdir (directory)))
		{
			mountedShare=dirEntry->d_name;
			if ((mountedShare!=".")&&(mountedShare!=".."))
			{
//				mountedShare=rootPath+dirEntry->d_name;
				mountedShare=rootPath+mountedShare;
//try smbumount
				umountCommand="smbumount \""+mountedShare;
            umountCommand+="\"";
				cout<<"doing: "<<umountCommand<<endl;
            system(umountCommand);
//try umount
            umountCommand="umount \""+mountedShare;
            umountCommand+="\"";
				cout<<"doing: "<<umountCommand<<endl;
            system(umountCommand);

            cout<<"remaking dir: "<<mountedShare<<endl;
				rmdir(mountedShare);
			};
      };
      closedir(directory);
      cout<<"remaking topdir: "<<rootPath<<endl;
      rmdir(rootPath);
   };   

   Pix smbpix=getTargetPix(target);
   if (smbpix!=0)
   {
      hostList(smbpix).mounted=1;
   };
};

/*!
does a smblist to host target by running
smblist in a single xterm
*/
void QSambaClass::doSMBList(const char * target)
{
   String uname(""),pword("");
   int erg=getNamePass(uname,pword,"Enter user name:","Use &password","&Without password",target);
   if (erg==2) return;
   int pid=fork();
   if (pid==0) 
   {
      String s("smbclient");
      if (erg==0)
      {
      	s+=" -U ";
         s+=uname;
      }
      else if (erg==1) s+=" -N ";
      s+=" -L ";
      s+=target;
      if (ipForSamba==1)
      {
         Pix tmpPix=getTargetPix(target);
         if (hostList(tmpPix).informed==0) getIP(target);
         s+=" -I ";
         s+=hostList(tmpPix).ip;
      };
      s+="|less";

      cout<<"smblist: "<<s<<endl;
		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char*)target;
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);

   	doErrorMess("smbclient");
		exit(1);
   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};

void QSambaClass::doSMBClient(const char * target)
{
   QDialogX dlg(0,"dialog",TRUE);
   dlg.resize(340,420);

   QFrame frame1(&dlg);
   frame1.setGeometry(10,40,315,195);
   frame1.setFrameStyle(QFrame::Sunken|QFrame::Box);

   QSambaSharesList liste(this,&frame1,target,"test",TRUE,FALSE);
   liste.setGeometry(5,5,305,185);
   
   QLabel *text;
   String sx("Connect to which share from host ");
   sx+=target;
   text=new QLabel(sx,&dlg);
   text->setGeometry(15,5,305,30);
	text->setFont( QFont( "Helvetica", 12, QFont::Bold ) );
   
   QNamePass qnp(&userHist,&dlg);
   qnp.move(10,245);

   QPushButton mountButton("&Connect",&dlg);
   mountButton.move(10,380);

   QPushButton pingButton("&Ping",&dlg);
   pingButton.move(120,380);

   QPushButton cancelButton("&Cancel",&dlg);
   cancelButton.move(230,380);

   currentTarget=target;

   connect(&mountButton,SIGNAL(clicked()),&dlg,SLOT(accept()));
   connect(&cancelButton,SIGNAL(clicked()),&dlg,SLOT(reject()));
   connect(&pingButton,SIGNAL(clicked()),this,SLOT(doPing()));

   int dlgerg=dlg.exec();

   if (dlgerg==QDialog::Rejected) return;

   getListFromCBox(userHist,qnp.getBox());

   String sharename=liste.text(liste.currentItem());
   sharename=sharename.before('#');
   sharename.reverse();
   sharename=sharename.after(RXwhite);
   sharename.reverse();
   if (sharename=="") return;
   int pid=fork();
   if (pid==0) 
   {
      String titel(myName+": Connected to //");
      titel+=target;
      titel+="/"+sharename;
      String s("smbclient \"");
		s+='\\';
		s+='\\';
		s+='\\';
		s+='\\';
      s+=target;
		s+='\\';
		s+='\\';
		s+=sharename;
      s+="\"";

      if (ipForSamba==1)
      {
         Pix tmpPix=getTargetPix(target);
         if (hostList(tmpPix).informed==0) getIP(target);
         s+=" -I ";
         s+=hostList(tmpPix).ip;
      };
      if (qnp.usePW())
      {
      	s+=" -U ";
         s+=qnp.userName();
      }
      else s+=" -N ";

		char *argtest[20];
		argtest[0]=(char*)((const char*)shell);
		argtest[1]="-title";
		argtest[2]=(char*)((const char*) titel);
		int extraOpts(0);
		while (shellOpts[extraOpts]!="")
		{
			argtest[3+extraOpts]=(char*)((const char*)shellOpts[extraOpts]);
			extraOpts++;
		};
		argtest[extraOpts+3]="-e";
		argtest[extraOpts+4]="sh";
		argtest[extraOpts+5]="-c";
		argtest[extraOpts+6]=(char*)((const char*)s);
		argtest[extraOpts+7]=0;
		execvp((const char*)shell,argtest);

		doErrorMess("smbclient");
		exit(1);
   };   
   if (pid<0) cout<<"fork or sh not found, \ncheck "<<myName<<"rc for correct path to sh\nand ensure that smbmount is in your path"<<endl;
};

/*!
display a modal dialogbox which shows
the name of the host, the shares and other things
*/
void QSambaClass::doShowInfo(const char * target)
{
   smbpix=getTargetPix(target);
   if (smbpix==0)
   {
      QMessageBox::warning(this,"Host not found","Host not found, action failed\nStay cool, think it must have been a bug");
      return;
   };

   getPCStatus(target);

   QDialogX diag(0,"test",TRUE);
   diag.resize(300,270);

   QListBox liste(&diag);
   liste.setGeometry(10,115,280,100);

   QPushButton ok("&Close",&diag);
   ok.move(10,230);

   QLabel *text;
   text=new QLabel("Host:",&diag);
   text->setGeometry(10,5,90,20);
	text->setFont(QFont("Helvetica",12,QFont::Bold));
   text=new QLabel(hostList(smbpix).pc_name,&diag);
   text->setGeometry(110,5,100,20);

   text=new QLabel("Comment:",&diag);
   text->setGeometry(10,25,90,20);
	text->setFont(QFont("Helvetica",12,QFont::Bold));
   text=new QLabel(hostList(smbpix).comment,&diag);
   text->setGeometry(110,25,150,20);

   text=new QLabel("IP address:",&diag);
   text->setGeometry(10,45,90,20);
	text->setFont(QFont("Helvetica",12,QFont::Bold));
   text=new QLabel(hostList(smbpix).ip,&diag);
   text->setGeometry(110,45,150,20);

   text=new QLabel("Running OS:",&diag);
   text->setGeometry(10,65,90,20);
	text->setFont(QFont("Helvetica",12,QFont::Bold));
   text=new QLabel(hostList(smbpix).os,&diag);
   text->setGeometry(110,65,150,20);

   text=new QLabel("Available shares:",&diag);
   text->setGeometry(10,90,250,20);
	text->setFont(QFont("Helvetica",12,QFont::Bold));
   
   sharepix=hostList(smbpix).shares.first();

   while (sharepix!=0)			//s2 = mountpoint; s = sharename
   {
      liste.insertItem(hostList(smbpix).shares(sharepix).name+"   #"+hostList(smbpix).shares(sharepix).comment);
      hostList(smbpix).shares.next(sharepix);   
   };
   connect(&ok,SIGNAL(clicked()),&diag,SLOT(accept()));
   diag.exec();
};

const char * QSambaClass::getCurrentUserName()
{
   QPushButtonX* tmpbt=0;
   Pix smbpix=button_liste.first();
   for (int i=0;i<currentUser;i++) button_liste.next(smbpix);   
   tmpbt=button_liste(smbpix);
   return tmpbt->text();
};

void QSambaClass::doSystemMenu()
{
   sysMenu.popup(QCursor::pos());
};

void QSambaClass::procSysMenu(int id)
{
   int result(0);
   String target,uname;
	switch (id)
	{
/*		case 0:
         doExploreHost();
			break;*/
		case 0:
         manualSMBMount();
			break;
/*		case 2:
         doUnmount();
			break;*/
		case 1:
         manualSMBClient();
			break;
		case 2:
         manualSMBList();
			break;
		case 3:
         	result=getUserHost(target,uname,"Login as user:");
         	if (result==0) execRLogin((const char*)target,(const char*)uname);
			break;
		case 4:
         	result=getUserHost(target,uname,"Talk to user:");
         	if (result==0) execTalk((const char*)target,(const char*)uname);
			break;
		case 5:
         	result=getUserHost(target,uname,"Telnet as user:");
         	if (result==0) execTelnet((const char*)target,(const char*)uname);

			break;
		case 6:
         	result=getHost(target,"Put Finger on host:");
         	if ((result==0)&& (target!="")) doFinger((const char*)target);
			break;
		case 7:
         	result=getHost(target,"Ping to host:");
         	if ((result==0)&&(target!=""))  doPing((const char*)target);
			break;

		case 8:
         	result=getHost(target,"Get address of host:");
            if ((result==0) && (target!=""))
            {
               uname=getIPDirect((const char*)target);
               uname="IP address of host "+String(target)+String(": ")+uname;
               QMessageBox::information(this,"NSLookup",(const char *)uname);
            };
			break;
		case 10:
            if (adjustSettings()) readConfig();
			break;
		case 11:
         	refresh();
            statsDlg->updateStatus();
			break;
		case 12:
         	doPingServer();
			break;

		case 13:
         	doAboutDialog();
			break;
	}
};

void QSambaClass::procMenu(int id)
{
   String uname=getCurrentUserName();
   cout<<uname<<endl;
	switch (id)
	{
		case 0:
         doExploreHost((const char*)uname);
			break;
		case 1:
         doSMBMount((const char*)uname);
			break;
		case 2:
         doUnmount((const char*)uname);
			break;
		case 3:
         doSMBClient((const char*)uname);
			break;
		case 4:
         doSMBList((const char*)uname);
			break;
		case 5:
         doRLogin((const char*)uname);
			break;
		case 6:
         doTalk((const char*)uname);
			break;
		case 7:
         doTelnet((const char*)uname);
			break;
		case 8:
         doFinger((const char*)uname);
			break;
		case 9:
         doPing((const char*)uname);
			break;
		case 10:
         doShowInfo((const char*)uname);
			break;
	}
};

/*!
updates the list of buttonbars using smblist
*/
void QSambaClass::refresh()
{
   QPushButtonX *tmpbt;
   String s("");
   cout<<"sambaForList: "<<sambaForList<<endl;

   getNetStatus();

   smbpix=button_liste.first();		//delete old buttons
   while (smbpix!=0)
   {
      tmpbt=button_liste(smbpix);
      button_liste.next(smbpix);   
      removeChild(tmpbt);
      delete tmpbt;
   };
   button_liste.clear();

   smbpix=hostList.first();		//create all buttons new
   int count(0);

   while (smbpix!=0)
   {
      s=hostList(smbpix).pc_name;
      if ((s!="") && (hostList(smbpix).running==1))
		{
			tmpbt=new QPushButtonX((const char *)s,this);
         tmpbt->setValue(count);
			tmpbt->setGeometry((count/rows)*(fontSize*10),(count%rows)*(fontSize*2),fontSize*10,fontSize*2);
   		tmpbt->setFont( QFont( "Helvetica", fontSize, QFont::Normal ) );

         connect(tmpbt,SIGNAL(valueRightClicked(int)),this,SLOT(showMenu(int)));
         connect(tmpbt,SIGNAL(valueClicked(int)),this,SLOT(doQuickExploreHost(int)));

			count++;
			button_liste.append(tmpbt);
         tmpbt->show();
		};
      hostList.next(smbpix);
   };

   statusButton.move((count/rows)*(fontSize*10),(count%rows)*(fontSize*2));
	count++;
   aboutButton.move((count/rows)*(fontSize*10),(count%rows)*(fontSize*2));
   count++;
   exitButton.move((count/rows)*(fontSize*10),(count%rows)*(fontSize*2));
   count++;
   cout<<"count: "<<count<<endl;
   if ((count/*+1*/)>rows)
   setFixedSize((1+count/rows)*(fontSize*10),rows*(fontSize*2));
   else setFixedSize(fontSize*10,count*(fontSize*2));
   resize(size());
};
