#include <GetOpt.h>
#include <iostream.h>
#include <String.h>

#include "ksambaclass.h"
#include "../utils/mytypes.h"

#include <kapp.h>

//#include "mmain.h"

void printVersion()
{
   cout<<"\nKNetMon 0.90betaR2\nby Alexander Neundorf\nhttp://www.rz.tu-ilmenau.de/~lekus/software.htm\n";
   cout<<"email: alexander.neundorf@rz.tu-ilmenau.de\n"<<endl;
};

void printHelp()
{
   printVersion();
   cout<<"Usage: knetmon [options]\n\n-h             prints this helptext\n-v             prints the version number\n";
   cout<<"-c /path/xyzrc starts using the configuration file /path/xyzrc\n               instead of the standard qnetmonrc, path must be the complete path\n"<<endl;
};

int main( int argc, char **argv )
{

  // Invokes ctor `GetOpt (int argc, char **argv,
  //                       char *optstring);'
  String configFile("std");
  GetOpt getopt (argc, argv, "vhc:");
  int option_char;
  while ((option_char = getopt ()) != EOF)
	  switch (option_char)
	  {
		  case 'v':	printVersion();
           			return 0;
                  break;
		  case 'h':	printHelp();
           			return 0;
                  break;
		  case 'c': configFile = getopt.optarg;
           			break;
	  }

	KApplication a( argc, argv );
	a.setFont(QFont("Helvetica",12));
   String tmp1(a.argv()[0]),tmpPath,tmpName;
   splitFilename(String(tmp1),tmpPath,tmpName);

   KSambaClass ksmb((const char*)configFile,tmpName);
   ksmb.startUp();
      
	QObject::connect( &ksmb, SIGNAL(quit()), &a, SLOT(quit()) );

	a.setMainWidget( &ksmb );
	ksmb.show();
	return a.exec();
}
