#include "ksambaclass.h"

/*!
constructor
*/
KSambaClass::KSambaClass(const char *config,const char *selfName):QSambaClass(config,selfName)
,currentTab("conf")
{;};

void KSambaClass::setHelpContext(const char *tabText)
{
   if (String(tabText)=="Settings") currentTab="conf_settings";
   else if (String(tabText)=="Network-Settings") currentTab="conf_net";
   else if (String(tabText)=="GUI-Settings") currentTab="conf_gui";
};

void KSambaClass::invokeHelp()
{
   kapp->invokeHTMLHelp("knetmon/index.html",QString(currentTab));
};

void KSambaClass::doAboutDialog()
{
   QMessageBoxX mb(0,"mess");
	mb.setFont( QFont( "Helvetica", 12, QFont::Bold ) );
   mb.setIcon(QMessageBox::Information);
   mb.setMouseCatching(TRUE);
   mb.setText("KNetMon 0.90beta by Alexander Neundorf\nBug reports, comments,... to alexander.neundorf@rz.tu-ilmenau.de\nNewest versions under http://www.rz.tu-ilmenau.de/~lekus/software.htm\n\nThis program is free available under the terms of the GNU General Public License\n\nCreated using Qt 1.4 by Troll Tech http://www.troll.no");
   mb.exec();
};

#include <iostream.h>
void KSambaClass::readConfigCore()
{
   cout<<"********* ksambaclass::readconfigcore ******"<<endl;
   cout<<"configfile: "<<configFile<<endl;
// SambaClass::readConfigCore();
// TInitFile initf((const char*)configFile,(const char* ) configDir);

   KConfig *config;
    if (configFile=="qnetmonrc") config = kapp->getConfig();
    else
    {
       config = new KConfig(configDir+configFile);
         cout<<"configuring from file: "<<(configDir+configFile)<<endl;
    };
    config->reparseConfiguration();

   String tmpRefresh(config->readEntry("refresh"));
	char *error="";
	int tmp=strtol(tmpRefresh,&error,10);
   if ((tmpRefresh!="manual") &&((tmp<5)||(tmp>3600)))
   {
      cout<<"Invalid entry for refresh: -"<<tmpRefresh<<"-\npossible values: manual,5 to 3600\nrefresh time set to 180 s"<<endl;
      refreshTime=180;
   }
   else if (tmpRefresh=="manual") refreshTime=-1;
   else refreshTime=tmp;
	tmp=strtol(config->readEntry("max_rows","0"),&error,10);
   if (tmp>0) rows=tmp;

   if (config->readEntry("xtalk","standard")!="standard") talkCommand=config->readEntry("xtalk","standard");
   if (config->readEntry("unmount_on_exit")=="no") unmountOnExit=0; else unmountOnExit=1;
   if (config->readEntry("use_ip_for_samba")=="yes") ipForSamba=1;   
   sambaForList=(config->readEntry("use_smbclient_for_getting_userlist")!="no");

   nsLookup=config->readEntry("use_nslookup");   
   if (nsLookup=="no") nsLookup="";

	tmp=strtol(config->readEntry("font_size","1"),&error,10);
   if (tmp>3) fontSize=tmp;

   browseListServer=config->readEntry("browselist_server","localhost");
   smbMountPath=config->readEntry("mount_point","/tmp/network");

   cout<<smbMountPath<<endl;
   shell=config->readEntry("xterm","xterm");
   tmpFile=config->readEntry("tmpfile","/tmp/knetmonstd.tmp");
   stdUser=config->readEntry("std_user","rookie");

//read shell options
   String tmpString=(const char*)config->readEntry("xterm_options","");
   if (tmpString=="") shellOpts[0]="";
   else
   {
		int optCount(0);
		do
		{
			shellOpts[optCount]=(String)tmpString.before(RXwhite);
         if ((tmpString!="") && (tmpString.before(RXwhite)=="")) shellOpts[optCount]=tmpString;
         cout<<"shelloption "<<optCount<<": *"<<shellOpts[optCount]<<"*"<<endl;
			tmpString=tmpString.after(RXwhite);
			optCount++;
      } while (tmpString!="");
   };

//read filemanager
   tmpString=config->readEntry("filemanager","kfmclient openURL %dir");
   if (tmpString=="") fManager[0]="";
   else
   {
		int optCount(0);
		do
		{
			fManager[optCount]=(String)tmpString.before(RXwhite);
         if ((tmpString!="") && (tmpString.before(RXwhite)=="")) fManager[optCount]=tmpString;
         cout<<"fm: "<<optCount<<": *"<<fManager[optCount]<<"*"<<endl;
			tmpString=tmpString.after(RXwhite);
			optCount++;
      } while (tmpString!="");
   };
   
   if (ipForSamba==1)
   {
      command="smbclient -L "+browseListServer+" -I "+getIPDirect(browseListServer)+" >"+tmpFile;
   } else
   command="smbclient -L "+browseListServer+" >"+tmpFile;
   cout<<"smbclienting: -"<<command<<"-"<<endl;
   cout<<"sambaForList: "<<sambaForList<<endl;
};

bool KSambaClass::adjustSettings()
{
   QTabDialog tabdialog(0,"tabdialog",TRUE);
	tabdialog.setCaption( "KNetMon Configuraton" );
	tabdialog.resize( 370, 340 );
	tabdialog.setCancelButton();
   connect(&tabdialog,SIGNAL(selected(const char *)),this,SLOT(setHelpContext(const char*)));

	QWidget setDlg(&tabdialog);
	tabdialog.addTab(&setDlg,"Settings");

	QLineEdit smbMountPathLe(&setDlg);
	smbMountPathLe.setText(smbMountPath);
	smbMountPathLe.setGeometry(190,15,130,30);
   QLabel smbMountPathL(&smbMountPathLe,"Mount &shares under:",&setDlg);
   smbMountPathL.setGeometry(10,15,170,30);
   QToolTip::add(&smbMountPathLe,"here the shares will be mounted,\nyou MUST have WRITE-PERMISSION");

	QLineEdit tmpFileLe(&setDlg);
	tmpFileLe.setText(tmpFile);
	tmpFileLe.setGeometry(190,55,130,30);
   QLabel tmpFileL(&tmpFileLe,"Temporary &file:",&setDlg);
   tmpFileL.setGeometry(10,55,170,30);
   QToolTip::add(&tmpFileLe,"usually you shouldn't need to change this");

   QString tmpQStr("");
   tmpQStr=tmpQStr.setNum(refreshTime);
	QLineEdit refreshTimeLe(&setDlg);
   cout<<"refreshTime: -"<<tmpQStr<<"-"<<endl;
	refreshTimeLe.setText(tmpQStr);
//	refreshTimeLe.setText(dec(refreshTime));	//from Integer.h
	refreshTimeLe.setGeometry(190,95,130,30);
   QLabel refreshTimeL(&refreshTimeLe,"&Update period:",&setDlg);
   refreshTimeL.setGeometry(10,95,170,30);
   QToolTip::add(&refreshTimeLe,"update period in seconds");

	QCheckBox unmountOnExitCb("Unmount on &exit",&setDlg);
	unmountOnExitCb.setGeometry(10,135,110,30);
   if (unmountOnExit) unmountOnExitCb.setChecked(TRUE);
   else unmountOnExitCb.setChecked(FALSE);
   QToolTip::add(&unmountOnExitCb,"usually you should keep this checked");

	QWidget netDlg(&tabdialog);
	tabdialog.addTab(&netDlg,"Network-Settings");

	QLineEdit stdUserLe(&netDlg);
	stdUserLe.setText(stdUser);
	stdUserLe.setGeometry(190,15,130,30);
   QLabel stdUserL(&stdUserLe,"Your &username:",&netDlg);
   stdUserL.setGeometry(10,15,170,30);
   QToolTip::add(&stdUserLe,"you should know");

	QCheckBoxX sambaForListCb("Use &samba for getting browse list: ",&netDlg);
	QCheckBoxX nsLookupCb("Use &NSLookup: ",&netDlg);
	QCheckBoxX ipForSambaCb("Use &IP for samba",&netDlg);

	nsLookupCb.setGeometry(10,55,110,30);
	QLineEdit nsLookupLe(&netDlg);
	nsLookupLe.setGeometry(190,55,130,30);
	nsLookupLe.setText(nsLookup);
	if (nsLookup=="")
	{
		nsLookupLe.setEnabled(FALSE);
		nsLookupCb.setChecked(FALSE);
	}
	else nsLookupCb.setChecked(TRUE);
	connect(&nsLookupCb,SIGNAL(toggled(bool)),&nsLookupLe,SLOT(setEnabled(bool)));
   connect(&nsLookupCb,SIGNAL(invCheckedFalse(bool)),&sambaForListCb,SLOT(setCheckedSl(bool)));
   connect(&nsLookupCb,SIGNAL(checkedFalse(bool)),&ipForSambaCb,SLOT(setCheckedSl(bool)));
   QToolTip::add(&nsLookupCb,"if checked, knetmon will be able to retrieve the IP addresses from your nameserver");
   QToolTip::add(&nsLookupLe,"enter the IP address of your nameserver, its name may work too");

	sambaForListCb.setGeometry(10,95,200,30);
   if (sambaForList) sambaForListCb.setChecked(TRUE);
   else sambaForListCb.setChecked(FALSE);
   QToolTip::add(&sambaForListCb,"if checked, smbclient is used for getting\na list of active hosts, it is recommended to enable this");
   connect(&sambaForListCb,SIGNAL(invCheckedFalse(bool)),&nsLookupCb,SLOT(setCheckedSl(bool)));
   
	QLineEdit browseListServerLe(&netDlg);
	browseListServerLe.setGeometry(190,135,130,30);
	browseListServerLe.setText(browseListServer);
   QLabel browseListServerL(&browseListServerLe,"Get &browselist from:",&netDlg);
   browseListServerL.setGeometry(10,135,170,30);
   QToolTip::add(&browseListServerLe,"name of a host, which provides a browsing list,\ne.g. the name server or your own machine");

	ipForSambaCb.setGeometry(10,175,200,30);
   connect(&ipForSambaCb,SIGNAL(checkedTrue(bool)),&nsLookupCb,SLOT(setCheckedSl(bool)));
   if (ipForSamba)
   {
      ipForSambaCb.setChecked(TRUE);
      nsLookupCb.setChecked(TRUE);
   }
   else ipForSambaCb.setChecked(FALSE);
   QToolTip::add(&ipForSambaCb,"if checked, samba will use the IP-address for its actions,\nusually it should work without this option");


	QWidget guiDlg(&tabdialog);
	tabdialog.addTab(&guiDlg,"GUI-Settings");

	QCheckBox talkCommandCb("Use special talk program: ",&guiDlg);
	talkCommandCb.setGeometry(10,15,170,30);
	QLineEdit talkCommandLe(&guiDlg);
	talkCommandLe.setGeometry(190,15,130,30);
   connect(&talkCommandCb,SIGNAL(toggled(bool)),&talkCommandLe,SLOT(setEnabled(bool)));
   if (talkCommand=="standard")
   {
      talkCommandCb.setChecked(FALSE);
      talkCommandLe.setEnabled(FALSE);
      talkCommandLe.setText("ktalk");
   }
   else
   {
      talkCommandCb.setChecked(TRUE);
      talkCommandLe.setText(talkCommand);
   };
   QToolTip::add(&talkCommandCb,"if not checked, the standard talk program in\na xterm is used, else the talk you enter here");
   QToolTip::add(&talkCommandLe,"the name of a X talk, e.g. \"ktalk\"");

	QLineEdit rowsLe(&guiDlg);
	rowsLe.setGeometry(190,55,130,30);

   tmpQStr=tmpQStr.setNum(rows);
   cout<<"rows: -"<<tmpQStr<<"-"<<endl;
   rowsLe.setText(tmpQStr);
// rowsLe.setText(dec(rows));
   QLabel rowsL(&rowsLe,"&Max. number of button rows:",&guiDlg);
   rowsL.setGeometry(10,55,170,30);
   QToolTip::add(&rowsLe,"the maximum number of buttons vertically");

	QLineEdit fontSizeLe(&guiDlg);
	fontSizeLe.setGeometry(190,95,130,30);
   tmpQStr=tmpQStr.setNum(fontSize);
   cout<<"fontSize: -"<<tmpQStr<<"-"<<endl;
   fontSizeLe.setText(tmpQStr);
//   fontSizeLe.setText(dec(fontSize));
   QLabel fontSizeL(&fontSizeLe,"Adjust &fontsize:",&guiDlg);
   fontSizeL.setGeometry(10,95,170,30);
   QToolTip::add(&fontSizeLe,"the font size of the buttons");

	QLineEdit shellLe(&guiDlg);
	shellLe.setGeometry(190,135,130,30);
	shellLe.setText(shell);
   QLabel shellL(&shellLe,"&Use following xterm:",&guiDlg);
   shellL.setGeometry(10,135,170,30);
   QToolTip::add(&shellLe,"the name of your favourite xterm, kvt won't work, I think");

   String tmpStr;
	int count(0);
	while (shellOpts[count]!="")
	{
		tmpStr+=" "+shellOpts[count];
		count++;
	};
	QLineEdit shellOptsLe(&guiDlg);
	shellOptsLe.setGeometry(190,175,130,30);
	shellOptsLe.setText(tmpStr);
   QLabel shellOptsL(&shellOptsLe,"&Start xterm with options:",&guiDlg);
   shellOptsL.setGeometry(10,175,170,30);
   QToolTip::add(&shellOptsLe,"the xterm entered above will\nbe started with these options");

   tmpStr="";
   count=0;
	while (fManager[count]!="")
	{
		tmpStr+=" "+fManager[count];
		count++;
	};
	QLineEdit fManagerLe(&guiDlg);
	fManagerLe.setGeometry(190,215,130,30);
	fManagerLe.setText(tmpStr);
   QLabel fManagerL(&fManagerLe,"&Explore with:",&guiDlg);
   fManagerL.setGeometry(10,215,170,30);
	QToolTip::add(&fManagerLe,"a filemanager which opens directory %dir");

   QPushButton helpButton("&Help",&tabdialog);
   helpButton.setGeometry(10,307,90,25);
   connect(&helpButton,SIGNAL(clicked()),this,SLOT(invokeHelp()));

	if(tabdialog.exec() == QDialog::Accepted)
	{
      KConfig *config;
      if (configFile=="qnetmonrc") config = kapp->getConfig();
      else
      {
         config = new KConfig(configDir+configFile);
         cout<<"configuring from file: "<<(configDir+configFile)<<endl;
      };
//		KConfig *config = kapp->getConfig();
		config->reparseConfiguration();
      
      config->writeEntry("std_user",stdUserLe.text());
      config->writeEntry("browselist_server",browseListServerLe.text());
      config->writeEntry("xterm",shellLe.text());
      config->writeEntry("xterm_options",shellOptsLe.text());
      config->writeEntry("max_rows",rowsLe.text());
      config->writeEntry("font_size",fontSizeLe.text());
		config->writeEntry("mount_point",smbMountPathLe.text());
		config->writeEntry("tmpfile",tmpFileLe.text());
		config->writeEntry("filemanager",fManagerLe.text());
		config->writeEntry("refresh",refreshTimeLe.text());

      if (nsLookupCb.isChecked()==FALSE) config->writeEntry("use_nslookup","no");
      else config->writeEntry("use_nslookup",nsLookupLe.text());

      if (sambaForListCb.isChecked()) config->writeEntry("use_smbclient_for_getting_userlist","yes");
      else config->writeEntry("use_smbclient_for_getting_userlist","no");

      if (ipForSambaCb.isChecked()) config->writeEntry("use_ip_for_samba","yes");
      else config->writeEntry("use_ip_for_samba","no");

      if (unmountOnExitCb.isChecked()) config->writeEntry("unmount_on_exit","yes");
      else config->writeEntry("unmount_on_exit","no");

      if (talkCommandCb.isChecked()) config->writeEntry("xtalk",talkCommandLe.text());
      else config->writeEntry("xtalk","standard");
      
      config->sync();
                  
		cout<<"accepted"<<endl;
		return TRUE;
	}
/*    config->setGroup("GUI Settings");

		// Size
		QString entry = config->readEntry("Size", "100 100");
		QTextStream str(entry, IO_ReadOnly);
		int w, h;
		str >> w >> h;
		entry.sprintf("%d %d",w,h);
		config->writeEntry("Size", entry);
		resize(w,h);*/
	return FALSE;
};

