# =======================================================================
# X Window Application Module 
# for Hamster Font Manager
#
# $Date: 1998/11/02 17:58:34 $
# $Revision: 1.18 $
#
# 1998 The Hamster Project Team [MF]
# =======================================================================

#========================================================
#                  Test stuff
#========================================================

# local x_putdebug:
set x_debug 0
proc x_putdebug {text} {
    global x_debug
    if {$x_debug} {
	puts "X-Window: $text"
    }
}

x_putdebug "LOADING APP"

#========================================================
#                  X-Window requirement
#========================================================

# REQUIRED-FILES: x.xbm
# INSTALL-CODE: echo 0 > %HFMDIR%/fonts/fonts.dir
# INSTALL-CODE: echo ========================================================
# INSTALL-CODE: echo To use the fonts managed by HFM on X-Window, you have to
# INSTALL-CODE: echo ensure the following commands will be executed when
# INSTALL-CODE: echo starting X-Window:
# INSTALL-CODE: echo   xset +fp %HFMDIR%/fonts
# INSTALL-CODE: echo   xset fp rehash
# INSTALL-CODE: echo =========================================================

#========================================================
#                  Public variables
#========================================================

# It's a list of applications HAMSTER knows about,
# supplemented by X-window.
lappend AppMods "X"

#========================================================
#                  Private variables
#========================================================

# It's a list of font-types that the X-module supports
# now
set x_FontTypeExtentions {bdf pfa pfb pcf ps spd snf}

# It's an identifier for the bitmap of the X-Window
# Icon
set x_Icon [image create bitmap -file $HFMDirectory/x.xbm]

# It's a label, marking the begining of the X-Window
# part in the hfm.conf file
set x_Config(X-Label) "<X>"

# It's a list, containing the original X-Window font
# directories
set x_FontPath ""

# It's a switch indicating whether X-Window is supported
# or not, but it becomes created later ...
# x_Config(XWinActive)

# It's a list, containing the fonts that are already
# been returned since the first run of HAMSTER.
set x_Config(RetNewFont) ""

# The following array becomes created later,
# not at this moment.
#
# It's an array of lists with the FontDir as index.
# The structure is as following:
#
# x_RelatedToFont (FileName) {Status FullFontName Alias_1 Alias_2 ... Alias_n} 
#
# FileName is the name of the font-file, Status indicates
# if the font is active or not: 1/0, FontDir indicates to
# which directory the font belongs to, FullFontName is the
# full name of the font (1. alias)

#========================================================
#                  Private procedures
#========================================================

#----------------- x_MakeFileRW --------------------
#
# This procedure makes a given file readable and
# writable and returns 1. If this isn't possible,
# it returns 0. 

proc x_MakeFileRW {dir file} {
    x_putdebug "x_MakeFileRW"
    set path [file join "$dir" "$file"]
    if {! [file exist $path]} {
	return 1
    } elseif {! [file isfile $path]} {
	return 0
    } elseif {[file owned $path]} {
	exec chmod u+rw $path
	return 1
    } elseif {[file readable $path] && [file writable $path]} {
	return 1
    } else {
	return 0
    }
}

#----------------- x_ReadXFontPath --------------------
# 
# This procedure extracts the X-Window font-path from
# the output of "xset -q" and saves it in "x_FontPath"

proc x_ReadXFontPath {} {
    x_putdebug "x_ReadXFontPath"
    global x_FontPath HFMDirectory
    if {[info exist x_FontPath]} {
	unset x_FontPath
    }
    set xset_list [split [exec -keepnewline xset -q] \n]
    set index [lsearch -glob $xset_list "*Font Path:*"]
    if {! ($index == -1)} {
	incr index 
	set fontpath_with_spaces [lindex $xset_list $index]
	set fontpath_without_spaces [string trim $fontpath_with_spaces] 
	foreach dir [split $fontpath_without_spaces ,] {
	    set dir_homo [file join [file dirname $dir] [file tail $dir]]
	    if {([file isdirectory $dir_homo] == 1) 
	    && ($dir_homo != [file join "$HFMDirectory" "fonts"])
	    && ([x_MakeFileRW "$dir_homo" "fonts.dir"])
	    && ([x_MakeFileRW "$dir_homo" "fonts.alias"])} {
		lappend x_FontPath $dir_homo
	    }
	}
    }
}

#----------------- x_DoesAliasExist ---------------------
#
#
#

proc x_DoesAliasExist {aliasname} {
    x_putdebug "x_DoesAliasExist"
    global x_RelatedToFont
    foreach FileNameSearch [lsort [array names x_RelatedToFont]] {
	set Pos [lsearch [lrange $x_RelatedToFont($FileNameSearch) 1 end] "$aliasname"]
	if {($Pos != -1) && [lindex $x_RelatedToFont($FileNameSearch) 0]} {
	    return 1
	}
    }
    foreach FileNameSearch [lsort [array names x_RelatedToFont]] {
	set Pos [lsearch [lrange $x_RelatedToFont($FileNameSearch) 1 end] "$aliasname"]
	if {$Pos != -1} {
	    if {! [lindex $x_RelatedToFont($FileNameSearch) 0]} {
		incr Pos
		if {$Pos == 1} {
		    set x_RelatedToFont($FileNameSearch) [lreplace $x_RelatedToFont($FileNameSearch) $Pos $Pos {}]
		} else {
		    set x_RelatedToFont($FileNameSearch) [lreplace $x_RelatedToFont($FileNameSearch) $Pos $Pos]
		}
	    }
	}
    }
    return 0
}

#----------------- x_ReadFDFAFromHFM --------------------
#
# This procedure reads the fonts.dir and fonts.alias found
# in the HFM/fonts-directory. It extracts the read
# information and puts those that relates to a common font
# in the same list. Each font gets another list in a array
# of lists with the following structure:
# x_RelatedToFont(FileName) {Status FullFontName Alias_1 Alias_2 ... Alias_n}

proc x_ReadFDFAFromHFM {} {
    x_putdebug "x_ReadFDFAFromHFM"
    global x_Config x_RelatedToFont HFMDirectory 
    if {[info exist x_RelatedToFont]} {
	unset x_RelatedToFont
    }
    set Status 1
    set SourceDir [file join "$HFMDirectory" "fonts"]
    # Read HFM/fonts/fonts.dir
    if {[file exist [file join "$SourceDir" "fonts.dir"]]} {
	set FontsDir [open [file join "$SourceDir" "fonts.dir"] r]
	gets $FontsDir dummy
	for {gets $FontsDir line} {! [eof $FontsDir]} {gets $FontsDir line} {
	    lappend x_RelatedToFont([lindex [split $line] 0]) "$Status"
	    lappend x_RelatedToFont([lindex [split $line] 0]) "[lrange [split $line] 1 end]"
	}
	close $FontsDir
	# Read HFM/fonts/fonts.alias
	if {[file exist [file join "$SourceDir" "fonts.alias"]]} {
	    set FontsAlias [open [file join "$SourceDir" "fonts.alias"] r]
	    for {gets $FontsAlias line} {! [eof $FontsAlias]} {gets $FontsAlias line} {
		foreach FileName [array names x_RelatedToFont] {
		    if {"[lindex $x_RelatedToFont($FileName) 1]" == "[lrange [split $line] 1 end]"} {
			lappend x_RelatedToFont($FileName) "[lindex [split $line] 0]"
		    }
		}
	    }
	    close $FontsDir
	}
	return 1
    } else {
	return 0
    }
}

#----------------- x_WriteFDFAToHFM ------------------------
#
# This procedure writes all information from the array of
# lists with the following structure
# x_RelatedToFont(FileName) {Status FullFontName Alias_1 Alias_2 ... Alias_n} 
# to the files fonts.dir and fonts.alias in the HFM/fonts-
# directory

proc x_WriteFDFAToHFM {} {
    x_putdebug "x_WriteFDFAToHFM"
    global x_Config x_RelatedToFont HFMDirectory
    set TargetDir [file join "$HFMDirectory" "fonts"]
    if {[file exist [file join "$TargetDir" "fonts.dir"]]} {
	if {[file writable [file join "$TargetDir" "fonts.dir"]]} {
	    if {([file exist [file join "$TargetDir" "fonts.alias"]])
	    && ([file writable [file join "$TargetDir" "fonts.alias"]])
	    || (! [file exist [file join "$TargetDir" "fonts.alias"]])
	    && (! [file writable [file join "$TargetDir" "fonts.alias"]])} {
		# Counting how much fonts are to be stored
		set NumberOfFonts 0
		foreach FileName [lsort [array names x_RelatedToFont]] {
		    if {[lindex $x_RelatedToFont($FileName) 0]} {
			incr NumberOfFonts 1
		    }
		}
		# Storing the relation information in the file "HFM/fonts/fonts.dir"
		# and "HFM/fonts/fonts.alias"
		set FontsDir [open [file join "$TargetDir" "fonts.dir"] w]
		set FontsAlias [open [file join "$TargetDir" "fonts.alias"] w]
		puts $FontsDir $NumberOfFonts
		foreach FileName [lsort [array names x_RelatedToFont]] {
		    if {[lindex $x_RelatedToFont($FileName) 0]} {
			puts $FontsDir "$FileName [lindex $x_RelatedToFont($FileName) 1]"
			foreach Alias [lsort [lrange $x_RelatedToFont($FileName) 2 end]] { 
			    puts $FontsAlias "$Alias [lindex $x_RelatedToFont($FileName) 1]"
			}
		    }
		}
		close $FontsDir
		close $FontsAlias
		if {[catch {exec xset fp rehash}]} {
		    return "You have a faulty fonts.dir/fonts.alias, because X-Window was very upset rehasing his fontpath!"
		}
	    } else {
		return "No write permission for [file join "$TargetDir" "fonts.alias"]!"
	    }
	} else {
	    return "No write permission for [file join "$TargetDir" "fonts.dir"]!"
	}
    } else {
	return "[file join "$TargetDir" "fonts.dir"] doesn't exist!"
    }
}

#----------------- x_GenerateName --------------------
#
# This procedure extracts every useable item from
# fontinfo and gerates the full fontname of a font.
# At least it returnes this full fontaname.

proc x_GenerateName {fontinfo} {
    x_putdebug "x_GenerateName"
    if {[llength [lindex $fontinfo 3]] != 0} {
	append FullFontName "-[lindex $fontinfo 3]"
    } else {
	append FullFontName "-0"
    }
    if {[llength [lindex $fontinfo 4]] != 0} {
	append FullFontName "-[lindex $fontinfo 4]"
    } else {
	append FullFontName "-0"
    }
    if {[llength [lindex $fontinfo 5]] != 0} {
	append FullFontName "-[lindex $fontinfo 5]"
    } else {
	append FullFontName "-0"
    }
    if {[llength [lindex $fontinfo 6]] != 0} {
	append FullFontName "-[lindex $fontinfo 6]"
    } else {
	append FullFontName "-0"
    }
    if {[llength [lindex $fontinfo 7]] != 0} {
	append FullFontName "-[lindex $fontinfo 7]-0-0-0-0-0"
    } else {
	append FullFontName "-0-0-0-0-0-0"
    }
    if {[llength [lindex $fontinfo 9]] != 0} {
	append FullFontName "-[lindex $fontinfo 9]-0"
    } else {
	append FullFontName "-0-0"
    }
    if {[llength [lindex $fontinfo 10]] != 0} {
	append FullFontName "-[lindex $fontinfo 10]"
    } else {
	append FullFontName "-0"
    }
    return "$FullFontName"
}

#========================================================
#                  Public procedures
#========================================================

#----------------- X_Init -------------------------------
#
# This procedure reads the x-Windows part of the file
# "HFM/hfm.conf". Now there are only the returned fonts
# that are to be read from the config file.
# Also this procedure calls the "x_ReadFDFAFromHFM"
# -procedure. For explanation see " x_ReadFDFAFromHFM".

proc X_Init {configfile} {
    x_putdebug "X_Init"
    global x_Config
    x_ReadXFontPath
    unset x_Config(RetNewFont)
    seek $configfile 0 start
    for {gets $configfile dummy} {(! [eof $configfile]) && ($dummy != $x_Config(X-Label))} {gets $configfile dummy} {
    }
    for {gets $configfile line} {! [eof $configfile]} {gets $configfile line} {
    	switch [lindex [split $line] 0] {
	    |XWinActive| {set x_Config(XWinActive) [lindex [split $line] 1]}
	    |RetNewFont| {lappend x_Config(RetNewFont) [lrange [split $line] 1 end]}
	    default      {if {[string match <?*> $line]} {break}}
	}
    }
    return [x_ReadFDFAFromHFM]
}

#----------------- X_CheckConfigInput -----------------
#
# This procedure has nothing to do, but returning
# an empty string.

proc X_CheckConfigInput { } {
    x_putdebug "X_CheckConfigInput"
    global x_userinput x_Config
    x_ReadXFontPath
    set x_Config(XWinActive) $x_userinput
    return ""
}


#----------------- X_QueryNewFonts --------------------
#
# This procedure returns all files found in the
# font-search-path which weren't returned before.

proc X_QueryNewFonts {} {
    x_putdebug "X_QueryNewFonts"
    global x_FontPath x_Config HFMDirectory
    set x_Config(RetNewFont) ""
    set new_files ""
    set read_files ""
    if {([info exist x_FontPath]) && $x_Config(XWinActive)} {
	foreach dir $x_FontPath {
	    set read_files [glob -nocomplain [file join "$dir" "*"]]
	    foreach file $read_files {
		if {([lsearch -exact $x_Config(RetNewFont) $file] == -1)
		&& ([x_MakeFileRW $dir $file])} {
		    lappend new_files $file
		    lappend x_Config(RetNewFont) $file
		}
	    }
	}
	return $new_files
    } else {
	return ""
    }
}

#----------------- X_QueryInstalled -------------------
#
# This procedure returns 1 when a font-search-path is
# found and x_Config(XWinActive) is set to 1,
# 0 otherwise.

proc X_QueryInstalled {} {
    x_putdebug "X_QueryInstalled"
    global x_FontPath x_Config
    if {$x_Config(XWinActive) == 0} {
	return 0
    }
    if {(! [info exist x_FontPath]) || ([llength $x_FontPath] == 0)} {
	return 0
    } else {
	return 1
    }
}        

#----------------- X_QueryConfigFrame -----------------
#
# This procedure returns a X-Window specific config
# frame. In this case it is a button, witch the user
# can click either on (X-Window support) or off
# (No X-Window support). Default is on.

proc X_QueryConfigFrame {parent} {
    x_putdebug "X_QueryConfigFrame"
    global x_Config
    set xframe $parent.xframe
    tixLabelFrame $xframe -label "X-Window" -labelside acrosstop -options {
        label.padX 5
    }
    set f [$xframe subwidget frame]
    checkbutton $f.cb -text "support X-Window" -anchor w -variable x_userinput
    pack $f.cb -in $f -side top -expand no -fill both
    if {[info exist x_Config(XWinActive)]} {
	if {$x_Config(XWinActive)} {
	    $f.cb select
	} else {
	    $f.cb deselect
	}
    } else {
	$f.cb select
    }
    return $xframe
}

#----------------- X_QueryTypeSupported ---------------
#
# This procedure searches in a list of font-file-extensions,
# if the parameter-value is supported by X-Window.
# It returns 1, in the case the parameter-value is part of
# the list, 0 otherwise.

proc X_QueryTypeSupported {fonttype} {
    x_putdebug "X_QueryTypeSupported"
    global x_FontTypeExtentions
    if {[lsearch -exact $x_FontTypeExtentions [string tolower $fonttype]] == -1} {
	return 0
    } else {
	return 1
    }
}

#----------------- X_QueryAppName ---------------------
#
# This procedure returns the original name of this 
# application (X-Window), instead of a shorter version
# like for example X.
 
proc X_QueryAppName {} {
    x_putdebug "X_QueryAppName"
    return "X-Window"
}

#----------------- X_QueryIcon ------------------------
#
# This procedure returns the identifier of the X-Window-
# icon.

proc X_QueryIcon {} {
    x_putdebug "X_QueryIcon"
    global x_Icon
    return $x_Icon
}

#----------------- X_WriteConfig ----------------------
#
# This procedure writes the returned fonts to the
# file "hfm/hfm.conf" and writes fonts relationship
# with "x_WriteFDFAToHFM"

proc X_WriteConfig {configfile} {
    x_putdebug "X_WriteConfig"
    global x_Config
    puts $configfile $x_Config(X-Label)
    append XWinActiveLabel "|XWinActive| " $x_Config(XWinActive)
    puts $configfile "$XWinActiveLabel"
    append RetNewFontLabel "|RetNewFont| " [join $x_Config(RetNewFont)]
    puts $configfile "$RetNewFontLabel"
    return [x_WriteFDFAToHFM]
}

#----------------- X_ActivateFont ---------------------
#
# This procedure activates a font.
# For explanation see below

proc X_ActivateFont {fontinfo sourcepath} {
    x_putdebug "X_ActivateFont"
    global x_RelatedToFont
    set FileName [file tail [lindex $fontinfo 1]]
    set Status 1

    # Try to extract the full fontname from "sourcepath/fonts.dir".
    # If it is possible write "sourcepath/fonts.dir" without the
    # line corresponding to the full font name, otherwise the
    # file is written untouched.

    set Generate 0
    if {[string length $sourcepath] == 0} {
	set Generate 1
    } elseif {! [file exist [file join [file dirname $sourcepath] "fonts.dir"]]} {
	set Generate 1
    } elseif {! [file isfile [file join [file dirname $sourcepath] "fonts.dir"]]} {
	return "In \"[file dirname $sourcepath]\" there is a \"fonts.dir\", but it's not a file!"
    } elseif {! [file readable [file join [file dirname $sourcepath] "fonts.dir"]]} {
	return "In \"[file dirname $sourcepath]\" there is a file called \"fonts.dir\" that isn't readable!"
    } elseif {! [file writable [file join [file dirname $sourcepath] "fonts.dir"]]} {
	return "In \"[file dirname $sourcepath]\" there is a file called \"fonts.dir\" that isn't writable!"
    } else {
	set Generate 1
	set FontsDir [open [file join [file dirname $sourcepath] "fonts.dir"] r]
	gets $FontsDir dummy
	set Counter 0
	for {gets $FontsDir line} {! [eof $FontsDir]} {gets $FontsDir line} {
	    if {([llength [split $line]] == 2) && ($FileName == [lindex [split $line] 0])} {
		set FullFontName "[lrange [split $line] 1 end]"
		set Generate 0
	    } else {
		set FileBuffer($Counter) $line
		incr Counter
	    }
	}
	close $FontsDir
	set FontsDir [open [file join [file dirname $sourcepath] "fonts.dir"] w]
	puts $FontsDir "$Counter"
	foreach Counter [lsort [array names FileBuffer]] {
	    puts $FontsDir "$FileBuffer($Counter)"
	    unset FileBuffer($Counter)
	}
	close $FontsDir
	if {[catch {exec xset fp rehash}]} {
	    return "You have a faulty \"fonts.dir\" or \"fonts.alias\", because X-Window\nwas very upset rehasing his fontpath!"
	}
    }

    # Gerates the full font name depending on "Generate"

    if {$Generate} {
	set FullFontName [x_GenerateName $fontinfo]
    }

    # Generating an entry in the "x_RelatedToFont"-array,
    # if the font doesn't exist. Otherwise, if the font
    # is deactivated, activating the font and adding
    # an full font name if there isn't one.
 
    if {! [x_DoesAliasExist "$FullFontName"]} {
	if {[info exist x_RelatedToFont($FileName)]} {
	    if {! [lindex $x_RelatedToFont($FileName) 0]} {
		set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 0 0 $Status]
		if {[string length [lindex $x_RelatedToFont($FileName) 1]] == 0} {
		    set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 1 1 "$FullFontName"]
		}
	    }
	} else {
	    lappend x_RelatedToFont($FileName) "$Status"
	    lappend x_RelatedToFont($FileName) "$FullFontName"
	}
    }

    # Try to extract all alias from "sourcepath/fonts.alias".
    # If it is possible to extract at least one, it writes
    # "sourcepath/fonts.dir" without the lines corresponding to
    # the aliases, otherwise the file is written untouched.

    if {(! ([string length $sourcepath] == 0))
    && ([file exist [file join [file dirname $sourcepath] "fonts.alias"]])} { 
	if {! [file isfile [file join [file dirname $sourcepath] "fonts.alias"]]} {
	    return "In \"[file dirname $sourcepath]\" there is a \"fonts.alias\", but it's not a file!"
	} elseif {! [file readable [file join [file dirname $sourcepath] "fonts.alias"]]} {
	    return "In \"[file dirname $sourcepath]\" there is a file called \"fonts.alias\" that isn't readable!"
	} elseif {! [file writable [file join [file dirname $sourcepath] "fonts.alias"]]} {
	    return "In \"[file dirname $sourcepath]\" there is a file called \"fonts.alias\" that isn't writable!"
	} else {
	    set FontsAlias [open [file join [file dirname $sourcepath] "fonts.alias"] r]
	    set Counter 0
	    for {gets $FontsAlias line} {! [eof $FontsAlias]} {gets $FontsAlias line} {
		if {("$FullFontName" == "[lrange [split $line] 1 end]")
		&& (! [x_DoesAliasExist "[lindex [split $line] 0]"])} {
		    lappend x_RelatedToFont($FileName) "[lindex [split $line] 0]"
		} else {
		    set FileBuffer($Counter) $line
		    incr Counter
		}
	    }
	    close $FontsAlias
	    set FontsAlias [open [file join [file dirname $sourcepath] "fonts.alias"] w]
	    foreach Counter [lsort [array names FileBuffer]] {
		puts $FontsAlias "$FileBuffer($Counter)"
	    }
	    close $FontsAlias
	    if {[catch {exec xset fp rehash}]} {
		return "You have a faulty \"fonts.dir\" or \"fonts.alias\", because X-Window\nwas very upset rehasing his fontpath!"
	    }
	    return ""
	}
    } else {
	return ""
    }
}
#----------------- X_DeactivateFont -------------------
#
# This procedure deactivates a font. If this is
# possible it returns an empty string, otherwise (the
# font doesn't exist) it returns an error message.


proc X_DeactivateFont {fontinfo} {
    x_putdebug "X_DeactivateFont"
    global x_RelatedToFont
    set Status 0
    set FileName [file tail [lindex $fontinfo 1]]
    if {[info exist x_RelatedToFont($FileName)]} {
	set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 0 0 $Status]
	return ""
    } else {
	return "There's no font\n\"[lindex $fontinfo 0]\"\nto deactivate!"
    }
}

#----------------- X_QueryFontActive ------------------
#
# This procedure returns 1, if the font is activated,
# otherwise (font doesn't exist or is deactivated)
# it returns 0.

proc X_QueryFontActive {fontinfo} {
    x_putdebug "X_QueryFontActive"
    global x_RelatedToFont
    set FileName [file tail [lindex $fontinfo 1]]
    if {[info exist x_RelatedToFont($FileName)]} {
	if {[lindex $x_RelatedToFont($FileName) 0]} {
	    return 1   
	} else {
	    return 0
	}
    } else {
	return 0
    }
}

#----------------- X_AddAlias -------------------------
#
# This procedure adds an alias to a font.
# If this is possible it returns an empty string.
# Otherwise (font doesn't exist or the alias to be add
# still depends to another font) it returns a error
# message.

proc X_AddAlias {fontinfo aliasname} {
    x_putdebug "X_AddAlias"
    global x_RelatedToFont x_Config HFMDirectory
    set words [llength [split $aliasname]]
    if {$words != 1} {
	return "The alias\n\"$aliasname\"\ncan't be added, because it's made of $words words,\nbut only 1 word is allowed!" 
    }
    set Status 1
    set FileName [file tail [lindex $fontinfo 1]]
    if {[x_DoesAliasExist $aliasname]} {
    	return "The alias\n\"$aliasname\"\ncan't be added, because it still belongs\nto an active X-Window font!"
    } elseif {! [info exist x_RelatedToFont($FileName)]} {
	lappend x_RelatedToFont($FileName) "$Status"
	lappend x_RelatedToFont($FileName) "[x_GenerateName $fontinfo]"
    } elseif {! [lindex $x_RelatedToFont($FileName) 0]} {
	set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 0 0 $Status]
	if {[string length [lindex $x_RelatedToFont($FileName) 1]] == 0} {
	    set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 1 1 "[x_GenerateName $fontinfo]"]
	}
    }
    lappend x_RelatedToFont($FileName) "$aliasname"
    return ""
}

#------------------ X_RenameAlias ----------------------
#
# This procedure renames an alias from a font.
# If this is possible it returns an empty string.
# Otherwise (font doesn't exist or new alias still depends
# to another font) it returns a error message.

proc X_RenameAlias {fontinfo oldaliasname newaliasname} {
    x_putdebug "X_RenameAlias"
    global x_RelatedToFont x_Config HFMDirectory
    set words [llength [split $newaliasname]]
    if {$words != 1} {
	return "The alias\n\"$oldaliasname\"\ncan't be renamed, because the new alias\n\"$newaliasname\"\nis made of $words words, but only 1 word is allowed!" 
    }
    set Status 0
    set FileName [file tail [lindex $fontinfo 1]]
    if {[info exist x_RelatedToFont($FileName)]} {
	if {[x_DoesAliasExist $newaliasname]} {
	    return "The alias\n\"$oldaliasname\"\ncan't be renamed, because the new alias\n\"$newaliasname\"\nstill belongs to an active X-Window font!"
	} else {
	    set Pos2 [lsearch [lrange $x_RelatedToFont($FileName) 1 end] "$oldaliasname"]
	    incr Pos2
	    if {$Pos2 > 1} {
		set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) $Pos2 $Pos2 "$newaliasname"]
		return ""
	    } else {
		return "The alias\n\"$oldaliasname\"\ncan't be renamed, because it's a special kind of alias,\nwhich X-Window needs to extract information\nto manage the font!"
	    }
	}
    } else {
	return "The alias\n\"$oldaliasname\"\ncan't be renamed, because there's no related font!"
    }
}

#----------------- X_RemoveAlias ----------------------
#
# This procedure removes an alias from a font.
# If this is possible it returns an empty string.
# Otherwise (font doesn't exist or is deactivated)
# it returns a error message.

proc X_RemoveAlias {fontinfo aliasname} {
    x_putdebug "X_RemoveAlias"
    global x_RelatedToFont
    set Status 0
    set FileName [file tail [lindex $fontinfo 1]]
    if {[info exist x_RelatedToFont($FileName)]} {
	if {[lindex $x_RelatedToFont($FileName) 0]} {
	    set Pos [lsearch [lrange $x_RelatedToFont($FileName) 1 end] $aliasname]
	    incr Pos
	    if {$Pos == 1} {
		set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) 0 0 $Status]
		set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) $Pos $Pos {}] 
	    } else {
		set x_RelatedToFont($FileName) [lreplace $x_RelatedToFont($FileName) $Pos $Pos]
	    }
	    return ""
	} else {
	    return "The alias\n\"$aliasname\"\ncan't be removed, because the related font is deactivated!"
	}
    } else {
	return "The alias\n\"$aliasname\"\ncan't be removed, because there's no related font!"
    }
}

#----------------- X_QueryAliases ---------------------
#
# This procedure returns all aliases assosiated to a
# given font. If there are no aliases an empty string
# is returned.

proc X_QueryAliases {fontinfo} {
    x_putdebug "X_QueryAliases"
    global x_RelatedToFont
    set FileName [file tail [lindex $fontinfo 1]]
    if {[info exist x_RelatedToFont($FileName)]
    && [lindex $x_RelatedToFont($FileName) 0]} {
	x_putdebug "$x_RelatedToFont($FileName)"
	return [lrange $x_RelatedToFont($FileName) 1 end]
    } else {
	return ""
    }
}

#----------------- X_QueryMAS -------------------------
#
# This procedure returns 1, because X-Window is supporting
# more then one alias per font-name.

proc X_QueryMAS {} {
    x_putdebug "X_QueryMAS"
    return 1
}

#----------------- X_QueryPrefsFrame ------------------
#
# This procedure returns a frame to enable the user to
# edit the properties for each font by hand. This is
# usefull, because not every property of fourteen
# different ones which are covered by the full name of an
# X-Window-font could be extracted from the fontfile
# itself.

proc X_QueryPrefsFrame {parent fontinfo} {
    x_putdebug "X_QueryPrefsFrame"
    return ""
}

#----------------- X_CheckPrefsInput ------------------
#  
# This procedure trys to check user input depending to
# the preference frame. 

proc X_CheckPrefsInput {} {
    x_putdebug "X_CheckPrefsInput"
    return ""
}

