# =======================================================================
# Utilities 
# for Hamster Font Manager
#
# $Date: 1998/10/30 11:43:26 $
# $Revision: 1.11 $
#
# To be used by plugins in their Config-Frame and elsewhere
#
# =======================================================================
#
# Copyright (C) 1998 The Hamster Project Team
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# =======================================================================

# REQUIRED-FILES: LICENSE

# ========================================================================
# GLOBAL PROCEDURES 
# ========================================================================

# ------------------------------------------------------------------------
# UTIL_RequestDir
# ------------------------------------------------------------------------
# Pops up a modale DirDialog initially set to the directory specified
# in the global variable $variable.
# This proc doesn't return until the user presses "OK" or "Cancel"
# in the dialog. On "OK", the selected directory is written to $variable
# and 1 is returned, on "Cancel" $variable is unchanged and 0 is returned
# ------------------------------------------------------------------------

proc UTIL_RequestDir { wmtitle label varname } {
    global util_dir_dlg util_dir_variable util_event

    upvar $varname variable
    catch {
	if {[info exist variable] && $variable != "" } {
	    set dir_box [$util_dir_dlg subwidget dirbox]
	    $dir_box configure -value $variable
	    $dir_box configure -label $label
	}
    }

    wm title .globaldirdialog $wmtitle

    $util_dir_dlg popup
    tixPushGrab .globaldirdialog

    set util_event 2

    tkwait variable util_event

    tixPopGrab

    if {$util_event==1} {
	set variable $util_dir_variable
    }
    return $util_event
}

# ------------------------------------------------------------------------
# UTIL_RequestFile
# ------------------------------------------------------------------------
# Pops up a modale FileDialog initially set to the file specified
# in the global variable $variable.
# This proc doesn't return until the user presses "OK" or "Cancel"
# in the dialog. On "OK", the selected file is written to $variable
# and 1 is returned, on "Cancel" $variable is unchanged and 0 is returned
# ------------------------------------------------------------------------

proc UTIL_RequestFile { wmtitle varname {ftypes {{{*} {All files}}}} } {
    global util_file_dlg util_file_variable util_event

    upvar $varname variable
    set fs_box [$util_file_dlg subwidget fsbox]
    set dir_list [$fs_box subwidget dirlist]

    # Sets possible file patterns and chooses first item
    $fs_box config -filetypes $ftypes -pattern [lindex [lindex $ftypes 0] 0]
    $fs_box subwidget types config -selection [lindex [lindex $ftypes 0] 0]

    # First selection is set to existing variable
    if {[info exist variable] && $variable != ""} {
	catch {
	    $dir_list configure -value [file dirname $variable]
	    set file [$fs_box subwidget file]
	    set file_list [ [$fs_box subwidget filelist] subwidget listbox]
	}
	catch {
	    $file configure -value [file tail $variable]
	    $file configure -selection [file tail $variable]
	    set file_pos [lsearch [$file_list get 0 end] [file tail $variable]]
	    if {$file_pos > -1} {
		$file_list selection set $file_pos
		$file_list see $file_pos
	    }
	}
    }

    wm title .globalfiledialog $wmtitle
    $util_file_dlg popup

    tixPushGrab .globalfiledialog
    set util_event 0
    tkwait variable util_event
    tixPopGrab
    if {$util_event==1} {
	set variable $util_file_variable
    }
    return $util_event
}

# ------------------------------------------------------------------------
# UTIL_ShowHamster
# ------------------------------------------------------------------------
# Multi-purpose status window
# ------------------------------------------------------------------------

proc UTIL_ShowHamster { args } {
    global util_ShowHamster
    set argc [llength $args]
    set done 0
    set win 0
    set labels 0
    set meter 0
    for {set i 0} {$i < $argc} {incr i} {
	switch -exact -- [lindex $args $i] {
	    -done {set done 1}
	    -image {
		incr i
		set image [lindex $args $i]
		set win 1
		set labels 1
	    }
	    -label {
		incr i
		set label [lindex $args $i]
		set win 1
		set labels 1
	    }
	    -metertext {
		incr i
		set metertext [lindex $args $i]
		set win 1
		set meter 1
	    }
	    -metervalue {
		incr i
		set metervalue [lindex $args $i]
		set win 1
		set meter 1
	    }
	    -status {
		incr i
		set status [lindex $args $i]
	    }
	    -statuswidget {
		incr i
		set util_ShowHamster(status) [lindex $args $i]
		if {! [string length $util_ShowHamster(status)] } {
		    unset util_ShowHamster(status)
		}
	    }
	    -title {
		incr i
		set title [lindex $args $i]
		set win 1
	    }
	    default {puts stderr "UTIL_ShowHamster called with illegal arguments: $args"}
	}
    }
    if $done {
	if [info exist util_ShowHamster(window)] {
	    destroy $util_ShowHamster(window)
	    unset util_ShowHamster(window)
	    catch {unset util_ShowHamster(image)}
	    catch {unset util_ShowHamster(label)}
	    catch {unset util_ShowHamster(meter)}
	}
	if [info exist util_ShowHamster(status)] {
	    $util_ShowHamster(status) config -text ""
	}
	update idletasks
	return
    }
    if {$win && ! [info exist util_ShowHamster(window)]} {
	set util_ShowHamster(window) [toplevel .util_hamsterwin]
	wm title $util_ShowHamster(window) $util_ShowHamster(DefaultTitle)
	pack [frame $util_ShowHamster(window).top] -side top -fill both -expand 1
    }
    if [info exist title] {
	wm title $util_ShowHamster(window) $title
    }
    if {$labels && ! [info exist util_ShowHamster(label)]} {
	set util_ShowHamster(image) [label $util_ShowHamster(window).top.image]
	set util_ShowHamster(label) [label $util_ShowHamster(window).top.label]
	pack $util_ShowHamster(image) $util_ShowHamster(label) -side left
    }
    if [info exist image] {
	$util_ShowHamster(image) config -image $image
    }
    if [info exist label] {
	$util_ShowHamster(label) config -text $label
    }
    if {$meter && ! [info exist util_ShowHamster(meter)]} {
	set util_ShowHamster(meter) [tixMeter $util_ShowHamster(window).meter]
	pack $util_ShowHamster(meter) -side top -fill x -expand 1
    }
    if [info exist metervalue] {
	$util_ShowHamster(meter) config -value $metervalue
    }
    if [info exist metertext] {
	$util_ShowHamster(meter) config -text $metertext
    }
    if [info exist status] {
	if [info exist util_ShowHamster(status)] {
	    $util_ShowHamster(status) config -text $status
	} {
	    puts stderr "UTIL_ShowHamster: no status bar defined."
	}
    }
    update idletasks
}

# ------------------------------------------------------------------------
# UTIL_ShowLicense
# ------------------------------------------------------------------------
# Pops up a window with the license agreement. The user has to confirm
# this to proceed. 
# ------------------------------------------------------------------------

proc UTIL_ShowLicense { } {
    global HFMDirectory
    set licensefile [file join $HFMDirectory "LICENSE"]

    # HFM won't run without the file.
    if {! [file readable $licensefile]} {
	puts stderr "hfm: license agreement file not found."
	exit
    }

    # Create the window.
    set f [toplevel .licensewin]
    wm title $f "HFM: License Agreement"
    label $f.l1 -text "Read the following license agreement carefully."
    tixScrolledText $f.t -scrollbar y
    label $f.l2 -text "Do you accept the terms listed above?"
    tixButtonBox $f.box -orientation horizontal -relief flat
    $f.box add yes -text "Accept" -width 15 -command "destroy $f"
    $f.box add no -text "Don't Accept" -width 15 -command "exit"
    pack $f.l1 -side top -fill x -padx 10 -pady 5
    pack $f.t -side top -fill both -expand 1 -padx 10 -pady 5
    pack $f.box $f.l2 -side bottom -fill x -padx 10 -pady 5

    # Read the license file
    if [catch {
	set in [open $licensefile]
	set license [read $in]
	close $in
    }] {
	puts stderr "hfm: couldn't read license agreement."
	exit
    }

    # Display the text.
    [$f.t subwidget text] insert end $license
    [$f.t subwidget text] configure -state disabled -wrap none -font fixed

    # Wait for user to confirm dialog.
    tixPushGrab $f
    tkwait window $f
    tixPopGrab
}

# ========================================================================
# PRIVATE stuff
# ========================================================================

set global_event 0
set util_dir_variable ""
set util_file_variable ""
set util_ShowHamster(DefaultTitle) "Please wait"

#
# Callbacks for DirDialog:
#

proc util_selectdir { dirname } {
    global util_dir_variable util_event
    set util_dir_variable $dirname
    set util_event 1
}

proc util_canceldir { } {
    global util_event

    #grab release .globaldirdialog
    set util_event 0

    wm withdraw .globaldirdialog
}

#
# Callbacks for FileDialog:
#

proc util_selectfile { filename } {
    global util_file_variable util_event
    set util_file_variable $filename
    #grab release .globalfiledialog
    set util_event 1
}

proc util_cancelfile { } {
    global util_event

    #grab release .globalfiledialog
    set util_event 0

    wm withdraw .globalfiledialog
}

#
# Generate generic Dialogs:
#

set util_dir_dlg [ tixDirSelectDialog .globaldirdialog -command util_selectdir]
set util_dir_cancel [ $util_dir_dlg subwidget cancel ]
$util_dir_cancel configure -command util_canceldir

set util_file_dlg [ tixExFileSelectDialog .globalfiledialog -command util_selectfile]
set util_file_cancel [ [$util_file_dlg subwidget fsbox] subwidget cancel ]
$util_file_cancel configure -command util_cancelfile


