# =======================================================================
# PostScript Font Module
# for Hamster Font Manager
#
# $Date: 1998/11/12 14:03:40 $
# $Revision: 1.26 $
#
# =======================================================================
#
# Copyright (C) 1998 The Hamster Project Team [EB]
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# =======================================================================

# REQUIRED-FILES: ps.xbm

# Append itself to list of known applications
lappend FontTypeMods "PS"

putdebug "LOADING FONTTYPE: PS"

set ps_config(icon) [image create bitmap -file [file join $HFMDirectory ps.xbm]]

# ========================================================================
# GLOBAL PROCEDURES - Following the HFM Module standard
# ========================================================================

# ------------------------------------------------------------------------
# PS_Init
# ------------------------------------------------------------------------
# Initializes this module. Called when HFM is started
# ------------------------------------------------------------------------

proc PS_Init { file } {
  global ps_tr

  # Finds the 'tr' utility (translate chars)
  catch { exec which tr } ps_tr
  if {![file executable $ps_tr]} {
    unset ps_tr
  }
  return 1
}

# ------------------------------------------------------------------------
# PS_ReadFontFile
# ------------------------------------------------------------------------
# Analizes the given font to see if it is a PS font
# ------------------------------------------------------------------------

proc PS_ReadFontFile { filename } {

    if {![file readable $filename]} {
	return ""
    }

	# Info stolen from type1inst,
	# and changed by baschneo@trick.informatik.uni-stuttgart.de

	set foundries {
		 {"Basil K. Malyshev" "malyshev"}
		 {"American Mathematical Society"    "ams"}
		 {"Ross Moore"   "moore"}
		 {"Shareware"	"shareware"}
		 {"ShareWare"	"shareware"}
		 {"SHAREWARE"	"shareware"}
		 {"Shwre"		"shareware"}
		 {"De Nada"		"denada"}
		{"Adobe" "adobe"}
		{"Allied Corporation"    "allied"}
		{"Publishers' Paradise"  "paradise"}
		{"PUBLISHERS' PARADISE"  "paradise"}
		{"Bigelow & Holmes"  "b&h"}
		{"Bitstream" "bitstream"}
		{"Corel Corporation" "corel"}
		{"International Typeface Corporation"    "itc"}
		{"IBM"   "ibm"}
		{"LETRASET"  "letraset"}
		{"Monotype Corporation"  "monotype"}
		{"SoftMaker" "softmaker"}
		{"URW"   "urw"}
		{"Jonathan Brecher"  "brecher"}
		{"Brendel Informatik"    "brendel"}
		{"A. Carr"   "carr"}
		{"FontBank"  "fontbank"}
		{"Hershey"   "hershey"}
		{"A.S.Meit"  "meit"}
		{"Andrew s. Meit"    "meit"}
		{"S.G. Moye" "moye"}
		{"S. G. Moye"    "moye"}
		{"D. Rakowski"   "rakowski"}
		{"David Rakowski"    "rakowski"}
		{"Reasonable Solutions"  "reasonable"}
		{"Southern Software" "southern"}
		{"Title Wave"    "titlewave"}
		{"ZSoft" "zsoft"}
		{"Digiteyes Multimedia"  "digiteyes"}
		{"MWSoft"    "mwsoft"}
		{"MacroMind" "macromind"}
		{"Three Islands Press"   "3ip"}
		{"Hank Gillette" "gillette"}
		{"Doug Miles"    "miles"}
		{"Richard Mitchell"  "mitchell"}
	}

	set weights {
		{"book"    "book"}
		{"demibold"    "demibold"}
		{"semibold"    "demibold"}
		{"demi"    "demibold"}
		{"semi"    "demibold"}
		{"extrabold"   "extrabold"}
		{"boldface"    "bold"}
		{"bold"    "bold"}
		{"heavyface"   "heavyface"}
		{"heavy"   "heavy"}
		{"ultrablack"  "ultrablack"}
		{"extrablack"  "extrablack"}
		{"ultra"   "ultra"}
		{"black"   "black"}
		{"extralight"  "extralight"}
		{"light"   "light"}
		{"thin"    "thin"}
		{"super"   "super"}
		{"thin"    "thin"}
		{"ligh"    "light"}
		{"semi"    "demi"}
		{"bold"    "bold"}
		{"heavy"   "heavy"}
		{"black"   "black"}
		{"normal"  "medium"}
		{"regular" "regular"}
		{"roman"   "roman"}
	}
	
	set slants {
		{"italic"   "i"}
		{"roman"    "r"}
		{"regular"  "r"}
		{"cursive"  "i"}
		{"kursiv"   "i"}
		{"oblique"  "o"}
		{"obl"  "o"}
		{"slanted"  "o"}
		{"upright"  "r"}
		{"inclined" "i"}
	}
	
	set styles {
		{"extracondensed"   "extracondensed"}
		{"condensed"    "condensed"}
		{"cond" "condensed"}
		{"sans" "sans"}
		{"wide" "wide"}
		{"cn"   "condensed"}
		{"narrow"   "narrow"}
		{"extracompressed"  "extracompressed"}
		{"compressed"   "compressed"}
		{"extraextended"    "extraextended"}
		{"extended" "extended"}
		{"expanded" "expanded"}
		{"normal"   "normal"}
	}
	
	set addstyles {
		{"alt"   "alternate"}
		{"beginning" "beginning"}
		{"display"   "display"}
		{"dfr"   "dfr"}
		{"ending"    "ending"}
		{"ep"    "expert"}
		{"exp"   "expert"}
		{"gothic"  "gothic"}
		{"ornaments" "ornaments"}
		{"osf"   "oldstylefigures"}
		{"outline"   "outline"}
		 {"script"    "script"}
		 {"smallcaps"    "smallcaps"}
		 {"sc"    "smallcaps"}
		 {"german" "german"}
		 {"english" "english"}
		 {"duplex"  "duplex"}
		 {"triplex" "triplex"}
		 {"simplex" "simplex"}
		 {"complex" "complex"}
		{"shaded"    "shaded"}
		{"shadowed"  "shadowed"}
		{"stencil"   "stencil"}
		{"swash" "swash"}
		{"sw"    "swash"}
		{"one"   "one"}
		{"two"   "two"}
		{"three" "three"}
		{"four"  "four"}
	}

	# Space chars (space, tab, lf), for regular expression
	set s "\[ 	\n\]"

	# Ghostscript Fonts can look like PSFonts, but crash X-Fontservers
	if {[file extension $filename] == ".gsf"} { return "" }

	# First try to pass the file through 'pfbtops'

	global ps_tr
	set cmd "pfbtops $filename"
	if {[info exist ps_tr]} {
		append cmd " | $ps_tr \"\\00\" \"\""
	}

	if { [catch { set font [eval exec $cmd] } error] }  {
		# Not possible, so read the font file manually
		if {![file isfile $filename]} { return "" }
		if {[catch {set in [open $filename r]}]} {
			# Oops, what kind of file is that?
			return ""
		}
		set font [read $in]
		close $in
		# Remove MS-DOS CR's
		regsub -all "\r\n" $font "\n" font
		regsub -all "\r" $font "\n" font
		set firstline [lindex [split $font "\n"] 0]
		if {
		  ![string match "%!PS-AdobeFont-*" $firstline] &&
		  ![string match "%!FontType1-*" $firstline]
		} {
			# Not a font file
			return ""
		}
	}

putdebug "lenght: [string length $font]"
	catch { unset field }
	catch { unset fontinfo }

	set in ""
	# Infos we need from the font:
	set weneed "isFixedPitch FamilyName Weight FullName FontName \
	            Encoding Notice BlendAxisType"

	foreach line [split $font "\n"] {
		# Go through font line by line and remember fields we need
		set line [string trim $line]
		if {[string match "%*" $line]} { continue }
		if {$line == "currentdict end"} { break }
		if {$in == ""} {
			# We are not in any definition we need
			foreach needed $weneed {
				if {[regexp -nocase -- "/[string tolower ${needed}]$s*(.*)" $line dummy line]} {
					# We found a /Needed line!
					set in $needed
					set field($needed) ""
					break
				}
			}
		}
		if {$in != ""} {
			# We are currently reading definition of '$in'
			set gotend 0
			if {[regexp -nocase -- "(.*)$s*readonly$s+def" $line dummy line]} {
				# This is the end of this field
				set gotend 1
			} elseif {[regexp -nocase -- "(.*)$s*def" $line dummy line]} {
				# This is also the end
				set gotend 1
			}
			append field($in) $line
			# Field continues in next line
			if {[string match "*\\\\" $line]} { append field($in) "\n" }
			if {$gotend} {
				# This field is over
				set in ""
			}
		}
	}
	
	if {![info exist field(FontName)]} {
		# No FontName => No font!!
		putdebug "$filename: NO PS FONT!"
		return ""
	}
	
	foreach needed $weneed {
		if {[info exist field($needed)]} {
			# Remove leading "(" and trailing ")" from field data
			set field($needed) "[string trimright [string trimleft $field($needed) "( "] ") "]"
		}
	}

	set field(FontName) [string trimleft $field(FontName) "/"]
	putdebug "$filename: $field(FontName)"

	# MultipleMaster Font
	# (not really supported (I have never seen one) )
	set mm 0
	
	# FOUNDRY INFO
	set fontinfo(foundry) "unknown"
	if {[info exist field(Notice)]} {
		# Get foundry matchin the '/Notice' with '$foundies' list
		foreach item $foundries {
			if {[regexp [lindex $item 0] $field(Notice)] > 0} {
				set fontinfo(foundry) [lindex $item 1]
				break
			}
		}
	}
	
	set fontinfo(family) ""
	set fontstyle ""
	
	# Get a list of all styles from FullName
	if {[info exist field(FullName)] && [info exist field(FamilyName)]} {
		if {[string match "$field(FamilyName)*" "$field(FullName)"]} {
			regsub -- $field(FamilyName) $field(FullName) "" fontstyle
			set fontstyle [string trim $fontstyle]
		}
	}
	
	# Styles can also appear after the '-' in the FontName
	set split [split [string tolower $field(FontName)] "-"]
	if {[string tolower [lindex $split 0]] == $fontinfo(foundry)} {
		# Foundry is the first element in the FontName, strip it:
		# the real font family comes AFTER that
		set fontinfo(family) [lindex $split 1]
		set idx 2
	} {
		set fontinfo(family) [lindex $split 0]
		set idx 1
	}
	# Go over rest of FontName for additional styles
	foreach style [lrange $split $idx end] { append fontstyle " $style" }
	
	if {[string match "$fontinfo(foundry)*" $fontinfo(family)]} {
		# Family also contains the foundry name, so strip it
		set fontinfo(family) [string trim \
	                               [string range $fontinfo(family) \
	                                       [string length $fontinfo(foundry)] \
	                                       end]]
	}
	
	# Remove all '-'s from the family name
	regsub -all -- "-" $fontinfo(family) " " fontinfo(family)
	
	# WEIGHT
	set fontinfo(weight) ""
	if {[info exist field(Weight)]} {
		if {[regexp -nocase "^all" $field(Weight)]} {
			# MultipleMaster font
			set mm 1
		}
		set weight [string tolower $field(Weight)]
		set fontinfo(weight) "$weight"
	}
	foreach item $weights {
		if {[regexp -nocase [lindex $item 0] $fontstyle]} {
			if {$fontinfo(weight) == ""} {
				# Only change the weight if we don't already have one
				set fontinfo(weight) [lindex $item 1]
			}
		}
		regsub -nocase -all "[lindex $item 0]" $fontstyle "" fontstyle
	}
	if {$fontinfo(weight) == ""} {
		# Nothing found, default to medium
		set fontinfo(weight) "medium"
	}
	
	# SLANT
	set fontinfo(slant) "r"
	foreach item $slants {
		if {[regexp -nocase [lindex $item 0] $fontstyle]} {
			set fontinfo(slant) [lindex $item 1]
		}
		regsub -nocase -all "[lindex $item 0]" $fontstyle "" fontstyle
	}
	
	# STYLE
	set fontinfo(style) "normal"
	foreach item $styles {
		if {[regexp -nocase [lindex $item 0] $fontstyle]} {
			set fontinfo(style) [lindex $item 1]
		}
		regsub -nocase -all "[lindex $item 0]" $fontstyle "" fontstyle
	}
	
	# ADD-STYLE
	set fontinfo(addstyle) ""
	foreach item $addstyles {
		if {[regexp -nocase [lindex $item 0] $fontstyle]} {
			set fontinfo(addstyle) [lindex $item 1]
		}
		regsub -nocase -all "[lindex $item 0]" $fontstyle "" fontstyle
	}
	
	# ENCODING
	if {
			![info exist field(Encoding)] ||
			$field(Encoding) != "StandardEncoding"
	} {
		set fontinfo(encoding) "adobe-fontspecific"
	} else {
		set fontinfo(encoding) "iso8859-1"
	}
	
	# FIXED PITCH?
	if {
			[info exist field(isFixedPitch)] &&
			[string tolower $field(isFixedPitch)] == "true"
	} {
		set fontinfo(fixedpitch) "m"
	} else {
		set fontinfo(fixedpitch) "p"
	}

	# MultipleMaster fonts have this field
#	if {[info exist field(BlendAxisTypes)]} {
#		set axis $field(BlendAxisTypes)
#		regsub -all "Weight" $axis "" axis
#		regsub -all "Width" $axis "" axis
#		set axis "\[[string trim $axis]\]"
#	}

# This would make the fontname part in a X fonts.scale line for this PS Font
#	set xline ""
#	append xline "-$fontinfo(foundry)"
#	append xline "-$fontinfo(family)"
#	append xline "-$fontinfo(weight)"
#	append xline "-$fontinfo(slant)"
#	append xline "-$fontinfo(style)"
#	append xline "-$fontinfo(addstyle)"
#	append xline "-0-0-0-0"
#	append xline "-$fontinfo(fixedpitch)"
#	append xline "-0"
#	append xline "-$fontinfo(encoding)"

	#
	# AddFiles-support by GB
	# 

	set afmname [file rootname $filename].afm
	if {[file readable $afmname]} {
	   set fontinfo(addfiles) [list $afmname]
	} else {
	   set fontinfo(addfiles) {}
	}

	return [list \
	        $field(FontName) \
	        $filename \
	        "PS" \
	        $fontinfo(foundry) \
	        $fontinfo(family) \
	        $fontinfo(weight) \
	        $fontinfo(slant) \
	        $fontinfo(style) \
	        $fontinfo(addstyle) \
	        $fontinfo(fixedpitch) \
	        $fontinfo(encoding) \
		$fontinfo(addfiles) \
	       ]
}

# ------------------------------------------------------------------------
# PS_QueryConfigFrame
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_QueryConfigFrame { parent } {
	return ""
}

# ------------------------------------------------------------------------
# PS_CheckConfigInput
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_CheckConfigInput { } {
  return ""
}

# ------------------------------------------------------------------------
# PS_QueryIcon
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_QueryIcon { } {
  global ps_config
  return $ps_config(icon)
}

# ------------------------------------------------------------------------
# PS_QueryFilePatterns
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_QueryFilePatterns { } {
  return "*.pfa *.pfb"
}

# ------------------------------------------------------------------------
# PS_WriteConfig
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_WriteConfig { file } {
  return ""
}

# ------------------------------------------------------------------------
# PS_QueryHasPreview
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_QueryHasPreview { } {
  return 1
}

# ------------------------------------------------------------------------
# PS_CreatePreviewImage
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_CreatePreviewImage { fontinfo imageid } {
	set filename [ lindex $fontinfo 1 ]
	set fontname [ lindex $fontinfo 0 ]

	set tmppfa /tmp/hfm-font.[pid].pfa
	set tmpps /tmp/hfm-preview.[pid].ps
	set tmppgm /tmp/hfm-preview.[pid].pgm
	set tmpFontmap /tmp/hfm-Fontmap.[pid]

	set error [catch {
		UTIL_ShowHamster -metervalue 0.0 -metertext "Make PS file" \
			-title "Create Preview"

		# Creates a temporary Fontmap file
		set out [open $tmpFontmap w]
		puts $out "/$fontname	($filename)	;"
		close $out

		set out [open $tmpps w]

#		# The font file
#		while {[gets $in line] >=0} {
#			puts $out $line
#		}
#		close $in

		# The sample text
		puts $out "/$fontname findfont"
		puts $out "12.0 scalefont setfont 0 400 moveto (ABCDEFG abcdefg 123) show"
		puts $out "/$fontname findfont"
		puts $out "18.0 scalefont setfont 0 374 moveto (ABCDEFG abcdefg 123) show"
		puts $out "/$fontname findfont"
		puts $out "24.0 scalefont setfont 0 348 moveto (ABCDEFG abcdefg 123) show"
		puts $out "/$fontname findfont"
		puts $out "36.0 scalefont setfont 0 300 moveto (ABCDEFG abcdefg 123) show"
		puts $out "/$fontname findfont"
		puts $out "48.0 scalefont setfont 0 240 moveto (ABCDEFG) show"
		puts $out "0 190 moveto (abcdefg) show"
		puts $out "0 140 moveto (12345) show"
		puts $out "showpage"
		close $out

		UTIL_ShowHamster -metervalue 0.3 -metertext "Running gs"
		exec gs -q -dBATCH -dTextAlphaBits=4 -sDEVICE=pgmraw -sFONTMAP=$tmpFontmap -dNOPAUSE -sPAPERSIZE=a6 -sOutputFile=$tmppgm $tmpps

		UTIL_ShowHamster -metervalue 0.9 -metertext "Creating image"
		if [catch {
			image create photo $imageid -file $tmppgm
			# pgm files created by old ghostscript versions may not work.
		}] {
			# Couldn't load image. Try to filter it through ppmtopgm.
			exec ppmtopgm $tmppgm > ${tmppgm}.new
			image create photo $imageid -file ${tmppgm}.new
		}
	} errormsg]

	catch { file delete -force $tmppgm }
	catch { file delete -force ${tmppgm}.new }
	catch { file delete -force $tmppfa }
	catch { file delete -force $tmpps }
	catch { file delete -force $tmpFontmap }

	UTIL_ShowHamster -done

	if {$error} {
		return "Preview failed : $errormsg"
	}
	return ""
}

# ------------------------------------------------------------------------
# PS_QueryAppName
# ------------------------------------------------------------------------
# 
# ------------------------------------------------------------------------

proc PS_QueryAppName { } {
  return "Postscript"
}

